/*
 * Decompiled with CFR 0.152.
 */
package tr.extract;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import tr.extract.Resources;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FontInstaller {
    private static final Logger LOG = Logger.getLogger("au.com.trgtd.tr.extract.FontInstaller");
    private static final GraphicsEnvironment GRAPHICS_ENVIRONMENT = GraphicsEnvironment.getLocalGraphicsEnvironment();
    private static Map<String, Font> fontsMap;

    public static void installFonts() {
        if (!FontInstaller.isJavaVersionOk()) {
            LOG.warning("Could not register report fonts - Java version earlier than 1.6");
            return;
        }
        FontInstaller.installFont("DejaVu Sans", Resources.FILE_DEJAVU_SANS_TTF);
        FontInstaller.installFont("DejaVu Sans Bold", Resources.FILE_DEJAVU_SANS_BOLD_TTF);
        FontInstaller.installFont("DejaVu Sans Bold Oblique", Resources.FILE_DEJAVU_SANS_BOLD_OBLIQUE_TTF);
        FontInstaller.installFont("DejaVu Sans Oblique", Resources.FILE_DEJAVU_SANS_OBLIQUE_TTF);
        FontInstaller.installFont("DejaVuSans", Resources.FILE_DEJAVU_SANS_TTF);
        FontInstaller.installFont("DejaVuSans-Bold", Resources.FILE_DEJAVU_SANS_BOLD_TTF);
        FontInstaller.installFont("DejaVuSans-BoldOblique", Resources.FILE_DEJAVU_SANS_BOLD_OBLIQUE_TTF);
        FontInstaller.installFont("DejaVuSans-Oblique", Resources.FILE_DEJAVU_SANS_OBLIQUE_TTF);
        FontInstaller.installFont("DejaVu Serif", Resources.FILE_DEJAVU_SERIF_TTF);
        FontInstaller.installFont("DejaVu Serif Bold", Resources.FILE_DEJAVU_SERIF_BOLD_TTF);
        FontInstaller.installFont("DejaVu Serif Bold Italic", Resources.FILE_DEJAVU_SERIF_BOLD_ITALIC_TTF);
        FontInstaller.installFont("DejaVu Serif Italic", Resources.FILE_DEJAVU_SERIF_ITALIC_TTF);
        FontInstaller.installFont("DejaVuSerif", Resources.FILE_DEJAVU_SERIF_TTF);
        FontInstaller.installFont("DejaVuSerif-Bold", Resources.FILE_DEJAVU_SERIF_BOLD_TTF);
        FontInstaller.installFont("DejaVuSerif-BoldItalic", Resources.FILE_DEJAVU_SERIF_BOLD_ITALIC_TTF);
        FontInstaller.installFont("DejaVuSerif-Italic", Resources.FILE_DEJAVU_SERIF_ITALIC_TTF);
    }

    private static void installFont(String fontName, File ttfFile) {
        try {
            if (FontInstaller.getFontsMap(false).containsKey(fontName)) {
                LOG.info(fontName + " font is already registered.");
                return;
            }
            Font font = Font.createFont(0, ttfFile);
            if (font == null) {
                LOG.warning(fontName + " font could not be created.");
                return;
            }
            if (!GRAPHICS_ENVIRONMENT.registerFont(font)) {
                LOG.warning(fontName + " font was not registered.");
                return;
            }
            LOG.info(fontName + " font was registered.");
        }
        catch (Exception ex) {
            LOG.warning(fontName + " font could not be registered.");
        }
    }

    private static Map<String, Font> getFontsMap(boolean refresh) {
        if (fontsMap == null || refresh) {
            fontsMap = new HashMap<String, Font>();
            for (Font font : GRAPHICS_ENVIRONMENT.getAllFonts()) {
                fontsMap.put(font.getFontName(), font);
            }
        }
        return fontsMap;
    }

    private static boolean isJavaVersionOk() {
        try {
            String javaVersion = System.getProperty("java.version");
            float version = Float.parseFloat(javaVersion.substring(0, 3));
            return version >= 1.6f;
        }
        catch (NumberFormatException nfe) {
            LOG.severe("Unable to determine Java version. " + nfe.getMessage());
            return false;
        }
    }
}

