/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.transport.http;

import java.io.Closeable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import org.apache.http.HttpHost;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.eclipse.aether.RepositoryCache;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.transport.http.AuthSchemePool;
import org.eclipse.aether.transport.http.SslConfig;
import org.eclipse.aether.util.ConfigUtils;

final class GlobalState
implements Closeable {
    private static final String KEY = GlobalState.class.getName();
    private static final String CONFIG_PROP_CACHE_STATE = "aether.connector.http.cacheState";
    private final ConcurrentMap<SslConfig, HttpClientConnectionManager> connectionManagers = new ConcurrentHashMap<SslConfig, HttpClientConnectionManager>();
    private final ConcurrentMap<CompoundKey, Object> userTokens = new ConcurrentHashMap<CompoundKey, Object>();
    private final ConcurrentMap<HttpHost, AuthSchemePool> authSchemePools = new ConcurrentHashMap<HttpHost, AuthSchemePool>();
    private final ConcurrentMap<CompoundKey, Boolean> expectContinues = new ConcurrentHashMap<CompoundKey, Boolean>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static GlobalState get(RepositorySystemSession session2) {
        RepositoryCache repoCache = session2.getCache();
        if (repoCache == null) return null;
        if (!ConfigUtils.getBoolean(session2, true, CONFIG_PROP_CACHE_STATE)) {
            return null;
        }
        Object tmp = repoCache.get(session2, KEY);
        if (tmp instanceof GlobalState) {
            return (GlobalState)tmp;
        }
        Class<GlobalState> clazz = GlobalState.class;
        synchronized (GlobalState.class) {
            tmp = repoCache.get(session2, KEY);
            if (tmp instanceof GlobalState) {
                return (GlobalState)tmp;
            }
            GlobalState cache2 = new GlobalState();
            repoCache.put(session2, KEY, cache2);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return cache2;
        }
    }

    private GlobalState() {
    }

    @Override
    public void close() {
        Iterator it = this.connectionManagers.entrySet().iterator();
        while (it.hasNext()) {
            HttpClientConnectionManager connMgr = (HttpClientConnectionManager)it.next().getValue();
            it.remove();
            connMgr.shutdown();
        }
    }

    public HttpClientConnectionManager getConnectionManager(SslConfig config2) {
        HttpClientConnectionManager manager = (HttpClientConnectionManager)this.connectionManagers.get(config2);
        if (manager == null) {
            HttpClientConnectionManager connMgr = GlobalState.newConnectionManager(config2);
            manager = this.connectionManagers.putIfAbsent(config2, connMgr);
            if (manager != null) {
                connMgr.shutdown();
            } else {
                manager = connMgr;
            }
        }
        return manager;
    }

    public static HttpClientConnectionManager newConnectionManager(SslConfig sslConfig) {
        RegistryBuilder<PlainConnectionSocketFactory> registryBuilder = RegistryBuilder.create().register("http", PlainConnectionSocketFactory.getSocketFactory());
        if (sslConfig == null) {
            registryBuilder.register("https", (PlainConnectionSocketFactory)((Object)SSLConnectionSocketFactory.getSystemSocketFactory()));
        } else {
            SSLSocketFactory sslSocketFactory = sslConfig.context != null ? sslConfig.context.getSocketFactory() : (SSLSocketFactory)SSLSocketFactory.getDefault();
            HostnameVerifier hostnameVerifier = sslConfig.verifier != null ? sslConfig.verifier : SSLConnectionSocketFactory.getDefaultHostnameVerifier();
            registryBuilder.register("https", (PlainConnectionSocketFactory)((Object)new SSLConnectionSocketFactory(sslSocketFactory, sslConfig.protocols, sslConfig.cipherSuites, hostnameVerifier)));
        }
        PoolingHttpClientConnectionManager connMgr = new PoolingHttpClientConnectionManager(registryBuilder.build());
        connMgr.setMaxTotal(100);
        connMgr.setDefaultMaxPerRoute(50);
        return connMgr;
    }

    public Object getUserToken(CompoundKey key2) {
        return this.userTokens.get(key2);
    }

    public void setUserToken(CompoundKey key2, Object userToken) {
        if (userToken != null) {
            this.userTokens.put(key2, userToken);
        } else {
            this.userTokens.remove(key2);
        }
    }

    public ConcurrentMap<HttpHost, AuthSchemePool> getAuthSchemePools() {
        return this.authSchemePools;
    }

    public Boolean getExpectContinue(CompoundKey key2) {
        return (Boolean)this.expectContinues.get(key2);
    }

    public void setExpectContinue(CompoundKey key2, boolean enabled) {
        this.expectContinues.put(key2, enabled);
    }

    static class CompoundKey {
        private final Object[] keys;

        CompoundKey(Object ... keys2) {
            this.keys = keys2;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || !this.getClass().equals(obj.getClass())) {
                return false;
            }
            CompoundKey that = (CompoundKey)obj;
            return Arrays.equals(this.keys, that.keys);
        }

        public int hashCode() {
            int hash2 = 17;
            hash2 = hash2 * 31 + Arrays.hashCode(this.keys);
            return hash2;
        }

        public String toString() {
            return Arrays.toString(this.keys);
        }
    }
}

