/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import java.io.IOException;
import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.crypto.InvalidSignatureException;
import org.bouncycastle.crypto.Parameters;
import org.bouncycastle.crypto.UpdateOutputStream;
import org.bouncycastle.crypto.fips.FipsOutputVerifier;
import org.bouncycastle.crypto.internal.DSA;
import org.bouncycastle.crypto.internal.Digest;
import org.bouncycastle.crypto.internal.io.DigestOutputStream;
import org.bouncycastle.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DSAOutputVerifier<T extends Parameters>
extends FipsOutputVerifier<T> {
    private final DSA dsa;
    private final Digest digest;
    private final T parameter;

    DSAOutputVerifier(DSA dSA, Digest digest, T t) {
        this.dsa = dSA;
        this.digest = digest;
        this.parameter = t;
    }

    @Override
    public T getParameters() {
        return this.parameter;
    }

    @Override
    public UpdateOutputStream getVerifyingStream() {
        return new DigestOutputStream(this.digest);
    }

    @Override
    public boolean isVerified(byte[] byArray) throws InvalidSignatureException {
        try {
            BigInteger[] bigIntegerArray = this.decode(byArray);
            byte[] byArray2 = new byte[this.digest.getDigestSize()];
            this.digest.doFinal(byArray2, 0);
            return this.dsa.verifySignature(byArray2, bigIntegerArray[0], bigIntegerArray[1]);
        }
        catch (Exception exception) {
            throw new InvalidSignatureException("Unable to process signature: " + exception.getMessage(), exception);
        }
    }

    public BigInteger[] decode(byte[] byArray) throws IOException {
        ASN1Sequence aSN1Sequence = (ASN1Sequence)ASN1Primitive.fromByteArray(byArray);
        if (aSN1Sequence.size() != 2) {
            throw new IOException("malformed signature");
        }
        if (!Arrays.areEqual(byArray, aSN1Sequence.getEncoded("DER"))) {
            throw new IOException("malformed signature");
        }
        BigInteger[] bigIntegerArray = new BigInteger[]{ASN1Integer.getInstance(aSN1Sequence.getObjectAt(0)).getValue(), ASN1Integer.getInstance(aSN1Sequence.getObjectAt(1)).getValue()};
        return bigIntegerArray;
    }
}

