/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport.netty4;

import io.netty.channel.Channel;
import java.net.InetSocketAddress;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.concurrent.CompletableContext;
import org.elasticsearch.transport.TcpServerChannel;
import org.elasticsearch.transport.netty4.Netty4TcpChannel;

public class Netty4TcpServerChannel
implements TcpServerChannel {
    private final Channel channel;
    private final CompletableContext<Void> closeContext = new CompletableContext();

    Netty4TcpServerChannel(Channel channel) {
        this.channel = channel;
        Netty4TcpChannel.addListener(this.channel.closeFuture(), this.closeContext);
    }

    public InetSocketAddress getLocalAddress() {
        return (InetSocketAddress)this.channel.localAddress();
    }

    public void close() {
        this.channel.close();
    }

    public void addCloseListener(ActionListener<Void> listener) {
        this.closeContext.addListener(ActionListener.toBiConsumer(listener));
    }

    public boolean isOpen() {
        return this.channel.isOpen();
    }

    public String toString() {
        return "Netty4TcpChannel{localAddress=" + this.getLocalAddress() + '}';
    }
}

