/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.node;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.node.AExpression;
import org.elasticsearch.painless.phase.UserTreeVisitor;

public class EMapInit
extends AExpression {
    private final List<AExpression> keyNodes;
    private final List<AExpression> valueNodes;

    public EMapInit(int identifier, Location location, List<AExpression> keyNodes, List<AExpression> valueNodes) {
        super(identifier, location);
        this.keyNodes = Collections.unmodifiableList(Objects.requireNonNull(keyNodes));
        this.valueNodes = Collections.unmodifiableList(Objects.requireNonNull(valueNodes));
    }

    public List<AExpression> getKeyNodes() {
        return this.keyNodes;
    }

    public List<AExpression> getValueNodes() {
        return this.valueNodes;
    }

    @Override
    public <Scope> void visit(UserTreeVisitor<Scope> userTreeVisitor, Scope scope) {
        userTreeVisitor.visitMapInit(this, scope);
    }

    @Override
    public <Scope> void visitChildren(UserTreeVisitor<Scope> userTreeVisitor, Scope scope) {
        for (AExpression keyNode : this.keyNodes) {
            keyNode.visit(userTreeVisitor, scope);
        }
        for (AExpression valueNode : this.valueNodes) {
            valueNode.visit(userTreeVisitor, scope);
        }
    }
}

