/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.reporting;

import com.adobe.epubcheck.reporting.CheckMessage;
import com.adobe.epubcheck.util.PathUtil;
import com.adobe.epubcheck.util.outWriter;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.codehaus.jackson.annotate.JsonProperty;

class CheckerMetadata {
    @JsonProperty
    private String path;
    @JsonProperty
    private String filename;
    @JsonProperty
    private String checkerVersion;
    @JsonProperty
    private String checkDate;
    @JsonProperty
    private long elapsedTime = -1L;
    @JsonProperty
    private int nFatal = 0;
    @JsonProperty
    private int nError = 0;
    @JsonProperty
    private int nWarning = 0;
    @JsonProperty
    private int nUsage = 0;
    private final String workingDirectory = System.getProperty("user.dir");
    private Date processStartDateTime;
    private Date processEndDateTime;
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("MM-dd-yyyy HH:mm:ss");

    public void setFileInfo(File epubFile) {
        this.path = PathUtil.removeWorkingDirectory(epubFile.getAbsolutePath());
        this.filename = epubFile.getName();
    }

    public void setCheckerVersion(String value) {
        this.checkerVersion = value;
    }

    public long getProcessDuration() {
        if (this.elapsedTime == -1L) {
            this.setElapsedTime();
        }
        return this.elapsedTime;
    }

    public void setStartDate() {
        this.processStartDateTime = new Date();
        this.checkDate = dateFormat.format(this.processStartDateTime);
    }

    public void setStopDate() {
        this.processEndDateTime = new Date();
        this.setElapsedTime();
    }

    private void setElapsedTime() {
        this.elapsedTime = this.processEndDateTime.getTime() - this.processStartDateTime.getTime();
    }

    public void setMessageTypes(List<CheckMessage> messages) {
        for (CheckMessage message : messages) {
            if (message.getSeverity() != null) {
                switch (message.getSeverity()) {
                    case FATAL: {
                        ++this.nFatal;
                        break;
                    }
                    case ERROR: {
                        ++this.nError;
                        break;
                    }
                    case WARNING: {
                        ++this.nWarning;
                        break;
                    }
                    case USAGE: {
                        ++this.nUsage;
                    }
                }
                continue;
            }
            outWriter.print("message with no severity");
        }
    }
}

