/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.panel.AbstractGoodsLabel;
import net.sf.freecol.client.gui.panel.Draggable;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.common.debug.FreeColDebugger;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Market;
import net.sf.freecol.common.model.Player;

public final class MarketLabel
extends AbstractGoodsLabel
implements Draggable,
PropertyChangeListener {
    private final Market market;

    public MarketLabel(ImageLibrary lib, GoodsType type, Market market) {
        super(lib, new AbstractGoods(type, 100));
        if (market == null) {
            throw new IllegalArgumentException("Null market");
        }
        this.market = market;
        this.update();
    }

    public MarketLabel addBorder() {
        this.setBorder(Utility.TOPCELLBORDER);
        this.setVerticalTextPosition(3);
        this.setHorizontalTextPosition(0);
        return this;
    }

    public void update() {
        GoodsType type = this.getType();
        Player player = this.market.getOwner();
        String toolTipText = Messages.getName(type);
        if (player == null || player.canTrade(type)) {
            this.setEnabled(true);
        } else {
            toolTipText = Messages.message(type.getLabel());
            this.setEnabled(false);
        }
        if (FreeColDebugger.isInDebugMode(FreeColDebugger.DebugMode.MENUS)) {
            toolTipText = toolTipText + " " + this.market.getAmountInMarket(type);
        }
        this.setToolTipText(toolTipText);
        this.setText(this.market.getPaidForSale(type) + "/" + this.market.getCostToBuy(type));
    }

    public Market getMarket() {
        return this.market;
    }

    @Override
    public void setDefaultAmount() {
        this.setAmount(100);
    }

    @Override
    public boolean isOnCarrier() {
        return false;
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        this.update();
    }
}

