/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.AbstractUnit;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Named;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Role;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.option.UnitListOption;
import net.sf.freecol.common.util.RandomChoice;
import net.sf.freecol.common.util.RandomUtils;
import net.sf.freecol.common.util.StringUtils;

public final class Monarch
extends FreeColGameObject
implements Named {
    private static final Logger logger = Logger.getLogger(Monarch.class.getName());
    public static final int MONARCH_MINIMUM_PRICE = 200;
    public static final int HESSIAN_MINIMUM_PRICE = 5000;
    public static final int MINIMUM_TAX_RATE = 20;
    private Player player;
    private boolean supportSea = false;
    private boolean displeasure = false;
    private Force expeditionaryForce;
    private Force interventionForce;
    private List<UnitType> navalTypes = null;
    private List<UnitType> bombardTypes = null;
    private List<UnitType> landTypes = null;
    private Role mountedRole = null;
    private Role armedRole = null;
    private Role refMountedRole;
    private Role refArmedRole;
    private List<UnitType> mercenaryTypes = null;
    private List<UnitType> navalREFUnitTypes = null;
    private List<UnitType> landREFUnitTypes = null;
    private static final String DISPLEASURE_TAG = "displeasure";
    private static final String EXPEDITIONARY_FORCE_TAG = "expeditionaryForce";
    private static final String INTERVENTION_FORCE_TAG = "interventionForce";
    private static final String PLAYER_TAG = "player";
    private static final String SUPPORT_SEA_TAG = "supportSea";
    private static final String NAME_TAG = "name";
    private static final String MERCENARY_FORCE_TAG = "mercenaryForce";

    public Monarch(Game game, Player player) {
        super(game);
        if (player == null) {
            throw new IllegalStateException("player == null");
        }
        this.player = player;
    }

    public Monarch(Game game, String id) {
        super(game, id);
    }

    public Force getExpeditionaryForce() {
        if (this.expeditionaryForce == null) {
            Specification spec = this.getSpecification();
            this.expeditionaryForce = new Force((UnitListOption)spec.getOption("model.option.refSize"), null);
        }
        return this.expeditionaryForce;
    }

    public Force getInterventionForce() {
        if (this.interventionForce == null) {
            Specification spec = this.getSpecification();
            this.interventionForce = new Force((UnitListOption)spec.getOption("model.option.interventionForce"), null);
        }
        return this.interventionForce;
    }

    public Force getMercenaryForce() {
        Specification spec = this.getSpecification();
        return new Force((UnitListOption)spec.getOption("model.option.mercenaryForce"), null);
    }

    public Force getWarSupportForce() {
        Specification spec = this.getSpecification();
        return new Force((UnitListOption)spec.getOption("model.option.warSupportForce"), null);
    }

    public boolean getSupportSea() {
        return this.supportSea;
    }

    public void setSupportSea(boolean supportSea) {
        this.supportSea = supportSea;
    }

    public boolean getDispleasure() {
        return this.displeasure;
    }

    public void setDispleasure(boolean displeasure) {
        this.displeasure = displeasure;
    }

    private int taxMaximum() {
        return this.getSpecification().getInteger("model.option.maximumTax");
    }

    private void initializeCaches() {
        if (this.navalTypes != null) {
            return;
        }
        Specification spec = this.getSpecification();
        this.navalTypes = new ArrayList<UnitType>();
        this.bombardTypes = new ArrayList<UnitType>();
        this.landTypes = new ArrayList<UnitType>();
        this.mercenaryTypes = new ArrayList<UnitType>();
        this.navalREFUnitTypes = spec.getREFUnitTypes(true);
        this.landREFUnitTypes = spec.getREFUnitTypes(false);
        for (UnitType unitType : spec.getUnitTypeList()) {
            if (unitType.hasAbility("model.ability.supportUnit")) {
                if (unitType.hasAbility("model.ability.navalUnit")) {
                    this.navalTypes.add(unitType);
                } else if (unitType.hasAbility("model.ability.bombard")) {
                    this.bombardTypes.add(unitType);
                } else if (unitType.hasAbility("model.ability.canBeEquipped")) {
                    this.landTypes.add(unitType);
                }
            }
            if (!unitType.hasAbility("model.ability.mercenaryUnit")) continue;
            this.mercenaryTypes.add(unitType);
        }
        for (Role r : spec.getMilitaryRoles()) {
            boolean ok = r.isAvailableTo(this.player, this.landTypes.get(0));
            boolean armed = r.hasAbility("model.ability.armed");
            boolean mounted = r.hasAbility("model.ability.mounted");
            boolean ref = r.requiresAbility("model.ability.refUnit");
            if (armed && mounted) {
                if (ok && !ref && this.mountedRole == null) {
                    this.mountedRole = r;
                    continue;
                }
                if (ok || !ref || this.refMountedRole != null) continue;
                this.refMountedRole = r;
                continue;
            }
            if (!armed || mounted) continue;
            if (ok && !ref && this.armedRole == null) {
                this.armedRole = r;
                continue;
            }
            if (ok || !ref || this.refArmedRole != null) continue;
            this.refArmedRole = r;
        }
    }

    public List<Player> collectPotentialEnemies() {
        return this.player.hasAbility("model.ability.ignoreEuropeanWars") ? Collections.emptyList() : this.getGame().getLiveEuropeanPlayers(this.player).stream().filter(p -> p.isPotentialEnemy(this.player)).collect(Collectors.toList());
    }

    public List<Player> collectPotentialFriends() {
        return this.getGame().getLiveEuropeanPlayers(this.player).stream().filter(p -> p.isPotentialFriend(this.player)).collect(Collectors.toList());
    }

    public boolean actionIsValid(MonarchAction action) {
        this.initializeCaches();
        switch (action) {
            case NO_ACTION: {
                return true;
            }
            case RAISE_TAX_ACT: 
            case RAISE_TAX_WAR: {
                return this.player.getTax() < this.taxMaximum();
            }
            case FORCE_TAX: {
                return false;
            }
            case LOWER_TAX_WAR: 
            case LOWER_TAX_OTHER: {
                return this.player.getTax() > 30;
            }
            case WAIVE_TAX: {
                return true;
            }
            case ADD_TO_REF: {
                return !this.navalREFUnitTypes.isEmpty() && !this.landREFUnitTypes.isEmpty();
            }
            case DECLARE_PEACE: {
                return !this.collectPotentialFriends().isEmpty();
            }
            case DECLARE_WAR: {
                return !this.collectPotentialEnemies().isEmpty();
            }
            case SUPPORT_SEA: {
                return this.player.getAttackedByPrivateers() && !this.getSupportSea() && !this.getDispleasure();
            }
            case SUPPORT_LAND: 
            case MONARCH_MERCENARIES: {
                return this.player.isAtWar() && !this.getDispleasure();
            }
            case HESSIAN_MERCENARIES: {
                return this.player.checkGold(5000);
            }
            case DISPLEASURE: {
                return false;
            }
        }
        throw new IllegalArgumentException("Bogus monarch action: " + (Object)((Object)action));
    }

    public List<RandomChoice<MonarchAction>> getActionChoices() {
        int grace;
        Specification spec = this.getSpecification();
        ArrayList<RandomChoice<MonarchAction>> choices = new ArrayList<RandomChoice<MonarchAction>>();
        int dx = 1 + spec.getInteger("model.option.monarchMeddling");
        int turn = this.getGame().getTurn().getNumber();
        if (turn < (grace = (6 - dx) * 10) || this.player.getSettlements().isEmpty() || this.player.getPlayerType() != Player.PlayerType.COLONIAL) {
            return choices;
        }
        this.addIfValid(choices, MonarchAction.NO_ACTION, Math.max(200 - turn, 100));
        this.addIfValid(choices, MonarchAction.RAISE_TAX_ACT, 5 + dx);
        this.addIfValid(choices, MonarchAction.RAISE_TAX_WAR, 5 + dx);
        this.addIfValid(choices, MonarchAction.LOWER_TAX_WAR, 5 - dx);
        this.addIfValid(choices, MonarchAction.LOWER_TAX_OTHER, 5 - dx);
        this.addIfValid(choices, MonarchAction.ADD_TO_REF, 10 + dx);
        this.addIfValid(choices, MonarchAction.DECLARE_PEACE, 6 - dx);
        this.addIfValid(choices, MonarchAction.DECLARE_WAR, 5 + dx);
        if (this.player.checkGold(200)) {
            this.addIfValid(choices, MonarchAction.MONARCH_MERCENARIES, 6 - dx);
        } else if (dx < 3) {
            this.addIfValid(choices, MonarchAction.SUPPORT_LAND, 3 - dx);
        }
        this.addIfValid(choices, MonarchAction.SUPPORT_SEA, 6 - dx);
        this.addIfValid(choices, MonarchAction.HESSIAN_MERCENARIES, 6 - dx);
        return choices;
    }

    private void addIfValid(List<RandomChoice<MonarchAction>> choices, MonarchAction action, int weight) {
        if (this.actionIsValid(action)) {
            choices.add(new RandomChoice<MonarchAction>(action, weight));
        }
    }

    public int raiseTax(Random random) {
        Specification spec = this.getSpecification();
        int taxAdjustment = spec.getInteger("model.option.taxAdjustment");
        int turn = this.getGame().getTurn().getNumber();
        int oldTax = this.player.getTax();
        int adjust = Math.max(1, (6 - taxAdjustment) * 10);
        adjust = 1 + RandomUtils.randomInt(logger, "Tax rise", random, 5 + turn / adjust);
        return Math.min(oldTax + adjust, this.taxMaximum());
    }

    public int lowerTax(Random random) {
        Specification spec = this.getSpecification();
        int taxAdjustment = spec.getInteger("model.option.taxAdjustment");
        int oldTax = this.player.getTax();
        int adjust = Math.max(1, 10 - taxAdjustment);
        adjust = 1 + RandomUtils.randomInt(logger, "Tax reduction", random, adjust);
        return Math.max(oldTax - adjust, 20);
    }

    public UnitType getNavalREFUnitType() {
        this.initializeCaches();
        return this.navalREFUnitTypes.get(0);
    }

    public AbstractUnit chooseForREF(Random random) {
        List<UnitType> types;
        this.initializeCaches();
        Specification spec = this.getSpecification();
        Force ref = this.getExpeditionaryForce();
        boolean needNaval = ref.getCapacity() < ref.getSpaceRequired() + 15;
        List<UnitType> list = types = needNaval ? this.navalREFUnitTypes : this.landREFUnitTypes;
        if (types.isEmpty()) {
            return null;
        }
        UnitType unitType = RandomUtils.getRandomMember(logger, "Choose REF unit", types, random);
        Role role = needNaval || !unitType.hasAbility("model.ability.canBeEquipped") ? spec.getDefaultRole() : (RandomUtils.randomInt(logger, "Choose land role", random, 3) == 0 ? this.refMountedRole : this.refArmedRole);
        int number = needNaval ? 1 : RandomUtils.randomInt(logger, "Choose land#", random, 3) + 1;
        AbstractUnit result = new AbstractUnit(unitType, role.getId(), number);
        logger.info("Add to " + this.player.getDebugName() + " REF: capacity=" + ref.getCapacity() + " spaceRequired=" + ref.getSpaceRequired() + " => " + result);
        return result;
    }

    public void updateInterventionForce() {
        Specification spec = this.getSpecification();
        int interventionTurns = spec.getInteger("model.option.interventionTurns");
        if (interventionTurns > 0) {
            Force ivf = this.getInterventionForce();
            int updates = this.getGame().getTurn().getNumber() / interventionTurns;
            for (AbstractUnit unit : ivf.getLandUnits()) {
                int value = unit.getNumber() + updates;
                unit.setNumber(value);
            }
            ivf.updateSpaceAndCapacity();
            while (ivf.getCapacity() < ivf.getSpaceRequired()) {
                boolean progress = false;
                for (AbstractUnit ship : ivf.getNavalUnits()) {
                    if (!ship.getType(spec).canCarryUnits() || ship.getType(spec).getSpace() <= 0) continue;
                    int value = ship.getNumber() + 1;
                    ship.setNumber(value);
                    progress = true;
                }
                if (!progress) break;
                ivf.updateSpaceAndCapacity();
            }
        }
    }

    public List<AbstractUnit> getSupport(Random random, boolean naval) {
        this.initializeCaches();
        Specification spec = this.getSpecification();
        ArrayList<AbstractUnit> support = new ArrayList<AbstractUnit>();
        if (naval) {
            support.add(new AbstractUnit(RandomUtils.getRandomMember(logger, "Choose naval support", this.navalTypes, random), "model.role.default", 1));
            this.setSupportSea(true);
            return support;
        }
        int difficulty = spec.getInteger("model.option.monarchSupport");
        switch (difficulty) {
            case 4: {
                support.add(new AbstractUnit(RandomUtils.getRandomMember(logger, "Choose bombard", this.bombardTypes, random), "model.role.default", 1));
                support.add(new AbstractUnit(RandomUtils.getRandomMember(logger, "Choose mounted", this.landTypes, random), this.mountedRole.getId(), 2));
                break;
            }
            case 3: {
                support.add(new AbstractUnit(RandomUtils.getRandomMember(logger, "Choose mounted", this.landTypes, random), this.mountedRole.getId(), 2));
                support.add(new AbstractUnit(RandomUtils.getRandomMember(logger, "Choose soldier", this.landTypes, random), this.armedRole.getId(), 1));
                break;
            }
            case 2: {
                support.add(new AbstractUnit(RandomUtils.getRandomMember(logger, "Choose mounted", this.landTypes, random), this.mountedRole.getId(), 2));
                break;
            }
            case 1: {
                support.add(new AbstractUnit(RandomUtils.getRandomMember(logger, "Choose mounted", this.landTypes, random), this.mountedRole.getId(), 1));
                support.add(new AbstractUnit(RandomUtils.getRandomMember(logger, "Choose soldier", this.landTypes, random), this.armedRole.getId(), 1));
                break;
            }
            case 0: {
                support.add(new AbstractUnit(RandomUtils.getRandomMember(logger, "Choose soldier", this.landTypes, random), this.armedRole.getId(), 1));
                break;
            }
        }
        return support;
    }

    public List<AbstractUnit> getWarSupport(Player enemy, Random random) {
        Specification spec = this.getSpecification();
        double baseStrength = this.player.calculateStrength(false);
        double enemyStrength = enemy.calculateStrength(false);
        double strengthRatio = Player.strengthRatio(baseStrength, enemyStrength);
        ArrayList<AbstractUnit> result = new ArrayList<AbstractUnit>();
        double NOSUPPORT = 0.6;
        double p = 10.0 * (0.6 - strengthRatio);
        if (p >= 1.0 || p > 0.0 && p > RandomUtils.randomDouble(logger, "War support?", random)) {
            double ratio;
            double strength;
            double fullRatio;
            double supportStrength;
            block10: {
                Force wsf = this.getWarSupportForce();
                result.addAll(wsf.getUnits());
                supportStrength = wsf.calculateStrength(false);
                fullRatio = Player.strengthRatio(baseStrength + supportStrength, enemyStrength);
                if (fullRatio < 0.6) {
                    for (AbstractUnit au : result) {
                        int amount = au.getNumber();
                        au.setNumber(amount += RandomUtils.randomInt(logger, "Vary war force " + au.getId(), random, 3) - 1);
                    }
                } else if (enemyStrength <= 0.0) {
                    while (result.size() > 1) {
                        result.remove(0);
                    }
                    ((AbstractUnit)result.get(0)).setNumber(1);
                } else {
                    for (AbstractUnit au : result) {
                        for (int n = au.getNumber() - 1; n >= 1; --n) {
                            au.setNumber(n);
                            strength = AbstractUnit.calculateStrength(spec, result);
                            ratio = Player.strengthRatio(baseStrength + strength, enemyStrength);
                            if (!(ratio < 0.6)) {
                                continue;
                            }
                            break block10;
                        }
                    }
                }
            }
            strength = AbstractUnit.calculateStrength(spec, result);
            ratio = Player.strengthRatio(baseStrength + strength, enemyStrength);
            logger.finest("War support: initially=" + supportStrength + "/" + fullRatio + " finally=" + strength + "/" + ratio);
        }
        return result;
    }

    public List<AbstractUnit> getMercenaries(Random random) {
        this.initializeCaches();
        Specification spec = this.getSpecification();
        Role defaultRole = spec.getDefaultRole();
        int mercPrice = spec.getInteger("model.option.mercenaryPrice");
        ArrayList<Role> landRoles = new ArrayList<Role>();
        landRoles.add(this.armedRole);
        landRoles.add(this.mountedRole);
        ArrayList<AbstractUnit> mercs = new ArrayList<AbstractUnit>();
        int count = RandomUtils.randomInt(logger, "Mercenary count", random, 2) + 2;
        int price = 0;
        FreeColObject unitType = null;
        ArrayList<UnitType> unitTypes = new ArrayList<UnitType>(this.mercenaryTypes);
        while (!unitTypes.isEmpty() && count > 0) {
            unitType = RandomUtils.getRandomMember(logger, "Merc unit", unitTypes, random);
            unitTypes.remove(unitType);
            Role role = unitType.hasAbility("model.ability.canBeEquipped") ? (Role)RandomUtils.getRandomMember(logger, "Merc role", landRoles, random) : defaultRole;
            int n = RandomUtils.randomInt(logger, "Merc count " + unitType, random, Math.min(count, 2)) + 1;
            AbstractUnit au = new AbstractUnit((UnitType)unitType, role.getId(), n);
            while (true) {
                int newPrice;
                if (this.player.checkGold(price + (newPrice = this.player.getPrice(au) * mercPrice / 100))) {
                    mercs.add(au);
                    price += newPrice;
                    count -= n;
                    break;
                }
                if (--n <= 0) break;
                au.setNumber(n);
            }
            if (count > 0) continue;
            break;
        }
        if (mercs.isEmpty() && unitType != null) {
            Role r = unitType.hasAbility("model.ability.canBeEquipped") ? this.armedRole : defaultRole;
            mercs.add(new AbstractUnit((UnitType)unitType, r.getId(), 1));
        }
        return mercs;
    }

    @Override
    public String getNameKey() {
        return this.player.getNation().getRulerNameKey();
    }

    @Override
    public int checkIntegrity(boolean fix) {
        int result = super.checkIntegrity(fix);
        ArrayList<AbstractUnit> todo = new ArrayList<AbstractUnit>();
        Force ref = this.getExpeditionaryForce();
        Iterator<AbstractUnit> it = ref.getLandUnits().iterator();
        while (it.hasNext()) {
            AbstractUnit au = it.next();
            if ("model.role.soldier".equals(au.getRoleId())) {
                if (fix) {
                    au.setRoleId("model.role.infantry");
                    result = 0;
                    it.remove();
                    todo.add(au);
                } else {
                    return -1;
                }
            }
            if (!"model.role.dragoon".equals(au.getRoleId())) continue;
            if (fix) {
                au.setRoleId("model.role.cavalry");
                result = 0;
                it.remove();
                todo.add(au);
                continue;
            }
            return -1;
        }
        for (AbstractUnit au : todo) {
            ref.add(au);
        }
        return result;
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        xw.writeAttribute(PLAYER_TAG, this.player);
        if (xw.validFor(this.player)) {
            xw.writeAttribute(SUPPORT_SEA_TAG, this.supportSea);
            xw.writeAttribute(DISPLEASURE_TAG, this.displeasure);
        }
    }

    @Override
    protected void writeChildren(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeChildren(xw);
        if (xw.validFor(this.player)) {
            this.getExpeditionaryForce().toXML(xw, EXPEDITIONARY_FORCE_TAG);
            this.getInterventionForce().toXML(xw, INTERVENTION_FORCE_TAG);
        }
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        this.player = xr.findFreeColGameObject(this.getGame(), PLAYER_TAG, Player.class, null, true);
        this.supportSea = xr.getAttribute(SUPPORT_SEA_TAG, false);
        this.displeasure = xr.getAttribute(DISPLEASURE_TAG, false);
    }

    @Override
    protected void readChildren(FreeColXMLReader xr) throws XMLStreamException {
        if (this.expeditionaryForce == null) {
            this.expeditionaryForce = new Force();
        }
        if (this.interventionForce == null) {
            this.interventionForce = new Force();
        }
        super.readChildren(xr);
    }

    @Override
    protected void readChild(FreeColXMLReader xr) throws XMLStreamException {
        String tag = xr.getLocalName();
        if (EXPEDITIONARY_FORCE_TAG.equals(tag)) {
            this.expeditionaryForce.readFromXML(xr);
            this.expeditionaryForce.fixOldREFRoles();
        } else if (INTERVENTION_FORCE_TAG.equals(tag)) {
            this.interventionForce.readFromXML(xr);
        } else if ("landUnits".equals(tag)) {
            this.expeditionaryForce.getLandUnits().clear();
            while (xr.nextTag() != 2) {
                AbstractUnit newUnit = new AbstractUnit(xr);
                this.expeditionaryForce.getLandUnits().add(newUnit);
            }
        } else if (MERCENARY_FORCE_TAG.equals(tag)) {
            new Force().readFromXML(xr);
        } else if ("navalUnits".equals(tag)) {
            this.expeditionaryForce.getNavalUnits().clear();
            while (xr.nextTag() != 2) {
                AbstractUnit newUnit = new AbstractUnit(xr);
                this.expeditionaryForce.getNavalUnits().add(newUnit);
            }
        } else {
            super.readChild(xr);
        }
    }

    @Override
    public String getXMLTagName() {
        return Monarch.getXMLElementTagName();
    }

    public static String getXMLElementTagName() {
        return "monarch";
    }

    public static enum MonarchAction {
        NO_ACTION,
        RAISE_TAX_ACT,
        RAISE_TAX_WAR,
        FORCE_TAX,
        LOWER_TAX_WAR,
        LOWER_TAX_OTHER,
        WAIVE_TAX,
        ADD_TO_REF,
        DECLARE_PEACE,
        DECLARE_WAR,
        SUPPORT_LAND,
        SUPPORT_SEA,
        MONARCH_MERCENARIES,
        HESSIAN_MERCENARIES,
        DISPLEASURE;


        private String getKey() {
            return "monarch.action." + StringUtils.getEnumKey(this);
        }

        public String getTextKey() {
            return "model." + this.getKey() + ".text";
        }

        public String getYesKey() {
            return "model." + this.getKey() + ".yes";
        }

        public String getNoKey() {
            return "model." + this.getKey() + ".no";
        }

        public String getHeaderKey() {
            return "model." + this.getKey() + ".header";
        }
    }

    public class Force {
        private final List<AbstractUnit> landUnits = new ArrayList<AbstractUnit>();
        private final List<AbstractUnit> navalUnits = new ArrayList<AbstractUnit>();
        private int spaceRequired;
        private int capacity;
        public static final String LAND_UNITS_TAG = "landUnits";
        public static final String NAVAL_UNITS_TAG = "navalUnits";

        public Force() {
        }

        public Force(UnitListOption option, String ability) {
            Specification spec = Monarch.this.getSpecification();
            List units = option.getOptionValues();
            for (AbstractUnit unit : units) {
                UnitType unitType = unit.getType(spec);
                if (ability == null || unitType.hasAbility(ability)) {
                    if (unitType.hasAbility("model.ability.navalUnit")) {
                        this.navalUnits.add(unit);
                        continue;
                    }
                    this.landUnits.add(unit);
                    continue;
                }
                logger.warning("Found unit lacking required ability \"" + ability + "\": " + unit);
            }
            this.updateSpaceAndCapacity();
        }

        public final int getSpaceRequired() {
            return this.spaceRequired;
        }

        public final int getCapacity() {
            return this.capacity;
        }

        public final void updateSpaceAndCapacity() {
            Specification spec = Monarch.this.getSpecification();
            this.capacity = this.navalUnits.stream().filter(nu -> nu.getType(spec).canCarryUnits()).mapToInt(nu -> nu.getType(spec).getSpace() * nu.getNumber()).sum();
            this.spaceRequired = this.landUnits.stream().mapToInt(lu -> lu.getType(spec).getSpaceTaken() * lu.getNumber()).sum();
        }

        public final List<AbstractUnit> getUnits() {
            List<AbstractUnit> result = this.getLandUnits();
            result.addAll(this.getNavalUnits());
            return result;
        }

        public final List<AbstractUnit> getNavalUnits() {
            return AbstractUnit.deepCopy(this.navalUnits);
        }

        public final List<AbstractUnit> getLandUnits() {
            return AbstractUnit.deepCopy(this.landUnits);
        }

        public final boolean isEmpty() {
            return this.landUnits.isEmpty() && this.navalUnits.isEmpty();
        }

        public void add(AbstractUnit au) {
            Specification spec = Monarch.this.getSpecification();
            UnitType unitType = au.getType(spec);
            int n = au.getNumber();
            boolean added = false;
            if (unitType.hasAbility("model.ability.navalUnit")) {
                for (AbstractUnit refUnit : this.navalUnits) {
                    if (spec.getUnitType(refUnit.getId()) != unitType) continue;
                    refUnit.setNumber(refUnit.getNumber() + n);
                    if (unitType.canCarryUnits()) {
                        this.capacity += unitType.getSpace() * n;
                    }
                    added = true;
                    break;
                }
                if (!added) {
                    this.navalUnits.add(au);
                }
            } else {
                for (AbstractUnit refUnit : this.landUnits) {
                    if (spec.getUnitType(refUnit.getId()) != unitType || !refUnit.getRoleId().equals(au.getRoleId())) continue;
                    refUnit.setNumber(refUnit.getNumber() + n);
                    this.spaceRequired += unitType.getSpaceTaken() * n;
                    added = true;
                    break;
                }
                if (!added) {
                    this.landUnits.add(au);
                }
            }
            this.updateSpaceAndCapacity();
        }

        public double calculateStrength(boolean naval) {
            return AbstractUnit.calculateStrength(Monarch.this.getSpecification(), naval ? this.navalUnits : this.landUnits);
        }

        public void fixOldREFRoles() {
            Iterator<AbstractUnit> aui = this.landUnits.iterator();
            ArrayList<AbstractUnit> todo = new ArrayList<AbstractUnit>();
            while (aui.hasNext()) {
                AbstractUnit au = aui.next();
                if ("SOLDIER".equals(au.getRoleId()) || "model.role.soldier".equals(au.getRoleId())) {
                    au.setRoleId("model.role.infantry");
                    aui.remove();
                    todo.add(au);
                    continue;
                }
                if (!"DRAGOON".equals(au.getRoleId()) && !"model.role.dragoon".equals(au.getRoleId())) continue;
                au.setRoleId("model.role.cavalry");
                aui.remove();
                todo.add(au);
            }
            while (!todo.isEmpty()) {
                this.add((AbstractUnit)todo.remove(0));
            }
        }

        public void toXML(FreeColXMLWriter xw, String tag) throws XMLStreamException {
            xw.writeStartElement(tag);
            xw.writeStartElement(NAVAL_UNITS_TAG);
            for (AbstractUnit unit : this.navalUnits) {
                unit.toXML(xw);
            }
            xw.writeEndElement();
            xw.writeStartElement(LAND_UNITS_TAG);
            for (AbstractUnit unit : this.landUnits) {
                unit.toXML(xw);
            }
            xw.writeEndElement();
            xw.writeEndElement();
        }

        public void readFromXML(FreeColXMLReader xr) throws XMLStreamException {
            this.navalUnits.clear();
            this.landUnits.clear();
            while (xr.nextTag() != 2) {
                String tag = xr.getLocalName();
                if (LAND_UNITS_TAG.equals(tag)) {
                    while (xr.nextTag() != 2) {
                        this.add(new AbstractUnit(xr));
                    }
                    continue;
                }
                if (NAVAL_UNITS_TAG.equals(tag)) {
                    while (xr.nextTag() != 2) {
                        this.add(new AbstractUnit(xr));
                    }
                    continue;
                }
                logger.warning("Bogus Force tag: " + tag);
            }
        }
    }
}

