/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider.runner;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.gradle.configuration.project.ConfigureProjectBuildOperationType;
import org.gradle.internal.build.event.BuildEventSubscriptions;
import org.gradle.internal.build.event.types.AbstractOperationResult;
import org.gradle.internal.build.event.types.AbstractProjectConfigurationResult;
import org.gradle.internal.build.event.types.DefaultFailure;
import org.gradle.internal.build.event.types.DefaultOperationDescriptor;
import org.gradle.internal.build.event.types.DefaultOperationFinishedProgressEvent;
import org.gradle.internal.build.event.types.DefaultOperationStartedProgressEvent;
import org.gradle.internal.build.event.types.DefaultPluginApplicationResult;
import org.gradle.internal.build.event.types.DefaultProjectConfigurationDescriptor;
import org.gradle.internal.build.event.types.DefaultProjectConfigurationFailureResult;
import org.gradle.internal.build.event.types.DefaultProjectConfigurationSuccessResult;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationListener;
import org.gradle.internal.operations.OperationFinishEvent;
import org.gradle.internal.operations.OperationIdentifier;
import org.gradle.internal.operations.OperationStartEvent;
import org.gradle.tooling.events.OperationType;
import org.gradle.tooling.internal.protocol.events.InternalOperationFinishedProgressEvent;
import org.gradle.tooling.internal.protocol.events.InternalOperationStartedProgressEvent;
import org.gradle.tooling.internal.protocol.events.InternalPluginIdentifier;
import org.gradle.tooling.internal.protocol.events.InternalProjectConfigurationResult;
import org.gradle.tooling.internal.provider.runner.BuildOperationParentTracker;
import org.gradle.tooling.internal.provider.runner.PluginApplicationTracker;
import org.gradle.tooling.internal.provider.runner.ProgressEventConsumer;
import org.gradle.tooling.internal.provider.runner.SubtreeFilteringBuildOperationListener;

class ClientForwardingProjectConfigurationOperationListener
extends SubtreeFilteringBuildOperationListener<ConfigureProjectBuildOperationType.Details> {
    private final Map<OperationIdentifier, ProjectConfigurationResult> results = new ConcurrentHashMap<OperationIdentifier, ProjectConfigurationResult>();
    private final BuildOperationParentTracker parentTracker;
    private final PluginApplicationTracker pluginApplicationTracker;

    ClientForwardingProjectConfigurationOperationListener(ProgressEventConsumer eventConsumer, BuildEventSubscriptions clientSubscriptions, BuildOperationListener delegate, BuildOperationParentTracker parentTracker, PluginApplicationTracker pluginApplicationTracker) {
        super(eventConsumer, clientSubscriptions, delegate, OperationType.PROJECT_CONFIGURATION, ConfigureProjectBuildOperationType.Details.class);
        this.parentTracker = parentTracker;
        this.pluginApplicationTracker = pluginApplicationTracker;
    }

    @Override
    public void finished(BuildOperationDescriptor buildOperation, OperationFinishEvent finishEvent) {
        PluginApplicationTracker.PluginApplication pluginApplication;
        super.finished(buildOperation, finishEvent);
        if (this.isEnabled() && (pluginApplication = this.pluginApplicationTracker.getRunningPluginApplication(buildOperation.getId())) != null) {
            ProjectConfigurationResult result = this.parentTracker.findClosestExistingAncestor(buildOperation.getParentId(), this.results::get);
            if (result != null && this.hasNoEnclosingRunningPluginApplicationForSamePlugin(buildOperation, pluginApplication.getPlugin())) {
                result.increment(pluginApplication, finishEvent.getEndTime() - finishEvent.getStartTime());
            }
        }
    }

    private boolean hasNoEnclosingRunningPluginApplicationForSamePlugin(BuildOperationDescriptor buildOperation, InternalPluginIdentifier plugin) {
        return !this.pluginApplicationTracker.hasRunningPluginApplication(buildOperation.getParentId(), pluginApplication -> pluginApplication.getPlugin().equals(plugin));
    }

    @Override
    protected InternalOperationStartedProgressEvent toStartedEvent(BuildOperationDescriptor buildOperation, OperationStartEvent startEvent, ConfigureProjectBuildOperationType.Details details) {
        this.results.put(buildOperation.getId(), new ProjectConfigurationResult());
        return new DefaultOperationStartedProgressEvent(startEvent.getStartTime(), (DefaultOperationDescriptor)this.toProjectConfigurationDescriptor(buildOperation, details));
    }

    @Override
    protected InternalOperationFinishedProgressEvent toFinishedEvent(BuildOperationDescriptor buildOperation, OperationFinishEvent finishEvent, ConfigureProjectBuildOperationType.Details details) {
        AbstractProjectConfigurationResult result = this.toProjectConfigurationOperationResult(finishEvent, this.results.remove(buildOperation.getId()));
        return new DefaultOperationFinishedProgressEvent(finishEvent.getEndTime(), (DefaultOperationDescriptor)this.toProjectConfigurationDescriptor(buildOperation, details), (AbstractOperationResult)result);
    }

    private DefaultProjectConfigurationDescriptor toProjectConfigurationDescriptor(BuildOperationDescriptor buildOperation, ConfigureProjectBuildOperationType.Details details) {
        OperationIdentifier id = buildOperation.getId();
        String displayName = buildOperation.getDisplayName();
        Object parentId = this.eventConsumer.findStartedParentId(buildOperation);
        return new DefaultProjectConfigurationDescriptor((Object)id, displayName, parentId, details.getRootDir(), details.getProjectPath());
    }

    private AbstractProjectConfigurationResult toProjectConfigurationOperationResult(OperationFinishEvent finishEvent, ProjectConfigurationResult configResult) {
        List<Object> pluginApplicationResults;
        long startTime = finishEvent.getStartTime();
        long endTime = finishEvent.getEndTime();
        Throwable failure = finishEvent.getFailure();
        List<Object> list = pluginApplicationResults = configResult != null ? configResult.toInternalPluginApplicationResults() : Collections.emptyList();
        if (failure != null) {
            return new DefaultProjectConfigurationFailureResult(startTime, endTime, Collections.singletonList(DefaultFailure.fromThrowable((Throwable)failure)), pluginApplicationResults);
        }
        return new DefaultProjectConfigurationSuccessResult(startTime, endTime, pluginApplicationResults);
    }

    private static class PluginApplicationResult {
        private AtomicLong duration = new AtomicLong();
        private final InternalPluginIdentifier plugin;
        private final long firstApplicationId;

        PluginApplicationResult(InternalPluginIdentifier plugin, long firstApplicationId) {
            this.plugin = plugin;
            this.firstApplicationId = firstApplicationId;
        }

        long getFirstApplicationId() {
            return this.firstApplicationId;
        }

        void increment(long duration) {
            this.duration.addAndGet(duration);
        }

        InternalProjectConfigurationResult.InternalPluginApplicationResult toInternalPluginApplicationResult() {
            return new DefaultPluginApplicationResult(this.plugin, Duration.ofMillis(this.duration.get()));
        }
    }

    private static class ProjectConfigurationResult {
        private final Map<InternalPluginIdentifier, PluginApplicationResult> pluginApplicationResults = new ConcurrentHashMap<InternalPluginIdentifier, PluginApplicationResult>();

        private ProjectConfigurationResult() {
        }

        void increment(PluginApplicationTracker.PluginApplication pluginApplication, long duration) {
            InternalPluginIdentifier plugin = pluginApplication.getPlugin();
            this.pluginApplicationResults.computeIfAbsent(plugin, key -> new PluginApplicationResult(plugin, pluginApplication.getApplicationId())).increment(duration);
        }

        List<InternalProjectConfigurationResult.InternalPluginApplicationResult> toInternalPluginApplicationResults() {
            return this.pluginApplicationResults.values().stream().sorted(Comparator.comparing(PluginApplicationResult::getFirstApplicationId)).map(PluginApplicationResult::toInternalPluginApplicationResult).collect(Collectors.toCollection(ArrayList::new));
        }
    }
}

