/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.java;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.psi.JavaCodeFragment;
import org.jetbrains.kotlin.com.intellij.psi.JavaElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnonymousClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassType;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpressionList;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaCodeReferenceElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiSuperExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.Constants;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.ChildRole;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.java.ExpressionPsiElement;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;

public class PsiSuperExpressionImpl
extends ExpressionPsiElement
implements PsiSuperExpression,
Constants {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.tree.java.PsiSuperExpressionImpl");

    public PsiSuperExpressionImpl() {
        super(SUPER_EXPRESSION);
    }

    @Override
    public PsiJavaCodeReferenceElement getQualifier() {
        return (PsiJavaCodeReferenceElement)this.findChildByRoleAsPsiElement(54);
    }

    @Override
    public PsiType getType() {
        PsiJavaCodeReferenceElement qualifier = this.getQualifier();
        if (qualifier != null) {
            PsiElement aClass2 = qualifier.resolve();
            if (!(aClass2 instanceof PsiClass)) {
                return null;
            }
            return this.getSuperType((PsiClass)aClass2, PsiUtil.isLanguageLevel8OrHigher(this));
        }
        for (PsiElement scope2 = this.getContext(); scope2 != null; scope2 = scope2.getContext()) {
            PsiType fragmentSuperType;
            if (scope2 instanceof PsiClass) {
                PsiClass aClass3 = (PsiClass)scope2;
                return this.getSuperType(aClass3, false);
            }
            if (scope2 instanceof PsiExpressionList && scope2.getParent() instanceof PsiAnonymousClass) {
                scope2 = scope2.getParent();
                continue;
            }
            if (!(scope2 instanceof JavaCodeFragment) || (fragmentSuperType = ((JavaCodeFragment)scope2).getSuperType()) == null) continue;
            return fragmentSuperType;
        }
        return null;
    }

    @Nullable
    private PsiType getSuperType(PsiClass aClass2, boolean checkImmediateSuperInterfaces) {
        PsiClassType[] superTypes2;
        PsiClass containingClass;
        if ("java.lang.Object".equals(aClass2.getQualifiedName())) {
            return null;
        }
        PsiClass psiClass = containingClass = checkImmediateSuperInterfaces ? PsiTreeUtil.getParentOfType((PsiElement)this, PsiClass.class) : null;
        if (containingClass != null) {
            superTypes2 = containingClass.isInterface() ? containingClass.getExtendsListTypes() : (containingClass instanceof PsiAnonymousClass ? new PsiClassType[]{((PsiAnonymousClass)containingClass).getBaseClassType()} : containingClass.getImplementsListTypes());
            for (PsiClassType superType : superTypes2) {
                PsiClass superClass = superType.resolve();
                if (superClass == null || !superClass.isInterface() || !aClass2.equals(superClass)) continue;
                return superType;
            }
        }
        if (aClass2.isInterface()) {
            return PsiType.getJavaLangObject(this.getManager(), this.getResolveScope());
        }
        if (aClass2 instanceof PsiAnonymousClass) {
            PsiClassType baseClassType = ((PsiAnonymousClass)aClass2).getBaseClassType();
            PsiClass psiClass2 = baseClassType.resolve();
            return psiClass2 != null && !psiClass2.isInterface() ? baseClassType : PsiType.getJavaLangObject(this.getManager(), this.getResolveScope());
        }
        superTypes2 = aClass2.getExtendsListTypes();
        return superTypes2.length == 0 ? PsiType.getJavaLangObject(this.getManager(), this.getResolveScope()) : superTypes2[0];
    }

    @Override
    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            default: {
                return null;
            }
            case 54: {
                return this.getFirstChildNode().getElementType() == JAVA_CODE_REFERENCE ? this.getFirstChildNode() : null;
            }
            case 55: {
                return this.findChildByType(DOT);
            }
            case 96: 
        }
        return this.getLastChildNode();
    }

    @Override
    public int getChildRole(@NotNull ASTNode child) {
        if (child == null) {
            PsiSuperExpressionImpl.$$$reportNull$$$0(0);
        }
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == JAVA_CODE_REFERENCE) {
            return 54;
        }
        if (i == DOT) {
            return 55;
        }
        if (i == SUPER_KEYWORD) {
            return 96;
        }
        return 0;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            PsiSuperExpressionImpl.$$$reportNull$$$0(1);
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitSuperExpression(this);
        } else {
            visitor2.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "PsiSuperExpression:" + this.getText();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiSuperExpressionImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getChildRole";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "accept";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

