/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.jdbc.user;

import com.google.inject.Inject;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.auth.jdbc.base.RestrictedObject;
import org.apache.guacamole.auth.jdbc.user.ModeledUser;
import org.apache.guacamole.auth.jdbc.user.UserService;
import org.apache.guacamole.net.auth.Directory;
import org.apache.guacamole.net.auth.User;
import org.mybatis.guice.transactional.Transactional;

public class UserDirectory
extends RestrictedObject
implements Directory<User> {
    @Inject
    private UserService userService;

    public User get(String identifier) throws GuacamoleException {
        return (User)this.userService.retrieveObject(this.getCurrentUser(), identifier);
    }

    @Transactional
    public Collection<User> getAll(Collection<String> identifiers) throws GuacamoleException {
        Collection objects = this.userService.retrieveObjects(this.getCurrentUser(), identifiers);
        return Collections.unmodifiableCollection(objects);
    }

    @Transactional
    public Set<String> getIdentifiers() throws GuacamoleException {
        return this.userService.getIdentifiers(this.getCurrentUser());
    }

    @Transactional
    public void add(User object) throws GuacamoleException {
        this.userService.createObject(this.getCurrentUser(), object);
    }

    @Transactional
    public void update(User object) throws GuacamoleException {
        ModeledUser user = (ModeledUser)object;
        this.userService.updateObject(this.getCurrentUser(), user);
    }

    @Transactional
    public void remove(String identifier) throws GuacamoleException {
        this.userService.deleteObject(this.getCurrentUser(), identifier);
    }
}

