/*
 * Decompiled with CFR 0.152.
 */
package com.southernstorm.noise.crypto;

import com.southernstorm.noise.protocol.Destroyable;
import java.util.Arrays;

public final class Poly1305
implements Destroyable,
Cloneable {
    private final byte[] nonce = new byte[16];
    private final byte[] block = new byte[16];
    private final int[] h = new int[5];
    private final int[] r = new int[5];
    private final int[] c = new int[5];
    private final long[] t = new long[10];
    private int posn = 0;

    public void reset(byte[] key, int offset) {
        System.arraycopy(key, offset + 16, this.nonce, 0, 16);
        Arrays.fill(this.h, 0);
        this.posn = 0;
        this.r[0] = key[offset] & 0xFF | (key[offset + 1] & 0xFF) << 8 | (key[offset + 2] & 0xFF) << 16 | (key[offset + 3] & 3) << 24;
        this.r[1] = (key[offset + 3] & 0xC) >> 2 | (key[offset + 4] & 0xFC) << 6 | (key[offset + 5] & 0xFF) << 14 | (key[offset + 6] & 0xF) << 22;
        this.r[2] = (key[offset + 6] & 0xF0) >> 4 | (key[offset + 7] & 0xF) << 4 | (key[offset + 8] & 0xFC) << 12 | (key[offset + 9] & 0x3F) << 20;
        this.r[3] = (key[offset + 9] & 0xC0) >> 6 | (key[offset + 10] & 0xFF) << 2 | (key[offset + 11] & 0xF) << 10 | (key[offset + 12] & 0xFC) << 18;
        this.r[4] = key[offset + 13] & 0xFF | (key[offset + 14] & 0xFF) << 8 | (key[offset + 15] & 0xF) << 16;
    }

    public void update(byte[] data, int offset, int length) {
        while (length > 0) {
            if (this.posn == 0 && length >= 16) {
                this.processChunk(data, offset, false);
                offset += 16;
                length -= 16;
                continue;
            }
            int temp = 16 - this.posn;
            if (temp > length) {
                temp = length;
            }
            System.arraycopy(data, offset, this.block, this.posn, temp);
            offset += temp;
            length -= temp;
            this.posn += temp;
            if (this.posn < 16) continue;
            this.processChunk(this.block, 0, false);
            this.posn = 0;
        }
    }

    public void pad() {
        if (this.posn != 0) {
            Arrays.fill(this.block, this.posn, 16, (byte)0);
            this.processChunk(this.block, 0, false);
            this.posn = 0;
        }
    }

    public void finish(byte[] token, int offset) {
        if (this.posn != 0) {
            this.block[this.posn] = 1;
            Arrays.fill(this.block, this.posn + 1, 16, (byte)0);
            this.processChunk(this.block, 0, true);
        }
        int carry = (this.h[4] >> 26) * 5 + this.h[0];
        this.h[0] = carry & 0x3FFFFFF;
        carry = (carry >> 26) + this.h[1];
        this.h[1] = carry & 0x3FFFFFF;
        carry = (carry >> 26) + this.h[2];
        this.h[2] = carry & 0x3FFFFFF;
        carry = (carry >> 26) + this.h[3];
        this.h[3] = carry & 0x3FFFFFF;
        this.h[4] = (carry >> 26) + (this.h[4] & 0x3FFFFFF);
        carry = 5 + this.h[0];
        this.c[0] = carry & 0x3FFFFFF;
        carry = (carry >> 26) + this.h[1];
        this.c[1] = carry & 0x3FFFFFF;
        carry = (carry >> 26) + this.h[2];
        this.c[2] = carry & 0x3FFFFFF;
        carry = (carry >> 26) + this.h[3];
        this.c[3] = carry & 0x3FFFFFF;
        this.c[4] = (carry >> 26) + this.h[4];
        int mask = -(this.c[4] >> 26 & 1);
        int nmask = ~mask;
        this.h[0] = this.h[0] & nmask | this.c[0] & mask;
        this.h[1] = this.h[1] & nmask | this.c[1] & mask;
        this.h[2] = this.h[2] & nmask | this.c[2] & mask;
        this.h[3] = this.h[3] & nmask | this.c[3] & mask;
        this.h[4] = this.h[4] & nmask | this.c[4] & mask;
        this.block[0] = (byte)this.h[0];
        this.block[1] = (byte)(this.h[0] >> 8);
        this.block[2] = (byte)(this.h[0] >> 16);
        this.block[3] = (byte)(this.h[0] >> 24 | this.h[1] << 2);
        this.block[4] = (byte)(this.h[1] >> 6);
        this.block[5] = (byte)(this.h[1] >> 14);
        this.block[6] = (byte)(this.h[1] >> 22 | this.h[2] << 4);
        this.block[7] = (byte)(this.h[2] >> 4);
        this.block[8] = (byte)(this.h[2] >> 12);
        this.block[9] = (byte)(this.h[2] >> 20 | this.h[3] << 6);
        this.block[10] = (byte)(this.h[3] >> 2);
        this.block[11] = (byte)(this.h[3] >> 10);
        this.block[12] = (byte)(this.h[3] >> 18);
        this.block[13] = (byte)this.h[4];
        this.block[14] = (byte)(this.h[4] >> 8);
        this.block[15] = (byte)(this.h[4] >> 16);
        carry = (this.nonce[0] & 0xFF) + (this.block[0] & 0xFF);
        token[offset] = (byte)carry;
        for (int x = 1; x < 16; ++x) {
            carry = (carry >> 8) + (this.nonce[x] & 0xFF) + (this.block[x] & 0xFF);
            token[offset + x] = (byte)carry;
        }
    }

    private void processChunk(byte[] chunk, int offset, boolean finalChunk) {
        this.c[0] = chunk[offset] & 0xFF | (chunk[offset + 1] & 0xFF) << 8 | (chunk[offset + 2] & 0xFF) << 16 | (chunk[offset + 3] & 3) << 24;
        this.c[1] = (chunk[offset + 3] & 0xFC) >> 2 | (chunk[offset + 4] & 0xFF) << 6 | (chunk[offset + 5] & 0xFF) << 14 | (chunk[offset + 6] & 0xF) << 22;
        this.c[2] = (chunk[offset + 6] & 0xF0) >> 4 | (chunk[offset + 7] & 0xFF) << 4 | (chunk[offset + 8] & 0xFF) << 12 | (chunk[offset + 9] & 0x3F) << 20;
        this.c[3] = (chunk[offset + 9] & 0xC0) >> 6 | (chunk[offset + 10] & 0xFF) << 2 | (chunk[offset + 11] & 0xFF) << 10 | (chunk[offset + 12] & 0xFF) << 18;
        this.c[4] = chunk[offset + 13] & 0xFF | (chunk[offset + 14] & 0xFF) << 8 | (chunk[offset + 15] & 0xFF) << 16;
        if (!finalChunk) {
            this.c[4] = this.c[4] | 0x1000000;
        }
        this.h[0] = this.h[0] + this.c[0];
        this.h[1] = this.h[1] + this.c[1];
        this.h[2] = this.h[2] + this.c[2];
        this.h[3] = this.h[3] + this.c[3];
        this.h[4] = this.h[4] + this.c[4];
        long hv = this.h[0];
        this.t[0] = hv * (long)this.r[0];
        this.t[1] = hv * (long)this.r[1];
        this.t[2] = hv * (long)this.r[2];
        this.t[3] = hv * (long)this.r[3];
        this.t[4] = hv * (long)this.r[4];
        for (int x = 1; x < 5; ++x) {
            hv = this.h[x];
            int n = x;
            this.t[n] = this.t[n] + hv * (long)this.r[0];
            int n2 = x + 1;
            this.t[n2] = this.t[n2] + hv * (long)this.r[1];
            int n3 = x + 2;
            this.t[n3] = this.t[n3] + hv * (long)this.r[2];
            int n4 = x + 3;
            this.t[n4] = this.t[n4] + hv * (long)this.r[3];
            this.t[x + 4] = hv * (long)this.r[4];
        }
        this.h[0] = (int)this.t[0] & 0x3FFFFFF;
        hv = this.t[1] + (this.t[0] >> 26);
        this.h[1] = (int)hv & 0x3FFFFFF;
        hv = this.t[2] + (hv >> 26);
        this.h[2] = (int)hv & 0x3FFFFFF;
        hv = this.t[3] + (hv >> 26);
        this.h[3] = (int)hv & 0x3FFFFFF;
        hv = this.t[4] + (hv >> 26);
        this.h[4] = (int)hv & 0x3FFFFFF;
        hv = this.t[5] + (hv >> 26);
        this.c[0] = (int)hv & 0x3FFFFFF;
        hv = this.t[6] + (hv >> 26);
        this.c[1] = (int)hv & 0x3FFFFFF;
        hv = this.t[7] + (hv >> 26);
        this.c[2] = (int)hv & 0x3FFFFFF;
        hv = this.t[8] + (hv >> 26);
        this.c[3] = (int)hv & 0x3FFFFFF;
        hv = this.t[9] + (hv >> 26);
        this.c[4] = (int)hv;
        int carry = this.h[0] + this.c[0] * 5;
        this.h[0] = carry & 0x3FFFFFF;
        carry = (carry >> 26) + this.h[1] + this.c[1] * 5;
        this.h[1] = carry & 0x3FFFFFF;
        carry = (carry >> 26) + this.h[2] + this.c[2] * 5;
        this.h[2] = carry & 0x3FFFFFF;
        carry = (carry >> 26) + this.h[3] + this.c[3] * 5;
        this.h[3] = carry & 0x3FFFFFF;
        this.h[4] = carry = (carry >> 26) + this.h[4] + this.c[4] * 5;
    }

    @Override
    public void destroy() {
        Arrays.fill(this.nonce, (byte)0);
        Arrays.fill(this.block, (byte)0);
        Arrays.fill(this.h, 0);
        Arrays.fill(this.r, 0);
        Arrays.fill(this.c, 0);
        Arrays.fill(this.t, 0L);
    }

    public Poly1305 clone() throws CloneNotSupportedException {
        return (Poly1305)super.clone();
    }
}

