/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.language.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import de.plushnikov.intellij.plugin.language.psi.LombokConfigElementType;
import de.plushnikov.intellij.plugin.language.psi.LombokConfigTokenType;
import de.plushnikov.intellij.plugin.language.psi.impl.LombokConfigCleanerImpl;
import de.plushnikov.intellij.plugin.language.psi.impl.LombokConfigOperationImpl;
import de.plushnikov.intellij.plugin.language.psi.impl.LombokConfigPropertyImpl;

public interface LombokConfigTypes {
    public static final IElementType CLEANER = new LombokConfigElementType("CLEANER");
    public static final IElementType OPERATION = new LombokConfigElementType("OPERATION");
    public static final IElementType PROPERTY = new LombokConfigElementType("PROPERTY");
    public static final IElementType CLEAR = new LombokConfigTokenType("CLEAR");
    public static final IElementType COMMENT = new LombokConfigTokenType("COMMENT");
    public static final IElementType CRLF = new LombokConfigTokenType("CRLF");
    public static final IElementType KEY = new LombokConfigTokenType("KEY");
    public static final IElementType SEPARATOR = new LombokConfigTokenType("SEPARATOR");
    public static final IElementType SIGN = new LombokConfigTokenType("SIGN");
    public static final IElementType VALUE = new LombokConfigTokenType("VALUE");

    public static class Factory {
        public static PsiElement createElement(ASTNode node) {
            IElementType type = node.getElementType();
            if (type == CLEANER) {
                return new LombokConfigCleanerImpl(node);
            }
            if (type == OPERATION) {
                return new LombokConfigOperationImpl(node);
            }
            if (type == PROPERTY) {
                return new LombokConfigPropertyImpl(node);
            }
            throw new AssertionError((Object)("Unknown element type: " + type));
        }
    }
}

