/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.lombokconfig;

import java.util.Locale;

public enum ConfigKey {
    CONFIG_STOP_BUBBLING("config.stopBubbling", "false"),
    COPYABLE_ANNOTATIONS("lombok.copyableAnnotations", "", false),
    LOG_FIELDNAME("lombok.log.fieldName", "log"),
    LOG_FIELD_IS_STATIC("lombok.log.fieldIsStatic", "true"),
    LOG_CUSTOM_DECLARATION("lombok.log.custom.declaration", ""),
    EQUALSANDHASHCODE_CALL_SUPER("lombok.equalsAndHashCode.callSuper", "warn"),
    EQUALSANDHASHCODE_DO_NOT_USE_GETTERS("lombok.equalsAndHashCode.doNotUseGetters", "false"),
    ANYCONSTRUCTOR_SUPPRESS_CONSTRUCTOR_PROPERTIES("lombok.anyConstructor.suppressConstructorProperties", "true"),
    ANYCONSTRUCTOR_ADD_CONSTRUCTOR_PROPERTIES("lombok.anyConstructor.addConstructorProperties", "false"),
    STANDARD_EXCEPTION_ADD_CONSTRUCTOR_PROPERTIES("lombok.standardException.addConstructorProperties", "false"),
    TOSTRING_CALL_SUPER("lombok.toString.callSuper", "skip"),
    TOSTRING_DO_NOT_USE_GETTERS("lombok.toString.doNotUseGetters", "false"),
    TOSTRING_INCLUDE_FIELD_NAMES("lombok.toString.includeFieldNames", "true"),
    ACCESSORS_PREFIX("lombok.accessors.prefix", "", false),
    ACCESSORS_CHAIN("lombok.accessors.chain", "false"),
    ACCESSORS_FLUENT("lombok.accessors.fluent", "false"),
    GETTER_NO_IS_PREFIX("lombok.getter.noIsPrefix", "false"),
    SINGULAR_USE_GUAVA("lombok.singular.useGuava", "false"),
    SINGULAR_AUTO("lombok.singular.auto", "true"),
    FIELDDEFAULTS_FINAL("lombok.fieldDefaults.defaultFinal", "false"),
    FIELDDEFAULTS_PRIVATE("lombok.fieldDefaults.defaultPrivate", "false"),
    NONNULL_EXCEPTIONTYPE("lombok.nonNull.exceptionType", "java.lang.NullPointerException"),
    ADD_GENERATED_ANNOTATION("lombok.addGeneratedAnnotation", "true"),
    ADD_SUPPRESS_FB_WARNINGS("lombok.extern.findbugs.addSuppressFBWarnings", "false"),
    FIELD_NAME_CONSTANTS_PREFIX("lombok.fieldNameConstants.prefix", "FIELD_"),
    FIELD_NAME_CONSTANTS_SUFFIX("lombok.fieldNameConstants.suffix", ""),
    FIELD_NAME_CONSTANTS_TYPENAME("lombok.fieldNameConstants.innerTypeName", "Fields"),
    FIELD_NAME_CONSTANTS_UPPERCASE("lombok.fieldNameConstants.uppercase", "false"),
    NO_ARGS_CONSTRUCTOR_EXTRA_PRIVATE("lombok.noArgsConstructor.extraPrivate", "false"),
    BUILDER_CLASS_NAME("lombok.builder.className", "*Builder");

    private final String configKey;
    private final String configDefaultValue;
    private final boolean configScalarValue;

    private ConfigKey(String configKey, String configDefaultValue) {
        this(configKey, configDefaultValue, true);
    }

    private ConfigKey(String configKey, String configDefaultValue, boolean configScalarValue) {
        this.configKey = configKey.toLowerCase(Locale.ENGLISH);
        this.configDefaultValue = configDefaultValue;
        this.configScalarValue = configScalarValue;
    }

    public String getConfigKey() {
        return this.configKey;
    }

    public String getConfigDefaultValue() {
        return this.configDefaultValue;
    }

    boolean isConfigScalarValue() {
        return this.configScalarValue;
    }

    public static ConfigKey fromConfigStringKey(String configStringKey) {
        for (ConfigKey keys : ConfigKey.values()) {
            if (!keys.getConfigKey().equalsIgnoreCase(configStringKey)) continue;
            return keys;
        }
        return null;
    }
}

