/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.processor.clazz.log;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import de.plushnikov.intellij.plugin.LombokBundle;
import de.plushnikov.intellij.plugin.lombokconfig.ConfigDiscovery;
import de.plushnikov.intellij.plugin.lombokconfig.ConfigKey;
import de.plushnikov.intellij.plugin.problem.ProblemBuilder;
import de.plushnikov.intellij.plugin.processor.clazz.log.AbstractLogProcessor;
import de.plushnikov.intellij.plugin.processor.clazz.log.CustomLogParser;
import de.plushnikov.intellij.plugin.util.PsiAnnotationUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomLogProcessor
extends AbstractLogProcessor {
    public CustomLogProcessor() {
        super("lombok.CustomLog");
    }

    @NotNull
    private static String getCustomDeclaration(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            CustomLogProcessor.$$$reportNull$$$0(0);
        }
        String string = ConfigDiscovery.getInstance().getStringLombokConfigProperty(ConfigKey.LOG_CUSTOM_DECLARATION, psiClass);
        if (string == null) {
            CustomLogProcessor.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @Nullable
    public String getLoggerType(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            CustomLogProcessor.$$$reportNull$$$0(2);
        }
        return CustomLogParser.parseLoggerType(CustomLogProcessor.getCustomDeclaration(psiClass));
    }

    @Override
    @NotNull
    String getLoggerInitializer(@NotNull PsiClass psiClass) {
        String loggerInitializer;
        if (psiClass == null) {
            CustomLogProcessor.$$$reportNull$$$0(3);
        }
        if ((loggerInitializer = CustomLogParser.parseLoggerInitializer(CustomLogProcessor.getCustomDeclaration(psiClass))) == null) {
            throw new IllegalStateException("Invalid custom log declaration.");
        }
        String string = loggerInitializer;
        if (string == null) {
            CustomLogProcessor.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    @NotNull
    List<AbstractLogProcessor.LoggerInitializerParameter> getLoggerInitializerParameters(@NotNull PsiClass psiClass, boolean topicPresent) {
        CustomLogParser.LoggerInitializerDeclaration declaration;
        if (psiClass == null) {
            CustomLogProcessor.$$$reportNull$$$0(5);
        }
        if ((declaration = CustomLogParser.parseInitializerParameters(CustomLogProcessor.getCustomDeclaration(psiClass))) == null) {
            throw new IllegalStateException("Invalid custom log declaration.");
        }
        if (!declaration.has(topicPresent)) {
            throw new IllegalStateException("@CustomLog is not configured to work " + (topicPresent ? "with" : "without") + " topic.");
        }
        List<AbstractLogProcessor.LoggerInitializerParameter> list = declaration.get(topicPresent);
        if (list == null) {
            CustomLogProcessor.$$$reportNull$$$0(6);
        }
        return list;
    }

    @Override
    protected boolean validate(@NotNull PsiAnnotation psiAnnotation, @NotNull PsiClass psiClass, @NotNull ProblemBuilder builder) {
        boolean topicPresent;
        if (psiAnnotation == null) {
            CustomLogProcessor.$$$reportNull$$$0(7);
        }
        if (psiClass == null) {
            CustomLogProcessor.$$$reportNull$$$0(8);
        }
        if (builder == null) {
            CustomLogProcessor.$$$reportNull$$$0(9);
        }
        if (!super.validate(psiAnnotation, psiClass, builder)) {
            return false;
        }
        CustomLogParser.LoggerInitializerDeclaration declaration = CustomLogParser.parseInitializerParameters(CustomLogProcessor.getCustomDeclaration(psiClass));
        if (declaration == null) {
            builder.addError(LombokBundle.message("inspection.message.custom.log.not.configured.correctly", new Object[0]));
            return false;
        }
        String topic = PsiAnnotationUtil.getStringAnnotationValue(psiAnnotation, "topic", "");
        boolean bl = topicPresent = !StringUtil.isEmptyOrSpaces((String)topic);
        if (topicPresent) {
            if (!declaration.hasWithTopic()) {
                builder.addError(LombokBundle.message("inspection.message.custom.log.does.not.allow.topic", new Object[0]));
                return false;
            }
        } else if (!declaration.hasWithoutTopic()) {
            builder.addError(LombokBundle.message("inspection.message.custom.log.requires.topic", new Object[0]));
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "de/plushnikov/intellij/plugin/processor/clazz/log/CustomLogProcessor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiAnnotation";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "de/plushnikov/intellij/plugin/processor/clazz/log/CustomLogProcessor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomDeclaration";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoggerInitializer";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoggerInitializerParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCustomDeclaration";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getLoggerType";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getLoggerInitializer";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getLoggerInitializerParameters";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "validate";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

