/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tracing.ide;

import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.task.ProjectTaskContext;
import com.intellij.task.ProjectTaskListener;
import com.intellij.task.ProjectTaskManager;
import com.intellij.tracing.Tracer;
import com.intellij.tracing.ide.TracingBundle;
import com.intellij.tracing.ide.TracingService;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.io.PathKt;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.TextStreamsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u001c\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\n\u0010\f\u001a\u00060\rj\u0002`\u000eH\u0002J\u0014\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00100\u00122\u0006\u0010\u0015\u001a\u00020\u0013H\u0002J\u0010\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0013H\u0002J\u0010\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/tracing/ide/TracingProjectTaskListener;", "Lcom/intellij/task/ProjectTaskListener;", "()V", "span", "Lcom/intellij/tracing/Tracer$Span;", "finished", "", "result", "Lcom/intellij/task/ProjectTaskManager$Result;", "handleException", "tracingService", "Lcom/intellij/tracing/ide/TracingService;", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "mergeFiles", "", "files", "", "Ljava/nio/file/Path;", "readEntries", "trace", "showNotificationNotification", "mergedFile", "started", "context", "Lcom/intellij/task/ProjectTaskContext;", "Companion", "intellij.platform.tracing.ide"})
public final class TracingProjectTaskListener
implements ProjectTaskListener {
    private volatile Tracer.Span span;
    private static final Logger log;
    @NotNull
    public static final Companion Companion;

    public void started(@NotNull ProjectTaskContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        TracingService tracingService = TracingService.Companion.getInstance();
        if (!tracingService.isTracingEnabled()) {
            return;
        }
        try {
            Path filePath = TracingService.Companion.createPath(TracingService.TraceKind.Ide);
            tracingService.registerIdeTrace(filePath);
            tracingService.bindJpsTraceIfExistsToCurrentSession();
            Tracer.runTracer((int)0, (Path)filePath, (long)1L, (Consumer)new Consumer(this, tracingService){
                final /* synthetic */ TracingProjectTaskListener this$0;
                final /* synthetic */ TracingService $tracingService;

                public final void accept(Exception exception) {
                    Exception exception2 = exception;
                    Intrinsics.checkNotNullExpressionValue((Object)exception2, (String)"exception");
                    TracingProjectTaskListener.access$handleException(this.this$0, this.$tracingService, exception2);
                }
                {
                    this.this$0 = tracingProjectTaskListener;
                    this.$tracingService = tracingService;
                }
            });
            this.span = Tracer.start((String)"Build");
        }
        catch (IOException e) {
            this.handleException(tracingService, e);
        }
    }

    public void finished(@NotNull ProjectTaskManager.Result result) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        TracingService tracingService = TracingService.Companion.getInstance();
        if (!tracingService.isTracingEnabled()) {
            return;
        }
        Tracer.Span span = this.span;
        if (span != null) {
            span.complete();
        }
        Tracer.finishTracer((Consumer)new Consumer(this, tracingService){
            final /* synthetic */ TracingProjectTaskListener this$0;
            final /* synthetic */ TracingService $tracingService;

            public final void accept(Exception exception) {
                Exception exception2 = exception;
                Intrinsics.checkNotNullExpressionValue((Object)exception2, (String)"exception");
                TracingProjectTaskListener.access$handleException(this.this$0, this.$tracingService, exception2);
            }
            {
                this.this$0 = tracingProjectTaskListener;
                this.$tracingService = tracingService;
            }
        });
        List<Path> filesToMerge = tracingService.drainFilesToMerge();
        AppExecutorUtil.getAppExecutorService().execute(new Runnable(this, filesToMerge, tracingService){
            final /* synthetic */ TracingProjectTaskListener this$0;
            final /* synthetic */ List $filesToMerge;
            final /* synthetic */ TracingService $tracingService;

            public final void run() {
                try {
                    String mergedText = this.this$0.mergeFiles(this.$filesToMerge);
                    Path mergedFilePath = TracingService.Companion.createPath(TracingService.TraceKind.Merged);
                    Files.createDirectories(mergedFilePath.getParent(), new FileAttribute[0]);
                    PathsKt.writeText$default((Path)mergedFilePath, (CharSequence)mergedText, null, (OpenOption[])new OpenOption[0], (int)2, null);
                    Path path = mergedFilePath.getParent();
                    Intrinsics.checkNotNullExpressionValue((Object)path, (String)"mergedFilePath.parent");
                    TracingProjectTaskListener.access$showNotificationNotification(this.this$0, path);
                }
                catch (IOException e) {
                    TracingProjectTaskListener.access$handleException(this.this$0, this.$tracingService, e);
                }
            }
            {
                this.this$0 = tracingProjectTaskListener;
                this.$filesToMerge = list;
                this.$tracingService = tracingService;
            }
        });
    }

    private final void handleException(TracingService tracingService, Exception e) {
        tracingService.clearPathsToMerge();
        log.warn((Throwable)e);
    }

    private final void showNotificationNotification(Path mergedFile) {
        Notification notification = new Notification("BuildTracing", TracingBundle.Companion.message("notification.content.tracing.file.was.created", new Object[0]), NotificationType.INFORMATION);
        notification.addAction(new AnAction(mergedFile, TracingBundle.Companion.message("action.open.trace.directory.in.file.manager.text", new Object[0])){
            final /* synthetic */ Path $mergedFile;

            public void actionPerformed(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                PsiNavigationSupport.getInstance().openDirectoryInSystemFileManager(this.$mergedFile.getParent().toFile());
            }
            {
                this.$mergedFile = $captured_local_variable$0;
                super($super_call_param$1);
            }
        });
        notification.notify(null);
    }

    @NotNull
    public final String mergeFiles(@NotNull List<? extends Path> files) throws IOException {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter(files, (String)"files");
        StringBuilder $this$buildString = stringBuilder = new StringBuilder();
        boolean bl = false;
        StringBuilder stringBuilder2 = $this$buildString;
        Object object = "[\n";
        StringBuilder stringBuilder3 = stringBuilder2.append((String)object);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(value)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append('\\n')");
        for (Path path : files) {
            if (!PathKt.exists((Path)path)) continue;
            List<String> entries = this.readEntries(path);
            for (String entry : entries) {
                StringBuilder stringBuilder4 = $this$buildString;
                StringBuilder stringBuilder5 = stringBuilder4.append(entry);
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(value)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5.append('\n'), (String)"append('\\n')");
            }
        }
        StringBuilder stringBuilder6 = $this$buildString;
        object = "]\n";
        StringBuilder stringBuilder7 = stringBuilder6.append((String)object);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7, (String)"append(value)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7.append('\n'), (String)"append('\\n')");
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    private final List<String> readEntries(Path trace) {
        File file = trace.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"trace.toFile()");
        File file2 = file;
        Charset charset = Charsets.UTF_8;
        int n = 8192;
        Object object = file2;
        object = new InputStreamReader((InputStream)new FileInputStream((File)object), charset);
        return CollectionsKt.dropLast((List)SequencesKt.toList((Sequence)SequencesKt.drop((Sequence)TextStreamsKt.lineSequence((BufferedReader)(object instanceof BufferedReader ? (BufferedReader)object : new BufferedReader((Reader)object, n))), (int)1)), (int)1);
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(TracingProjectTaskListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        log = logger;
    }

    public static final /* synthetic */ void access$handleException(TracingProjectTaskListener $this, TracingService tracingService, Exception e) {
        $this.handleException(tracingService, e);
    }

    public static final /* synthetic */ void access$showNotificationNotification(TracingProjectTaskListener $this, Path mergedFile) {
        $this.showNotificationNotification(mergedFile);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/tracing/ide/TracingProjectTaskListener$Companion;", "", "()V", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.platform.tracing.ide"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

