/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.compiler.configuration;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.extensions.PluginId;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinPluginLayout;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010\u0018\u001a\u00020\u0019R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0006R\u0011\u0010\f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0011\u0010\r\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0006R\u0011\u0010\u000e\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0006R\u0011\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0006R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/idea/compiler/configuration/KotlinIdePlugin;", "", "()V", "hasPatchedVersion", "", "getHasPatchedVersion", "()Z", "id", "Lcom/intellij/openapi/extensions/PluginId;", "getId", "()Lcom/intellij/openapi/extensions/PluginId;", "isDev", "isPostProcessed", "isPreRelease", "isRelease", "isSnapshot", "originalVersion", "", "getOriginalVersion", "()Ljava/lang/String;", "version", "getVersion", "getPluginDescriptor", "Lcom/intellij/ide/plugins/IdeaPluginDescriptor;", "getPluginInfo", "Lcom/intellij/internal/statistic/utils/PluginInfo;", "kotlin.base.plugin"})
public final class KotlinIdePlugin {
    @NotNull
    private static final PluginId id;
    private static final boolean isPostProcessed;
    private static final boolean hasPatchedVersion;
    @NotNull
    private static final String originalVersion;
    @NotNull
    private static final String version;
    private static final boolean isSnapshot;
    @NotNull
    public static final KotlinIdePlugin INSTANCE;

    @NotNull
    public final PluginId getId() {
        return id;
    }

    public final boolean isPostProcessed() {
        return isPostProcessed;
    }

    public final boolean getHasPatchedVersion() {
        return hasPatchedVersion;
    }

    @NotNull
    public final String getOriginalVersion() {
        return originalVersion;
    }

    @NotNull
    public final String getVersion() {
        return version;
    }

    public final boolean isSnapshot() {
        return isSnapshot;
    }

    public final boolean isRelease() {
        return !isSnapshot && KotlinPluginLayout.Companion.getInstance().getStandaloneCompilerVersion().isRelease();
    }

    public final boolean isPreRelease() {
        return !this.isRelease();
    }

    public final boolean isDev() {
        return !isSnapshot && KotlinPluginLayout.Companion.getInstance().getStandaloneCompilerVersion().isDev();
    }

    @NotNull
    public final IdeaPluginDescriptor getPluginDescriptor() {
        IdeaPluginDescriptor ideaPluginDescriptor = PluginManagerCore.getPlugin((PluginId)id);
        if (ideaPluginDescriptor == null) {
            String string = "Kotlin IDE plugin (" + id + ") disappeared";
            throw new IllegalStateException(string.toString());
        }
        return ideaPluginDescriptor;
    }

    @NotNull
    public final PluginInfo getPluginInfo() {
        return PluginInfoDetectorKt.getPluginInfoById((PluginId)id);
    }

    private KotlinIdePlugin() {
    }

    static {
        IdeaPluginDescriptor ideaPluginDescriptor;
        Object $this$firstOrNull$iv;
        String mainPluginId;
        block3: {
            KotlinIdePlugin kotlinIdePlugin;
            INSTANCE = kotlinIdePlugin = new KotlinIdePlugin();
            mainPluginId = "org.jetbrains.kotlin";
            List allPluginIds = CollectionsKt.listOf((Object[])new String[]{mainPluginId, "com.intellij.appcode.kmm", "org.jetbrains.kotlin.native.appcode"});
            Object[] objectArray = PluginManagerCore.getPlugins();
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"PluginManagerCore.getPlugins()");
            $this$firstOrNull$iv = objectArray;
            boolean $i$f$firstOrNull = false;
            int n = ((IdeaPluginDescriptor[])$this$firstOrNull$iv).length;
            for (int i = 0; i < n; ++i) {
                IdeaPluginDescriptor element$iv;
                IdeaPluginDescriptor it = element$iv = $this$firstOrNull$iv[i];
                boolean bl = false;
                IdeaPluginDescriptor ideaPluginDescriptor2 = it;
                Intrinsics.checkNotNullExpressionValue((Object)ideaPluginDescriptor2, (String)"it");
                PluginId pluginId = ideaPluginDescriptor2.getPluginId();
                Intrinsics.checkNotNullExpressionValue((Object)pluginId, (String)"it.pluginId");
                if (!allPluginIds.contains(pluginId.getIdString())) continue;
                ideaPluginDescriptor = element$iv;
                break block3;
            }
            ideaPluginDescriptor = null;
        }
        if (ideaPluginDescriptor == null) {
            $this$firstOrNull$iv = PluginManagerCore.getPlugins();
            String string = Arrays.toString((Object[])$this$firstOrNull$iv);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(this)");
            $this$firstOrNull$iv = "Kotlin IDE plugin not found above the active plugins: " + string;
            throw new IllegalStateException($this$firstOrNull$iv.toString());
        }
        IdeaPluginDescriptor pluginDescriptor = ideaPluginDescriptor;
        String patchedVersion = System.getProperty("kotlin.plugin.version", null);
        PluginId pluginId = pluginDescriptor.getPluginId();
        Intrinsics.checkNotNullExpressionValue((Object)pluginId, (String)"pluginDescriptor.pluginId");
        id = pluginId;
        isPostProcessed = Intrinsics.areEqual((Object)id.getIdString(), (Object)mainPluginId);
        hasPatchedVersion = patchedVersion != null;
        String string = pluginDescriptor.getVersion();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pluginDescriptor.version");
        originalVersion = string;
        String string2 = patchedVersion;
        if (string2 == null) {
            string2 = originalVersion;
        }
        version = string2;
        isSnapshot = Intrinsics.areEqual((Object)version, (Object)"@snapshot@") || StringsKt.contains$default((CharSequence)version, (CharSequence)"-SNAPSHOT", (boolean)false, (int)2, null);
    }
}

