/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration;

import com.intellij.jarRepository.RepositoryLibraryType;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.ProjectDataManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryProperties;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JVMCompilerArguments;
import org.jetbrains.kotlin.config.KotlinFacetSettings;
import org.jetbrains.kotlin.idea.KotlinJvmBundle;
import org.jetbrains.kotlin.idea.compiler.configuration.Kotlin2JvmCompilerArgumentsHolder;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinInProjectUtilsKt;
import org.jetbrains.kotlin.idea.configuration.KotlinJavaModuleConfigurator;
import org.jetbrains.kotlin.idea.configuration.KotlinProjectConfigurator;
import org.jetbrains.kotlin.idea.configuration.KotlinWithLibraryConfigurator;
import org.jetbrains.kotlin.idea.configuration.NotificationMessageCollector;
import org.jetbrains.kotlin.idea.facet.FacetUtilsKt;
import org.jetbrains.kotlin.idea.facet.KotlinFacet;
import org.jetbrains.kotlin.idea.facet.KotlinFacetConfiguration;
import org.jetbrains.kotlin.idea.framework.JavaRuntimeLibraryDescription;
import org.jetbrains.kotlin.idea.framework.JsLibraryStdDetectionUtil;
import org.jetbrains.kotlin.idea.util.projectStructure.ProjectStructureUtilKt;
import org.jetbrains.kotlin.idea.versions.LibraryJarDescriptor;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.jvm.JvmPlatforms;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u0000 52\b\u0012\u0004\u0012\u00020\u00020\u0001:\u00015B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0016\u0010&\u001a\u00020'2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)H\u0014J.\u0010+\u001a\u00020'2\u0006\u0010,\u001a\u00020*2\u0006\u0010-\u001a\u00020.2\u0014\u0010/\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020'01\u0018\u000100H\u0016J\u0010\u00102\u001a\u00020\u00102\u0006\u0010,\u001a\u00020*H\u0002J\u0010\u00103\u001a\u00020\u00102\u0006\u0010,\u001a\u00020*H\u0014J\u0010\u00104\u001a\u00020\u00102\u0006\u0010,\u001a\u00020*H\u0016R\u0014\u0010\u0004\u001a\u00020\u00058TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR&\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\rX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00058TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0007R\u0014\u0010\u0015\u001a\u00020\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\u00058UX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0007R\u0014\u0010\u001e\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0007R\u0014\u0010 \u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u0007R\u0014\u0010\"\u001a\u00020#8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%\u00a8\u00066"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/KotlinJavaModuleConfigurator;", "Lorg/jetbrains/kotlin/idea/configuration/KotlinWithLibraryConfigurator;", "Lorg/jetbrains/idea/maven/utils/library/RepositoryLibraryProperties;", "()V", "dialogTitle", "", "getDialogTitle", "()Ljava/lang/String;", "libraryJarDescriptor", "Lorg/jetbrains/kotlin/idea/versions/LibraryJarDescriptor;", "getLibraryJarDescriptor", "()Lorg/jetbrains/kotlin/idea/versions/LibraryJarDescriptor;", "libraryMatcher", "Lkotlin/Function2;", "Lcom/intellij/openapi/roots/libraries/Library;", "Lcom/intellij/openapi/project/Project;", "", "getLibraryMatcher", "()Lkotlin/jvm/functions/Function2;", "libraryName", "getLibraryName", "libraryProperties", "getLibraryProperties", "()Lorg/jetbrains/idea/maven/utils/library/RepositoryLibraryProperties;", "libraryType", "Lcom/intellij/jarRepository/RepositoryLibraryType;", "getLibraryType", "()Lcom/intellij/jarRepository/RepositoryLibraryType;", "messageForOverrideDialog", "getMessageForOverrideDialog", "name", "getName", "presentableText", "getPresentableText", "targetPlatform", "Lorg/jetbrains/kotlin/platform/TargetPlatform;", "getTargetPlatform", "()Lorg/jetbrains/kotlin/platform/TargetPlatform;", "configureKotlinSettings", "", "modules", "", "Lcom/intellij/openapi/module/Module;", "configureModule", "module", "collector", "Lorg/jetbrains/kotlin/idea/configuration/NotificationMessageCollector;", "writeActions", "", "Lkotlin/Function0;", "hasBrokenJsRuntime", "isApplicable", "isConfigured", "Companion", "kotlin.jvm"})
public class KotlinJavaModuleConfigurator
extends KotlinWithLibraryConfigurator<RepositoryLibraryProperties> {
    @NotNull
    private final Function2<Library, Project, Boolean> libraryMatcher = libraryMatcher.1.INSTANCE;
    @NotNull
    public static final String NAME = "java";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    protected boolean isApplicable(@NotNull Module module2) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        return super.isApplicable(module2) && !this.hasBrokenJsRuntime(module2);
    }

    @NotNull
    public RepositoryLibraryType getLibraryType() {
        RepositoryLibraryType repositoryLibraryType = RepositoryLibraryType.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)repositoryLibraryType, (String)"RepositoryLibraryType.getInstance()");
        return repositoryLibraryType;
    }

    @Override
    @NotNull
    public RepositoryLibraryProperties getLibraryProperties() {
        return this.getLibraryJarDescriptor().getRepositoryLibraryProperties();
    }

    @Override
    public boolean isConfigured(@NotNull Module module2) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        return ConfigureKotlinInProjectUtilsKt.hasKotlinJvmRuntimeInScope(module2);
    }

    @Override
    @NotNull
    protected String getLibraryName() {
        return "KotlinJavaRuntime";
    }

    @Override
    @NotNull
    protected String getDialogTitle() {
        return JavaRuntimeLibraryDescription.Companion.getDIALOG_TITLE();
    }

    @Override
    @Nls
    @NotNull
    protected String getMessageForOverrideDialog() {
        return JavaRuntimeLibraryDescription.Companion.getJAVA_RUNTIME_LIBRARY_CREATION();
    }

    @Override
    @NotNull
    public String getPresentableText() {
        return KotlinJvmBundle.message("language.name.java", new Object[0]);
    }

    @Override
    @NotNull
    public String getName() {
        return NAME;
    }

    @Override
    @NotNull
    public TargetPlatform getTargetPlatform() {
        return JvmPlatforms.INSTANCE.getUnspecifiedJvmPlatform();
    }

    @Override
    @NotNull
    public LibraryJarDescriptor getLibraryJarDescriptor() {
        return LibraryJarDescriptor.RUNTIME_JDK8_JAR;
    }

    @Override
    @NotNull
    protected Function2<Library, Project, Boolean> getLibraryMatcher() {
        return this.libraryMatcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void configureKotlinSettings(@NotNull List<? extends Module> modules2) {
        boolean canChangeProjectSettings;
        Module project2;
        block11: {
            boolean bl;
            Intrinsics.checkNotNullParameter(modules2, (String)"modules");
            Module module2 = (Module)CollectionsKt.firstOrNull(modules2);
            if (module2 == null || (module2 = module2.getProject()) == null) {
                return;
            }
            Intrinsics.checkNotNullExpressionValue((Object)module2, (String)"modules.firstOrNull()?.project ?: return");
            project2 = module2;
            Iterable iterable = ProjectStructureUtilKt.allModules((Project)project2);
            boolean $i$f$all = false;
            if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : iterable) {
                    Module it = (Module)element$iv;
                    boolean bl2 = false;
                    Module module3 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)module3, (String)"it");
                    Sdk sdk2 = ProjectStructureUtilKt.getSdk(module3);
                    if (sdk2 != null && (sdk2 = ProjectStructureUtilKt.getVersion(sdk2)) != null ? sdk2.isAtLeast(JavaSdkVersion.JDK_1_8) : true) continue;
                    bl = false;
                    break block11;
                }
                bl = canChangeProjectSettings = true;
            }
        }
        if (canChangeProjectSettings) {
            Kotlin2JvmCompilerArgumentsHolder.Companion.getInstance((Project)project2).update(configureKotlinSettings.1.INSTANCE);
        } else {
            for (Module module4 : modules2) {
                IdeModifiableModelsProvider modelsProvider;
                Sdk sdk3 = ProjectStructureUtilKt.getSdk(module4);
                Object sdkVersion = sdk3 != null ? ProjectStructureUtilKt.getVersion(sdk3) : null;
                if (sdkVersion == null || !sdkVersion.isAtLeast(JavaSdkVersion.JDK_1_8)) continue;
                Intrinsics.checkNotNullExpressionValue((Object)ProjectDataManager.getInstance().createModifiableModelsProvider((Project)project2), (String)"ProjectDataManager.getIn\u2026leModelsProvider(project)");
                try {
                    KotlinFacet facet = FacetUtilsKt.getOrCreateFacet$default(module4, modelsProvider, false, null, true, 4, null);
                    KotlinFacetSettings facetSettings = ((KotlinFacetConfiguration)facet.getConfiguration()).getSettings();
                    FacetUtilsKt.initializeIfNeeded$default(facetSettings, module4, null, JvmPlatforms.INSTANCE.getJvm8(), null, 8, null);
                    CommonCompilerArguments commonCompilerArguments = facetSettings.getCompilerArguments();
                    if (!(commonCompilerArguments instanceof K2JVMCompilerArguments)) {
                        commonCompilerArguments = null;
                    }
                    K2JVMCompilerArguments k2JVMCompilerArguments = (K2JVMCompilerArguments)commonCompilerArguments;
                    if (k2JVMCompilerArguments == null) continue;
                    k2JVMCompilerArguments.setJvmTarget("1.8");
                }
                finally {
                    modelsProvider.dispose();
                }
            }
        }
    }

    @Override
    public void configureModule(@NotNull Module module2, @NotNull NotificationMessageCollector collector2, @Nullable List<Function0<Unit>> writeActions) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Intrinsics.checkNotNullParameter((Object)collector2, (String)"collector");
        super.configureModule(module2, collector2, writeActions);
        ConfigureKotlinInProjectUtilsKt.addStdlibToJavaModuleInfo(module2, collector2, writeActions);
    }

    private final boolean hasBrokenJsRuntime(Module module2) {
        ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module2);
        Intrinsics.checkNotNullExpressionValue((Object)moduleRootManager, (String)"ModuleRootManager.getInstance(module)");
        for (OrderEntry orderEntry : moduleRootManager.getOrderEntries()) {
            LibraryEx library2;
            OrderEntry orderEntry2 = orderEntry;
            if (!(orderEntry2 instanceof LibraryOrderEntry)) {
                orderEntry2 = null;
            }
            LibraryOrderEntry libraryOrderEntry = (LibraryOrderEntry)orderEntry2;
            Object object = libraryOrderEntry != null ? libraryOrderEntry.getLibrary() : null;
            if (!(object instanceof LibraryEx)) {
                object = null;
            }
            if ((LibraryEx)object == null) {
                continue;
            }
            Library library3 = (Library)library2;
            Project project2 = module2.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"module.project");
            if (!JsLibraryStdDetectionUtil.INSTANCE.hasJsStdlibJar(library3, project2, true)) continue;
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/KotlinJavaModuleConfigurator$Companion;", "", "()V", "NAME", "", "instance", "Lorg/jetbrains/kotlin/idea/configuration/KotlinJavaModuleConfigurator;", "getInstance", "()Lorg/jetbrains/kotlin/idea/configuration/KotlinJavaModuleConfigurator;", "kotlin.jvm"})
    public static final class Companion {
        @NotNull
        public final KotlinJavaModuleConfigurator getInstance() {
            Object object = Extensions.findExtension(KotlinProjectConfigurator.Companion.getEP_NAME(), KotlinJavaModuleConfigurator.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"Extensions.findExtension\u2026Configurator::class.java)");
            return (KotlinJavaModuleConfigurator)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

