/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration.notifications;

import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import java.util.function.BiConsumer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.KotlinIcons;
import org.jetbrains.kotlin.idea.configuration.notifications.MigrationNotificationKt;
import org.jetbrains.kotlin.idea.migration.KotlinMigrationProjectFUSCollector;
import org.jetbrains.kotlin.idea.migration.MigrationInfo;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000(\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a \u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007*\u00060\u0007j\u0002`\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a \u0010\f\u001a\n \b*\u0004\u0018\u00010\u00070\u0007*\u00060\u0007j\u0002`\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\r"}, d2={"showMigrationNotification", "", "project", "Lcom/intellij/openapi/project/Project;", "migrationInfo", "Lorg/jetbrains/kotlin/idea/migration/MigrationInfo;", "appendBr", "Ljava/lang/StringBuilder;", "kotlin.jvm.PlatformType", "Lkotlin/text/StringBuilder;", "line", "", "appendIndentBr", "kotlin.idea"})
public final class MigrationNotificationKt {
    public static final void showMigrationNotification(@NotNull Project project2, @NotNull MigrationInfo migrationInfo) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)migrationInfo, (String)"migrationInfo");
        StringBuilder $this$buildString = stringBuilder = new StringBuilder();
        boolean bl = false;
        MigrationNotificationKt.appendBr($this$buildString, KotlinBundle.message("configuration.migration.text.detected.migration", new Object[0]));
        if (migrationInfo.getOldLanguageVersion() != migrationInfo.getNewLanguageVersion()) {
            MigrationNotificationKt.appendIndentBr($this$buildString, KotlinBundle.message("configuration.migration.text.language.version", migrationInfo.getOldLanguageVersion(), migrationInfo.getNewLanguageVersion()));
        }
        if (Intrinsics.areEqual((Object)migrationInfo.getOldApiVersion(), (Object)migrationInfo.getNewApiVersion()) ^ true) {
            MigrationNotificationKt.appendIndentBr($this$buildString, KotlinBundle.message("configuration.migration.text.api.version", migrationInfo.getOldApiVersion(), migrationInfo.getNewApiVersion()));
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        String detectedChangeMessage = string;
        KotlinMigrationProjectFUSCollector.Companion.logNotification(migrationInfo);
        NotificationGroupManager.getInstance().getNotificationGroup("Kotlin Migration").createNotification(KotlinBundle.message("configuration.migration.title.kotlin.migration", new Object[0]), KotlinBundle.message("configuration.migration.text.update.your.code.to.replace.deprecated", new Object[0]) + "<br/><br/>" + detectedChangeMessage, NotificationType.WARNING).setSuggestionType(true).addAction((AnAction)NotificationAction.createExpiring((String)KotlinBundle.message("configuration.migration.text.scan.for.deprecations", new Object[0]), (BiConsumer)showMigrationNotification.1.INSTANCE)).setImportant(true).setIcon(KotlinIcons.SMALL_LOGO).notify(project2);
    }

    private static final StringBuilder appendBr(StringBuilder $this$appendBr, String line) {
        return $this$appendBr.append(line + "<br/>");
    }

    private static final StringBuilder appendIndentBr(StringBuilder $this$appendIndentBr, String line) {
        return MigrationNotificationKt.appendBr($this$appendIndentBr, "&nbsp;&nbsp;" + line);
    }
}

