/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.evaluate.compilation;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.compiled.SignatureParsing;
import com.intellij.psi.impl.compiled.StubBuildingVisitor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.ClassUtil;
import com.intellij.util.Function;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.debugger.evaluate.variables.EvaluatorValueConverter;
import org.jetbrains.kotlin.idea.debugger.evaluate.variables.EvaluatorValueConverterKt;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001$B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002J\u0018\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J\u0018\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u000fH\u0002J\"\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u000fH\u0002J\u001c\u0010\u001a\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u0015H\u0002J*\u0010\u001c\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u000fH\u0002J\u0018\u0010\u001f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002J(\u0010 \u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u000fH\u0016J0\u0010!\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\"\u001a\u00020#H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/ReflectionCallMethodVisitor;", "Lorg/jetbrains/org/objectweb/asm/MethodVisitor;", "project", "Lcom/intellij/openapi/project/Project;", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "methodVisitor", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/psi/search/GlobalSearchScope;Lorg/jetbrains/org/objectweb/asm/MethodVisitor;)V", "boxValue", "", "type", "Lorg/jetbrains/org/objectweb/asm/Type;", "boxedType", "fetchReflectionField", "owner", "", "name", "fetchReflectionMethod", "resolvedCall", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/ReflectionCallMethodVisitor$ResolvedMethodCall;", "findClass", "Lcom/intellij/psi/PsiClass;", "internalName", "findMethod", "Lcom/intellij/psi/PsiMethod;", "descriptor", "pushClassLiteral", "resolvedClass", "resolveApplicableMethodCall", "opcode", "", "unboxValue", "visitFieldInsn", "visitMethodInsn", "isInterface", "", "ResolvedMethodCall", "kotlin.jvm-debugger.evaluation"})
final class ReflectionCallMethodVisitor
extends MethodVisitor {
    private final Project project;
    private final GlobalSearchScope scope;

    private final void boxValue(Type type2, Type boxedType) {
        String methodDescriptor = "(" + type2.getDescriptor() + ")" + boxedType.getDescriptor();
        super.visitMethodInsn(184, boxedType.getInternalName(), "valueOf", methodDescriptor, false);
    }

    private final void unboxValue(Type type2, Type boxedType) {
        String boxedClassName = boxedType.getInternalName();
        String string = EvaluatorValueConverter.Companion.getUNBOXING_METHOD_NAMES().get(boxedClassName);
        if (string == null) {
            String string2 = "Unexpected boxed type: " + boxedType;
            throw new IllegalStateException(string2.toString());
        }
        String methodName2 = string;
        String methodDescriptor = "()" + type2.getDescriptor();
        super.visitMethodInsn(182, boxedClassName, methodName2, methodDescriptor, false);
    }

    private final void pushClassLiteral(Type type2, PsiClass resolvedClass) {
        PsiClass psiClass2;
        if (type2.getSort() != 10 && type2.getSort() != 9) {
            throw (Throwable)new IllegalStateException("Object or array type expected, got " + type2);
        }
        String internalName = type2.getInternalName();
        PsiClass psiClass3 = resolvedClass;
        if (psiClass3 == null) {
            String string = internalName;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"internalName");
            psiClass3 = psiClass2 = this.findClass(string);
        }
        if (psiClass2 != null && !psiClass2.hasModifierProperty("public")) {
            String string = internalName;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"internalName");
            super.visitLdcInsn((Object)StringsKt.replace$default((String)string, (char)'/', (char)'.', (boolean)false, (int)4, null));
            super.visitMethodInsn(184, "java/lang/Class", "forName", "(Ljava/lang/String;)Ljava/lang/Class;", false);
        } else {
            super.visitLdcInsn((Object)type2);
        }
    }

    static /* synthetic */ void pushClassLiteral$default(ReflectionCallMethodVisitor reflectionCallMethodVisitor, Type type2, PsiClass psiClass2, int n, Object object) {
        if ((n & 2) != 0) {
            psiClass2 = null;
        }
        reflectionCallMethodVisitor.pushClassLiteral(type2, psiClass2);
    }

    private final PsiClass findClass(String internalName) {
        Type type2;
        Type type3 = type2 = Type.getObjectType((String)internalName);
        Intrinsics.checkNotNullExpressionValue((Object)type3, (String)"type");
        if (type3.getSort() != 10) {
            return null;
        }
        StringCharacterIterator iterator = new StringCharacterIterator(type2.getDescriptor());
        String string = SignatureParsing.parseTypeString((CharacterIterator)iterator, (Function)StubBuildingVisitor.GUESSING_MAPPER);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"SignatureParsing.parseTy\u2026gVisitor.GUESSING_MAPPER)");
        String classType = string;
        return JavaPsiFacade.getInstance((Project)this.project).findClass(classType, this.scope);
    }

    private final void fetchReflectionField(String owner, String name2) {
        Type type2 = Type.getObjectType((String)owner);
        Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"Type.getObjectType(owner)");
        ReflectionCallMethodVisitor.pushClassLiteral$default(this, type2, null, 2, null);
        super.visitLdcInsn((Object)name2);
        String methodSignature = "(Ljava/lang/String;)Ljava/lang/reflect/Field;";
        super.visitMethodInsn(182, "java/lang/Class", "getDeclaredField", methodSignature, false);
        super.visitInsn(89);
        super.visitLdcInsn((Object)1);
        super.visitMethodInsn(182, "java/lang/reflect/Field", "setAccessible", "(Z)V", false);
    }

    public void visitFieldInsn(int opcode, @NotNull String owner, @NotNull String name2, @NotNull String descriptor2) {
        boolean isPut;
        Type valueType;
        PsiField field;
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        PsiClass psiClass2 = this.findClass(owner);
        PsiField psiField = field = psiClass2 != null ? psiClass2.findFieldByName(name2, false) : null;
        if (field == null || field.hasModifierProperty("public")) {
            super.visitFieldInsn(opcode, owner, name2, descriptor2);
            return;
        }
        Type type2 = valueType = Type.getType((String)descriptor2);
        Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"valueType");
        Type boxedValueType = EvaluatorValueConverterKt.box(type2);
        this.fetchReflectionField(owner, name2);
        boolean isCategory2Type = valueType.getSize() == 2;
        switch (opcode) {
            case 178: {
                super.visitInsn(1);
                break;
            }
            case 179: {
                super.visitInsn(1);
                super.visitInsn(isCategory2Type ? 94 : 93);
                super.visitInsn(88);
                break;
            }
            case 180: {
                super.visitInsn(95);
                break;
            }
            case 181: {
                super.visitInsn(isCategory2Type ? 91 : 90);
                super.visitInsn(87);
                super.visitInsn(isCategory2Type ? 94 : 91);
                super.visitInsn(isCategory2Type ? 88 : 87);
                super.visitInsn(95);
                super.visitInsn(isCategory2Type ? 94 : 93);
                super.visitInsn(88);
                break;
            }
            default: {
                throw (Throwable)new IllegalStateException("Unexpected opcode " + opcode);
            }
        }
        boolean bl = isPut = opcode == 179 || opcode == 181;
        if (isPut && Intrinsics.areEqual((Object)valueType, (Object)boxedValueType) ^ true) {
            this.boxValue(valueType, boxedValueType);
        }
        String methodName2 = isPut ? "set" : "get";
        String methodSignature = isPut ? "(Ljava/lang/Object;Ljava/lang/Object;)V" : "(Ljava/lang/Object;)Ljava/lang/Object;";
        super.visitMethodInsn(182, "java/lang/reflect/Field", methodName2, methodSignature, false);
        if (!isPut) {
            super.visitTypeInsn(192, boxedValueType.getInternalName());
            if (Intrinsics.areEqual((Object)valueType, (Object)boxedValueType) ^ true) {
                this.unboxValue(valueType, boxedValueType);
            }
        }
    }

    private final PsiMethod findMethod(String owner, String name2, String descriptor2) {
        PsiMethod[] methods2;
        PsiClass psiClass2 = this.findClass(owner);
        if (psiClass2 == null) {
            return null;
        }
        PsiClass declaringClass = psiClass2;
        for (PsiMethod method : methods2 = Intrinsics.areEqual((Object)name2, (Object)"<init>") ? declaringClass.getConstructors() : declaringClass.findMethodsByName(name2, true)) {
            String methodDescriptor = ClassUtil.getAsmMethodSignature((PsiMethod)method);
            if (!Intrinsics.areEqual((Object)methodDescriptor, (Object)descriptor2)) continue;
            return method;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final ResolvedMethodCall resolveApplicableMethodCall(int opcode, String owner, String name2, String descriptor2) {
        String string;
        PsiClass declaringClass;
        PsiMethod method;
        if (opcode != 182 && opcode != 184 && opcode != 183) {
            return null;
        }
        if (StringsKt.startsWith$default((String)name2, (String)"<", (boolean)false, (int)2, null) && Intrinsics.areEqual((Object)name2, (Object)"<init>") ^ true) {
            return null;
        }
        if (Intrinsics.areEqual((Object)name2, (Object)"<init>")) {
            return null;
        }
        PsiMethod psiMethod = method = this.findMethod(owner, name2, descriptor2);
        Object object = declaringClass = psiMethod != null ? psiMethod.getContainingClass() : null;
        if (method == null || method.hasModifierProperty("public") || declaringClass == null) {
            return null;
        }
        PsiClassType psiClassType = PsiElementFactory.getInstance((Project)this.project).createType(declaringClass);
        Intrinsics.checkNotNullExpressionValue((Object)psiClassType, (String)"PsiElementFactory.getIns\u2026reateType(declaringClass)");
        PsiClassType declaringClassType = psiClassType;
        String it = string = ClassUtil.getBinaryPresentation((PsiType)((PsiType)declaringClassType));
        boolean bl = false;
        String string2 = it;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it");
        CharSequence charSequence = string2;
        String string3 = charSequence.length() > 0 ? string : null;
        if (string3 == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"ClassUtil.getBinaryPrese\u2026tEmpty() } ?: return null");
        String declaringClassTypeDescriptor = string3;
        Type declaringClassAsmType = Type.getType((String)declaringClassTypeDescriptor);
        PsiParameterList psiParameterList = method.getParameterList();
        Intrinsics.checkNotNullExpressionValue((Object)psiParameterList, (String)"method.parameterList");
        int parameterCount = psiParameterList.getParametersCount();
        ArrayList parameterTypes2 = new ArrayList(parameterCount);
        ArrayList boxedParameterTypes = new ArrayList(parameterCount);
        int n = 0;
        int n2 = parameterCount;
        while (n < n2) {
            String parameterTypeDescriptor;
            String string4;
            PsiParameter parameter;
            void index2;
            if (method.getParameterList().getParameter((int)index2) == null) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)parameter, (String)"method.parameterList.get\u2026ter(index) ?: return null");
            String it2 = string4 = ClassUtil.getBinaryPresentation((PsiType)parameter.getType());
            boolean bl2 = false;
            String string5 = it2;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"it");
            CharSequence charSequence2 = string5;
            if ((charSequence2.length() > 0 ? string4 : null) == null) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)parameterTypeDescriptor, (String)"ClassUtil.getBinaryPrese\u2026tEmpty() } ?: return null");
            parameterTypeDescriptor = parameterTypeDescriptor;
            Type parameterType = Type.getType((String)parameterTypeDescriptor);
            Collection collection = parameterTypes2;
            collection.add(parameterType);
            collection = boxedParameterTypes;
            Type type2 = parameterType;
            Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"parameterType");
            Type type3 = EvaluatorValueConverterKt.box(type2);
            collection.add(type3);
            ++index2;
        }
        Type type4 = declaringClassAsmType;
        Intrinsics.checkNotNullExpressionValue((Object)type4, (String)"declaringClassAsmType");
        return new ResolvedMethodCall(declaringClass, type4, parameterTypes2, boxedParameterTypes);
    }

    /*
     * WARNING - void declaration
     */
    private final void fetchReflectionMethod(String name2, ResolvedMethodCall resolvedCall2) {
        ReflectionCallMethodVisitor reflectionCallMethodVisitor;
        boolean isConstructor = Intrinsics.areEqual((Object)name2, (Object)"<init>");
        this.pushClassLiteral(resolvedCall2.getDeclaringClassType(), resolvedCall2.getDeclaringClass());
        if (!isConstructor) {
            super.visitLdcInsn((Object)name2);
        }
        ReflectionCallMethodVisitor $this$run = reflectionCallMethodVisitor = this;
        boolean bl = false;
        super.visitLdcInsn((Object)resolvedCall2.getParameterTypes().size());
        super.visitTypeInsn(189, "java/lang/Class");
        int n = 0;
        int n2 = resolvedCall2.getParameterTypes().size();
        while (n < n2) {
            void index2;
            Type parameterType = resolvedCall2.getParameterTypes().get((int)index2);
            Type boxedParameterType = resolvedCall2.getBoxedParameterTypes().get((int)index2);
            super.visitInsn(89);
            super.visitLdcInsn((Object)((int)index2));
            if (Intrinsics.areEqual((Object)parameterType, (Object)boxedParameterType) ^ true) {
                super.visitFieldInsn(178, boxedParameterType.getInternalName(), "TYPE", "Ljava/lang/Class;");
            } else {
                ReflectionCallMethodVisitor.pushClassLiteral$default($this$run, parameterType, null, 2, null);
            }
            super.visitInsn(83);
            ++index2;
        }
        String getMethodName = isConstructor ? "getDeclaredConstructor" : "getDeclaredMethod";
        String getMethodSignature2 = isConstructor ? "([Ljava/lang/Class;)Ljava/lang/reflect/Constructor;" : "(Ljava/lang/String;[Ljava/lang/Class;)Ljava/lang/reflect/Method;";
        super.visitMethodInsn(182, "java/lang/Class", getMethodName, getMethodSignature2, false);
        super.visitInsn(89);
        super.visitLdcInsn((Object)1);
        super.visitMethodInsn(182, "java/lang/reflect/AccessibleObject", "setAccessible", "(Z)V", false);
    }

    /*
     * WARNING - void declaration
     */
    public void visitMethodInsn(int opcode, @NotNull String owner, @NotNull String name2, @NotNull String descriptor2, boolean isInterface) {
        Type returnType2;
        Type type2;
        ReflectionCallMethodVisitor reflectionCallMethodVisitor;
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        ResolvedMethodCall resolvedCall2 = this.resolveApplicableMethodCall(opcode, owner, name2, descriptor2);
        if (resolvedCall2 == null) {
            super.visitMethodInsn(opcode, owner, name2, descriptor2, isInterface);
            return;
        }
        boolean isConstructor = Intrinsics.areEqual((Object)name2, (Object)"<init>");
        boolean isStatic = opcode == 184;
        int parameterCount = resolvedCall2.getParameterTypes().size();
        super.visitLdcInsn((Object)parameterCount);
        super.visitTypeInsn(189, "java/lang/Object");
        ReflectionCallMethodVisitor $this$run = reflectionCallMethodVisitor = this;
        boolean bl = false;
        int n = parameterCount - 1;
        boolean bl2 = false;
        while (n >= 0) {
            void index2;
            Type parameterType = resolvedCall2.getParameterTypes().get((int)index2);
            Type boxedParameterType = resolvedCall2.getBoxedParameterTypes().get((int)index2);
            super.visitInsn(89);
            super.visitInsn(parameterType.getSize() == 2 ? 94 : 93);
            super.visitInsn(88);
            if (Intrinsics.areEqual((Object)parameterType, (Object)boxedParameterType) ^ true) {
                $this$run.boxValue(parameterType, boxedParameterType);
            }
            super.visitLdcInsn((Object)((int)index2));
            super.visitInsn(95);
            super.visitInsn(83);
            --index2;
        }
        if (isStatic) {
            super.visitInsn(1);
            super.visitInsn(95);
        }
        this.fetchReflectionMethod(name2, resolvedCall2);
        if (isConstructor) {
            super.visitInsn(95);
        } else {
            super.visitInsn(91);
            super.visitInsn(87);
        }
        String invokeReceiverType = isConstructor ? "java/lang/reflect/Constructor" : "java/lang/reflect/Method";
        String invokeMethodName = isConstructor ? "newInstance" : "invoke";
        String invokeMethodSignature = isConstructor ? "([Ljava/lang/Object;)Ljava/lang/Object;" : "(Ljava/lang/Object;[Ljava/lang/Object;)Ljava/lang/Object;";
        super.visitMethodInsn(182, invokeReceiverType, invokeMethodName, invokeMethodSignature, false);
        if (isConstructor) {
            type2 = resolvedCall2.getDeclaringClassType();
        } else {
            Type type3 = Type.getMethodType((String)descriptor2);
            Intrinsics.checkNotNullExpressionValue((Object)type3, (String)"Type.getMethodType(descriptor)");
            type2 = type3.getReturnType();
        }
        Type type4 = returnType2 = type2;
        Intrinsics.checkNotNullExpressionValue((Object)type4, (String)"returnType");
        Type boxedReturnType = EvaluatorValueConverterKt.box(type4);
        super.visitTypeInsn(192, boxedReturnType.getInternalName());
        if (Intrinsics.areEqual((Object)returnType2, (Object)boxedReturnType) ^ true) {
            this.unboxValue(returnType2, boxedReturnType);
        }
    }

    public ReflectionCallMethodVisitor(@NotNull Project project2, @NotNull GlobalSearchScope scope2, @NotNull MethodVisitor methodVisitor) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)methodVisitor, (String)"methodVisitor");
        super(589824, methodVisitor);
        this.project = project2;
        this.scope = scope2;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\n\b\u0002\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\u0002\u0010\tR\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000b\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/ReflectionCallMethodVisitor$ResolvedMethodCall;", "", "declaringClass", "Lcom/intellij/psi/PsiClass;", "declaringClassType", "Lorg/jetbrains/org/objectweb/asm/Type;", "parameterTypes", "", "boxedParameterTypes", "(Lcom/intellij/psi/PsiClass;Lorg/jetbrains/org/objectweb/asm/Type;Ljava/util/List;Ljava/util/List;)V", "getBoxedParameterTypes", "()Ljava/util/List;", "getDeclaringClass", "()Lcom/intellij/psi/PsiClass;", "getDeclaringClassType", "()Lorg/jetbrains/org/objectweb/asm/Type;", "getParameterTypes", "kotlin.jvm-debugger.evaluation"})
    private static final class ResolvedMethodCall {
        @NotNull
        private final PsiClass declaringClass;
        @NotNull
        private final Type declaringClassType;
        @NotNull
        private final List<Type> parameterTypes;
        @NotNull
        private final List<Type> boxedParameterTypes;

        @NotNull
        public final PsiClass getDeclaringClass() {
            return this.declaringClass;
        }

        @NotNull
        public final Type getDeclaringClassType() {
            return this.declaringClassType;
        }

        @NotNull
        public final List<Type> getParameterTypes() {
            return this.parameterTypes;
        }

        @NotNull
        public final List<Type> getBoxedParameterTypes() {
            return this.boxedParameterTypes;
        }

        public ResolvedMethodCall(@NotNull PsiClass declaringClass, @NotNull Type declaringClassType, @NotNull List<Type> parameterTypes2, @NotNull List<Type> boxedParameterTypes) {
            Intrinsics.checkNotNullParameter((Object)declaringClass, (String)"declaringClass");
            Intrinsics.checkNotNullParameter((Object)declaringClassType, (String)"declaringClassType");
            Intrinsics.checkNotNullParameter(parameterTypes2, (String)"parameterTypes");
            Intrinsics.checkNotNullParameter(boxedParameterTypes, (String)"boxedParameterTypes");
            this.declaringClass = declaringClass;
            this.declaringClassType = declaringClassType;
            this.parameterTypes = parameterTypes2;
            this.boxedParameterTypes = boxedParameterTypes;
        }
    }
}

