/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto;

import com.intellij.debugger.SourcePosition;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.core.util.PsiLinesUtilsKt;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtExpression;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001e\u0010\u0000\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0005"}, d2={"findFirstAndLastStatementPositions", "Lkotlin/Pair;", "Lcom/intellij/debugger/SourcePosition;", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclarationWithBody;", "kotlin.jvm-debugger.core"})
public final class KotlinLambdaMethodFilterKt {
    @NotNull
    public static final Pair<SourcePosition, SourcePosition> findFirstAndLastStatementPositions(@NotNull KtDeclarationWithBody declaration2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        KtExpression body2 = declaration2.getBodyExpression();
        if (body2 != null && PsiLinesUtilsKt.isMultiLine((PsiElement)declaration2)) {
            PsiElement[] psiElementArray = body2.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"body.children");
            PsiElement[] psiElementArray2 = psiElementArray;
            if (!(psiElementArray2.length == 0)) {
                Object object;
                SourcePosition firstStatementPosition = null;
                SourcePosition lastStatementPosition = null;
                KtExpression ktExpression = body2;
                if (!(ktExpression instanceof KtBlockExpression)) {
                    ktExpression = null;
                }
                if ((object = (KtBlockExpression)ktExpression) == null || (object = object.getStatements()) == null) {
                    object = CollectionsKt.listOf((Object)body2);
                }
                Object statements2 = object;
                Collection collection = (Collection)statements2;
                if (!collection.isEmpty() && (firstStatementPosition = SourcePosition.createFromElement((PsiElement)((PsiElement)CollectionsKt.first((List)statements2)))) != null) {
                    KtExpression lastStatement = (KtExpression)CollectionsKt.last((List)statements2);
                    PsiFile psiFile2 = firstStatementPosition.getFile();
                    KtExpression ktExpression2 = lastStatement;
                    Intrinsics.checkNotNullExpressionValue((Object)ktExpression2, (String)"lastStatement");
                    TextRange textRange = ktExpression2.getTextRange();
                    Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"lastStatement.textRange");
                    lastStatementPosition = SourcePosition.createFromOffset((PsiFile)psiFile2, (int)textRange.getEndOffset());
                }
                return new Pair((Object)firstStatementPosition, (Object)lastStatementPosition);
            }
        }
        SourcePosition position = SourcePosition.createFromElement((PsiElement)((PsiElement)declaration2));
        return new Pair((Object)position, (Object)position);
    }
}

