/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.gradle.configuration;

import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginsAdvertiser;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.util.PlatformUtils;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.gradle.KotlinIdeaGradleBundle;
import org.jetbrains.kotlin.idea.gradle.configuration.KotlinResolverUtilKt;
import org.jetbrains.kotlin.idea.gradle.configuration.state.DontShowAgainKotlinAdditionPluginSuggestionService;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000(\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u001a\u000e\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u001aD\u0010\r\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0001\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000b2\u000e\b\u0002\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\t0\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u0001H\u0002\"$\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0000\u001a\u00020\u00018B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b\u0002\u0010\u0003\"\u0004\b\u0004\u0010\u0005\"$\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0000\u001a\u00020\u00018B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b\u0006\u0010\u0003\"\u0004\b\u0007\u0010\u0005\u00a8\u0006\u0015"}, d2={"value", "", "isKotlinJSInspectionsPackSuggestionEnabled", "()Z", "setKotlinJSInspectionsPackSuggestionEnabled", "(Z)V", "isNativeDebugSuggestionEnabled", "setNativeDebugSuggestionEnabled", "suggestKotlinJsInspectionPackPlugin", "", "projectPath", "", "suggestNativeDebug", "suggestPluginInstall", "notificationContent", "pluginId", "Lcom/intellij/openapi/extensions/PluginId;", "displayId", "onDontShowAgainActionPerformed", "Lkotlin/Function0;", "onlyForUltimate", "kotlin.gradle.gradle-idea"})
public final class KotlinResolverUtilKt {
    private static final boolean isNativeDebugSuggestionEnabled() {
        DontShowAgainKotlinAdditionPluginSuggestionService service2 = DontShowAgainKotlinAdditionPluginSuggestionService.Companion.getInstance();
        return !service2.getState().getDontShowAgainKotlinNativeDebuggerPluginSuggestion();
    }

    private static final void setNativeDebugSuggestionEnabled(boolean value2) {
        DontShowAgainKotlinAdditionPluginSuggestionService service2 = DontShowAgainKotlinAdditionPluginSuggestionService.Companion.getInstance();
        service2.getState().setDontShowAgainKotlinNativeDebuggerPluginSuggestion(!value2);
    }

    private static final boolean isKotlinJSInspectionsPackSuggestionEnabled() {
        DontShowAgainKotlinAdditionPluginSuggestionService service2 = DontShowAgainKotlinAdditionPluginSuggestionService.Companion.getInstance();
        return !service2.getState().getDontShowAgainKotlinJSInspectionPackSuggestion();
    }

    private static final void setKotlinJSInspectionsPackSuggestionEnabled(boolean value2) {
        DontShowAgainKotlinAdditionPluginSuggestionService service2 = DontShowAgainKotlinAdditionPluginSuggestionService.Companion.getInstance();
        service2.getState().setDontShowAgainKotlinJSInspectionPackSuggestion(!value2);
    }

    public static final void suggestNativeDebug(@NotNull String projectPath2) {
        Intrinsics.checkNotNullParameter((Object)projectPath2, (String)"projectPath");
        if (!KotlinResolverUtilKt.isNativeDebugSuggestionEnabled()) {
            return;
        }
        String string = KotlinIdeaGradleBundle.message("notification.text.native.debug.provides.debugger.for.kotlin.native", new Object[0]);
        PluginId pluginId = PluginId.getId((String)"com.intellij.nativeDebug");
        Intrinsics.checkNotNullExpressionValue((Object)pluginId, (String)"PluginId.getId(\"com.intellij.nativeDebug\")");
        boolean bl = true;
        Function0 function0 = suggestNativeDebug.1.INSTANCE;
        PluginId pluginId2 = pluginId;
        String string2 = "kotlin.native.debug";
        KotlinResolverUtilKt.suggestPluginInstall(projectPath2, string, pluginId2, string2, (Function0<Unit>)function0, bl);
    }

    public static final void suggestKotlinJsInspectionPackPlugin(@NotNull String projectPath2) {
        Intrinsics.checkNotNullParameter((Object)projectPath2, (String)"projectPath");
        if (!KotlinResolverUtilKt.isKotlinJSInspectionsPackSuggestionEnabled()) {
            return;
        }
        String string = KotlinIdeaGradleBundle.message("notification.text.kotlin.js.inspections.pack.provides.inspections.and.quick.fixes.for.kotlin.js", new Object[0]);
        PluginId pluginId = PluginId.getId((String)"org.jetbrains.kotlin-js-inspection-pack-plugin");
        Intrinsics.checkNotNullExpressionValue((Object)pluginId, (String)"PluginId.getId(\"org.jetb\u2026-inspection-pack-plugin\")");
        boolean bl = false;
        Function0 function0 = suggestKotlinJsInspectionPackPlugin.1.INSTANCE;
        PluginId pluginId2 = pluginId;
        String string2 = "kotlin.js";
        KotlinResolverUtilKt.suggestPluginInstall$default(projectPath2, string, pluginId2, string2, function0, bl, 32, null);
    }

    private static final void suggestPluginInstall(String projectPath2, @NlsContexts.NotificationContent String notificationContent, PluginId pluginId, String displayId, Function0<Unit> onDontShowAgainActionPerformed, boolean onlyForUltimate) {
        Project project2;
        block4: {
            ProjectManager projectManager;
            if (onlyForUltimate && !PlatformUtils.isIdeaUltimate()) {
                return;
            }
            if (PluginManagerCore.isPluginInstalled((PluginId)pluginId)) {
                return;
            }
            ProjectManager projectManager2 = projectManager = ProjectManager.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)projectManager2, (String)"projectManager");
            Project[] projectArray = projectManager2.getOpenProjects();
            Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"projectManager.openProjects");
            Project[] $this$firstOrNull$iv = projectArray;
            boolean $i$f$firstOrNull = false;
            int n = $this$firstOrNull$iv.length;
            for (int i = 0; i < n; ++i) {
                Project element$iv;
                Project it = element$iv = $this$firstOrNull$iv[i];
                boolean bl = false;
                Project project3 = it;
                Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"it");
                if (!Intrinsics.areEqual((Object)project3.getBasePath(), (Object)projectPath2)) continue;
                project2 = element$iv;
                break block4;
            }
            project2 = null;
        }
        if (project2 == null) {
            return;
        }
        Project project4 = project2;
        PluginsAdvertiser.getNotificationGroup().createNotification(KotlinIdeaGradleBundle.message("notification.title.plugin.suggestion", new Object[0]), notificationContent, NotificationType.INFORMATION).setDisplayId(displayId).setSuggestionType(true).addAction((AnAction)new NotificationAction(project4, pluginId, KotlinIdeaGradleBundle.message("action.text.install", new Object[0])){
            final /* synthetic */ Project $project;
            final /* synthetic */ PluginId $pluginId;

            public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification2) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Intrinsics.checkNotNullParameter((Object)notification2, (String)"notification");
                PluginsAdvertiser.installAndEnable$default((Project)this.$project, (Set)SetsKt.setOf((Object)this.$pluginId), (boolean)false, (boolean)false, null, (Runnable)new Runnable(notification2){
                    final /* synthetic */ Notification $notification;

                    public final void run() {
                        this.$notification.expire();
                    }
                    {
                        this.$notification = notification2;
                    }
                }, (int)28, null);
            }
            {
                this.$project = $captured_local_variable$0;
                this.$pluginId = $captured_local_variable$1;
                super($super_call_param$2);
            }
        }).addAction((AnAction)new NotificationAction(onDontShowAgainActionPerformed, KotlinIdeaGradleBundle.message("action.text.dontShowAgain", new Object[0])){
            final /* synthetic */ Function0 $onDontShowAgainActionPerformed;

            public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification2) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Intrinsics.checkNotNullParameter((Object)notification2, (String)"notification");
                this.$onDontShowAgainActionPerformed.invoke();
                notification2.expire();
            }
            {
                this.$onDontShowAgainActionPerformed = $captured_local_variable$0;
                super($super_call_param$1);
            }
        }).notify(project4);
    }

    static /* synthetic */ void suggestPluginInstall$default(String string, String string2, PluginId pluginId, String string3, Function0 function0, boolean bl, int n, Object object) {
        if ((n & 0x10) != 0) {
            function0 = suggestPluginInstall.1.INSTANCE;
        }
        if ((n & 0x20) != 0) {
            bl = false;
        }
        KotlinResolverUtilKt.suggestPluginInstall(string, string2, pluginId, string3, (Function0<Unit>)function0, bl);
    }

    public static final /* synthetic */ boolean access$isNativeDebugSuggestionEnabled$p() {
        return KotlinResolverUtilKt.isNativeDebugSuggestionEnabled();
    }

    public static final /* synthetic */ void access$setNativeDebugSuggestionEnabled$p(boolean bl) {
        KotlinResolverUtilKt.setNativeDebugSuggestionEnabled(bl);
    }

    public static final /* synthetic */ boolean access$isKotlinJSInspectionsPackSuggestionEnabled$p() {
        return KotlinResolverUtilKt.isKotlinJSInspectionsPackSuggestionEnabled();
    }

    public static final /* synthetic */ void access$setKotlinJSInspectionsPackSuggestionEnabled$p(boolean bl) {
        KotlinResolverUtilKt.setKotlinJSInspectionsPackSuggestionEnabled(bl);
    }
}

