/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.Alarm;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.core.KotlinPluginDisposable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000e\u001a\u00020\u000fH\u0002J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0007J\u0010\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0007H\u0002J\u000e\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0007J\u000e\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0007J\u0010\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0007H\u0002R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/KotlinHighlightingSuspender;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "lastThrownExceptionTimestampPerFile", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "", "suspendTimeoutMs", "timeoutSeconds", "", "updateQueue", "Lcom/intellij/util/Alarm;", "cleanup", "", "isSuspended", "", "file", "scheduleUpdate", "suspend", "unsuspend", "updateNotifications", "Companion", "kotlin.core"})
public final class KotlinHighlightingSuspender {
    private final int timeoutSeconds;
    private final Map<VirtualFile, Long> lastThrownExceptionTimestampPerFile;
    private final long suspendTimeoutMs;
    private final Alarm updateQueue;
    private final Project project;
    @NotNull
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean suspend(@NotNull VirtualFile file2) {
        long l;
        Map<VirtualFile, Long> map2;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        this.cleanup();
        if (this.suspendTimeoutMs <= 0L) {
            return false;
        }
        long timestamp = System.currentTimeMillis();
        Map<VirtualFile, Long> map3 = map2 = this.lastThrownExceptionTimestampPerFile;
        synchronized (map3) {
            long lastThrownExceptionTimestamp;
            long l2;
            boolean bl = false;
            Long l3 = this.lastThrownExceptionTimestampPerFile.get(file2);
            if (l3 != null) {
                l2 = l3;
            } else {
                KotlinHighlightingSuspender kotlinHighlightingSuspender;
                KotlinHighlightingSuspender $this$run = kotlinHighlightingSuspender = this;
                boolean bl2 = false;
                $this$run.lastThrownExceptionTimestampPerFile.put(file2, timestamp);
                l2 = 0L;
            }
            l = lastThrownExceptionTimestamp = l2;
        }
        long lastThrownExceptionTimestamp = l;
        this.scheduleUpdate(file2);
        this.updateNotifications(file2);
        return timestamp - lastThrownExceptionTimestamp > this.suspendTimeoutMs;
    }

    private final void scheduleUpdate(VirtualFile file2) {
        Alarm alarm2;
        Alarm $this$apply = alarm2 = this.updateQueue;
        boolean bl = false;
        $this$apply.addRequest(new Runnable(this, file2){
            final /* synthetic */ KotlinHighlightingSuspender this$0;
            final /* synthetic */ VirtualFile $file$inlined;
            {
                this.this$0 = kotlinHighlightingSuspender;
                this.$file$inlined = virtualFile2;
            }

            public final void run() {
                KotlinHighlightingSuspender.access$updateNotifications(this.this$0, this.$file$inlined);
            }
        }, this.suspendTimeoutMs + 1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void unsuspend(@NotNull VirtualFile file2) {
        Map<VirtualFile, Long> map2;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Map<VirtualFile, Long> map3 = map2 = this.lastThrownExceptionTimestampPerFile;
        synchronized (map3) {
            boolean bl = false;
            Long l = this.lastThrownExceptionTimestampPerFile.remove(file2);
        }
        this.cleanup();
        this.updateNotifications(file2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isSuspended(@NotNull VirtualFile file2) {
        long l;
        Map<VirtualFile, Long> map2;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        this.cleanup();
        long timestamp = System.currentTimeMillis();
        Map<VirtualFile, Long> map3 = map2 = this.lastThrownExceptionTimestampPerFile;
        synchronized (map3) {
            boolean bl = false;
            Long l2 = this.lastThrownExceptionTimestampPerFile.get(file2);
            if (l2 == null) {
                boolean bl2 = false;
                return bl2;
            }
            long l3 = l2;
            l = l3;
        }
        long lastThrownExceptionTimestamp = l;
        return timestamp - lastThrownExceptionTimestamp < this.suspendTimeoutMs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void cleanup() {
        VirtualFile p1;
        Iterable $this$forEach$iv;
        Object object;
        long timestamp = System.currentTimeMillis();
        List filesToUpdate = new ArrayList();
        List filesToUpdateLater = new ArrayList();
        Object object2 = object = this.lastThrownExceptionTimestampPerFile;
        synchronized (object2) {
            boolean bl = false;
            if (this.lastThrownExceptionTimestampPerFile.isEmpty()) {
                return;
            }
            Iterator<Map.Entry<VirtualFile, Long>> it = this.lastThrownExceptionTimestampPerFile.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<VirtualFile, Long> next2 = it.next();
                if (timestamp - ((Number)next2.getValue()).longValue() <= this.suspendTimeoutMs) continue;
                Collection collection = filesToUpdate;
                VirtualFile virtualFile2 = next2.getKey();
                collection.add(virtualFile2);
                it.remove();
            }
            bl = filesToUpdateLater.addAll((Collection)this.lastThrownExceptionTimestampPerFile.keySet());
        }
        this.updateQueue.cancelAllRequests();
        object = filesToUpdate;
        object2 = this;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            p1 = (VirtualFile)element$iv;
            boolean bl = false;
            ((KotlinHighlightingSuspender)object2).updateNotifications(p1);
        }
        $this$forEach$iv = filesToUpdateLater;
        object2 = this;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            p1 = (VirtualFile)element$iv;
            boolean bl = false;
            ((KotlinHighlightingSuspender)object2).scheduleUpdate(p1);
        }
    }

    private final void updateNotifications(VirtualFile file2) {
        EditorNotifications.getInstance((Project)this.project).updateNotifications(file2);
    }

    public KotlinHighlightingSuspender(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        this.timeoutSeconds = Registry.intValue((String)"kotlin.suspended.highlighting.timeout", (int)10);
        this.lastThrownExceptionTimestampPerFile = new LinkedHashMap();
        this.suspendTimeoutMs = TimeUnit.SECONDS.toMillis(this.timeoutSeconds);
        this.updateQueue = new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)KotlinPluginDisposable.Companion.getInstance(this.project));
    }

    public static final /* synthetic */ void access$updateNotifications(KotlinHighlightingSuspender $this, VirtualFile file2) {
        $this.updateNotifications(file2);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/KotlinHighlightingSuspender$Companion;", "", "()V", "getInstance", "Lorg/jetbrains/kotlin/idea/highlighter/KotlinHighlightingSuspender;", "project", "Lcom/intellij/openapi/project/Project;", "kotlin.core"})
    public static final class Companion {
        @NotNull
        public final KotlinHighlightingSuspender getInstance(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Project $this$service$iv = project2;
            boolean $i$f$service = false;
            Object object = $this$service$iv.getService(KotlinHighlightingSuspender.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(T::class.java)");
            return (KotlinHighlightingSuspender)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

