/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter.markers;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings;
import com.intellij.codeInsight.daemon.GutterIconDescriptor;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProviderDescriptor;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.SeparatorPlacement;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.highlighter.markers.DslHighlightingMarkerKt;
import org.jetbrains.kotlin.idea.highlighter.markers.KotlinLineMarkerOptions;
import org.jetbrains.kotlin.idea.highlighter.markers.KotlinLineMarkerProviderKt;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtil;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassInitializer;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0016\u0010\b\u001a\u0012\u0012\n\b\u0000\u0012\u0006\u0012\u0002\b\u00030\n0\tj\u0002`\u000bH\u0016J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\n2\u0006\u0010\r\u001a\u00020\u0007H\u0002J\u0018\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\n2\u0006\u0010\r\u001a\u00020\u0007H\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0013\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0016\u00a2\u0006\u0002\u0010\u0014J\u000e\u0010\u0015\u001a\u00020\u0016*\u0004\u0018\u00010\u0007H\u0002J\f\u0010\u0017\u001a\u00020\u0016*\u00020\u0007H\u0002\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/markers/KotlinLineMarkerProvider;", "Lcom/intellij/codeInsight/daemon/LineMarkerProviderDescriptor;", "()V", "collectSlowLineMarkers", "", "elements", "", "Lcom/intellij/psi/PsiElement;", "result", "", "Lcom/intellij/codeInsight/daemon/LineMarkerInfo;", "Lorg/jetbrains/kotlin/idea/highlighter/markers/LineMarkerInfos;", "createLineSeparatorByElement", "element", "getLineMarkerInfo", "getName", "", "getOptions", "", "Lcom/intellij/codeInsight/daemon/GutterIconDescriptor$Option;", "()[Lcom/intellij/codeInsight/daemon/GutterIconDescriptor$Option;", "canHaveSeparator", "", "wantsSeparator", "kotlin.idea"})
public final class KotlinLineMarkerProvider
extends LineMarkerProviderDescriptor {
    @NotNull
    public String getName() {
        return KotlinBundle.message("highlighter.name.kotlin.line.markers", new Object[0]);
    }

    @NotNull
    public GutterIconDescriptor.Option[] getOptions() {
        return KotlinLineMarkerOptions.INSTANCE.getOptions();
    }

    @Nullable
    public LineMarkerInfo<PsiElement> getLineMarkerInfo(@NotNull PsiElement element3) {
        block1: {
            block2: {
                PsiElement prevSibling2;
                Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
                if (!DaemonCodeAnalyzerSettings.getInstance().SHOW_METHOD_SEPARATORS || !this.canHaveSeparator(element3) || !this.canHaveSeparator(prevSibling2 = PsiUtilsKt.getPrevSiblingIgnoringWhitespaceAndComments$default((PsiElement)element3, (boolean)false, (int)1, null))) break block1;
                if (this.wantsSeparator(element3)) break block2;
                PsiElement psiElement2 = prevSibling2;
                if (psiElement2 == null) break block1;
                if (!this.wantsSeparator(psiElement2)) break block1;
            }
            return this.createLineSeparatorByElement(element3);
        }
        return null;
    }

    private final boolean canHaveSeparator(PsiElement $this$canHaveSeparator) {
        return $this$canHaveSeparator instanceof KtFunction || $this$canHaveSeparator instanceof KtClassInitializer || $this$canHaveSeparator instanceof KtProperty && !((KtProperty)$this$canHaveSeparator).isLocal() || $this$canHaveSeparator instanceof KtObjectDeclaration && ((KtObjectDeclaration)$this$canHaveSeparator).isCompanion();
    }

    private final boolean wantsSeparator(PsiElement $this$wantsSeparator) {
        return $this$wantsSeparator instanceof KtFunction || StringUtil.getLineBreakCount((CharSequence)$this$wantsSeparator.getText()) > 0;
    }

    private final LineMarkerInfo<PsiElement> createLineSeparatorByElement(PsiElement element3) {
        PsiElement psiElement2 = PsiTreeUtil.getDeepestFirst((PsiElement)element3);
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"PsiTreeUtil.getDeepestFirst(element)");
        PsiElement anchor = psiElement2;
        LineMarkerInfo info2 = new LineMarkerInfo(anchor, anchor.getTextRange());
        EditorColorsManager editorColorsManager = EditorColorsManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsManager, (String)"EditorColorsManager.getInstance()");
        info2.separatorColor = editorColorsManager.getGlobalScheme().getColor(CodeInsightColors.METHOD_SEPARATORS_COLOR);
        info2.separatorPlacement = SeparatorPlacement.TOP;
        return info2;
    }

    public void collectSlowLineMarkers(@NotNull List<? extends PsiElement> elements2, @NotNull Collection<? super LineMarkerInfo<?>> result2) {
        boolean bl;
        block14: {
            Intrinsics.checkNotNullParameter(elements2, (String)"elements");
            Intrinsics.checkNotNullParameter(result2, (String)"result");
            if (elements2.isEmpty()) {
                return;
            }
            GutterIconDescriptor.Option[] $this$none$iv = KotlinLineMarkerOptions.INSTANCE.getOptions();
            boolean $i$f$none = false;
            int n = $this$none$iv.length;
            for (int i = 0; i < n; ++i) {
                GutterIconDescriptor.Option option2;
                GutterIconDescriptor.Option option22 = option2 = $this$none$iv[i];
                boolean bl2 = false;
                if (!option22.isEnabled()) continue;
                bl = false;
                break block14;
            }
            bl = true;
        }
        if (bl) {
            return;
        }
        PsiElement first2 = (PsiElement)CollectionsKt.first(elements2);
        DumbService dumbService = DumbService.getInstance((Project)first2.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)dumbService, (String)"DumbService.getInstance(first.project)");
        if (dumbService.isDumb() || !ProjectRootsUtil.isInProjectOrLibSource$default(first2, false, 2, null)) {
            return;
        }
        HashSet<KtNamedDeclaration> functions2 = new HashSet<KtNamedDeclaration>();
        HashSet<KtNamedDeclaration> properties2 = new HashSet<KtNamedDeclaration>();
        HashSet<KtNamedDeclaration> declarations = new HashSet<KtNamedDeclaration>();
        for (PsiElement psiElement2 : elements2) {
            KtNamedDeclaration element3;
            ProgressManager.checkCanceled();
            if (!(psiElement2 instanceof PsiIdentifier) && psiElement2.getFirstChild() != null) continue;
            PsiElement psiElement3 = psiElement2.getParent();
            if (!(psiElement3 instanceof KtNamedDeclaration)) {
                psiElement3 = null;
            }
            if ((KtNamedDeclaration)psiElement3 == null) {
                continue;
            }
            if (!declarations.add(element3)) continue;
            KtNamedDeclaration ktNamedDeclaration = element3;
            if (ktNamedDeclaration instanceof KtClass) {
                KotlinLineMarkerProviderKt.access$collectInheritedClassMarker((KtClass)element3, result2);
                DslHighlightingMarkerKt.collectHighlightingColorsMarkers((KtClass)element3, result2);
            } else if (ktNamedDeclaration instanceof KtNamedFunction) {
                functions2.add(element3);
                KotlinLineMarkerProviderKt.access$collectSuperDeclarationMarkers((KtDeclaration)element3, result2);
            } else if (ktNamedDeclaration instanceof KtProperty) {
                properties2.add(element3);
                KotlinLineMarkerProviderKt.access$collectSuperDeclarationMarkers((KtDeclaration)element3, result2);
            } else if (ktNamedDeclaration instanceof KtParameter && ((KtParameter)element3).hasValOrVar()) {
                properties2.add(element3);
                KotlinLineMarkerProviderKt.access$collectSuperDeclarationMarkers((KtDeclaration)element3, result2);
            }
            KotlinLineMarkerProviderKt.access$collectMultiplatformMarkers(element3, result2);
        }
        KotlinLineMarkerProviderKt.access$collectOverriddenFunctions(functions2, result2);
        KotlinLineMarkerProviderKt.access$collectOverriddenPropertyAccessors(properties2, result2);
    }
}

