/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.builtins.functions.FunctionInvokeDescriptor;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.PsiModificationUtilsKt;
import org.jetbrains.kotlin.idea.inspections.collections.FunctionUtilsKt;
import org.jetbrains.kotlin.idea.intentions.UtilsKt;
import org.jetbrains.kotlin.idea.search.usagesSearch.SearchHelpersKt;
import org.jetbrains.kotlin.lexer.KtKeywordToken;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.load.java.descriptors.JavaMethodDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.BuilderByPattern;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtBreakExpression;
import org.jetbrains.kotlin.psi.KtCallElement;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtContainerNode;
import org.jetbrains.kotlin.psi.KtContinueExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDoWhileExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtElementImplStub;
import org.jetbrains.kotlin.psi.KtElementUtilsKt;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtIsExpression;
import org.jetbrains.kotlin.psi.KtLabeledExpression;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPrefixExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtSafeQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtSuperExpression;
import org.jetbrains.kotlin.psi.KtThrowExpression;
import org.jetbrains.kotlin.psi.KtTypeArgumentList;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.KtWhileExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.ArrayFqNames;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeFactory;
import org.jetbrains.kotlin.types.TypeAttributes;
import org.jetbrains.kotlin.types.TypeAttributesKt;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.util.OperatorChecks;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000\u00d8\u0001\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010!\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020#H\u0002\u001a\u0010\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020'\u001a \u0010(\u001a\u00020)*\b\u0012\u0004\u0012\u00020\u000e0*2\u0006\u0010+\u001a\u00020\u00132\u0006\u0010,\u001a\u00020\u0007\u001a\u0012\u0010-\u001a\u00020)*\u00020.2\u0006\u0010/\u001a\u000200\u001a\n\u00101\u001a\u00020\u001b*\u00020\u0013\u001a\u0012\u00101\u001a\u00020\u001b*\n\u0012\u0006\b\u0001\u0012\u00020\u001c02\u001a\n\u00103\u001a\u00020\u000e*\u000204\u001a\f\u00105\u001a\u0004\u0018\u00010\u0007*\u000206\u001a\u000e\u00107\u001a\u0004\u0018\u00010\u001c*\u00020\u000eH\u0000\u001a\n\u00108\u001a\u00020\u000e*\u000204\u001a\f\u00109\u001a\u0004\u0018\u00010\u0007*\u00020:\u001a\f\u0010;\u001a\u00020\u001b*\u0004\u0018\u00010\u000e\u001a\u0014\u0010<\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\u0004*\u00020\u000eH\u0002\u001a\n\u0010=\u001a\u00020\u001b*\u00020\u0013\u001a \u0010>\u001a\u00020\u001b*\u00020\u000e2\u0014\b\u0002\u0010?\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u001b0@\u001a\n\u0010A\u001a\u00020\u001b*\u00020\u000e\u001a\u0016\u0010B\u001a\u00020\u001b*\u00020C2\n\b\u0002\u0010D\u001a\u0004\u0018\u00010E\u001a\f\u0010F\u001a\u00020\u001b*\u00020GH\u0000\u001a\u0012\u0010H\u001a\u00020\u001b*\u00020\u00132\u0006\u0010I\u001a\u00020\u0007\u001a\f\u0010J\u001a\u00020\u001b*\u0004\u0018\u00010K\u001a\n\u0010L\u001a\u00020\u001b*\u00020M\u001a\n\u0010N\u001a\u00020\u001b*\u00020\u0014\u001a\n\u0010O\u001a\u00020\u001b*\u00020K\u001a\f\u0010P\u001a\u00020\u001b*\u0004\u0018\u00010\u000e\u001a\n\u0010Q\u001a\u00020\u001b*\u000204\u001a\f\u0010R\u001a\u00020\u001b*\u0004\u0018\u00010K\u001a\u001c\u0010S\u001a\u0004\u0018\u000100*\b\u0012\u0004\u0012\u0002000T2\u0006\u0010U\u001a\u00020\u000eH\u0000\u001a\u0014\u0010V\u001a\u00020\u000e*\u00020\u000e2\b\b\u0002\u0010W\u001a\u00020\u001b\u001a\f\u0010X\u001a\u0004\u0018\u00010G*\u00020\u001c\u001a\u000e\u0010Y\u001a\u0004\u0018\u00010G*\u0004\u0018\u00010\u000e\u001a\n\u0010Z\u001a\u00020G*\u00020G\u001a$\u0010[\u001a\u00020\u000e*\u0002042\u0006\u0010\\\u001a\u00020.2\u0006\u0010]\u001a\u00020\u000e2\b\b\u0002\u0010^\u001a\u00020\u001b\u001a\u0012\u0010_\u001a\u00020\u001b*\n\u0012\u0006\b\u0001\u0012\u00020\u001c02\u001a\f\u0010`\u001a\u0004\u0018\u00010a*\u00020\u0013\u001a\u0016\u0010b\u001a\u0004\u0018\u00010\u000e*\u00020\u000e2\u0006\u0010W\u001a\u00020\u001bH\u0002\u001a\u001c\u0010c\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u001c\u0018\u000102*\u00020\u00142\u0006\u0010d\u001a\u00020e\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001c\u0010\t\u001a\u0010\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n0\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001d\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\u0004*\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\"\u0017\u0010\u0012\u001a\u0004\u0018\u00010\u0013*\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\"\u0017\u0010\u0017\u001a\u0004\u0018\u00010\u0007*\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\"\u0015\u0010\u001a\u001a\u00020\u001b*\u00020\u001c8F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001d\"\u0015\u0010\u001e\u001a\u00020\u001b*\u00020\u001f8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010 \u00a8\u0006f"}, d2={"ARRAY_OF_FUNCTION_NAMES", "", "Lorg/jetbrains/kotlin/name/Name;", "COUNT_FUNCTIONS", "", "Lorg/jetbrains/kotlin/name/FqName;", "ENUM_STATIC_METHODS", "", "KOTLIN_BUILTIN_ENUM_FUNCTIONS", "NEGATABLE_OPERATORS", "Lorg/jetbrains/kotlin/lexer/KtSingleValueToken;", "kotlin.jvm.PlatformType", "rangeTypes", "branches", "Lorg/jetbrains/kotlin/psi/KtExpression;", "Lorg/jetbrains/kotlin/psi/KtIfExpression;", "getBranches", "(Lorg/jetbrains/kotlin/psi/KtIfExpression;)Ljava/util/List;", "callExpression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "Lorg/jetbrains/kotlin/psi/KtQualifiedExpression;", "getCallExpression", "(Lorg/jetbrains/kotlin/psi/KtQualifiedExpression;)Lorg/jetbrains/kotlin/psi/KtCallExpression;", "calleeName", "getCalleeName", "(Lorg/jetbrains/kotlin/psi/KtQualifiedExpression;)Ljava/lang/String;", "isInvokeOperator", "", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "(Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;)Z", "isOperatorOrCompatible", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "(Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;)Z", "getNegatedOperatorText", "token", "Lcom/intellij/psi/tree/IElementType;", "splitPropertyDeclaration", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "appendCallOrQualifiedExpression", "", "Lorg/jetbrains/kotlin/psi/BuilderByPattern;", "call", "newFunctionName", "appendSemicolonBeforeLambdaContainingElement", "Lorg/jetbrains/kotlin/psi/KtPsiFactory;", "element", "Lcom/intellij/psi/PsiElement;", "canBeReplacedWithInvokeCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "deleteFirstReceiver", "Lorg/jetbrains/kotlin/psi/KtDotQualifiedExpression;", "description", "Lorg/jetbrains/kotlin/psi/KtContainerNode;", "getCallableDescriptor", "getLeftMostReceiverExpression", "getParentLambdaLabelName", "Lorg/jetbrains/kotlin/psi/KtBlockExpression;", "hasResultingIfWithoutElse", "ifBranchesOrThis", "isArrayOfFunction", "isCountCall", "predicate", "Lkotlin/Function1;", "isExitStatement", "isFinalizeMethod", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "isFlexibleRecursive", "Lorg/jetbrains/kotlin/types/KotlinType;", "isMethodCall", "fqMethodName", "isOne", "Lorg/jetbrains/kotlin/psi/KtElement;", "isRange", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "isReceiverExpressionWithValue", "isReferenceToBuiltInEnumFunction", "isSizeOrLength", "isToString", "isZero", "lastWithPersistedElementOrNull", "Lkotlin/sequences/Sequence;", "elementShouldPersist", "negate", "reformat", "receiverType", "receiverTypeIfSelectorIsSizeOrLength", "reflectToRegularFunctionType", "replaceFirstReceiver", "factory", "newReceiver", "safeAccess", "resolvedToArrayType", "singleLambdaArgumentExpression", "Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "specialNegation", "toResolvedCall", "bodyResolveMode", "Lorg/jetbrains/kotlin/resolve/lazy/BodyResolveMode;", "kotlin.idea"})
public final class UtilsKt {
    private static final Set<KtSingleValueToken> NEGATABLE_OPERATORS = SetsKt.setOf((Object[])new KtSingleValueToken[]{KtTokens.EQEQ, KtTokens.EXCLEQ, KtTokens.EQEQEQ, KtTokens.EXCLEQEQEQ, (KtSingleValueToken)KtTokens.IS_KEYWORD, (KtSingleValueToken)KtTokens.NOT_IS, (KtSingleValueToken)KtTokens.IN_KEYWORD, (KtSingleValueToken)KtTokens.NOT_IN, KtTokens.LT, KtTokens.LTEQ, KtTokens.GT, KtTokens.GTEQ});
    private static final List<FqName> COUNT_FUNCTIONS = CollectionsKt.listOf((Object[])new FqName[]{new FqName("kotlin.collections.count"), new FqName("kotlin.text.count")});
    private static final Set<Name> ARRAY_OF_FUNCTION_NAMES;
    private static final List<FqName> KOTLIN_BUILTIN_ENUM_FUNCTIONS;
    private static final List<String> ENUM_STATIC_METHODS;
    private static final Set<String> rangeTypes;

    @Nullable
    public static final String description(@NotNull KtContainerNode $this$description) {
        Intrinsics.checkNotNullParameter((Object)$this$description, (String)"$this$description");
        ASTNode aSTNode = $this$description.getNode();
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"node");
        IElementType iElementType = aSTNode.getElementType();
        if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.THEN)) {
            return "if";
        }
        if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.ELSE)) {
            return "else";
        }
        if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.BODY)) {
            PsiElement psiElement2 = $this$description.getParent();
            if (psiElement2 instanceof KtWhileExpression) {
                return "while";
            }
            if (psiElement2 instanceof KtDoWhileExpression) {
                return "do...while";
            }
            if (psiElement2 instanceof KtForExpression) {
                return "for";
            }
        }
        return null;
    }

    public static final boolean isMethodCall(@NotNull KtCallExpression $this$isMethodCall, @NotNull String fqMethodName) {
        Intrinsics.checkNotNullParameter((Object)$this$isMethodCall, (String)"$this$isMethodCall");
        Intrinsics.checkNotNullParameter((Object)fqMethodName, (String)"fqMethodName");
        ResolvedCall resolvedCall2 = ResolutionUtils.resolveToCall$default((KtElement)$this$isMethodCall, null, 1, null);
        if (resolvedCall2 == null) {
            return false;
        }
        ResolvedCall resolvedCall3 = resolvedCall2;
        return Intrinsics.areEqual((Object)DescriptorUtilsKt.getFqNameUnsafe((DeclarationDescriptor)((DeclarationDescriptor)resolvedCall3.getResultingDescriptor())).asString(), (Object)fqMethodName);
    }

    @Nullable
    public static final KtBinaryExpression splitPropertyDeclaration(@NotNull KtProperty property2) {
        Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
        PsiElement parent2 = property2.getParent();
        KtExpression ktExpression = property2.getInitializer();
        if (ktExpression == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)ktExpression, (String)"property.initializer ?: return null");
        KtExpression initializer2 = ktExpression;
        KotlinType explicitTypeToSet = property2.getTypeReference() != null ? null : ResolutionUtils.analyze$default((KtElement)initializer2, null, 1, null).getType(initializer2);
        KtPsiFactory psiFactory = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)((PsiElement)property2), (boolean)false, (int)2, null);
        Object[] objectArray = new Object[2];
        Name name2 = property2.getNameAsName();
        Intrinsics.checkNotNull((Object)name2);
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"property.nameAsName!!");
        objectArray[0] = name2;
        objectArray[1] = initializer2;
        KtExpression assignment2 = CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)psiFactory, (String)"$0 = $1", (Object[])objectArray, (boolean)false, (int)4, null);
        PsiElement psiElement2 = parent2.addAfter((PsiElement)assignment2, (PsiElement)property2);
        if (psiElement2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtBinaryExpression");
        }
        assignment2 = (KtExpression)((KtBinaryExpression)psiElement2);
        parent2.addAfter(psiFactory.createNewLine(), (PsiElement)property2);
        property2.setInitializer((KtExpression)null);
        if (explicitTypeToSet != null) {
            PsiModificationUtilsKt.setType$default((KtCallableDeclaration)property2, explicitTypeToSet, false, 2, null);
        }
        return (KtBinaryExpression)assignment2;
    }

    @Nullable
    public static final KtCallExpression getCallExpression(@NotNull KtQualifiedExpression $this$callExpression) {
        Intrinsics.checkNotNullParameter((Object)$this$callExpression, (String)"$this$callExpression");
        KtExpression ktExpression = $this$callExpression.getSelectorExpression();
        if (!(ktExpression instanceof KtCallExpression)) {
            ktExpression = null;
        }
        return (KtCallExpression)ktExpression;
    }

    @Nullable
    public static final String getCalleeName(@NotNull KtQualifiedExpression $this$calleeName) {
        Intrinsics.checkNotNullParameter((Object)$this$calleeName, (String)"$this$calleeName");
        KtCallExpression ktCallExpression = UtilsKt.getCallExpression($this$calleeName);
        Object object = ktCallExpression != null ? ktCallExpression.getCalleeExpression() : null;
        if (!(object instanceof KtNameReferenceExpression)) {
            object = null;
        }
        KtNameReferenceExpression ktNameReferenceExpression = (KtNameReferenceExpression)object;
        return ktNameReferenceExpression != null ? ktNameReferenceExpression.getText() : null;
    }

    @Nullable
    public static final ResolvedCall<? extends CallableDescriptor> toResolvedCall(@NotNull KtQualifiedExpression $this$toResolvedCall, @NotNull BodyResolveMode bodyResolveMode) {
        Intrinsics.checkNotNullParameter((Object)$this$toResolvedCall, (String)"$this$toResolvedCall");
        Intrinsics.checkNotNullParameter((Object)((Object)bodyResolveMode), (String)"bodyResolveMode");
        KtCallExpression ktCallExpression = UtilsKt.getCallExpression($this$toResolvedCall);
        return ktCallExpression != null ? ResolutionUtils.resolveToCall((KtElement)ktCallExpression, bodyResolveMode) : null;
    }

    public static final boolean isExitStatement(@NotNull KtExpression $this$isExitStatement) {
        Intrinsics.checkNotNullParameter((Object)$this$isExitStatement, (String)"$this$isExitStatement");
        KtExpression ktExpression = $this$isExitStatement;
        return ktExpression instanceof KtContinueExpression || ktExpression instanceof KtBreakExpression || ktExpression instanceof KtThrowExpression || ktExpression instanceof KtReturnExpression;
    }

    public static final boolean isReceiverExpressionWithValue(@NotNull KtQualifiedExpression $this$isReceiverExpressionWithValue) {
        Intrinsics.checkNotNullParameter((Object)$this$isReceiverExpressionWithValue, (String)"$this$isReceiverExpressionWithValue");
        KtExpression receiver2 = $this$isReceiverExpressionWithValue.getReceiverExpression();
        if (receiver2 instanceof KtSuperExpression) {
            return false;
        }
        return ResolutionUtils.analyze$default((KtElement)$this$isReceiverExpressionWithValue, null, 1, null).getType(receiver2) != null;
    }

    @NotNull
    public static final KtExpression negate(@NotNull KtExpression $this$negate, boolean reformat) {
        Intrinsics.checkNotNullParameter((Object)$this$negate, (String)"$this$negate");
        KtExpression specialNegation = UtilsKt.specialNegation($this$negate, reformat);
        if (specialNegation != null) {
            return specialNegation;
        }
        return CreateByPatternKt.createExpressionByPattern((KtPsiFactory)KtPsiFactoryKt.KtPsiFactory$default((PsiElement)((PsiElement)$this$negate), (boolean)false, (int)2, null), (String)"!$0", (Object[])new Object[]{$this$negate}, (boolean)reformat);
    }

    public static /* synthetic */ KtExpression negate$default(KtExpression ktExpression, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return UtilsKt.negate(ktExpression, bl);
    }

    public static final boolean hasResultingIfWithoutElse(@Nullable KtExpression $this$hasResultingIfWithoutElse) {
        boolean bl;
        block13: {
            KtExpression ktExpression = $this$hasResultingIfWithoutElse;
            if (ktExpression instanceof KtIfExpression) {
                bl = ((KtIfExpression)$this$hasResultingIfWithoutElse).getElse() == null || UtilsKt.hasResultingIfWithoutElse(((KtIfExpression)$this$hasResultingIfWithoutElse).getThen()) || UtilsKt.hasResultingIfWithoutElse(((KtIfExpression)$this$hasResultingIfWithoutElse).getElse());
            } else if (ktExpression instanceof KtWhenExpression) {
                List list2 = ((KtWhenExpression)$this$hasResultingIfWithoutElse).getEntries();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"entries");
                Iterable $this$any$iv = list2;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        KtWhenEntry it = (KtWhenEntry)element$iv;
                        boolean bl2 = false;
                        KtWhenEntry ktWhenEntry = it;
                        Intrinsics.checkNotNullExpressionValue((Object)ktWhenEntry, (String)"it");
                        if (!UtilsKt.hasResultingIfWithoutElse(ktWhenEntry.getExpression())) continue;
                        bl = true;
                        break block13;
                    }
                    bl = false;
                }
            } else if (ktExpression instanceof KtBinaryExpression) {
                bl = UtilsKt.hasResultingIfWithoutElse(((KtBinaryExpression)$this$hasResultingIfWithoutElse).getLeft()) || UtilsKt.hasResultingIfWithoutElse(((KtBinaryExpression)$this$hasResultingIfWithoutElse).getRight());
            } else if (ktExpression instanceof KtUnaryExpression) {
                bl = UtilsKt.hasResultingIfWithoutElse(((KtUnaryExpression)$this$hasResultingIfWithoutElse).getBaseExpression());
            } else if (ktExpression instanceof KtBlockExpression) {
                List list3 = ((KtBlockExpression)$this$hasResultingIfWithoutElse).getStatements();
                Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"statements");
                bl = UtilsKt.hasResultingIfWithoutElse((KtExpression)CollectionsKt.lastOrNull((List)list3));
            } else {
                bl = false;
            }
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final KtExpression specialNegation(KtExpression $this$specialNegation, boolean reformat) {
        KtPsiFactory factory2 = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)((PsiElement)$this$specialNegation), (boolean)false, (int)2, null);
        KtExpression ktExpression = $this$specialNegation;
        if (ktExpression instanceof KtPrefixExpression) {
            if (!Intrinsics.areEqual((Object)((KtPrefixExpression)$this$specialNegation).getOperationReference().getReferencedName(), (Object)"!")) return null;
            KtExpression baseExpression = ((KtPrefixExpression)$this$specialNegation).getBaseExpression();
            if (baseExpression == null) return null;
            BindingContext bindingContext2 = ResolutionUtils.analyze((KtElement)baseExpression, BodyResolveMode.PARTIAL);
            KotlinType type2 = bindingContext2.getType(baseExpression);
            if (type2 == null) return null;
            if (!KotlinBuiltIns.isBoolean((KotlinType)type2)) return null;
            return KtPsiUtil.safeDeparenthesize((KtExpression)baseExpression);
        }
        if (ktExpression instanceof KtBinaryExpression) {
            IElementType iElementType = ((KtBinaryExpression)$this$specialNegation).getOperationToken();
            Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"operationToken");
            IElementType operator = iElementType;
            if (!CollectionsKt.contains((Iterable)NEGATABLE_OPERATORS, (Object)operator)) {
                return null;
            }
            KtExpression ktExpression2 = ((KtBinaryExpression)$this$specialNegation).getLeft();
            if (ktExpression2 == null) return null;
            Intrinsics.checkNotNullExpressionValue((Object)ktExpression2, (String)"left ?: return null");
            KtExpression left = ktExpression2;
            KtExpression ktExpression3 = ((KtBinaryExpression)$this$specialNegation).getRight();
            if (ktExpression3 == null) return null;
            Intrinsics.checkNotNullExpressionValue((Object)ktExpression3, (String)"right ?: return null");
            KtExpression right2 = ktExpression3;
            return CreateByPatternKt.createExpressionByPattern((KtPsiFactory)factory2, (String)"$0 $1 $2", (Object[])new Object[]{left, UtilsKt.getNegatedOperatorText(operator), right2}, (boolean)reformat);
        }
        if (ktExpression instanceof KtIsExpression) {
            Object[] objectArray = new Object[3];
            KtExpression ktExpression4 = ((KtIsExpression)$this$specialNegation).getLeftHandSide();
            Intrinsics.checkNotNullExpressionValue((Object)ktExpression4, (String)"leftHandSide");
            objectArray[0] = ktExpression4;
            objectArray[1] = ((KtIsExpression)$this$specialNegation).isNegated() ? "is" : "!is";
            KtTypeReference ktTypeReference = ((KtIsExpression)$this$specialNegation).getTypeReference();
            if (ktTypeReference == null) return null;
            Intrinsics.checkNotNullExpressionValue((Object)ktTypeReference, (String)"typeReference ?: return null");
            objectArray[2] = ktTypeReference;
            return CreateByPatternKt.createExpressionByPattern((KtPsiFactory)factory2, (String)"$0 $1 $2", (Object[])objectArray, (boolean)reformat);
        }
        if (!(ktExpression instanceof KtConstantExpression)) return null;
        String string = ((KtConstantExpression)$this$specialNegation).getText();
        if (string == null) return null;
        switch (string) {
            case "true": {
                KtExpression ktExpression5 = factory2.createExpression("false");
                return ktExpression5;
            }
            case "false": {
                KtExpression ktExpression5 = factory2.createExpression("true");
                return ktExpression5;
            }
            default: {
                return null;
            }
        }
    }

    private static final String getNegatedOperatorText(IElementType token) {
        String string;
        IElementType iElementType = token;
        if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.EQEQ)) {
            KtSingleValueToken ktSingleValueToken = KtTokens.EXCLEQ;
            Intrinsics.checkNotNullExpressionValue((Object)ktSingleValueToken, (String)"KtTokens.EXCLEQ");
            String string2 = ktSingleValueToken.getValue();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"KtTokens.EXCLEQ.value");
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.EXCLEQ)) {
            KtSingleValueToken ktSingleValueToken = KtTokens.EQEQ;
            Intrinsics.checkNotNullExpressionValue((Object)ktSingleValueToken, (String)"KtTokens.EQEQ");
            String string3 = ktSingleValueToken.getValue();
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"KtTokens.EQEQ.value");
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.EQEQEQ)) {
            KtSingleValueToken ktSingleValueToken = KtTokens.EXCLEQEQEQ;
            Intrinsics.checkNotNullExpressionValue((Object)ktSingleValueToken, (String)"KtTokens.EXCLEQEQEQ");
            String string4 = ktSingleValueToken.getValue();
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"KtTokens.EXCLEQEQEQ.value");
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.EXCLEQEQEQ)) {
            KtSingleValueToken ktSingleValueToken = KtTokens.EQEQEQ;
            Intrinsics.checkNotNullExpressionValue((Object)ktSingleValueToken, (String)"KtTokens.EQEQEQ");
            String string5 = ktSingleValueToken.getValue();
            string = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"KtTokens.EQEQEQ.value");
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.IS_KEYWORD)) {
            KtKeywordToken ktKeywordToken = KtTokens.NOT_IS;
            Intrinsics.checkNotNullExpressionValue((Object)ktKeywordToken, (String)"KtTokens.NOT_IS");
            String string6 = ktKeywordToken.getValue();
            string = string6;
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"KtTokens.NOT_IS.value");
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.NOT_IS)) {
            KtKeywordToken ktKeywordToken = KtTokens.IS_KEYWORD;
            Intrinsics.checkNotNullExpressionValue((Object)ktKeywordToken, (String)"KtTokens.IS_KEYWORD");
            String string7 = ktKeywordToken.getValue();
            string = string7;
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"KtTokens.IS_KEYWORD.value");
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.IN_KEYWORD)) {
            KtKeywordToken ktKeywordToken = KtTokens.NOT_IN;
            Intrinsics.checkNotNullExpressionValue((Object)ktKeywordToken, (String)"KtTokens.NOT_IN");
            String string8 = ktKeywordToken.getValue();
            string = string8;
            Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"KtTokens.NOT_IN.value");
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.NOT_IN)) {
            KtModifierKeywordToken ktModifierKeywordToken = KtTokens.IN_KEYWORD;
            Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken, (String)"KtTokens.IN_KEYWORD");
            String string9 = ktModifierKeywordToken.getValue();
            string = string9;
            Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"KtTokens.IN_KEYWORD.value");
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.LT)) {
            KtSingleValueToken ktSingleValueToken = KtTokens.GTEQ;
            Intrinsics.checkNotNullExpressionValue((Object)ktSingleValueToken, (String)"KtTokens.GTEQ");
            String string10 = ktSingleValueToken.getValue();
            string = string10;
            Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"KtTokens.GTEQ.value");
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.LTEQ)) {
            KtSingleValueToken ktSingleValueToken = KtTokens.GT;
            Intrinsics.checkNotNullExpressionValue((Object)ktSingleValueToken, (String)"KtTokens.GT");
            String string11 = ktSingleValueToken.getValue();
            string = string11;
            Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"KtTokens.GT.value");
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.GT)) {
            KtSingleValueToken ktSingleValueToken = KtTokens.LTEQ;
            Intrinsics.checkNotNullExpressionValue((Object)ktSingleValueToken, (String)"KtTokens.LTEQ");
            String string12 = ktSingleValueToken.getValue();
            string = string12;
            Intrinsics.checkNotNullExpressionValue((Object)string12, (String)"KtTokens.LTEQ.value");
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.GTEQ)) {
            KtSingleValueToken ktSingleValueToken = KtTokens.LT;
            Intrinsics.checkNotNullExpressionValue((Object)ktSingleValueToken, (String)"KtTokens.LT");
            String string13 = ktSingleValueToken.getValue();
            string = string13;
            Intrinsics.checkNotNullExpressionValue((Object)string13, (String)"KtTokens.LT.value");
        } else {
            throw (Throwable)new IllegalArgumentException("The token " + token + " does not have a negated equivalent.");
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isFlexibleRecursive(@NotNull KotlinType $this$isFlexibleRecursive) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isFlexibleRecursive, (String)"$this$isFlexibleRecursive");
        if (FlexibleTypesKt.isFlexible((KotlinType)$this$isFlexibleRecursive)) {
            return true;
        }
        Iterable $this$any$iv = $this$isFlexibleRecursive.getArguments();
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            TypeProjection it = (TypeProjection)element$iv;
            boolean bl2 = false;
            if (!it.isStarProjection()) {
                KotlinType kotlinType = it.getType();
                Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"it.type");
                if (UtilsKt.isFlexibleRecursive(kotlinType)) {
                    return true;
                }
            }
            bl = false;
        } while (!bl);
        return true;
    }

    @NotNull
    public static final List<KtExpression> getBranches(@NotNull KtIfExpression $this$branches) {
        Intrinsics.checkNotNullParameter((Object)$this$branches, (String)"$this$branches");
        return UtilsKt.ifBranchesOrThis((KtExpression)$this$branches);
    }

    private static final List<KtExpression> ifBranchesOrThis(KtExpression $this$ifBranchesOrThis) {
        if (!($this$ifBranchesOrThis instanceof KtIfExpression)) {
            return CollectionsKt.listOf((Object)$this$ifBranchesOrThis);
        }
        Collection collection = CollectionsKt.listOf((Object)((KtIfExpression)$this$ifBranchesOrThis).getThen());
        KtExpression ktExpression = ((KtIfExpression)$this$ifBranchesOrThis).getElse();
        List list2 = ktExpression != null ? UtilsKt.ifBranchesOrThis(ktExpression) : null;
        List list3 = list2;
        if (list3 == null) {
            list3 = CollectionsKt.emptyList();
        }
        return CollectionsKt.plus((Collection)collection, (Iterable)list3);
    }

    public static final boolean resolvedToArrayType(@NotNull ResolvedCall<? extends CallableDescriptor> $this$resolvedToArrayType) {
        KotlinType kotlinType;
        Intrinsics.checkNotNullParameter($this$resolvedToArrayType, (String)"$this$resolvedToArrayType");
        KotlinType type2 = kotlinType = $this$resolvedToArrayType.getResultingDescriptor().getReturnType();
        boolean bl = false;
        return type2 != null && (KotlinBuiltIns.isArray((KotlinType)type2) || KotlinBuiltIns.isPrimitiveArray((KotlinType)type2));
    }

    public static final boolean isZero(@Nullable KtElement $this$isZero) {
        KtElement ktElement = $this$isZero;
        return Intrinsics.areEqual((Object)(ktElement != null ? ktElement.getText() : null), (Object)"0");
    }

    public static final boolean isOne(@Nullable KtElement $this$isOne) {
        KtElement ktElement = $this$isOne;
        return Intrinsics.areEqual((Object)(ktElement != null ? ktElement.getText() : null), (Object)"1");
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static final KotlinType receiverTypeIfSelectorIsSizeOrLength(@Nullable KtExpression $this$receiverTypeIfSelectorIsSizeOrLength) {
        Object element$iv;
        void $this$any$iv;
        ReceiverValue receiverType2;
        ReceiverValue receiverValue;
        Function1 function1;
        KtDotQualifiedExpression selector2;
        KtDotQualifiedExpression ktDotQualifiedExpression;
        KtExpression ktExpression = $this$receiverTypeIfSelectorIsSizeOrLength;
        if (!(ktExpression instanceof KtDotQualifiedExpression)) {
            ktExpression = null;
        }
        if ((ktDotQualifiedExpression = (KtDotQualifiedExpression)ktExpression) == null || (ktDotQualifiedExpression = ktDotQualifiedExpression.getSelectorExpression()) == null) {
            ktDotQualifiedExpression = $this$receiverTypeIfSelectorIsSizeOrLength;
        }
        KtDotQualifiedExpression ktDotQualifiedExpression2 = selector2 = ktDotQualifiedExpression;
        if (ktDotQualifiedExpression2 == null) return null;
        String string = ktDotQualifiedExpression2.getText();
        if (string == null) return null;
        switch (string) {
            case "size": {
                function1 = receiverTypeIfSelectorIsSizeOrLength.predicate.1.INSTANCE;
                break;
            }
            case "length": {
                function1 = receiverTypeIfSelectorIsSizeOrLength.predicate.2.INSTANCE;
                break;
            }
            default: {
                return null;
            }
        }
        Function1 predicate2 = function1;
        ResolvedCall resolvedCall2 = ResolutionUtils.resolveToCall$default((KtElement)selector2, null, 1, null);
        if (resolvedCall2 == null) return null;
        ResolvedCall resolvedCall3 = resolvedCall2;
        ReceiverValue receiverValue2 = resolvedCall3.getDispatchReceiver();
        if (receiverValue2 == null) {
            receiverValue2 = resolvedCall3.getExtensionReceiver();
        }
        ReceiverValue receiverValue3 = receiverValue2;
        if (receiverValue2 == null) return null;
        KotlinType kotlinType = receiverValue3.getType();
        receiverValue3 = kotlinType;
        if (kotlinType == null) return null;
        Intrinsics.checkNotNullExpressionValue((Object)receiverValue3, (String)"(resolvedCall.dispatchRe\u2026ver)?.type ?: return null");
        ReceiverValue it = receiverValue = (receiverType2 = receiverValue3);
        boolean bl = false;
        Collection collection = it.getConstructor().getSupertypes();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"it.constructor.supertypes");
        Iterable iterable = CollectionsKt.plus((Collection)collection, (Object)it);
        Function1 predicate$iv = predicate2;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return null;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return null;
        } while (!((Boolean)predicate$iv.invoke(element$iv = iterator.next())).booleanValue());
        boolean bl2 = true;
        if (!bl2) return null;
        ReceiverValue receiverValue4 = receiverValue;
        return receiverValue4;
    }

    public static final boolean isSizeOrLength(@Nullable KtExpression $this$isSizeOrLength) {
        return UtilsKt.receiverTypeIfSelectorIsSizeOrLength($this$isSizeOrLength) != null;
    }

    public static final boolean isCountCall(@NotNull KtExpression $this$isCountCall, @NotNull Function1<? super KtCallExpression, Boolean> predicate2) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$isCountCall, (String)"$this$isCountCall");
        Intrinsics.checkNotNullParameter(predicate2, (String)"predicate");
        KtExpression ktExpression = $this$isCountCall;
        if (!(ktExpression instanceof KtCallExpression)) {
            ktExpression = null;
        }
        if ((object = (KtCallExpression)ktExpression) == null) {
            KtExpression ktExpression2 = $this$isCountCall;
            if (!(ktExpression2 instanceof KtQualifiedExpression)) {
                ktExpression2 = null;
            }
            KtQualifiedExpression ktQualifiedExpression = (KtQualifiedExpression)ktExpression2;
            object = ktQualifiedExpression != null ? UtilsKt.getCallExpression(ktQualifiedExpression) : null;
        }
        if (object == null) {
            return false;
        }
        KtCallExpression callExpression2 = object;
        if (!((Boolean)predicate2.invoke((Object)callExpression2)).booleanValue()) {
            return false;
        }
        return FunctionUtilsKt.isCalling$default(callExpression2, COUNT_FUNCTIONS, null, 2, null);
    }

    public static /* synthetic */ boolean isCountCall$default(KtExpression ktExpression, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            function1 = isCountCall.1.INSTANCE;
        }
        return UtilsKt.isCountCall(ktExpression, (Function1<? super KtCallExpression, Boolean>)function1);
    }

    @NotNull
    public static final KtExpression getLeftMostReceiverExpression(@NotNull KtDotQualifiedExpression $this$getLeftMostReceiverExpression) {
        KtDotQualifiedExpression ktDotQualifiedExpression;
        Intrinsics.checkNotNullParameter((Object)$this$getLeftMostReceiverExpression, (String)"$this$getLeftMostReceiverExpression");
        KtExpression ktExpression = $this$getLeftMostReceiverExpression.getReceiverExpression();
        if (!(ktExpression instanceof KtDotQualifiedExpression)) {
            ktExpression = null;
        }
        if ((ktDotQualifiedExpression = (KtDotQualifiedExpression)ktExpression) == null || (ktDotQualifiedExpression = UtilsKt.getLeftMostReceiverExpression(ktDotQualifiedExpression)) == null) {
            ktDotQualifiedExpression = $this$getLeftMostReceiverExpression.getReceiverExpression();
        }
        return ktDotQualifiedExpression;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final KtExpression replaceFirstReceiver(@NotNull KtDotQualifiedExpression $this$replaceFirstReceiver, @NotNull KtPsiFactory factory2, @NotNull KtExpression newReceiver, boolean safeAccess) {
        KtExpression ktExpression;
        Intrinsics.checkNotNullParameter((Object)$this$replaceFirstReceiver, (String)"$this$replaceFirstReceiver");
        Intrinsics.checkNotNullParameter((Object)factory2, (String)"factory");
        Intrinsics.checkNotNullParameter((Object)newReceiver, (String)"newReceiver");
        if (safeAccess) {
            PsiElement psiElement2;
            void $this$replaced$iv;
            PsiElement psiElement3 = (PsiElement)$this$replaceFirstReceiver;
            Object[] objectArray = new Object[2];
            objectArray[0] = $this$replaceFirstReceiver.getReceiverExpression();
            KtExpression ktExpression2 = $this$replaceFirstReceiver.getSelectorExpression();
            Intrinsics.checkNotNull((Object)ktExpression2);
            objectArray[1] = ktExpression2;
            PsiElement newElement$iv = (PsiElement)CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)factory2, (String)"$0?.$1", (Object[])objectArray, (boolean)false, (int)4, null);
            boolean $i$f$replaced = false;
            if (Intrinsics.areEqual((Object)$this$replaced$iv, (Object)newElement$iv)) {
                psiElement2 = newElement$iv;
            } else {
                PsiElement result$iv = $this$replaced$iv.replace(newElement$iv);
                PsiElement psiElement4 = result$iv;
                if (!(psiElement4 instanceof KtExpression)) {
                    psiElement4 = null;
                }
                if ((psiElement2 = (PsiElement)((KtExpression)psiElement4)) == null) {
                    PsiElement psiElement5 = result$iv;
                    if (psiElement5 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
                    }
                    KtExpression ktExpression3 = ((KtParenthesizedExpression)psiElement5).getExpression();
                    if (ktExpression3 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
                    }
                    psiElement2 = (PsiElement)ktExpression3;
                }
            }
            ktExpression = (KtExpression)psiElement2;
        } else {
            ktExpression = (KtExpression)$this$replaceFirstReceiver;
        }
        if (ktExpression == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtQualifiedExpression");
        }
        KtQualifiedExpression replaced2 = (KtQualifiedExpression)ktExpression;
        KtExpression receiver2 = replaced2.getReceiverExpression();
        if (receiver2 instanceof KtDotQualifiedExpression) {
            ((KtDotQualifiedExpression)receiver2).replace((PsiElement)UtilsKt.replaceFirstReceiver((KtDotQualifiedExpression)receiver2, factory2, newReceiver, safeAccess));
        } else {
            receiver2.replace((PsiElement)newReceiver);
        }
        return (KtExpression)replaced2;
    }

    public static /* synthetic */ KtExpression replaceFirstReceiver$default(KtDotQualifiedExpression ktDotQualifiedExpression, KtPsiFactory ktPsiFactory, KtExpression ktExpression, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return UtilsKt.replaceFirstReceiver(ktDotQualifiedExpression, ktPsiFactory, ktExpression, bl);
    }

    @NotNull
    public static final KtExpression deleteFirstReceiver(@NotNull KtDotQualifiedExpression $this$deleteFirstReceiver) {
        Intrinsics.checkNotNullParameter((Object)$this$deleteFirstReceiver, (String)"$this$deleteFirstReceiver");
        KtExpression receiver2 = $this$deleteFirstReceiver.getReceiverExpression();
        if (receiver2 instanceof KtDotQualifiedExpression) {
            UtilsKt.deleteFirstReceiver((KtDotQualifiedExpression)receiver2);
        } else {
            KtExpression ktExpression = $this$deleteFirstReceiver.getSelectorExpression();
            if (ktExpression != null) {
                KtExpression ktExpression2;
                KtExpression it = ktExpression2 = ktExpression;
                boolean bl = false;
                PsiElement psiElement2 = $this$deleteFirstReceiver.replace((PsiElement)it);
                if (psiElement2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
                }
                return (KtExpression)psiElement2;
            }
        }
        return (KtExpression)$this$deleteFirstReceiver;
    }

    public static final boolean isArrayOfFunction(@NotNull KtCallExpression $this$isArrayOfFunction) {
        boolean bl;
        block7: {
            Intrinsics.checkNotNullParameter((Object)$this$isArrayOfFunction, (String)"$this$isArrayOfFunction");
            Object object = $this$isArrayOfFunction.getCalleeExpression();
            if (object == null || (object = object.getText()) == null) {
                return false;
            }
            Object functionName = object;
            Iterable $this$any$iv = ARRAY_OF_FUNCTION_NAMES;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Name it = (Name)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.asString(), (Object)functionName)) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        if (!bl) {
            return false;
        }
        ResolvedCall resolvedCall2 = ResolutionUtils.resolveToCall$default((KtElement)$this$isArrayOfFunction, null, 1, null);
        if (resolvedCall2 == null) {
            return false;
        }
        ResolvedCall resolvedCall3 = resolvedCall2;
        CallableDescriptor descriptor2 = resolvedCall3.getCandidateDescriptor();
        DeclarationDescriptor declarationDescriptor = descriptor2.getContainingDeclaration();
        if (!(declarationDescriptor instanceof PackageFragmentDescriptor)) {
            declarationDescriptor = null;
        }
        PackageFragmentDescriptor packageFragmentDescriptor = (PackageFragmentDescriptor)declarationDescriptor;
        return Intrinsics.areEqual((Object)(packageFragmentDescriptor != null ? packageFragmentDescriptor.getFqName() : null), (Object)StandardNames.BUILT_INS_PACKAGE_FQ_NAME) && ARRAY_OF_FUNCTION_NAMES.contains(descriptor2.getName());
    }

    @Nullable
    public static final String getParentLambdaLabelName(@NotNull KtBlockExpression $this$getParentLambdaLabelName) {
        Object v4;
        KtCallExpression callExpression2;
        block6: {
            Intrinsics.checkNotNullParameter((Object)$this$getParentLambdaLabelName, (String)"$this$getParentLambdaLabelName");
            PsiElement $this$getStrictParentOfType$iv = (PsiElement)$this$getParentLambdaLabelName;
            boolean $i$f$getStrictParentOfType = false;
            KtLambdaExpression ktLambdaExpression2 = (KtLambdaExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtLambdaExpression.class, (boolean)true);
            if (ktLambdaExpression2 == null) {
                return null;
            }
            KtLambdaExpression lambdaExpression2 = ktLambdaExpression2;
            PsiElement $this$getStrictParentOfType$iv2 = (PsiElement)lambdaExpression2;
            boolean $i$f$getStrictParentOfType2 = false;
            KtCallExpression ktCallExpression = (KtCallExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv2, KtCallExpression.class, (boolean)true);
            if (ktCallExpression == null) {
                return null;
            }
            callExpression2 = ktCallExpression;
            List list2 = callExpression2.getValueArguments();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"callExpression.valueArguments");
            Iterable iterable = $i$f$getStrictParentOfType2 = (Iterable)list2;
            for (Object t : iterable) {
                KtValueArgument it = (KtValueArgument)t;
                boolean bl = false;
                KtExpression ktExpression = it.getArgumentExpression();
                if (!((ktExpression != null ? KtElementUtilsKt.unpackFunctionLiteral((KtExpression)ktExpression, (boolean)false) : null) == lambdaExpression2)) continue;
                v4 = t;
                break block6;
            }
            v4 = null;
        }
        KtValueArgument ktValueArgument = v4;
        if (ktValueArgument == null) {
            return null;
        }
        KtValueArgument valueArgument = ktValueArgument;
        KtExpression ktExpression = valueArgument.getArgumentExpression();
        if (!(ktExpression instanceof KtLabeledExpression)) {
            ktExpression = null;
        }
        KtLabeledExpression ktLabeledExpression = (KtLabeledExpression)ktExpression;
        String lambdaLabelName = ktLabeledExpression != null ? ktLabeledExpression.getLabelName() : null;
        String string = lambdaLabelName;
        if (string == null) {
            KtSimpleNameExpression ktSimpleNameExpression = KtPsiUtilKt.getCallNameExpression((KtCallElement)((KtCallElement)callExpression2));
            string = ktSimpleNameExpression != null ? ktSimpleNameExpression.getText() : null;
        }
        return string;
    }

    @Nullable
    public static final CallableDescriptor getCallableDescriptor(@NotNull KtExpression $this$getCallableDescriptor) {
        Intrinsics.checkNotNullParameter((Object)$this$getCallableDescriptor, (String)"$this$getCallableDescriptor");
        ResolvedCall resolvedCall2 = ResolutionUtils.resolveToCall$default((KtElement)$this$getCallableDescriptor, null, 1, null);
        return resolvedCall2 != null ? resolvedCall2.getResultingDescriptor() : null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isFinalizeMethod(@NotNull KtDeclaration $this$isFinalizeMethod, @Nullable DeclarationDescriptor descriptor2) {
        DeclarationDescriptor declarationDescriptor;
        Intrinsics.checkNotNullParameter((Object)$this$isFinalizeMethod, (String)"$this$isFinalizeMethod");
        if (KtPsiUtilKt.containingClass((KtElement)((KtElement)$this$isFinalizeMethod)) == null) {
            return false;
        }
        KtDeclaration ktDeclaration = $this$isFinalizeMethod;
        if (!(ktDeclaration instanceof KtNamedFunction)) {
            ktDeclaration = null;
        }
        KtNamedFunction ktNamedFunction = (KtNamedFunction)ktDeclaration;
        if (ktNamedFunction == null) return false;
        KtNamedFunction function2 = ktNamedFunction;
        if (!Intrinsics.areEqual((Object)function2.getName(), (Object)"finalize")) return false;
        if (!function2.getValueParameters().isEmpty()) return false;
        DeclarationDescriptor declarationDescriptor2 = descriptor2;
        if (declarationDescriptor2 == null) {
            declarationDescriptor2 = declarationDescriptor = SearchHelpersKt.getDescriptor((KtDeclaration)function2);
        }
        if (!(declarationDescriptor2 instanceof FunctionDescriptor)) {
            declarationDescriptor = null;
        }
        FunctionDescriptor functionDescriptor2 = (FunctionDescriptor)declarationDescriptor;
        FunctionDescriptor functionDescriptor3 = functionDescriptor2;
        if (functionDescriptor2 == null) return false;
        KotlinType kotlinType = functionDescriptor3.getReturnType();
        functionDescriptor3 = kotlinType;
        if (kotlinType == null) return false;
        if (!TypeUtilsKt.isUnit((KotlinType)functionDescriptor3)) return false;
        return true;
    }

    public static /* synthetic */ boolean isFinalizeMethod$default(KtDeclaration ktDeclaration, DeclarationDescriptor declarationDescriptor, int n, Object object) {
        if ((n & 1) != 0) {
            declarationDescriptor = null;
        }
        return UtilsKt.isFinalizeMethod(ktDeclaration, declarationDescriptor);
    }

    public static final boolean isToString(@NotNull KtDotQualifiedExpression $this$isToString) {
        boolean bl;
        block11: {
            Intrinsics.checkNotNullParameter((Object)$this$isToString, (String)"$this$isToString");
            KtExpression ktExpression = $this$isToString.getSelectorExpression();
            if (!(ktExpression instanceof KtCallExpression)) {
                ktExpression = null;
            }
            KtCallExpression ktCallExpression = (KtCallExpression)ktExpression;
            if (ktCallExpression == null) {
                return false;
            }
            KtCallExpression callExpression2 = ktCallExpression;
            KtExpression ktExpression2 = callExpression2.getCalleeExpression();
            if (!(ktExpression2 instanceof KtNameReferenceExpression)) {
                ktExpression2 = null;
            }
            KtNameReferenceExpression ktNameReferenceExpression = (KtNameReferenceExpression)ktExpression2;
            if (ktNameReferenceExpression == null) {
                return false;
            }
            KtNameReferenceExpression referenceExpression = ktNameReferenceExpression;
            if (Intrinsics.areEqual((Object)referenceExpression.getReferencedName(), (Object)"toString") ^ true) {
                return false;
            }
            ResolvedCall<? extends CallableDescriptor> resolvedCall2 = UtilsKt.toResolvedCall((KtQualifiedExpression)$this$isToString, BodyResolveMode.PARTIAL);
            if (resolvedCall2 == null) {
                return false;
            }
            ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
            CallableDescriptor callableDescriptor = resolvedCall3.getResultingDescriptor();
            if (!(callableDescriptor instanceof CallableMemberDescriptor)) {
                callableDescriptor = null;
            }
            CallableMemberDescriptor callableMemberDescriptor = (CallableMemberDescriptor)callableDescriptor;
            if (callableMemberDescriptor == null) {
                return false;
            }
            CallableMemberDescriptor callableDescriptor2 = callableMemberDescriptor;
            Iterable $this$any$iv = org.jetbrains.kotlin.idea.core.DescriptorUtilsKt.getDeepestSuperDeclarations$default(callableDescriptor2, false, 1, null);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    CallableMemberDescriptor it = (CallableMemberDescriptor)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)DescriptorUtilsKt.getFqNameUnsafe((DeclarationDescriptor)((DeclarationDescriptor)it)).asString(), (Object)"kotlin.Any.toString")) continue;
                    bl = true;
                    break block11;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static final boolean isOperatorOrCompatible(@NotNull FunctionDescriptor $this$isOperatorOrCompatible) {
        Intrinsics.checkNotNullParameter((Object)$this$isOperatorOrCompatible, (String)"$this$isOperatorOrCompatible");
        if ($this$isOperatorOrCompatible instanceof JavaMethodDescriptor) {
            return OperatorChecks.INSTANCE.check($this$isOperatorOrCompatible).isSuccess();
        }
        return $this$isOperatorOrCompatible.isOperator();
    }

    public static final void appendSemicolonBeforeLambdaContainingElement(@NotNull KtPsiFactory $this$appendSemicolonBeforeLambdaContainingElement, @NotNull PsiElement element3) {
        Intrinsics.checkNotNullParameter((Object)$this$appendSemicolonBeforeLambdaContainingElement, (String)"$this$appendSemicolonBeforeLambdaContainingElement");
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        PsiElement previousElement2 = KtPsiUtil.skipSiblingsBackwardByPredicate((PsiElement)element3, (Predicate)appendSemicolonBeforeLambdaContainingElement.previousElement.1.INSTANCE);
        if (previousElement2 != null && previousElement2 instanceof KtExpression) {
            ((KtExpression)previousElement2).getParent().addAfter($this$appendSemicolonBeforeLambdaContainingElement.createSemicolon(), previousElement2);
        }
    }

    @Nullable
    public static final PsiElement lastWithPersistedElementOrNull(@NotNull Sequence<? extends PsiElement> $this$lastWithPersistedElementOrNull, @NotNull KtExpression elementShouldPersist) {
        Intrinsics.checkNotNullParameter($this$lastWithPersistedElementOrNull, (String)"$this$lastWithPersistedElementOrNull");
        Intrinsics.checkNotNullParameter((Object)elementShouldPersist, (String)"elementShouldPersist");
        PsiElement lastElement = null;
        boolean checked = false;
        for (PsiElement element3 : $this$lastWithPersistedElementOrNull) {
            checked = checked || element3 == elementShouldPersist;
            lastElement = element3;
        }
        return checked ? lastElement : null;
    }

    @NotNull
    public static final KotlinType reflectToRegularFunctionType(@NotNull KotlinType $this$reflectToRegularFunctionType) {
        Intrinsics.checkNotNullParameter((Object)$this$reflectToRegularFunctionType, (String)"$this$reflectToRegularFunctionType");
        boolean isTypeAnnotatedWithExtensionFunctionType = $this$reflectToRegularFunctionType.getAnnotations().findAnnotation(StandardNames.FqNames.extensionFunctionType) != null;
        int parameterCount = isTypeAnnotatedWithExtensionFunctionType ? $this$reflectToRegularFunctionType.getArguments().size() - 2 : $this$reflectToRegularFunctionType.getArguments().size() - 1;
        ClassDescriptor classDescriptor = FunctionTypesKt.isKSuspendFunctionType((KotlinType)$this$reflectToRegularFunctionType) ? TypeUtilsKt.getBuiltIns((KotlinType)$this$reflectToRegularFunctionType).getSuspendFunction(parameterCount) : TypeUtilsKt.getBuiltIns((KotlinType)$this$reflectToRegularFunctionType).getFunction(parameterCount);
        Intrinsics.checkNotNullExpressionValue((Object)classDescriptor, (String)"if (isKSuspendFunctionTy\u2026tFunction(parameterCount)");
        ClassDescriptor classDescriptor2 = classDescriptor;
        return (KotlinType)KotlinTypeFactory.simpleNotNullType((TypeAttributes)TypeAttributesKt.toDefaultAttributes((Annotations)$this$reflectToRegularFunctionType.getAnnotations()), (ClassDescriptor)classDescriptor2, (List)$this$reflectToRegularFunctionType.getArguments());
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean isReferenceToBuiltInEnumFunction(@NotNull KtElement $this$isReferenceToBuiltInEnumFunction) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isReferenceToBuiltInEnumFunction, (String)"$this$isReferenceToBuiltInEnumFunction");
        KtElement ktElement = $this$isReferenceToBuiltInEnumFunction;
        if (ktElement instanceof KtTypeReference) {
            KtExpression target2;
            PsiElement psiElement2 = ((KtTypeReference)$this$isReferenceToBuiltInEnumFunction).getParent();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"parent");
            PsiElement $this$getStrictParentOfType$iv = psiElement2;
            boolean $i$f$getStrictParentOfType2 = false;
            KtTypeArgumentList ktTypeArgumentList = (KtTypeArgumentList)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtTypeArgumentList.class, (boolean)true);
            KtExpression ktExpression = target2 = (KtExpression)PsiUtilsKt.getParentOfTypes((PsiElement)((PsiElement)(ktTypeArgumentList != null ? (KtElementImplStub)ktTypeArgumentList : (KtElementImplStub)$this$isReferenceToBuiltInEnumFunction)), (boolean)true, (Class[])new Class[]{KtCallExpression.class, KtCallableDeclaration.class});
            if (ktExpression instanceof KtCallExpression) {
                bl = FunctionUtilsKt.isCalling$default((KtCallExpression)target2, KOTLIN_BUILTIN_ENUM_FUNCTIONS, null, 2, null);
            } else if (ktExpression instanceof KtCallableDeclaration) {
                void $this$anyDescendantOfType$iv;
                PsiElement $i$f$getStrictParentOfType2 = (PsiElement)target2;
                Function1 predicate$iv = isReferenceToBuiltInEnumFunction.1.INSTANCE;
                boolean $i$f$anyDescendantOfType = false;
                void $this$findDescendantOfType$iv$iv = $this$anyDescendantOfType$iv;
                boolean $i$f$findDescendantOfType = false;
                void $this$findDescendantOfType$iv$iv$iv = $this$findDescendantOfType$iv$iv;
                boolean $i$f$findDescendantOfType2 = false;
                Ref.ObjectRef result$iv$iv$iv = new Ref.ObjectRef();
                $this$findDescendantOfType$iv$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(predicate$iv, result$iv$iv$iv){
                    final /* synthetic */ Function1 $predicate;
                    final /* synthetic */ Ref.ObjectRef $result;
                    {
                        this.$predicate = $predicate;
                        this.$result = $result;
                    }

                    public void visitElement(@NotNull PsiElement element3) {
                        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
                        if (element3 instanceof KtCallExpression && ((Boolean)this.$predicate.invoke((Object)element3)).booleanValue()) {
                            this.$result.element = element3;
                            this.stopWalking();
                            return;
                        }
                        PsiElement it = element3;
                        boolean bl = false;
                        super.visitElement(element3);
                    }
                });
                bl = (PsiElement)result$iv$iv$iv.element != null;
            } else {
                bl = false;
            }
        } else if (ktElement instanceof KtQualifiedExpression) {
            KtCallExpression ktCallExpression = UtilsKt.getCallExpression((KtQualifiedExpression)$this$isReferenceToBuiltInEnumFunction);
            bl = CollectionsKt.contains((Iterable)ENUM_STATIC_METHODS, ktCallExpression != null && (ktCallExpression = ktCallExpression.getCalleeExpression()) != null ? ktCallExpression.getText() : null);
        } else if (ktElement instanceof KtCallExpression) {
            KtExpression ktExpression = ((KtCallExpression)$this$isReferenceToBuiltInEnumFunction).getCalleeExpression();
            bl = CollectionsKt.contains((Iterable)ENUM_STATIC_METHODS, (Object)(ktExpression != null ? ktExpression.getText() : null));
        } else if (ktElement instanceof KtCallableReferenceExpression) {
            KtSimpleNameExpression ktSimpleNameExpression = ((KtCallableReferenceExpression)$this$isReferenceToBuiltInEnumFunction).getCallableReference();
            Intrinsics.checkNotNullExpressionValue((Object)ktSimpleNameExpression, (String)"this.callableReference");
            bl = ENUM_STATIC_METHODS.contains(ktSimpleNameExpression.getText());
        } else {
            bl = false;
        }
        return bl;
    }

    public static final boolean isInvokeOperator(@NotNull CallableDescriptor $this$isInvokeOperator) {
        Intrinsics.checkNotNullParameter((Object)$this$isInvokeOperator, (String)"$this$isInvokeOperator");
        return $this$isInvokeOperator instanceof FunctionDescriptor && !($this$isInvokeOperator instanceof FunctionInvokeDescriptor) && ((FunctionDescriptor)$this$isInvokeOperator).isOperator() && Intrinsics.areEqual((Object)((FunctionDescriptor)$this$isInvokeOperator).getName(), (Object)OperatorNameConventions.INVOKE);
    }

    public static final boolean canBeReplacedWithInvokeCall(@NotNull KtCallExpression $this$canBeReplacedWithInvokeCall) {
        Intrinsics.checkNotNullParameter((Object)$this$canBeReplacedWithInvokeCall, (String)"$this$canBeReplacedWithInvokeCall");
        ResolvedCall resolvedCall2 = ResolutionUtils.resolveToCall$default((KtElement)$this$canBeReplacedWithInvokeCall, null, 1, null);
        return resolvedCall2 != null && UtilsKt.canBeReplacedWithInvokeCall((ResolvedCall<? extends CallableDescriptor>)resolvedCall2);
    }

    public static final boolean canBeReplacedWithInvokeCall(@NotNull ResolvedCall<? extends CallableDescriptor> $this$canBeReplacedWithInvokeCall) {
        Intrinsics.checkNotNullParameter($this$canBeReplacedWithInvokeCall, (String)"$this$canBeReplacedWithInvokeCall");
        CallableDescriptor callableDescriptor = $this$canBeReplacedWithInvokeCall.getResultingDescriptor();
        if (!(callableDescriptor instanceof SimpleFunctionDescriptor)) {
            callableDescriptor = null;
        }
        SimpleFunctionDescriptor simpleFunctionDescriptor = (SimpleFunctionDescriptor)callableDescriptor;
        if (simpleFunctionDescriptor == null) {
            return false;
        }
        SimpleFunctionDescriptor descriptor2 = simpleFunctionDescriptor;
        return (descriptor2 instanceof FunctionInvokeDescriptor || UtilsKt.isInvokeOperator((CallableDescriptor)descriptor2)) && !DescriptorUtilsKt.isExtension((DeclarationDescriptor)((DeclarationDescriptor)descriptor2));
    }

    @Nullable
    public static final KotlinType receiverType(@NotNull CallableDescriptor $this$receiverType) {
        Intrinsics.checkNotNullParameter((Object)$this$receiverType, (String)"$this$receiverType");
        ReceiverParameterDescriptor receiverParameterDescriptor = $this$receiverType.getDispatchReceiverParameter();
        if (receiverParameterDescriptor == null) {
            receiverParameterDescriptor = $this$receiverType.getExtensionReceiverParameter();
        }
        return receiverParameterDescriptor != null ? receiverParameterDescriptor.getType() : null;
    }

    public static final void appendCallOrQualifiedExpression(@NotNull BuilderByPattern<KtExpression> $this$appendCallOrQualifiedExpression, @NotNull KtCallExpression call, @NotNull String newFunctionName) {
        block4: {
            KtValueArgumentList it;
            KtValueArgumentList ktValueArgumentList;
            KtExpression callOrQualified;
            Intrinsics.checkNotNullParameter($this$appendCallOrQualifiedExpression, (String)"$this$appendCallOrQualifiedExpression");
            Intrinsics.checkNotNullParameter((Object)call, (String)"call");
            Intrinsics.checkNotNullParameter((Object)newFunctionName, (String)"newFunctionName");
            KtQualifiedExpression ktQualifiedExpression = KtPsiUtilKt.getQualifiedExpressionForSelector((KtElement)((KtElement)call));
            KtExpression ktExpression = callOrQualified = ktQualifiedExpression != null ? (KtExpression)ktQualifiedExpression : (KtExpression)call;
            if (callOrQualified instanceof KtQualifiedExpression) {
                $this$appendCallOrQualifiedExpression.appendExpression(((KtQualifiedExpression)callOrQualified).getReceiverExpression());
                if (callOrQualified instanceof KtSafeQualifiedExpression) {
                    $this$appendCallOrQualifiedExpression.appendFixedText("?");
                }
                $this$appendCallOrQualifiedExpression.appendFixedText(".");
            }
            $this$appendCallOrQualifiedExpression.appendNonFormattedText(newFunctionName);
            KtValueArgumentList ktValueArgumentList2 = call.getValueArgumentList();
            if (ktValueArgumentList2 != null) {
                it = ktValueArgumentList = ktValueArgumentList2;
                boolean bl = false;
                KtValueArgumentList ktValueArgumentList3 = it;
                Intrinsics.checkNotNullExpressionValue((Object)ktValueArgumentList3, (String)"it");
                String string = ktValueArgumentList3.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.text");
                $this$appendCallOrQualifiedExpression.appendNonFormattedText(string);
            }
            List list2 = call.getLambdaArguments();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"call.lambdaArguments");
            KtLambdaArgument ktLambdaArgument = (KtLambdaArgument)CollectionsKt.firstOrNull((List)list2);
            if (ktLambdaArgument == null) break block4;
            it = ktValueArgumentList = ktLambdaArgument;
            boolean bl = false;
            if (it.getArgumentExpression() instanceof KtLabeledExpression) {
                $this$appendCallOrQualifiedExpression.appendFixedText(" ");
            }
            String string = it.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.text");
            $this$appendCallOrQualifiedExpression.appendNonFormattedText(string);
        }
    }

    @Nullable
    public static final KtLambdaExpression singleLambdaArgumentExpression(@NotNull KtCallExpression $this$singleLambdaArgumentExpression) {
        Intrinsics.checkNotNullParameter((Object)$this$singleLambdaArgumentExpression, (String)"$this$singleLambdaArgumentExpression");
        List list2 = $this$singleLambdaArgumentExpression.getLambdaArguments();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"lambdaArguments");
        KtLambdaArgument ktLambdaArgument = (KtLambdaArgument)CollectionsKt.singleOrNull((List)list2);
        if (ktLambdaArgument == null || (ktLambdaArgument = ktLambdaArgument.getArgumentExpression()) == null || (ktLambdaArgument = KtElementUtilsKt.unpackFunctionLiteral$default((KtExpression)ktLambdaArgument, (boolean)false, (int)1, null)) == null) {
            ktLambdaArgument = PsiModificationUtilsKt.getLastLambdaExpression($this$singleLambdaArgumentExpression);
        }
        return ktLambdaArgument;
    }

    public static final boolean isRange(@NotNull ClassDescriptor $this$isRange) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)$this$isRange, (String)"$this$isRange");
            Iterable $this$any$iv = rangeTypes;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)DescriptorUtilsKt.getFqNameUnsafe((DeclarationDescriptor)((DeclarationDescriptor)$this$isRange)).asString(), (Object)it)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    static {
        Set set2 = SetsKt.plus((Set)SetsKt.setOf((Object)ArrayFqNames.INSTANCE.getARRAY_OF_FUNCTION()), (Iterable)CollectionsKt.toSet((Iterable)ArrayFqNames.INSTANCE.getPRIMITIVE_TYPE_TO_ARRAY().values()));
        Name name2 = Name.identifier((String)"emptyArray");
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"Name.identifier(\"emptyArray\")");
        ARRAY_OF_FUNCTION_NAMES = SetsKt.plus((Set)set2, (Object)name2);
        KOTLIN_BUILTIN_ENUM_FUNCTIONS = CollectionsKt.listOf((Object[])new FqName[]{new FqName("kotlin.enumValues"), new FqName("kotlin.enumValueOf")});
        ENUM_STATIC_METHODS = CollectionsKt.listOf((Object[])new String[]{"values", "valueOf"});
        rangeTypes = SetsKt.setOf((Object[])new String[]{"kotlin.ranges.IntRange", "kotlin.ranges.CharRange", "kotlin.ranges.LongRange", "kotlin.ranges.UIntRange", "kotlin.ranges.ULongRange"});
    }

    public static final /* synthetic */ List access$getKOTLIN_BUILTIN_ENUM_FUNCTIONS$p() {
        return KOTLIN_BUILTIN_ENUM_FUNCTIONS;
    }
}

