/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.lang.ElementsHandler;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import java.util.Collection;
import java.util.HashSet;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u00012\u00020\u0002B!\u0012\b\b\u0001\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0007J+\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0096\u0002J9\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00a4\u0002J0\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u000e\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00180\u00172\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0096\u0002\u00a2\u0006\u0002\u0010\u0019J\u001d\u0010\u001a\u001a\u00020\u001b2\u000e\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00180\u0017H\u0016\u00a2\u0006\u0002\u0010\u001cJ\u001a\u0010\u001d\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0004J\u001a\u0010\u001e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002J\u000e\u0010\u001f\u001a\u0004\u0018\u00010\u0013*\u00020 H\u0002R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/AbstractPullPushMembersHandler;", "Lcom/intellij/refactoring/RefactoringActionHandler;", "Lcom/intellij/refactoring/lang/ElementsHandler;", "refactoringName", "", "helpId", "wrongPositionMessage", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "classOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "member", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "elements", "", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/openapi/project/Project;[Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/actionSystem/DataContext;)V", "isEnabledOnElements", "", "([Lcom/intellij/psi/PsiElement;)Z", "reportWrongContext", "reportWrongPosition", "getContainingClass", "Lorg/jetbrains/kotlin/psi/KtParameter;", "kotlin.idea"})
public abstract class AbstractPullPushMembersHandler
implements RefactoringActionHandler,
ElementsHandler {
    private final String refactoringName;
    private final String helpId;
    private final String wrongPositionMessage;

    private final void reportWrongPosition(Project project2, Editor editor2) {
        String message2 = RefactoringBundle.getCannotRefactorMessage((String)this.wrongPositionMessage);
        CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor2, (String)message2, (String)this.refactoringName, (String)this.helpId);
    }

    private final KtClassOrObject getContainingClass(KtParameter $this$getContainingClass) {
        Object object;
        if ($this$getContainingClass.hasValOrVar()) {
            KtDeclarationWithBody ktDeclarationWithBody = $this$getContainingClass.getOwnerFunction();
            if (!(ktDeclarationWithBody instanceof KtPrimaryConstructor)) {
                ktDeclarationWithBody = null;
            }
            KtPrimaryConstructor ktPrimaryConstructor = (KtPrimaryConstructor)ktDeclarationWithBody;
            object = ktPrimaryConstructor != null ? KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)((KtDeclaration)ktPrimaryConstructor)) : null;
        } else {
            object = null;
        }
        return object;
    }

    protected final void reportWrongContext(@NotNull Project project2, @Nullable Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        String message2 = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"is.not.supported.in.the.current.context", (Object[])new Object[]{this.refactoringName}));
        CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor2, (String)message2, (String)this.refactoringName, (String)this.helpId);
    }

    protected abstract void invoke(@NotNull Project var1, @Nullable Editor var2, @Nullable KtClassOrObject var3, @Nullable KtNamedDeclaration var4, @Nullable DataContext var5);

    public void invoke(@NotNull Project project2, @NotNull Editor editor2, @NotNull PsiFile file2, @Nullable DataContext dataContext) {
        Object v2;
        block4: {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            CaretModel caretModel = editor2.getCaretModel();
            Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"editor.caretModel");
            int offset2 = caretModel.getOffset();
            editor2.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
            PsiElement psiElement2 = file2.findElementAt(offset2);
            if (psiElement2 == null) {
                return;
            }
            Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"(file.findElementAt(offset) ?: return)");
            Sequence $this$firstOrNull$iv = PsiUtilsKt.getParentsWithSelf((PsiElement)psiElement2);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PsiElement it = (PsiElement)element$iv;
                boolean bl = false;
                if (!(it instanceof KtClassOrObject || (it instanceof KtNamedFunction || it instanceof KtProperty) && it.getParent() instanceof KtClassBody || it instanceof KtParameter && ((KtParameter)it).hasValOrVar() && ((KtParameter)it).getOwnerFunction() instanceof KtPrimaryConstructor)) continue;
                v2 = element$iv;
                break block4;
            }
            v2 = null;
        }
        PsiElement target2 = v2;
        if (target2 == null) {
            this.reportWrongPosition(project2, editor2);
            return;
        }
        if (!KotlinRefactoringUtilKt.canRefactor(target2)) {
            return;
        }
        this.invoke(project2, new PsiElement[]{target2}, dataContext);
    }

    /*
     * WARNING - void declaration
     */
    public void invoke(@NotNull Project project2, @NotNull PsiElement[] elements2, @Nullable DataContext dataContext) {
        void classOrObject;
        Pair pair;
        Editor editor2;
        DataContext dataContext2;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)elements2, (String)"elements");
        PsiElement psiElement2 = (PsiElement)ArraysKt.singleOrNull((Object[])elements2);
        if (psiElement2 == null) {
            return;
        }
        PsiElement element3 = psiElement2;
        DataContext dataContext3 = dataContext;
        if (dataContext3 != null) {
            DataContext it = dataContext2 = dataContext3;
            boolean bl = false;
            editor2 = (Editor)CommonDataKeys.EDITOR.getData(it);
        } else {
            editor2 = null;
        }
        Editor editor3 = editor2;
        PsiElement psiElement3 = element3;
        if (psiElement3 instanceof KtNamedFunction || psiElement3 instanceof KtProperty) {
            PsiElement $this$getStrictParentOfType$iv = element3;
            boolean $i$f$getStrictParentOfType = false;
            pair = TuplesKt.to((Object)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtClassOrObject.class, (boolean)true), (Object)((KtNamedDeclaration)element3));
        } else if (psiElement3 instanceof KtParameter) {
            pair = TuplesKt.to((Object)this.getContainingClass((KtParameter)element3), (Object)element3);
        } else if (psiElement3 instanceof KtClassOrObject) {
            pair = TuplesKt.to((Object)element3, null);
        } else {
            this.reportWrongPosition(project2, editor3);
            return;
        }
        Pair pair2 = pair;
        dataContext2 = (KtClassOrObject)pair2.component1();
        KtNamedDeclaration member = (KtNamedDeclaration)pair2.component2();
        this.invoke(project2, editor3, (KtClassOrObject)classOrObject, member, dataContext);
    }

    /*
     * WARNING - void declaration
     */
    public boolean isEnabledOnElements(@NotNull PsiElement[] elements2) {
        void var3_3;
        void $this$mapTo$iv;
        Intrinsics.checkNotNullParameter((Object)elements2, (String)"elements");
        PsiElement[] psiElementArray = elements2;
        Collection destination$iv = new HashSet();
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv).length;
        for (int i = 0; i < n; ++i) {
            Object object;
            void it;
            void item$iv;
            void var8_8 = item$iv = $this$mapTo$iv[i];
            Collection collection = destination$iv;
            boolean bl = false;
            void var10_10 = it;
            if (var10_10 instanceof KtNamedFunction || var10_10 instanceof KtProperty) {
                PsiElement psiElement2 = it.getParent();
                if (!(psiElement2 instanceof KtClassBody)) {
                    psiElement2 = null;
                }
                KtClassBody ktClassBody = (KtClassBody)psiElement2;
                Object object2 = ktClassBody != null ? ktClassBody.getParent() : null;
                if (!(object2 instanceof KtClassOrObject)) {
                    object2 = null;
                }
                object = (KtClassOrObject)object2;
            } else {
                object = var10_10 instanceof KtParameter ? this.getContainingClass((KtParameter)it) : (var10_10 instanceof KtClassOrObject ? (KtClassOrObject)it : null);
            }
            if (object == null) {
                return false;
            }
            KtClassOrObject ktClassOrObject = object;
            collection.add(ktClassOrObject);
        }
        return ((HashSet)var3_3).size() == 1;
    }

    public AbstractPullPushMembersHandler(@Nls @NotNull String refactoringName, @NotNull String helpId, @NlsContexts.DialogMessage @NotNull String wrongPositionMessage) {
        Intrinsics.checkNotNullParameter((Object)refactoringName, (String)"refactoringName");
        Intrinsics.checkNotNullParameter((Object)helpId, (String)"helpId");
        Intrinsics.checkNotNullParameter((Object)wrongPositionMessage, (String)"wrongPositionMessage");
        this.refactoringName = refactoringName;
        this.helpId = helpId;
        this.wrongPositionMessage = wrongPositionMessage;
    }
}

