/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.inline;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiReference;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.inline.InlineOptionsDialog;
import com.intellij.usageView.UsageViewTypeLocation;
import javax.swing.JRadioButton;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KMutableProperty1;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringSettings;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000b\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B!\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\b\u0010%\u001a\u00020\u0012H\u0014J\b\u0010&\u001a\u00020\u0012H\u0014J\b\u0010'\u001a\u00020(H&J\u0006\u0010)\u001a\u00020*J\b\u0010+\u001a\u00020\u0018H\u0014J\b\u0010,\u001a\u00020\u0018H\u0014J\u0010\u0010-\u001a\u00020\u00182\u0006\u0010.\u001a\u00020\u0018H\u0003J\b\u0010/\u001a\u00020\u0018H\u0014J\n\u00100\u001a\u0004\u0018\u00010\u0018H\u0014J\b\u00101\u001a\u00020\u0018H\u0014J\b\u00102\u001a\u00020\u0012H\u0004J\b\u00103\u001a\u00020\u0012H\u0004J\b\u00104\u001a\u00020*H\u0002R\u0016\u0010\u0004\u001a\u00028\u0000X\u0084\u0004\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001e\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u001e\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0014R\u0014\u0010\u0017\u001a\u00020\u00188BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u001cX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0016\u0010\u001f\u001a\u0004\u0018\u00010\u00188BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u001aR\u0014\u0010!\u001a\u00020\u00188BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u001aR\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$\u00a8\u00065"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/inline/AbstractKotlinInlineDialog;", "TDeclaration", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "Lcom/intellij/refactoring/inline/InlineOptionsDialog;", "declaration", "reference", "Lcom/intellij/psi/PsiReference;", "editor", "Lcom/intellij/openapi/editor/Editor;", "(Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;Lcom/intellij/psi/PsiReference;Lcom/intellij/openapi/editor/Editor;)V", "getDeclaration", "()Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "inlineKeepOption", "Lkotlin/reflect/KMutableProperty1;", "Lorg/jetbrains/kotlin/idea/refactoring/KotlinRefactoringSettings;", "", "getInlineKeepOption", "()Lkotlin/reflect/KMutableProperty1;", "inlineThisOption", "getInlineThisOption", "kind", "", "getKind", "()Ljava/lang/String;", "occurrencesNumber", "", "getOccurrencesNumber", "()I", "occurrencesString", "getOccurrencesString", "refactoringName", "getRefactoringName", "getReference", "()Lcom/intellij/psi/PsiReference;", "allowInlineAll", "canInlineThisOnly", "createProcessor", "Lcom/intellij/refactoring/BaseRefactoringProcessor;", "doAction", "", "getBorderTitle", "getInlineAllText", "getInlineText", "verb", "getInlineThisText", "getKeepTheDeclarationText", "getNameLabelText", "isInlineThis", "isKeepTheDeclarationByDefault", "saveSettings", "kotlin.idea"})
public abstract class AbstractKotlinInlineDialog<TDeclaration extends KtNamedDeclaration>
extends InlineOptionsDialog {
    private final int occurrencesNumber;
    @NotNull
    private final TDeclaration declaration;
    @Nullable
    private final PsiReference reference;
    @Nullable
    private final Editor editor;

    protected final boolean isKeepTheDeclarationByDefault() {
        return (Boolean)this.getInlineKeepOption().get((Object)KotlinRefactoringSettings.Companion.getInstance());
    }

    protected final boolean isInlineThis() {
        return (Boolean)this.getInlineThisOption().get((Object)KotlinRefactoringSettings.Companion.getInstance());
    }

    public final void doAction() {
        this.invokeRefactoring(this.createProcessor());
        this.saveSettings();
    }

    private final void saveSettings() {
        KotlinRefactoringSettings settings2 = KotlinRefactoringSettings.Companion.getInstance();
        JRadioButton jRadioButton = this.myRbInlineThisOnly;
        Intrinsics.checkNotNullExpressionValue((Object)jRadioButton, (String)"myRbInlineThisOnly");
        if (jRadioButton.isEnabled()) {
            JRadioButton jRadioButton2 = this.myRbInlineAll;
            Intrinsics.checkNotNullExpressionValue((Object)jRadioButton2, (String)"myRbInlineAll");
            if (jRadioButton2.isEnabled()) {
                this.getInlineThisOption().set((Object)settings2, (Object)this.isInlineThisOnly());
            }
        }
        JRadioButton jRadioButton3 = this.myKeepTheDeclaration;
        if (jRadioButton3 != null) {
            if (jRadioButton3.isEnabled()) {
                this.getInlineKeepOption().set((Object)settings2, (Object)this.isKeepTheDeclaration());
            }
        }
    }

    @NotNull
    public abstract KMutableProperty1<KotlinRefactoringSettings, Boolean> getInlineThisOption();

    @NotNull
    public abstract KMutableProperty1<KotlinRefactoringSettings, Boolean> getInlineKeepOption();

    @NotNull
    public abstract BaseRefactoringProcessor createProcessor();

    protected final int getOccurrencesNumber() {
        return this.occurrencesNumber;
    }

    private final String getOccurrencesString() {
        return this.occurrencesNumber >= 0 ? this.occurrencesNumber + " " + StringUtil.pluralize((String)"occurrence", (int)this.occurrencesNumber) : null;
    }

    private final String getKind() {
        String string = ElementDescriptionUtil.getElementDescription((PsiElement)((PsiElement)this.declaration), (ElementDescriptionLocation)((ElementDescriptionLocation)UsageViewTypeLocation.INSTANCE));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ElementDescriptionUtil.g\u2026iewTypeLocation.INSTANCE)");
        return string;
    }

    private final String getRefactoringName() {
        Object[] objectArray = new Object[1];
        String string = StringUtil.capitalizeWords((String)this.getKind(), (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringUtil.capitalizeWords(kind, true)");
        objectArray[0] = string;
        return KotlinBundle.message("text.inline.0", objectArray);
    }

    protected boolean canInlineThisOnly() {
        return false;
    }

    protected boolean allowInlineAll() {
        return true;
    }

    @NotNull
    protected String getBorderTitle() {
        return this.getRefactoringName();
    }

    @NotNull
    protected String getNameLabelText() {
        Object object;
        block3: {
            block2: {
                String string;
                object = this.getOccurrencesString();
                if (object == null) break block2;
                String it = string = object;
                boolean bl = false;
                object = " - " + it;
                if (object != null) break block3;
            }
            object = "";
        }
        String occurrencesString = object;
        return StringsKt.capitalize((String)this.getKind()) + " " + this.declaration.getNameAsSafeName() + " " + occurrencesString;
    }

    /*
     * WARNING - void declaration
     */
    @Nls
    private final String getInlineText(String verb) {
        Object object;
        Object[] objectArray;
        String string;
        block3: {
            block2: {
                void it;
                String string2;
                string = "text.inline.all.references.and.verb.0.the.kind.1.occurrences.2";
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = verb;
                objectArray2[1] = this.getKind();
                Object[] objectArray3 = objectArray2;
                objectArray = objectArray2;
                int n = 2;
                object = this.getOccurrencesString();
                if (object == null) break block2;
                String string3 = string2 = object;
                int n2 = n;
                Object[] objectArray4 = objectArray3;
                Object[] objectArray5 = objectArray;
                String string4 = string;
                boolean bl = false;
                String string5 = "(" + (String)it + ")";
                string = string4;
                objectArray = objectArray5;
                objectArray3 = objectArray4;
                n = n2;
                object = string5;
                if (object != null) break block3;
            }
            object = "";
        }
        objectArray3[n] = object;
        return KotlinBundle.message(string, objectArray);
    }

    @NotNull
    protected String getInlineAllText() {
        String string;
        if (this.declaration.isWritable()) {
            string = this.getInlineText(KotlinBundle.message("text.remove", new Object[0]));
        } else {
            String string2 = RefactoringBundle.message((String)"all.invocations.in.project");
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"RefactoringBundle.messag\u2026.invocations.in.project\")");
        }
        return string;
    }

    @Nullable
    protected String getKeepTheDeclarationText() {
        return this.declaration.isWritable() && (this.occurrencesNumber > 1 || !this.myInvokedOnReference) ? this.getInlineText(KotlinBundle.message("text.keep", new Object[0])) : null;
    }

    @NotNull
    protected String getInlineThisText() {
        return KotlinBundle.message("text.inline.this.reference.and.keep.the.0", this.getKind());
    }

    @NotNull
    protected final TDeclaration getDeclaration() {
        return this.declaration;
    }

    @Nullable
    protected final PsiReference getReference() {
        return this.reference;
    }

    @Nullable
    protected final Editor getEditor() {
        return this.editor;
    }

    public AbstractKotlinInlineDialog(@NotNull TDeclaration declaration2, @Nullable PsiReference reference2, @Nullable Editor editor2) {
        Intrinsics.checkNotNullParameter(declaration2, (String)"declaration");
        super(declaration2.getProject(), true, (PsiElement)declaration2);
        this.declaration = declaration2;
        this.reference = reference2;
        this.editor = editor2;
        this.occurrencesNumber = AbstractKotlinInlineDialog.access$initOccurrencesNumber$s759928653((PsiNameIdentifierOwner)this.declaration);
        this.myInvokedOnReference = this.reference != null;
        this.setTitle(this.getRefactoringName());
    }

    public static final /* synthetic */ int access$initOccurrencesNumber$s759928653(PsiNameIdentifierOwner p0) {
        return InlineOptionsDialog.initOccurrencesNumber((PsiNameIdentifierOwner)p0);
    }
}

