/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.introduce.extractFunction.ui;

import com.intellij.DynamicBundle;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.refactoring.ui.NameSuggestionsField;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.TitledSeparator;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.MultiMap;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractFunction.ui.ExtractFunctionParameterTablePanel;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine.ExtractableAnalysisUtilKt;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine.ExtractableCodeDescriptor;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine.ExtractableCodeDescriptorKt;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine.ExtractableCodeDescriptorWithConflicts;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine.ExtractableCodeDescriptorWithException;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine.ExtractionGeneratorConfiguration;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine.ExtractionGeneratorOptions;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine.ExtractorUtilKt;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine.Parameter;
import org.jetbrains.kotlin.idea.refactoring.introduce.ui.KotlinSignatureComponent;
import org.jetbrains.kotlin.idea.util.IdeDescriptorRenderers;
import org.jetbrains.kotlin.idea.util.NonblockingKt;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.types.KotlinType;

public class KotlinExtractFunctionDialog
extends DialogWrapper {
    private JPanel contentPane;
    private TitledSeparator inputParametersPanel;
    private JComboBox visibilityBox;
    private KotlinSignatureComponent signaturePreviewField;
    private JPanel functionNamePanel;
    private NameSuggestionsField functionNameField;
    private JLabel functionNameLabel;
    private JComboBox<KotlinType> returnTypeBox;
    private JPanel returnTypePanel;
    private ExtractFunctionParameterTablePanel parameterTablePanel;
    private final Project project;
    private final ExtractableCodeDescriptorWithConflicts originalDescriptor;
    private ExtractableCodeDescriptor currentDescriptor;
    private final Function1<KotlinExtractFunctionDialog, Unit> onAccept;

    public KotlinExtractFunctionDialog(@NotNull Project project2, @NotNull ExtractableCodeDescriptorWithConflicts originalDescriptor, @NotNull Function1<KotlinExtractFunctionDialog, Unit> onAccept) {
        if (project2 == null) {
            KotlinExtractFunctionDialog.$$$reportNull$$$0(0);
        }
        if (originalDescriptor == null) {
            KotlinExtractFunctionDialog.$$$reportNull$$$0(1);
        }
        if (onAccept == null) {
            KotlinExtractFunctionDialog.$$$reportNull$$$0(2);
        }
        super(project2, true);
        this.project = project2;
        this.originalDescriptor = originalDescriptor;
        this.$$$setupUI$$$();
        this.currentDescriptor = originalDescriptor.getDescriptor();
        this.onAccept = onAccept;
        this.setModal(true);
        this.setTitle(KotlinBundle.message("extract.function", new Object[0]));
        this.init();
        this.update();
    }

    private void createUIComponents() {
        this.signaturePreviewField = new KotlinSignatureComponent("", this.project);
    }

    private boolean isVisibilitySectionAvailable() {
        return ExtractableAnalysisUtilKt.isVisibilityApplicable(this.originalDescriptor.getDescriptor().getExtractionData());
    }

    private String getFunctionName() {
        return KtPsiUtilKt.quoteIfNeeded((String)this.functionNameField.getEnteredName());
    }

    @Nullable
    private KtModifierKeywordToken getVisibility() {
        if (!this.isVisibilitySectionAvailable()) {
            return null;
        }
        KtModifierKeywordToken value2 = (KtModifierKeywordToken)this.visibilityBox.getSelectedItem();
        return KtTokens.DEFAULT_VISIBILITY_KEYWORD.equals(value2) ? null : value2;
    }

    private boolean checkNames() {
        if (!KtPsiUtilKt.isIdentifier((String)this.getFunctionName())) {
            return false;
        }
        for (ExtractFunctionParameterTablePanel.ParameterInfo parameterInfo : this.parameterTablePanel.getSelectedParameterInfos()) {
            if (KtPsiUtilKt.isIdentifier((String)parameterInfo.getName())) continue;
            return false;
        }
        return true;
    }

    private void update() {
        this.currentDescriptor = this.createDescriptor();
        this.setOKActionEnabled(this.checkNames());
        this.signaturePreviewField.setText(ExtractorUtilKt.getSignaturePreview(this.getCurrentConfiguration(), IdeDescriptorRenderers.SOURCE_CODE_SHORT_NAMES_NO_ANNOTATIONS));
    }

    protected void init() {
        super.init();
        ExtractableCodeDescriptor extractableCodeDescriptor = this.originalDescriptor.getDescriptor();
        this.functionNameField = new NameSuggestionsField(ArrayUtil.toStringArray(extractableCodeDescriptor.getSuggestedNames()), this.project, (FileType)KotlinFileType.INSTANCE);
        this.functionNameField.addDataChangedListener(() -> this.update());
        this.functionNamePanel.add((Component)this.functionNameField, "Center");
        this.functionNameLabel.setLabelFor((Component)this.functionNameField);
        List<KotlinType> possibleReturnTypes = ExtractableCodeDescriptorKt.getPossibleReturnTypes(extractableCodeDescriptor.getControlFlow());
        if (possibleReturnTypes.size() > 1) {
            DefaultComboBoxModel<KotlinType> returnTypeBoxModel = new DefaultComboBoxModel<KotlinType>(possibleReturnTypes.toArray(new KotlinType[0]));
            this.returnTypeBox.setModel(returnTypeBoxModel);
            this.returnTypeBox.setRenderer(new DefaultListCellRenderer(){

                @Override
                @NotNull
                public Component getListCellRendererComponent(JList list2, Object value2, int index2, boolean isSelected, boolean cellHasFocus) {
                    super.getListCellRendererComponent((JList<?>)list2, value2, index2, isSelected, cellHasFocus);
                    @NlsSafe String text2 = IdeDescriptorRenderers.SOURCE_CODE_SHORT_NAMES_NO_ANNOTATIONS.renderType((KotlinType)value2);
                    this.setText(text2);
                    1 v0 = this;
                    if (v0 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return v0;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/refactoring/introduce/extractFunction/ui/KotlinExtractFunctionDialog$1", "getListCellRendererComponent"));
                }
            });
            this.returnTypeBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(@NotNull ItemEvent e) {
                    if (e == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    KotlinExtractFunctionDialog.this.update();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/kotlin/idea/refactoring/introduce/extractFunction/ui/KotlinExtractFunctionDialog$2", "itemStateChanged"));
                }
            });
        } else {
            this.returnTypePanel.getParent().remove(this.returnTypePanel);
        }
        this.visibilityBox.setModel(new DefaultComboBoxModel<IElementType>(KtTokens.VISIBILITY_MODIFIERS.getTypes()));
        boolean enableVisibility = this.isVisibilitySectionAvailable();
        this.visibilityBox.setEnabled(enableVisibility);
        if (enableVisibility) {
            KtModifierKeywordToken defaultVisibility = extractableCodeDescriptor.getVisibility();
            this.visibilityBox.setSelectedItem(defaultVisibility);
        }
        this.visibilityBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(@NotNull ItemEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                KotlinExtractFunctionDialog.this.update();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/kotlin/idea/refactoring/introduce/extractFunction/ui/KotlinExtractFunctionDialog$3", "itemStateChanged"));
            }
        });
        this.parameterTablePanel = new ExtractFunctionParameterTablePanel(){

            @Override
            protected void updateSignature() {
                KotlinExtractFunctionDialog.this.update();
            }

            @Override
            protected void onEnterAction() {
                KotlinExtractFunctionDialog.this.doOKAction();
            }

            @Override
            protected void onCancelAction() {
                KotlinExtractFunctionDialog.this.doCancelAction();
            }
        };
        this.parameterTablePanel.init(extractableCodeDescriptor.getReceiverParameter(), extractableCodeDescriptor.getParameters());
        this.inputParametersPanel.setText(KotlinBundle.message("text.parameters", new Object[0]));
        this.inputParametersPanel.setLabelFor((Component)this.parameterTablePanel.getTable());
        this.inputParametersPanel.add((Component)this.parameterTablePanel);
    }

    protected void doOKAction() {
        NonblockingKt.nonBlocking(this.project, () -> {
            try {
                return ExtractableAnalysisUtilKt.validate(this.currentDescriptor);
            }
            catch (RuntimeException e) {
                return new ExtractableCodeDescriptorWithException(e);
            }
        }, result2 -> {
            if (result2 instanceof ExtractableCodeDescriptorWithException) {
                throw ((ExtractableCodeDescriptorWithException)result2).getException();
            }
            MultiMap<PsiElement, String> conflicts2 = ((ExtractableCodeDescriptorWithConflicts)result2).getConflicts();
            conflicts2.values().removeAll(this.originalDescriptor.getConflicts().values());
            KotlinRefactoringUtilKt.checkConflictsInteractively(this.project, conflicts2, new Function0<Unit>(){

                public Unit invoke() {
                    KotlinExtractFunctionDialog.this.close(0);
                    return Unit.INSTANCE;
                }
            }, new Function0<Unit>(){

                public Unit invoke() {
                    KotlinExtractFunctionDialog.super.doOKAction();
                    return (Unit)KotlinExtractFunctionDialog.this.onAccept.invoke((Object)KotlinExtractFunctionDialog.this);
                }
            });
            return Unit.INSTANCE;
        });
    }

    public JComponent getPreferredFocusedComponent() {
        return this.functionNameField.getFocusableComponent();
    }

    protected JComponent createCenterPanel() {
        return this.contentPane;
    }

    @NotNull
    protected JComponent createContentPane() {
        JPanel jPanel2 = this.contentPane;
        if (jPanel2 == null) {
            KotlinExtractFunctionDialog.$$$reportNull$$$0(3);
        }
        return jPanel2;
    }

    @NotNull
    private ExtractableCodeDescriptor createDescriptor() {
        ExtractableCodeDescriptor extractableCodeDescriptor = KotlinExtractFunctionDialog.createNewDescriptor(this.originalDescriptor.getDescriptor(), this.getFunctionName(), this.getVisibility(), this.parameterTablePanel.getSelectedReceiverInfo(), this.parameterTablePanel.getSelectedParameterInfos(), (KotlinType)this.returnTypeBox.getSelectedItem());
        if (extractableCodeDescriptor == null) {
            KotlinExtractFunctionDialog.$$$reportNull$$$0(4);
        }
        return extractableCodeDescriptor;
    }

    @NotNull
    public ExtractionGeneratorConfiguration getCurrentConfiguration() {
        return new ExtractionGeneratorConfiguration(this.currentDescriptor, ExtractionGeneratorOptions.DEFAULT);
    }

    public static ExtractableCodeDescriptor createNewDescriptor(@NotNull ExtractableCodeDescriptor originalDescriptor, @NotNull String newName2, @Nullable KtModifierKeywordToken newVisibility, @Nullable ExtractFunctionParameterTablePanel.ParameterInfo newReceiverInfo, @NotNull List<ExtractFunctionParameterTablePanel.ParameterInfo> newParameterInfos, @Nullable KotlinType returnType2) {
        Parameter newReceiver;
        if (originalDescriptor == null) {
            KotlinExtractFunctionDialog.$$$reportNull$$$0(5);
        }
        if (newName2 == null) {
            KotlinExtractFunctionDialog.$$$reportNull$$$0(6);
        }
        if (newParameterInfos == null) {
            KotlinExtractFunctionDialog.$$$reportNull$$$0(7);
        }
        LinkedHashMap<Parameter, Parameter> oldToNewParameters = new LinkedHashMap<Parameter, Parameter>();
        for (ExtractFunctionParameterTablePanel.ParameterInfo parameterInfo : newParameterInfos) {
            oldToNewParameters.put((Parameter)parameterInfo.getOriginalParameter(), parameterInfo.toParameter());
        }
        Parameter originalReceiver = originalDescriptor.getReceiverParameter();
        Parameter parameter = newReceiver = newReceiverInfo != null ? newReceiverInfo.toParameter() : null;
        if (originalReceiver != null && newReceiver != null) {
            oldToNewParameters.put(originalReceiver, newReceiver);
        }
        return ExtractableCodeDescriptorKt.copy(originalDescriptor, newName2, newVisibility, oldToNewParameters, newReceiver, returnType2);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel2;
        JComboBox jComboBox;
        JPanel jPanel3;
        JLabel jLabel;
        TitledSeparator titledSeparator;
        JPanel jPanel4;
        this.createUIComponents();
        this.contentPane = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel5, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 6, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BorderLayout(0, 0));
        jPanel5.add((Component)jPanel6, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 6, null, null, null));
        this.inputParametersPanel = titledSeparator = new TitledSeparator();
        titledSeparator.setLayout(new BorderLayout(0, 0));
        titledSeparator.setText("");
        jPanel6.add((Component)titledSeparator, "Center");
        titledSeparator.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)DynamicBundle.getBundle((String)"messages/KotlinBundle", KotlinExtractFunctionDialog.class).getString("title.parameters"), (int)0, (int)0, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel7, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 0, null, new Dimension(-1, 200), null));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.add((Component)jPanel8, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel8.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)DynamicBundle.getBundle((String)"messages/KotlinBundle", KotlinExtractFunctionDialog.class).getString("signature.preview"), (int)0, (int)0, null, null));
        KotlinSignatureComponent kotlinSignatureComponent = this.signaturePreviewField;
        kotlinSignatureComponent.setText("");
        jPanel8.add((Component)((Object)kotlinSignatureComponent), new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, new Dimension(500, 100), new Dimension(500, 100), null));
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel9).setEnabled(true);
        ((Component)jPanel9).setVisible(true);
        jPanel4.add((Component)jPanel9, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 0, null, null, null));
        jPanel9.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), null, 0, 0, null, null));
        this.functionNameLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/KotlinBundle", KotlinExtractFunctionDialog.class).getString("name"));
        jPanel9.add((Component)jLabel, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/KotlinBundle", KotlinExtractFunctionDialog.class).getString("visibility"));
        ((Component)jLabel2).setVisible(true);
        jPanel9.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, new Dimension(114, 16), null));
        this.functionNamePanel = jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        jPanel9.add((Component)jPanel3, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.visibilityBox = jComboBox = new JComboBox();
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
        defaultComboBoxModel.addElement("private");
        defaultComboBoxModel.addElement("protected");
        defaultComboBoxModel.addElement("internal");
        defaultComboBoxModel.addElement("public");
        jComboBox.setModel(defaultComboBoxModel);
        ((Component)jComboBox).setVisible(true);
        jPanel9.add(jComboBox, new GridConstraints(1, 0, 1, 1, 8, 0, 2, 0, null, new Dimension(114, 26), null));
        this.returnTypePanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel9.add((Component)jPanel2, new GridConstraints(2, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, DynamicBundle.getBundle((String)"messages/KotlinBundle", KotlinExtractFunctionDialog.class).getString("return.type"));
        jPanel2.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        JComboBox jComboBox2 = new JComboBox();
        this.returnTypeBox = jComboBox2;
        jPanel2.add(jComboBox2, new GridConstraints(1, 0, 1, 2, 8, 1, 2, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel4.add((Component)spacer2, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 0, null, null, null));
        jLabel2.setLabelFor(jComboBox);
        jLabel3.setLabelFor(jComboBox2);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalDescriptor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onAccept";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/idea/refactoring/introduce/extractFunction/ui/KotlinExtractFunctionDialog";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newParameterInfos";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/idea/refactoring/introduce/extractFunction/ui/KotlinExtractFunctionDialog";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createContentPane";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createNewDescriptor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

