/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.converters;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.xml.ConvertContext;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.idea.maven.dom.converters.MavenArtifactCoordinatesConverter;
import org.jetbrains.idea.maven.dom.converters.MavenSmartConverter;
import org.jetbrains.idea.maven.indices.MavenIndicesManager;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenArtifactUtilKt;
import org.jetbrains.idea.reposearch.DependencySearchService;

public class MavenArtifactCoordinatesGroupIdConverter
extends MavenArtifactCoordinatesConverter
implements MavenSmartConverter<String> {
    @Override
    protected boolean doIsValid(MavenId id, MavenIndicesManager manager, ConvertContext context) {
        VirtualFile projectFile;
        MavenProject mavenProject2;
        if (StringUtil.isEmpty((String)id.getGroupId())) {
            return false;
        }
        MavenProjectsManager projectsManager = MavenProjectsManager.getInstance(context.getProject());
        if (StringUtil.isNotEmpty((String)id.getArtifactId()) && StringUtil.isNotEmpty((String)id.getVersion())) {
            if (projectsManager.findProject(id) != null) {
                return true;
            }
        } else {
            for (MavenProject project2 : projectsManager.getProjects()) {
                if (!id.getGroupId().equals(project2.getMavenId().getGroupId())) continue;
                return true;
            }
        }
        MavenProject mavenProject3 = mavenProject2 = (projectFile = this.getMavenProjectFile(context)) == null ? null : projectsManager.findProject(projectFile);
        if (mavenProject2 != null) {
            for (MavenArtifact artifact : mavenProject2.findDependencies(id.getGroupId(), id.getArtifactId())) {
                if (!MavenArtifactUtilKt.resolved(artifact)) continue;
                return true;
            }
        }
        return manager.hasLocalGroupId(id.getGroupId());
    }

    @Override
    protected Set<String> doGetVariants(MavenId id, DependencySearchService searchService) {
        return Collections.emptySet();
    }

    @Override
    public Collection<String> getSmartVariants(ConvertContext convertContext) {
        return Collections.emptySet();
    }
}

