/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.externalSystemIntegration.output.quickfixes;

import com.intellij.build.issue.BuildIssue;
import com.intellij.build.issue.BuildIssueQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.externalSystemIntegration.output.quickfixes.MavenConfigOpenQuickFix;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectBundle;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenUtil;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/idea/maven/externalSystemIntegration/output/quickfixes/MavenConfigBuildIssue;", "", "()V", "CONFIG_PARSE_ERROR", "", "CONFIG_VALUE_ERROR", "getIssue", "Lcom/intellij/build/issue/BuildIssue;", "title", "errorMessage", "project", "Lcom/intellij/openapi/project/Project;", "intellij.maven"})
public final class MavenConfigBuildIssue {
    @NotNull
    public static final String CONFIG_PARSE_ERROR = "Unable to parse maven.config:";
    @NotNull
    public static final String CONFIG_VALUE_ERROR = "For input string:";
    @NotNull
    public static final MavenConfigBuildIssue INSTANCE;

    @Nullable
    public final BuildIssue getIssue(@NotNull String title, @NotNull String errorMessage, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        MavenProjectsManager mavenProjectsManager = MavenProjectsManager.getInstance(project2);
        Intrinsics.checkNotNullExpressionValue((Object)mavenProjectsManager, (String)"MavenProjectsManager.getInstance(project)");
        List<MavenProject> list = mavenProjectsManager.getRootProjects();
        Intrinsics.checkNotNullExpressionValue(list, (String)"MavenProjectsManager.get\u2026nce(project).rootProjects");
        MavenProject mavenProject2 = (MavenProject)CollectionsKt.firstOrNull(list);
        if (mavenProject2 == null) {
            MavenLog.LOG.warn("Cannot find appropriate maven project,project =  " + project2.getName());
            return null;
        }
        VirtualFile configFile = MavenUtil.getConfigFile(mavenProject2, "/.mvn/maven.config");
        if (configFile == null) {
            return null;
        }
        MavenConfigOpenQuickFix mavenConfigOpenQuickFix = new MavenConfigOpenQuickFix(configFile, errorMessage);
        List quickFixes = CollectionsKt.listOf((Object)mavenConfigOpenQuickFix);
        StringBuilder issueDescription = new StringBuilder(errorMessage);
        issueDescription.append("\n\n");
        issueDescription.append(MavenProjectBundle.message("maven.quickfix.maven.config.file", mavenConfigOpenQuickFix.getId()));
        return new BuildIssue(title, issueDescription, quickFixes){
            @NotNull
            private final String title;
            @NotNull
            private final String description;
            @NotNull
            private final List<BuildIssueQuickFix> quickFixes;
            final /* synthetic */ String $title;
            final /* synthetic */ StringBuilder $issueDescription;
            final /* synthetic */ List $quickFixes;

            @NotNull
            public String getTitle() {
                return this.title;
            }

            @NotNull
            public String getDescription() {
                return this.description;
            }

            @NotNull
            public List<BuildIssueQuickFix> getQuickFixes() {
                return this.quickFixes;
            }

            @Nullable
            public Navigatable getNavigatable(@NotNull Project project2) {
                Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                return null;
            }
            {
                this.$title = $captured_local_variable$0;
                this.$issueDescription = $captured_local_variable$1;
                this.$quickFixes = $captured_local_variable$2;
                this.title = $captured_local_variable$0;
                String string = $captured_local_variable$1.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"issueDescription.toString()");
                this.description = string;
                this.quickFixes = $captured_local_variable$2;
            }
        };
    }

    private MavenConfigBuildIssue() {
    }

    static {
        MavenConfigBuildIssue mavenConfigBuildIssue;
        INSTANCE = mavenConfigBuildIssue = new MavenConfigBuildIssue();
    }
}

