/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.build.BuildProgressListener;
import com.intellij.build.SyncViewManager;
import com.intellij.configurationStore.SettingsSavingComponentJavaAdapter;
import com.intellij.ide.startup.StartupManagerEx;
import com.intellij.internal.statistic.StructuredIdeActivity;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.externalSystem.ExternalSystemModulePropertyManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.ProjectDataManager;
import com.intellij.openapi.externalSystem.service.project.autoimport.ExternalSystemProjectsWatcherImpl;
import com.intellij.openapi.externalSystem.statistics.ExternalSystemStatUtilKt;
import com.intellij.openapi.externalSystem.statistics.ProjectImportCollector;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.impl.CoreProgressManager;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.Alarm;
import com.intellij.util.EventDispatcher;
import com.intellij.util.NullableConsumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.PathKt;
import com.intellij.util.ui.update.Update;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.idea.maven.buildtool.MavenImportSpec;
import org.jetbrains.idea.maven.buildtool.MavenSyncConsole;
import org.jetbrains.idea.maven.execution.SyncBundle;
import org.jetbrains.idea.maven.externalSystemIntegration.output.quickfixes.CacheForCompilerErrorMessages;
import org.jetbrains.idea.maven.importing.MavenFoldersImporter;
import org.jetbrains.idea.maven.importing.MavenImportStats;
import org.jetbrains.idea.maven.importing.MavenModelUtil;
import org.jetbrains.idea.maven.importing.MavenPomPathModuleService;
import org.jetbrains.idea.maven.importing.MavenProjectImporter;
import org.jetbrains.idea.maven.indices.MavenIndicesManager;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenExplicitProfiles;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.model.MavenProfileKind;
import org.jetbrains.idea.maven.model.MavenRemoteRepository;
import org.jetbrains.idea.maven.navigator.MavenProjectsNavigator;
import org.jetbrains.idea.maven.project.MavenArtifactDownloader;
import org.jetbrains.idea.maven.project.MavenConsole;
import org.jetbrains.idea.maven.project.MavenDefaultModelsProvider;
import org.jetbrains.idea.maven.project.MavenEmbeddersManager;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenImportListener;
import org.jetbrains.idea.maven.project.MavenImportingSettings;
import org.jetbrains.idea.maven.project.MavenModelsProvider;
import org.jetbrains.idea.maven.project.MavenModificationTracker;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectBundle;
import org.jetbrains.idea.maven.project.MavenProjectChanges;
import org.jetbrains.idea.maven.project.MavenProjectResolver;
import org.jetbrains.idea.maven.project.MavenProjectsManagerState;
import org.jetbrains.idea.maven.project.MavenProjectsManagerWatcher;
import org.jetbrains.idea.maven.project.MavenProjectsProcessor;
import org.jetbrains.idea.maven.project.MavenProjectsProcessorArtifactsDownloadingTask;
import org.jetbrains.idea.maven.project.MavenProjectsProcessorEmptyTask;
import org.jetbrains.idea.maven.project.MavenProjectsProcessorFoldersResolvingTask;
import org.jetbrains.idea.maven.project.MavenProjectsProcessorPluginsResolvingTask;
import org.jetbrains.idea.maven.project.MavenProjectsProcessorResolvingTask;
import org.jetbrains.idea.maven.project.MavenProjectsProcessorTask;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.project.MavenResolveResultProblemProcessor;
import org.jetbrains.idea.maven.project.MavenWorkspaceSettings;
import org.jetbrains.idea.maven.project.MavenWorkspaceSettingsComponent;
import org.jetbrains.idea.maven.project.ResolveContext;
import org.jetbrains.idea.maven.project.importing.FilesList;
import org.jetbrains.idea.maven.project.importing.MavenImportingManager;
import org.jetbrains.idea.maven.server.MavenDistributionsCache;
import org.jetbrains.idea.maven.server.MavenEmbedderWrapper;
import org.jetbrains.idea.maven.server.MavenServerProgressIndicator;
import org.jetbrains.idea.maven.server.NativeMavenProjectHolder;
import org.jetbrains.idea.maven.tasks.MavenShortcutsManager;
import org.jetbrains.idea.maven.tasks.MavenTasksManager;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenMergingUpdateQueue;
import org.jetbrains.idea.maven.utils.MavenProcessCanceledException;
import org.jetbrains.idea.maven.utils.MavenProgressIndicator;
import org.jetbrains.idea.maven.utils.MavenRehighlighter;
import org.jetbrains.idea.maven.utils.MavenSimpleProjectComponent;
import org.jetbrains.idea.maven.utils.MavenTask;
import org.jetbrains.idea.maven.utils.MavenUtil;
import org.jetbrains.idea.maven.utils.MavenWslCache;
import org.jetbrains.idea.maven.utils.MavenWslUtil;

@State(name="MavenProjectsManager")
public class MavenProjectsManager
extends MavenSimpleProjectComponent
implements PersistentStateComponent<MavenProjectsManagerState>,
SettingsSavingComponentJavaAdapter,
Disposable {
    private static final int IMPORT_DELAY = 1000;
    private final ReentrantLock initLock;
    private final AtomicBoolean isInitialized;
    private MavenProjectsManagerState myState;
    private final Alarm myInitializationAlarm;
    private final MavenEmbeddersManager myEmbeddersManager;
    private MavenProjectsTree myProjectsTree;
    private MavenProjectResolver myMavenProjectResolver;
    private MavenProjectsManagerWatcher myWatcher;
    private MavenProjectsProcessor myReadingProcessor;
    private MavenProjectsProcessor myResolvingProcessor;
    private MavenProjectsProcessor myPluginsResolvingProcessor;
    private MavenProjectsProcessor myFoldersResolvingProcessor;
    private MavenProjectsProcessor myArtifactsDownloadingProcessor;
    private MavenProjectsProcessor myPostProcessor;
    private MavenMergingUpdateQueue myImportingQueue;
    private final Object myImportingDataLock;
    private final Map<MavenProject, MavenProjectChanges> myProjectsToImport;
    private final Set<MavenProject> myProjectsToResolve;
    private boolean myImportModuleGroupsRequired;
    private final EventDispatcher<MavenProjectsTree.Listener> myProjectsTreeDispatcher;
    private final List<Listener> myManagerListeners;
    private final ModificationTracker myModificationTracker;
    private BuildProgressListener myProgressListener;
    private MavenWorkspaceSettings myWorkspaceSettings;
    private volatile MavenSyncConsole mySyncConsole;
    private final MavenMergingUpdateQueue mySaveQueue;
    private static final int SAVE_DELAY = 1000;
    private Module myDummyModule;
    private transient boolean forceUpdateSnapshots;

    public static MavenProjectsManager getInstance(@NotNull Project project2) {
        if (project2 == null) {
            MavenProjectsManager.$$$reportNull$$$0(0);
        }
        return (MavenProjectsManager)project2.getService(MavenProjectsManager.class);
    }

    @Nullable
    public static MavenProjectsManager getInstanceIfCreated(@NotNull Project project2) {
        if (project2 == null) {
            MavenProjectsManager.$$$reportNull$$$0(1);
        }
        return (MavenProjectsManager)project2.getServiceIfCreated(MavenProjectsManager.class);
    }

    public MavenProjectsManager(@NotNull Project project2) {
        if (project2 == null) {
            MavenProjectsManager.$$$reportNull$$$0(2);
        }
        super(project2);
        this.initLock = new ReentrantLock();
        this.isInitialized = new AtomicBoolean();
        this.myState = new MavenProjectsManagerState();
        this.myImportingDataLock = new Object();
        this.myProjectsToImport = new LinkedHashMap<MavenProject, MavenProjectChanges>();
        this.myProjectsToResolve = new LinkedHashSet<MavenProject>();
        this.myImportModuleGroupsRequired = false;
        this.myProjectsTreeDispatcher = EventDispatcher.create(MavenProjectsTree.Listener.class);
        this.myManagerListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.forceUpdateSnapshots = false;
        this.myEmbeddersManager = new MavenEmbeddersManager(project2);
        this.myModificationTracker = new MavenModificationTracker(this);
        this.myInitializationAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
        this.mySaveQueue = new MavenMergingUpdateQueue("Maven save queue", 1000, !MavenUtil.isMavenUnitTestModeEnabled(), this);
        this.myProgressListener = (BuildProgressListener)this.myProject.getService(SyncViewManager.class);
        MavenRehighlighter.install(project2, this);
        Disposer.register((Disposable)this, this::projectClosed);
        CacheForCompilerErrorMessages.connectToJdkListener(project2, this);
    }

    @TestOnly
    public void setProgressListener(SyncViewManager testViewManager) {
        this.myProgressListener = testViewManager;
    }

    public MavenProjectsManagerState getState() {
        if (this.isInitialized()) {
            this.applyTreeToState();
        }
        return this.myState;
    }

    public void loadState(@NotNull MavenProjectsManagerState state2) {
        if (state2 == null) {
            MavenProjectsManager.$$$reportNull$$$0(3);
        }
        this.myState = state2;
        if (this.isInitialized()) {
            MavenProjectsManager.applyStateToTree(this.myProjectsTree, this);
            this.scheduleUpdateAllProjects(new MavenImportSpec(false, false, false));
        }
    }

    public void dispose() {
        this.mySyncConsole = null;
        this.myManagerListeners.clear();
    }

    public ModificationTracker getModificationTracker() {
        return this.myModificationTracker;
    }

    public MavenGeneralSettings getGeneralSettings() {
        MavenGeneralSettings generalSettings = this.getWorkspaceSettings().getGeneralSettings();
        generalSettings.setProject(this.myProject);
        return generalSettings;
    }

    public MavenImportingSettings getImportingSettings() {
        return this.getWorkspaceSettings().getImportingSettings();
    }

    private MavenWorkspaceSettings getWorkspaceSettings() {
        if (this.myWorkspaceSettings == null) {
            this.myWorkspaceSettings = MavenWorkspaceSettingsComponent.getInstance(this.myProject).getSettings();
        }
        return this.myWorkspaceSettings;
    }

    public File getLocalRepository() {
        return this.getGeneralSettings().getEffectiveLocalRepository();
    }

    @ApiStatus.Internal
    public int getFilterConfigCrc(@NotNull ProjectFileIndex projectFileIndex) {
        if (projectFileIndex == null) {
            MavenProjectsManager.$$$reportNull$$$0(4);
        }
        return this.myProjectsTree.getFilterConfigCrc(projectFileIndex);
    }

    public void initializeComponent() {
        if (!this.isNormalProject()) {
            return;
        }
        Runnable runnable = () -> {
            boolean wasMavenized;
            boolean bl = wasMavenized = !this.myState.originalFiles.isEmpty();
            if (!wasMavenized) {
                return;
            }
            this.initMavenized();
        };
        ApplicationManager.getApplication().executeOnPooledThread(runnable);
    }

    private void initMavenized() {
        this.doInit(false);
    }

    private void initNew(List<VirtualFile> files, MavenExplicitProfiles explicitProfiles) {
        this.myState.originalFiles = MavenUtil.collectPaths(files);
        MavenWorkspaceSettings workspaceSettings = this.getWorkspaceSettings();
        workspaceSettings.setEnabledProfiles(explicitProfiles.getEnabledProfiles());
        workspaceSettings.setDisabledProfiles(explicitProfiles.getDisabledProfiles());
        this.doInit(true);
    }

    @TestOnly
    public void initForTests() {
        this.doInit(false);
    }

    private void doInit(boolean isNew) {
        this.initLock.lock();
        try {
            if (this.isInitialized.getAndSet(true)) {
                return;
            }
            this.initPreloadMavenServices();
            this.initProjectsTree(!isNew);
            this.initWorkers();
            this.listenForSettingsChanges();
            this.listenForProjectsTreeChanges();
            this.registerSyncConsoleListener();
            this.updateTabTitles();
            MavenUtil.runWhenInitialized(this.myProject, (Runnable)((DumbAwareRunnable)() -> {
                if (!ApplicationManager.getApplication().isUnitTestMode()) {
                    MavenIndicesManager.getInstance(this.myProject).scheduleUpdateIndicesList(null);
                    this.fireActivated();
                    this.listenForExternalChanges();
                }
                if (!MavenUtil.isLinearImportEnabled()) {
                    this.scheduleUpdateAllProjects(new MavenImportSpec(false, isNew, false));
                }
            }));
        }
        finally {
            this.initLock.unlock();
        }
    }

    private void initPreloadMavenServices() {
        MavenProjectsNavigator.getInstance(this.myProject);
        MavenTasksManager.getInstance(this.myProject);
        MavenShortcutsManager.getInstance(this.myProject);
    }

    private void updateTabTitles() {
        Application app = ApplicationManager.getApplication();
        if (MavenUtil.isMavenUnitTestModeEnabled() || app.isHeadlessEnvironment()) {
            return;
        }
        this.addProjectsTreeListener(new MavenProjectsTree.Listener(){

            @Override
            public void projectsUpdated(@NotNull List<Pair<MavenProject, MavenProjectChanges>> updated, @NotNull List<MavenProject> deleted) {
                if (updated == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (deleted == null) {
                    1.$$$reportNull$$$0(1);
                }
                MavenProjectsManager.updateTabName(MavenUtil.collectFirsts(updated), MavenProjectsManager.this.myProject);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "updated";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "deleted";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/idea/maven/project/MavenProjectsManager$1";
                objectArray[2] = "projectsUpdated";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private static void updateTabName(@NotNull List<MavenProject> projects, @NotNull Project project2) {
        if (projects == null) {
            MavenProjectsManager.$$$reportNull$$$0(5);
        }
        if (project2 == null) {
            MavenProjectsManager.$$$reportNull$$$0(6);
        }
        MavenUtil.invokeLater(project2, () -> {
            for (MavenProject each : projects) {
                FileEditorManagerEx.getInstanceEx((Project)project2).updateFilePresentation(each.getFile());
            }
        });
    }

    public synchronized MavenSyncConsole getSyncConsole() {
        if (this.mySyncConsole == null) {
            this.mySyncConsole = new MavenSyncConsole(this.myProject);
        }
        return this.mySyncConsole;
    }

    private void initProjectsTree(boolean tryToLoadExisting) {
        if (tryToLoadExisting) {
            Path file = this.getProjectsTreeFile();
            try {
                if (PathKt.exists((Path)file)) {
                    this.myProjectsTree = MavenProjectsTree.read(this.myProject, file);
                }
            }
            catch (IOException e) {
                MavenLog.LOG.info((Throwable)e);
            }
        }
        if (this.myProjectsTree == null) {
            this.myProjectsTree = new MavenProjectsTree(this.myProject);
        }
        this.myMavenProjectResolver = new MavenProjectResolver(this.myProjectsTree);
        MavenProjectsManager.applyStateToTree(this.myProjectsTree, this);
        this.myProjectsTree.addListener((MavenProjectsTree.Listener)this.myProjectsTreeDispatcher.getMulticaster(), this);
    }

    private void applyTreeToState() {
        this.myState.originalFiles = this.myProjectsTree.getManagedFilesPaths();
        this.myState.ignoredFiles = new HashSet<String>(this.myProjectsTree.getIgnoredFilesPaths());
        this.myState.ignoredPathMasks = this.myProjectsTree.getIgnoredFilesPatterns();
    }

    public static void applyStateToTree(MavenProjectsTree tree, MavenProjectsManager manager) {
        MavenWorkspaceSettings settings = manager.getWorkspaceSettings();
        MavenExplicitProfiles explicitProfiles = new MavenExplicitProfiles(settings.enabledProfiles, settings.disabledProfiles);
        tree.resetManagedFilesPathsAndProfiles(manager.myState.originalFiles, explicitProfiles);
        tree.setIgnoredFilesPaths(new ArrayList<String>(manager.myState.ignoredFiles));
        tree.setIgnoredFilesPatterns(manager.myState.ignoredPathMasks);
    }

    public void doSave() {
        if (this.myProjectsTree == null) {
            return;
        }
        this.mySaveQueue.queue(new Update(this){

            public void run() {
                try {
                    MavenProjectsManager.this.myProjectsTree.save(MavenProjectsManager.this.getProjectsTreeFile());
                }
                catch (IOException e) {
                    MavenLog.LOG.info((Throwable)e);
                }
            }
        });
    }

    @ApiStatus.Internal
    public Path getProjectsTreeFile() {
        return MavenProjectsManager.getProjectsTreesDir().resolve(this.myProject.getLocationHash()).resolve("tree.dat");
    }

    @NotNull
    @ApiStatus.Internal
    public static Path getProjectsTreesDir() {
        Path path = MavenUtil.getPluginSystemDir("Projects");
        if (path == null) {
            MavenProjectsManager.$$$reportNull$$$0(7);
        }
        return path;
    }

    private void initWorkers() {
        this.myReadingProcessor = new MavenProjectsProcessor(this.myProject, MavenProjectBundle.message("maven.reading", new Object[0]), false, this.myEmbeddersManager);
        this.myResolvingProcessor = new MavenProjectsProcessor(this.myProject, MavenProjectBundle.message("maven.resolving", new Object[0]), true, this.myEmbeddersManager);
        this.myPluginsResolvingProcessor = new MavenProjectsProcessor(this.myProject, MavenProjectBundle.message("maven.downloading.plugins", new Object[0]), true, this.myEmbeddersManager);
        this.myFoldersResolvingProcessor = new MavenProjectsProcessor(this.myProject, MavenProjectBundle.message("maven.updating.folders", new Object[0]), true, this.myEmbeddersManager);
        this.myArtifactsDownloadingProcessor = new MavenProjectsProcessor(this.myProject, MavenProjectBundle.message("maven.downloading", new Object[0]), true, this.myEmbeddersManager);
        this.myPostProcessor = new MavenProjectsProcessor(this.myProject, MavenProjectBundle.message("maven.post.processing", new Object[0]), true, this.myEmbeddersManager);
        this.myWatcher = new MavenProjectsManagerWatcher(this.myProject, this.myProjectsTree, this.getGeneralSettings(), this.myReadingProcessor);
        this.myImportingQueue = new MavenMergingUpdateQueue(this.getClass().getName() + ": Importing queue", 1000, !MavenUtil.isMavenUnitTestModeEnabled(), this);
        this.myImportingQueue.makeUserAware(this.myProject);
        this.myImportingQueue.makeModalAware(this.myProject);
    }

    private void listenForSettingsChanges() {
        this.getImportingSettings().addListener(new MavenImportingSettings.Listener(){

            @Override
            public void createModuleGroupsChanged() {
                MavenProjectsManager.this.scheduleImportSettings(true);
            }

            @Override
            public void createModuleForAggregatorsChanged() {
                MavenProjectsManager.this.scheduleImportSettings();
            }

            @Override
            public void updateAllProjectStructure() {
                MavenProjectsManager.this.scheduleAllProjectImport();
            }
        });
    }

    private void registerSyncConsoleListener() {
        this.myProjectsTreeDispatcher.addListener((EventListener)new MavenProjectsTree.Listener(){

            @Override
            public void pluginsResolved(@NotNull MavenProject project2) {
                if (project2 == null) {
                    4.$$$reportNull$$$0(0);
                }
                MavenProjectsManager.this.getSyncConsole().getListener(MavenServerProgressIndicator.ResolveType.PLUGIN).finish();
            }

            @Override
            public void artifactsDownloaded(@NotNull MavenProject project2) {
                if (project2 == null) {
                    4.$$$reportNull$$$0(1);
                }
                MavenProjectsManager.this.getSyncConsole().getListener(MavenServerProgressIndicator.ResolveType.DEPENDENCY).finish();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "project";
                objectArray2[1] = "org/jetbrains/idea/maven/project/MavenProjectsManager$4";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "pluginsResolved";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "artifactsDownloaded";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private void listenForProjectsTreeChanges() {
        this.myProjectsTree.addListener(new MavenProjectsTree.Listener(){

            @Override
            public void projectsIgnoredStateChanged(@NotNull List<MavenProject> ignored, @NotNull List<MavenProject> unignored, boolean fromImport) {
                if (ignored == null) {
                    5.$$$reportNull$$$0(0);
                }
                if (unignored == null) {
                    5.$$$reportNull$$$0(1);
                }
                if (!fromImport) {
                    MavenProjectsManager.this.scheduleImport();
                }
            }

            @Override
            public void projectsUpdated(@NotNull List<Pair<MavenProject, MavenProjectChanges>> updated, @NotNull List<MavenProject> deleted) {
                MavenProject project2;
                if (updated == null) {
                    5.$$$reportNull$$$0(2);
                }
                if (deleted == null) {
                    5.$$$reportNull$$$0(3);
                }
                MavenProjectsManager.this.myEmbeddersManager.clearCaches();
                MavenProjectsManager.this.unscheduleAllTasks(deleted);
                List<MavenProject> updatedProjects = MavenUtil.collectFirsts(updated);
                ArrayList<Pair<MavenProject, MavenProjectChanges>> toImport = new ArrayList<Pair<MavenProject, MavenProjectChanges>>(updated);
                for (MavenProject eachDependent : MavenProjectsManager.this.myProjectsTree.getDependentProjects(updatedProjects)) {
                    toImport.add((Pair<MavenProject, MavenProjectChanges>)Pair.create((Object)eachDependent, (Object)MavenProjectChanges.DEPENDENCIES));
                }
                HashSet<MavenProject> toResolve = new HashSet<MavenProject>(updatedProjects);
                toResolve.addAll(MavenProjectsManager.this.myProjectsTree.getDependentProjects(ContainerUtil.concat(updatedProjects, deleted)));
                Iterator it = toResolve.iterator();
                while (it.hasNext()) {
                    MavenProject each = (MavenProject)it.next();
                    if (!each.hasReadingProblems()) continue;
                    MavenProjectsManager.this.getSyncConsole().notifyReadingProblems(each.getFile());
                    it.remove();
                }
                if (this.haveChanges(toImport) || !deleted.isEmpty()) {
                    MavenProjectsManager.this.scheduleForNextImport(toImport);
                }
                if (!deleted.isEmpty() && !MavenProjectsManager.this.hasScheduledProjects() && (project2 = (MavenProject)ObjectUtils.chooseNotNull((Object)((MavenProject)ContainerUtil.getFirstItem(toResolve)), (Object)((MavenProject)ContainerUtil.getFirstItem(MavenProjectsManager.this.getNonIgnoredProjects())))) != null) {
                    MavenProjectsManager.this.scheduleForNextImport((Pair<MavenProject, MavenProjectChanges>)Pair.create((Object)project2, (Object)MavenProjectChanges.ALL));
                    MavenProjectsManager.this.scheduleForNextResolve(Collections.singletonList(project2));
                }
                MavenProjectsManager.this.scheduleForNextResolve(toResolve);
                MavenProjectsManager.this.fireProjectScheduled();
            }

            private boolean haveChanges(List<Pair<MavenProject, MavenProjectChanges>> projectsWithChanges) {
                for (MavenProjectChanges each : MavenUtil.collectSeconds(projectsWithChanges)) {
                    if (!each.hasChanges()) continue;
                    return true;
                }
                return false;
            }

            @Override
            public void projectResolved(@NotNull Pair<MavenProject, MavenProjectChanges> projectWithChanges, @Nullable NativeMavenProjectHolder nativeMavenProject) {
                if (projectWithChanges == null) {
                    5.$$$reportNull$$$0(4);
                }
                MavenProjectsManager.this.forceUpdateSnapshots = false;
                if (nativeMavenProject != null) {
                    if (this.shouldScheduleProject(projectWithChanges)) {
                        MavenProjectsManager.this.scheduleForNextImport(projectWithChanges);
                        MavenImportingSettings importingSettings = (MavenImportingSettings)ReadAction.compute(() -> MavenProjectsManager.this.myProject.isDisposed() ? null : MavenProjectsManager.this.getImportingSettings());
                        if (importingSettings == null) {
                            return;
                        }
                        MavenProjectsManager.this.scheduleArtifactsDownloading(Collections.singleton((MavenProject)projectWithChanges.first), null, importingSettings.isDownloadSourcesAutomatically(), importingSettings.isDownloadDocsAutomatically(), null);
                    }
                    if (!((MavenProject)projectWithChanges.first).hasReadingProblems() && ((MavenProject)projectWithChanges.first).hasUnresolvedPlugins()) {
                        MavenProjectsManager.this.schedulePluginsResolve((MavenProject)projectWithChanges.first, nativeMavenProject);
                    }
                }
            }

            @Override
            public void foldersResolved(@NotNull Pair<MavenProject, MavenProjectChanges> projectWithChanges) {
                if (projectWithChanges == null) {
                    5.$$$reportNull$$$0(5);
                }
                if (this.shouldScheduleProject(projectWithChanges)) {
                    MavenProjectsManager.this.scheduleForNextImport(projectWithChanges);
                }
            }

            private boolean shouldScheduleProject(Pair<MavenProject, MavenProjectChanges> projectWithChanges) {
                return !((MavenProject)projectWithChanges.first).hasReadingProblems() && ((MavenProjectChanges)projectWithChanges.second).hasChanges();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "ignored";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "unignored";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "updated";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "deleted";
                        break;
                    }
                    case 4: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "projectWithChanges";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/idea/maven/project/MavenProjectsManager$5";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "projectsIgnoredStateChanged";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "projectsUpdated";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "projectResolved";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "foldersResolved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, this);
    }

    public void listenForExternalChanges() {
        this.myWatcher.start();
    }

    @TestOnly
    public void enableAutoImportInTests() {
        assert (this.isInitialized());
        this.listenForExternalChanges();
        this.myWatcher.enableAutoImportInTests();
    }

    private void projectClosed() {
        this.initLock.lock();
        try {
            if (!this.isInitialized.getAndSet(false)) {
                return;
            }
            Disposer.dispose((Disposable)this.myImportingQueue);
            this.myWatcher.stop();
            this.myReadingProcessor.stop();
            this.myResolvingProcessor.stop();
            this.myPluginsResolvingProcessor.stop();
            this.myFoldersResolvingProcessor.stop();
            this.myArtifactsDownloadingProcessor.stop();
            this.myPostProcessor.stop();
            this.mySaveQueue.flush();
            if (MavenUtil.isMavenUnitTestModeEnabled()) {
                PathKt.delete((Path)MavenProjectsManager.getProjectsTreesDir());
            }
        }
        finally {
            this.initLock.unlock();
        }
    }

    public MavenEmbeddersManager getEmbeddersManager() {
        return this.myEmbeddersManager;
    }

    private boolean isInitialized() {
        return !this.initLock.isLocked() && this.isInitialized.get();
    }

    public boolean isMavenizedProject() {
        return this.isInitialized();
    }

    public boolean isMavenizedModule(@NotNull Module m) {
        if (m == null) {
            MavenProjectsManager.$$$reportNull$$$0(8);
        }
        return (Boolean)ReadAction.compute(() -> !m.isDisposed() && ExternalSystemModulePropertyManager.getInstance((Module)m).isMavenized());
    }

    @TestOnly
    public void resetManagedFilesAndProfilesInTests(List<VirtualFile> files, MavenExplicitProfiles profiles2) {
        this.myWatcher.resetManagedFilesAndProfilesInTests(files, profiles2);
    }

    public void addManagedFilesWithProfiles(List<VirtualFile> files, MavenExplicitProfiles profiles2, Module dummyModuleToDelete) {
        this.myDummyModule = dummyModuleToDelete;
        if (!this.isInitialized()) {
            this.initNew(files, profiles2);
        } else {
            this.myWatcher.addManagedFilesWithProfiles(files, profiles2);
        }
    }

    public void addManagedFiles(@NotNull List<VirtualFile> files) {
        if (files == null) {
            MavenProjectsManager.$$$reportNull$$$0(9);
        }
        this.addManagedFilesWithProfiles(files, MavenExplicitProfiles.NONE, null);
    }

    public void addManagedFilesOrUnignore(@NotNull List<VirtualFile> files) {
        if (files == null) {
            MavenProjectsManager.$$$reportNull$$$0(10);
        }
        this.removeIgnoredFilesPaths(MavenUtil.collectPaths(files));
        this.addManagedFiles(files);
    }

    public void removeManagedFiles(@NotNull List<VirtualFile> files) {
        if (files == null) {
            MavenProjectsManager.$$$reportNull$$$0(11);
        }
        this.myWatcher.removeManagedFiles(files);
    }

    public boolean isManagedFile(@NotNull VirtualFile f) {
        if (f == null) {
            MavenProjectsManager.$$$reportNull$$$0(12);
        }
        if (!this.isInitialized()) {
            return false;
        }
        return this.myProjectsTree.isManagedFile(f);
    }

    @NotNull
    public MavenExplicitProfiles getExplicitProfiles() {
        if (!this.isInitialized()) {
            MavenExplicitProfiles mavenExplicitProfiles = MavenExplicitProfiles.NONE;
            if (mavenExplicitProfiles == null) {
                MavenProjectsManager.$$$reportNull$$$0(13);
            }
            return mavenExplicitProfiles;
        }
        MavenExplicitProfiles mavenExplicitProfiles = this.myProjectsTree.getExplicitProfiles();
        if (mavenExplicitProfiles == null) {
            MavenProjectsManager.$$$reportNull$$$0(14);
        }
        return mavenExplicitProfiles;
    }

    public void setExplicitProfiles(@NotNull MavenExplicitProfiles profiles2) {
        if (profiles2 == null) {
            MavenProjectsManager.$$$reportNull$$$0(15);
        }
        this.myWatcher.setExplicitProfiles(profiles2);
    }

    @NotNull
    public Collection<String> getAvailableProfiles() {
        if (!this.isInitialized()) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                MavenProjectsManager.$$$reportNull$$$0(16);
            }
            return list;
        }
        Collection<String> collection = this.myProjectsTree.getAvailableProfiles();
        if (collection == null) {
            MavenProjectsManager.$$$reportNull$$$0(17);
        }
        return collection;
    }

    @NotNull
    public Collection<Pair<String, MavenProfileKind>> getProfilesWithStates() {
        if (!this.isInitialized()) {
            List<Pair<String, MavenProfileKind>> list = Collections.emptyList();
            if (list == null) {
                MavenProjectsManager.$$$reportNull$$$0(18);
            }
            return list;
        }
        Collection<Pair<String, MavenProfileKind>> collection = this.myProjectsTree.getProfilesWithStates();
        if (collection == null) {
            MavenProjectsManager.$$$reportNull$$$0(19);
        }
        return collection;
    }

    public boolean hasProjects() {
        if (!this.isInitialized()) {
            return false;
        }
        return this.myProjectsTree.hasProjects();
    }

    @NotNull
    public List<MavenProject> getProjects() {
        if (!this.isInitialized()) {
            List<MavenProject> list = Collections.emptyList();
            if (list == null) {
                MavenProjectsManager.$$$reportNull$$$0(20);
            }
            return list;
        }
        List<MavenProject> list = this.myProjectsTree.getProjects();
        if (list == null) {
            MavenProjectsManager.$$$reportNull$$$0(21);
        }
        return list;
    }

    @NotNull
    public List<MavenProject> getRootProjects() {
        if (!this.isInitialized()) {
            List<MavenProject> list = Collections.emptyList();
            if (list == null) {
                MavenProjectsManager.$$$reportNull$$$0(22);
            }
            return list;
        }
        List<MavenProject> list = this.myProjectsTree.getRootProjects();
        if (list == null) {
            MavenProjectsManager.$$$reportNull$$$0(23);
        }
        return list;
    }

    @NotNull
    public List<MavenProject> getNonIgnoredProjects() {
        if (!this.isInitialized()) {
            List<MavenProject> list = Collections.emptyList();
            if (list == null) {
                MavenProjectsManager.$$$reportNull$$$0(24);
            }
            return list;
        }
        List<MavenProject> list = this.myProjectsTree.getNonIgnoredProjects();
        if (list == null) {
            MavenProjectsManager.$$$reportNull$$$0(25);
        }
        return list;
    }

    @NotNull
    public List<VirtualFile> getProjectsFiles() {
        if (!this.isInitialized()) {
            List<VirtualFile> list = Collections.emptyList();
            if (list == null) {
                MavenProjectsManager.$$$reportNull$$$0(26);
            }
            return list;
        }
        List<VirtualFile> list = this.myProjectsTree.getProjectsFiles();
        if (list == null) {
            MavenProjectsManager.$$$reportNull$$$0(27);
        }
        return list;
    }

    @Nullable
    public MavenProject findProject(@NotNull VirtualFile f) {
        if (f == null) {
            MavenProjectsManager.$$$reportNull$$$0(28);
        }
        if (!this.isInitialized()) {
            return null;
        }
        return this.myProjectsTree.findProject(f);
    }

    public MavenProject findSingleProjectInReactor(@NotNull MavenId id) {
        if (id == null) {
            MavenProjectsManager.$$$reportNull$$$0(29);
        }
        if (!this.isInitialized()) {
            return null;
        }
        return this.myProjectsTree.findSingleProjectInReactor(id);
    }

    @Nullable
    public MavenProject findProject(@NotNull MavenId id) {
        if (id == null) {
            MavenProjectsManager.$$$reportNull$$$0(30);
        }
        if (!this.isInitialized()) {
            return null;
        }
        return this.myProjectsTree.findProject(id);
    }

    @Nullable
    public MavenProject findProject(@NotNull MavenArtifact artifact) {
        if (artifact == null) {
            MavenProjectsManager.$$$reportNull$$$0(31);
        }
        if (!this.isInitialized()) {
            return null;
        }
        return this.myProjectsTree.findProject(artifact);
    }

    @Nullable
    public MavenProject findProject(@NotNull Module module) {
        if (module == null) {
            MavenProjectsManager.$$$reportNull$$$0(32);
        }
        MavenProject mavenProject2 = this.getMavenProject(module);
        String moduleName = module.getName();
        if (mavenProject2 == null && MavenModelUtil.isMainOrTestSubmodule(moduleName)) {
            Module parentModule = ModuleManager.getInstance((Project)this.myProject).findModuleByName(MavenModelUtil.getParentModuleName(moduleName));
            mavenProject2 = parentModule != null ? this.getMavenProject(parentModule) : null;
        }
        return mavenProject2;
    }

    private MavenProject getMavenProject(@NotNull Module module) {
        if (module == null) {
            MavenProjectsManager.$$$reportNull$$$0(33);
        }
        return (MavenProject)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> {
            VirtualFile f = this.findPomFile(module, new MavenModelsProvider(){

                @Override
                public Module[] getModules() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public VirtualFile[] getContentRoots(Module module) {
                    return ModuleRootManager.getInstance((Module)module).getContentRoots();
                }
            });
            MavenProject result = f == null ? null : this.findProject(f);
            return CachedValueProvider.Result.create((Object)result, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
    }

    @Nullable
    public Module findModule(@NotNull MavenProject project2) {
        if (project2 == null) {
            MavenProjectsManager.$$$reportNull$$$0(34);
        }
        if (!this.isInitialized()) {
            return null;
        }
        return ProjectRootManager.getInstance((Project)this.myProject).getFileIndex().getModuleForFile(project2.getFile());
    }

    @NotNull
    public Collection<MavenProject> findInheritors(@Nullable MavenProject parent) {
        if (parent == null || !this.isInitialized()) {
            List<MavenProject> list = Collections.emptyList();
            if (list == null) {
                MavenProjectsManager.$$$reportNull$$$0(35);
            }
            return list;
        }
        Collection<MavenProject> collection = this.myProjectsTree.findInheritors(parent);
        if (collection == null) {
            MavenProjectsManager.$$$reportNull$$$0(36);
        }
        return collection;
    }

    @Nullable
    public MavenProject findContainingProject(@NotNull VirtualFile file) {
        if (file == null) {
            MavenProjectsManager.$$$reportNull$$$0(37);
        }
        if (!this.isInitialized()) {
            return null;
        }
        Module module = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex().getModuleForFile(file);
        return module == null ? null : this.findProject(module);
    }

    @Nullable
    private VirtualFile findPomFile(@NotNull Module module, @NotNull MavenModelsProvider modelsProvider) {
        String pomFileUrl;
        if (module == null) {
            MavenProjectsManager.$$$reportNull$$$0(38);
        }
        if (modelsProvider == null) {
            MavenProjectsManager.$$$reportNull$$$0(39);
        }
        if ((pomFileUrl = MavenPomPathModuleService.getInstance(module).getPomFileUrl()) != null) {
            return VirtualFileManager.getInstance().findFileByUrl(pomFileUrl);
        }
        for (VirtualFile root : modelsProvider.getContentRoots(module)) {
            List pomFiles = MavenUtil.streamPomFiles(module.getProject(), root).collect(Collectors.toList());
            if (pomFiles.isEmpty()) continue;
            if (pomFiles.size() == 1) {
                return (VirtualFile)pomFiles.get(0);
            }
            for (VirtualFile file : pomFiles) {
                if (module.getName().equals(file.getNameWithoutExtension())) {
                    return file;
                }
                MavenProject mavenProject2 = this.findProject(file);
                if (mavenProject2 == null || !module.getName().equals(mavenProject2.getMavenId().getArtifactId())) continue;
                return file;
            }
        }
        return null;
    }

    @Nullable
    public MavenProject findAggregator(@NotNull MavenProject mavenProject2) {
        if (mavenProject2 == null) {
            MavenProjectsManager.$$$reportNull$$$0(40);
        }
        if (!this.isInitialized()) {
            return null;
        }
        return this.myProjectsTree.findAggregator(mavenProject2);
    }

    @Nullable
    public MavenProject findRootProject(@NotNull MavenProject mavenProject2) {
        if (mavenProject2 == null) {
            MavenProjectsManager.$$$reportNull$$$0(41);
        }
        if (!this.isInitialized()) {
            return null;
        }
        return this.myProjectsTree.findRootProject(mavenProject2);
    }

    @NotNull
    public List<MavenProject> getModules(@NotNull MavenProject aggregator) {
        if (aggregator == null) {
            MavenProjectsManager.$$$reportNull$$$0(42);
        }
        if (!this.isInitialized()) {
            List<MavenProject> list = Collections.emptyList();
            if (list == null) {
                MavenProjectsManager.$$$reportNull$$$0(43);
            }
            return list;
        }
        List<MavenProject> list = this.myProjectsTree.getModules(aggregator);
        if (list == null) {
            MavenProjectsManager.$$$reportNull$$$0(44);
        }
        return list;
    }

    @NotNull
    public List<String> getIgnoredFilesPaths() {
        if (!this.isInitialized()) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                MavenProjectsManager.$$$reportNull$$$0(45);
            }
            return list;
        }
        List<String> list = this.myProjectsTree.getIgnoredFilesPaths();
        if (list == null) {
            MavenProjectsManager.$$$reportNull$$$0(46);
        }
        return list;
    }

    public void setIgnoredFilesPaths(@NotNull List<String> paths) {
        if (paths == null) {
            MavenProjectsManager.$$$reportNull$$$0(47);
        }
        if (!this.isInitialized()) {
            return;
        }
        this.myProjectsTree.setIgnoredFilesPaths(paths);
    }

    public void removeIgnoredFilesPaths(Collection<String> paths) {
        if (!this.isInitialized()) {
            return;
        }
        this.myProjectsTree.removeIgnoredFilesPaths(paths);
    }

    public boolean getIgnoredState(@NotNull MavenProject project2) {
        if (project2 == null) {
            MavenProjectsManager.$$$reportNull$$$0(48);
        }
        if (!this.isInitialized()) {
            return false;
        }
        return this.myProjectsTree.getIgnoredState(project2);
    }

    public void setIgnoredState(@NotNull List<MavenProject> projects, boolean ignored) {
        if (projects == null) {
            MavenProjectsManager.$$$reportNull$$$0(49);
        }
        if (!this.isInitialized()) {
            return;
        }
        this.myProjectsTree.setIgnoredState(projects, ignored);
    }

    @NotNull
    public List<String> getIgnoredFilesPatterns() {
        if (!this.isInitialized()) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                MavenProjectsManager.$$$reportNull$$$0(50);
            }
            return list;
        }
        List<String> list = this.myProjectsTree.getIgnoredFilesPatterns();
        if (list == null) {
            MavenProjectsManager.$$$reportNull$$$0(51);
        }
        return list;
    }

    public void setIgnoredFilesPatterns(@NotNull List<String> patterns) {
        if (patterns == null) {
            MavenProjectsManager.$$$reportNull$$$0(52);
        }
        if (!this.isInitialized()) {
            return;
        }
        this.myProjectsTree.setIgnoredFilesPatterns(patterns);
    }

    public boolean isIgnored(@NotNull MavenProject project2) {
        if (project2 == null) {
            MavenProjectsManager.$$$reportNull$$$0(53);
        }
        if (!this.isInitialized()) {
            return false;
        }
        return this.myProjectsTree.isIgnored(project2);
    }

    public Set<MavenRemoteRepository> getRemoteRepositories() {
        HashSet<MavenRemoteRepository> result = new HashSet<MavenRemoteRepository>();
        for (MavenProject each : this.getProjects()) {
            result.addAll(each.getRemoteRepositories());
        }
        return result;
    }

    @TestOnly
    public MavenProjectsTree getProjectsTreeForTests() {
        return this.myProjectsTree;
    }

    @ApiStatus.Internal
    public void setProjectsTree(MavenProjectsTree newTree) {
        if (!this.isInitialized()) {
            this.initNew(Collections.emptyList(), MavenExplicitProfiles.NONE);
        }
        this.myProjectsTree = newTree;
        this.myWatcher.setProjectsTree(newTree);
    }

    @ApiStatus.Internal
    @NotNull
    public MavenProjectsTree getProjectsTree() {
        MavenProjectsTree tree = this.myProjectsTree;
        if (tree == null) {
            return new MavenProjectsTree(this.myProject);
        }
        MavenProjectsTree mavenProjectsTree = tree;
        if (mavenProjectsTree == null) {
            MavenProjectsManager.$$$reportNull$$$0(54);
        }
        return mavenProjectsTree;
    }

    private void scheduleUpdateAllProjects(MavenImportSpec spec) {
        this.doScheduleUpdateProjects(List.of(), spec);
    }

    @ApiStatus.Internal
    public AsyncPromise<Void> forceUpdateProjects() {
        return (AsyncPromise)this.doScheduleUpdateProjects(List.of(), MavenImportSpec.EXPLICIT_IMPORT);
    }

    public AsyncPromise<Void> forceUpdateProjects(@NotNull Collection<MavenProject> projects) {
        if (projects == null) {
            MavenProjectsManager.$$$reportNull$$$0(55);
        }
        return (AsyncPromise)this.doScheduleUpdateProjects(projects, MavenImportSpec.EXPLICIT_IMPORT);
    }

    public void forceUpdateAllProjectsOrFindAllAvailablePomFiles() {
        this.forceUpdateAllProjectsOrFindAllAvailablePomFiles(MavenImportSpec.EXPLICIT_IMPORT);
    }

    public void forceUpdateAllProjectsOrFindAllAvailablePomFiles(MavenImportSpec spec) {
        if (!this.isMavenizedProject()) {
            this.addManagedFiles(this.collectAllAvailablePomFiles());
        }
        if (MavenUtil.isLinearImportEnabled()) {
            MavenImportingManager.getInstance(this.myProject).openProjectAndImport(new FilesList(this.myProjectsTree.getExistingManagedFiles()), this.getImportingSettings(), this.getGeneralSettings(), spec);
            return;
        }
        this.doScheduleUpdateProjects(List.of(), spec);
    }

    private Promise<Void> doScheduleUpdateProjects(@NotNull Collection<MavenProject> projects, MavenImportSpec spec) {
        if (projects == null) {
            MavenProjectsManager.$$$reportNull$$$0(56);
        }
        if (MavenUtil.isLinearImportEnabled()) {
            return MavenImportingManager.getInstance(this.myProject).openProjectAndImport(new FilesList(ContainerUtil.map(projects, MavenProject::getFile)), this.getImportingSettings(), this.getGeneralSettings(), spec).getFinishPromise().then(it -> null);
        }
        MavenDistributionsCache.getInstance(this.myProject).cleanCaches();
        MavenWslCache.getInstance().clearCache();
        AsyncPromise promise = new AsyncPromise();
        MavenUtil.runWhenInitialized(this.myProject, (Runnable)((DumbAwareRunnable)() -> {
            if (projects.isEmpty()) {
                this.myWatcher.scheduleUpdateAll(spec).processed((Promise)promise);
            } else {
                this.myWatcher.scheduleUpdate(MavenUtil.collectFiles(projects), Collections.emptyList(), spec).processed((Promise)promise);
            }
        }));
        return promise;
    }

    public Promise<List<Module>> scheduleImportAndResolve() {
        return this.scheduleImportAndResolve(MavenImportSpec.EXPLICIT_IMPORT);
    }

    public Promise<List<Module>> scheduleImportAndResolve(MavenImportSpec spec) {
        MavenSyncConsole console2 = this.getSyncConsole();
        console2.startImport(this.myProgressListener, spec);
        StructuredIdeActivity activity = MavenImportStats.startImportActivity(this.myProject);
        this.fireImportAndResolveScheduled(spec);
        AsyncPromise<List<Module>> promise = this.scheduleResolve();
        promise.onProcessed(m -> this.completeMavenSyncOnImportCompletion(activity));
        return promise;
    }

    private void completeMavenSyncOnImportCompletion(StructuredIdeActivity activity) {
        this.waitForImportCompletion().onProcessed(o -> {
            activity.finished();
            MavenResolveResultProblemProcessor.notifyMavenProblems(this.myProject);
            MavenSyncConsole.finishTransaction(this.myProject);
        });
    }

    public void showServerException(Throwable e) {
        this.getSyncConsole().addException(e, this.myProgressListener);
    }

    public void terminateImport(int exitCode) {
        this.getSyncConsole().terminated(exitCode);
    }

    @ApiStatus.Internal
    public Promise<?> waitForImportCompletion() {
        if (MavenUtil.isLinearImportEnabled()) {
            return MavenImportingManager.getInstance(this.myProject).getImportFinishPromise();
        }
        AsyncPromise promise = new AsyncPromise();
        MavenUtil.runInBackground(this.myProject, SyncBundle.message("maven.sync.waiting.for.completion", new Object[0]), false, indicator -> {
            if (this.myReadingProcessor != null) {
                this.myReadingProcessor.waitForCompletion();
            }
            if (this.myArtifactsDownloadingProcessor != null) {
                this.myArtifactsDownloadingProcessor.waitForCompletion();
            }
            if (this.myFoldersResolvingProcessor != null) {
                this.myFoldersResolvingProcessor.waitForCompletion();
            }
            if (this.myPluginsResolvingProcessor != null) {
                this.myPluginsResolvingProcessor.waitForCompletion();
            }
            if (this.myResolvingProcessor != null) {
                this.myResolvingProcessor.waitForCompletion();
            }
            if (this.myPostProcessor != null) {
                this.myPostProcessor.waitForCompletion();
            }
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                MavenProgressIndicator.MavenProgressTracker mavenProgressTracker = (MavenProgressIndicator.MavenProgressTracker)this.myProject.getServiceIfCreated(MavenProgressIndicator.MavenProgressTracker.class);
                if (mavenProgressTracker != null) {
                    mavenProgressTracker.waitForProgressCompletion();
                }
                promise.setResult(null);
            });
        });
        return promise;
    }

    private AsyncPromise<List<Module>> scheduleResolve() {
        AsyncPromise result = new AsyncPromise();
        this.runWhenFullyOpen(() -> {
            LinkedHashSet<MavenProject> toResolve;
            Object object = this.myImportingDataLock;
            synchronized (object) {
                toResolve = new LinkedHashSet<MavenProject>(this.myProjectsToResolve);
                this.myProjectsToResolve.clear();
            }
            if (toResolve.isEmpty()) {
                result.setResult(Collections.emptyList());
                this.fireProjectImportCompleted();
                return;
            }
            ResolveContext context = new ResolveContext();
            Runnable onCompletion = () -> {
                if (this.hasScheduledProjects()) {
                    this.scheduleImport().processed((Promise)result);
                } else {
                    result.setResult(Collections.emptyList());
                    this.fireProjectImportCompleted();
                }
            };
            boolean useSinglePomResolver = Boolean.getBoolean("idea.maven.use.single.pom.resolver");
            if (useSinglePomResolver) {
                Iterator it = toResolve.iterator();
                while (it.hasNext()) {
                    MavenProject each = (MavenProject)it.next();
                    this.myResolvingProcessor.scheduleTask(new MavenProjectsProcessorResolvingTask(Collections.singleton(each), this.myProjectsTree, this.getGeneralSettings(), it.hasNext() ? null : onCompletion, context));
                }
            } else {
                this.myResolvingProcessor.scheduleTask(new MavenProjectsProcessorResolvingTask(toResolve, this.myProjectsTree, this.getGeneralSettings(), onCompletion, context));
            }
        });
        return result;
    }

    public void evaluateEffectivePom(final @NotNull MavenProject mavenProject2, final @NotNull NullableConsumer<? super String> consumer) {
        if (mavenProject2 == null) {
            MavenProjectsManager.$$$reportNull$$$0(57);
        }
        if (consumer == null) {
            MavenProjectsManager.$$$reportNull$$$0(58);
        }
        this.runWhenFullyOpen(() -> this.myResolvingProcessor.scheduleTask(new MavenProjectsProcessorTask(){

            @Override
            public void perform(Project project2, MavenEmbeddersManager embeddersManager, MavenConsole console2, MavenProgressIndicator indicator) throws MavenProcessCanceledException {
                indicator.setText(MavenProjectBundle.message("maven.project.importing.evaluating.effective.pom", new Object[0]));
                MavenProjectsManager.this.myMavenProjectResolver.executeWithEmbedder(mavenProject2, MavenProjectsManager.this.getEmbeddersManager(), MavenEmbeddersManager.FOR_DEPENDENCIES_RESOLVE, console2, indicator, new MavenProjectResolver.EmbedderTask(){

                    @Override
                    public void run(MavenEmbedderWrapper embedder) throws MavenProcessCanceledException {
                        try {
                            MavenExplicitProfiles profiles2 = mavenProject2.getActivatedProfilesIds();
                            VirtualFile virtualFile = mavenProject2.getFile();
                            File projectFile = MavenWslUtil.resolveWslAware(MavenProjectsManager.this.myProject, () -> new File(virtualFile.getPath()), wsl -> MavenWslUtil.getWslFile(wsl, new File(virtualFile.getPath())));
                            String res = embedder.evaluateEffectivePom(projectFile, (Collection<String>)profiles2.getEnabledProfiles(), (Collection<String>)profiles2.getDisabledProfiles());
                            consumer.consume((Object)res);
                        }
                        catch (UnsupportedOperationException e) {
                            e.printStackTrace();
                            consumer.consume(null);
                        }
                    }
                });
            }
        }));
    }

    @TestOnly
    public void scheduleResolveInTests(Collection<MavenProject> projects) {
        this.scheduleForNextResolve(projects);
        this.scheduleResolve();
    }

    @TestOnly
    public void scheduleResolveAllInTests() {
        this.scheduleResolveInTests(this.getProjects());
    }

    public void scheduleFoldersResolve(Collection<MavenProject> projects) {
        this.runWhenFullyOpen(() -> {
            Iterator it = projects.iterator();
            while (it.hasNext()) {
                MavenProject each = (MavenProject)it.next();
                Runnable onCompletion = it.hasNext() ? null : () -> {
                    if (this.hasScheduledProjects()) {
                        this.scheduleImport();
                    }
                };
                this.myFoldersResolvingProcessor.scheduleTask(new MavenProjectsProcessorFoldersResolvingTask(each, this.getImportingSettings(), this.myProjectsTree, onCompletion));
            }
        });
    }

    public void scheduleFoldersResolveForAllProjects() {
        this.scheduleFoldersResolve(this.getProjects());
    }

    private void schedulePluginsResolve(MavenProject project2, NativeMavenProjectHolder nativeMavenProject) {
        this.runWhenFullyOpen(() -> this.myPluginsResolvingProcessor.scheduleTask(new MavenProjectsProcessorPluginsResolvingTask(project2, nativeMavenProject, this.myProjectsTree, this.forceUpdateSnapshots)));
    }

    public void scheduleArtifactsDownloading(Collection<MavenProject> projects, @Nullable Collection<MavenArtifact> artifacts, boolean sources, boolean docs, @Nullable AsyncPromise<MavenArtifactDownloader.DownloadResult> result) {
        if (!sources && !docs) {
            return;
        }
        this.runWhenFullyOpen(() -> this.myArtifactsDownloadingProcessor.scheduleTask(new MavenProjectsProcessorArtifactsDownloadingTask(projects, artifacts, this.myMavenProjectResolver, sources, docs, (AsyncPromise<? super MavenArtifactDownloader.DownloadResult>)result)));
    }

    private void scheduleImportSettings() {
        this.scheduleImportSettings(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleImportSettings(boolean importModuleGroupsRequired) {
        Object object = this.myImportingDataLock;
        synchronized (object) {
            this.myImportModuleGroupsRequired = importModuleGroupsRequired;
        }
        this.scheduleImport();
    }

    private Promise<List<Module>> scheduleImport() {
        final AsyncPromise result = new AsyncPromise();
        this.runWhenFullyOpen(() -> this.myImportingQueue.queue(new Update(this){

            public void run() {
                result.setResult(MavenProjectsManager.this.importProjects());
                MavenProjectsManager.this.fireProjectImportCompleted();
            }
        }));
        return result;
    }

    private void scheduleAllProjectImport() {
        this.runWhenFullyOpen(() -> this.myImportingQueue.queue(new Update(this){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object = MavenProjectsManager.this.myImportingDataLock;
                synchronized (object) {
                    for (MavenProject project2 : MavenProjectsManager.this.getProjectsTree().getProjects()) {
                        MavenProjectsManager.this.myProjectsToImport.put(project2, MavenProjectChanges.ALL);
                    }
                }
                MavenProjectsManager.this.importProjects();
                MavenProjectsManager.this.fireProjectImportCompleted();
            }
        }));
    }

    @TestOnly
    public void scheduleImportInTests(List<VirtualFile> projectFiles) {
        ArrayList<Pair<MavenProject, MavenProjectChanges>> toImport = new ArrayList<Pair<MavenProject, MavenProjectChanges>>();
        for (VirtualFile each : projectFiles) {
            MavenProject project2 = this.findProject(each);
            if (project2 == null) continue;
            toImport.add((Pair<MavenProject, MavenProjectChanges>)Pair.create((Object)project2, (Object)MavenProjectChanges.ALL));
        }
        this.scheduleForNextImport(toImport);
        this.scheduleImport();
    }

    private void scheduleForNextImport(Pair<MavenProject, MavenProjectChanges> projectWithChanges) {
        this.scheduleForNextImport(Collections.singletonList(projectWithChanges));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleForNextImport(Collection<Pair<MavenProject, MavenProjectChanges>> projectsWithChanges) {
        Object object = this.myImportingDataLock;
        synchronized (object) {
            for (Pair<MavenProject, MavenProjectChanges> each : projectsWithChanges) {
                MavenProjectChanges changes = ((MavenProjectChanges)each.second).mergedWith(this.myProjectsToImport.get(each.first));
                this.myProjectsToImport.put((MavenProject)each.first, changes);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleForNextResolve(Collection<MavenProject> projects) {
        Object object = this.myImportingDataLock;
        synchronized (object) {
            this.myProjectsToResolve.addAll(projects);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasScheduledProjects() {
        if (!this.isInitialized()) {
            return false;
        }
        Object object = this.myImportingDataLock;
        synchronized (object) {
            return !this.myProjectsToImport.isEmpty() || !this.myProjectsToResolve.isEmpty();
        }
    }

    @TestOnly
    public boolean hasScheduledImportsInTests() {
        if (!this.isInitialized()) {
            return false;
        }
        return !this.myImportingQueue.isEmpty();
    }

    @TestOnly
    public void performScheduledImportInTests() {
        if (!this.isInitialized()) {
            return;
        }
        this.runWhenFullyOpen(() -> this.myImportingQueue.flush());
    }

    private void runWhenFullyOpen(Runnable runnable) {
        if (!this.isInitialized()) {
            return;
        }
        if (this.isNoBackgroundMode()) {
            runnable.run();
            return;
        }
        Ref wrapper = new Ref();
        wrapper.set(() -> {
            if (!StartupManagerEx.getInstanceEx((Project)this.myProject).postStartupActivityPassed()) {
                this.myInitializationAlarm.addRequest((Runnable)wrapper.get(), 1000);
                return;
            }
            runnable.run();
        });
        MavenUtil.runWhenInitialized(this.myProject, (Runnable)wrapper.get());
    }

    private void schedulePostImportTasks(List<MavenProjectsProcessorTask> postTasks) {
        for (MavenProjectsProcessorTask each : postTasks) {
            this.myPostProcessor.scheduleTask(each);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unscheduleAllTasks(List<MavenProject> projects) {
        for (MavenProject each : projects) {
            MavenProjectsProcessorEmptyTask dummyTask = new MavenProjectsProcessorEmptyTask(each);
            Object object = this.myImportingDataLock;
            synchronized (object) {
                this.myProjectsToImport.remove(each);
                this.myProjectsToResolve.remove(each);
            }
            this.myResolvingProcessor.removeTask(dummyTask);
            this.myPluginsResolvingProcessor.removeTask(dummyTask);
            this.myFoldersResolvingProcessor.removeTask(dummyTask);
            this.myPostProcessor.removeTask(dummyTask);
        }
    }

    @TestOnly
    public void unscheduleAllTasksInTests() {
        this.unscheduleAllTasks(this.getProjects());
    }

    public void waitForReadingCompletion() {
        this.waitForTasksCompletion(null);
    }

    public void waitForResolvingCompletion() {
        this.waitForTasksCompletion(this.myResolvingProcessor);
    }

    public void waitForFoldersResolvingCompletion() {
        this.waitForTasksCompletion(this.myFoldersResolvingProcessor);
    }

    public void waitForPluginsResolvingCompletion() {
        this.waitForTasksCompletion(this.myPluginsResolvingProcessor);
    }

    public void waitForArtifactsDownloadingCompletion() {
        this.waitForTasksCompletion(this.myArtifactsDownloadingProcessor);
    }

    public void waitForPostImportTasksCompletion() {
        this.myPostProcessor.waitForCompletion();
    }

    private void waitForTasksCompletion(MavenProjectsProcessor processor) {
        if (ApplicationManager.getApplication().isDispatchThread()) {
            FileDocumentManager.getInstance().saveAllDocuments();
        }
        this.myReadingProcessor.waitForCompletion();
        if (processor != null) {
            processor.waitForCompletion();
        }
    }

    public void updateProjectTargetFolders() {
        ApplicationManager.getApplication().invokeLater(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            MavenFoldersImporter.updateProjectFolders(this.myProject, true);
            VirtualFileManager.getInstance().asyncRefresh(null);
        });
    }

    public List<Module> importProjects() {
        return this.importProjects(ProjectDataManager.getInstance().createModifiableModelsProvider(this.myProject));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Module> importProjects(IdeModifiableModelsProvider modelsProvider) {
        List<Module> createdModules;
        boolean importModuleGroupsRequired;
        Map<MavenProject, MavenProjectChanges> projectsToImportWithChanges;
        Object object = this.myImportingDataLock;
        synchronized (object) {
            projectsToImportWithChanges = Collections.unmodifiableMap(new LinkedHashMap<MavenProject, MavenProjectChanges>(this.myProjectsToImport));
            this.myProjectsToImport.clear();
            importModuleGroupsRequired = this.myImportModuleGroupsRequired;
            this.myImportModuleGroupsRequired = false;
        }
        Ref importer = new Ref();
        Ref postTasks = new Ref();
        final Runnable r = () -> {
            StructuredIdeActivity activity = ExternalSystemStatUtilKt.importActivityStarted((Project)this.myProject, (ProjectSystemId)MavenUtil.SYSTEM_ID, () -> Collections.singletonList(ProjectImportCollector.TASK_CLASS.with(MavenImportStats.ImportingTaskOld.class)));
            try {
                MavenProjectImporter projectImporter = MavenProjectImporter.createImporter(this.myProject, this.myProjectsTree, projectsToImportWithChanges, importModuleGroupsRequired, modelsProvider, this.getImportingSettings(), this.myDummyModule, activity);
                importer.set((Object)projectImporter);
                postTasks.set(projectImporter.importProject());
            }
            finally {
                activity.finished();
            }
        };
        if (ApplicationManager.getApplication().isDispatchThread()) {
            r.run();
        } else {
            MavenUtil.runInBackground(this.myProject, MavenProjectBundle.message("maven.project.importing", new Object[0]), false, new MavenTask(){

                @Override
                public void run(MavenProgressIndicator indicator) {
                    r.run();
                }
            }).waitFor();
        }
        VirtualFileManager fm = VirtualFileManager.getInstance();
        if (this.isNoBackgroundMode() && !CoreProgressManager.shouldKeepTasksAsynchronousInHeadlessMode()) {
            ApplicationManager.getApplication().invokeAndWait(() -> fm.syncRefresh());
        } else {
            fm.asyncRefresh(null);
        }
        if (postTasks.get() != null) {
            this.schedulePostImportTasks((List)postTasks.get());
        }
        this.myImportingQueue.restartTimer();
        MavenProjectImporter projectImporter = (MavenProjectImporter)importer.get();
        List<Object> list = createdModules = projectImporter == null ? Collections.emptyList() : projectImporter.createdModules();
        if (!projectsToImportWithChanges.isEmpty()) {
            ((MavenImportListener)this.myProject.getMessageBus().syncPublisher(MavenImportListener.TOPIC)).importFinished(projectsToImportWithChanges.keySet(), createdModules);
        }
        return createdModules;
    }

    @ApiStatus.Internal
    public Map<VirtualFile, Module> getFileToModuleMapping(MavenModelsProvider modelsProvider) {
        HashMap<VirtualFile, Module> result = new HashMap<VirtualFile, Module>();
        for (Module each : modelsProvider.getModules()) {
            VirtualFile f = this.findPomFile(each, modelsProvider);
            if (f == null) continue;
            result.put(f, each);
        }
        return result;
    }

    @ApiStatus.Internal
    public List<VirtualFile> collectAllAvailablePomFiles() {
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>(this.getFileToModuleMapping(new MavenDefaultModelsProvider(this.myProject)).keySet());
        MavenUtil.streamPomFiles(this.myProject, this.myProject.getBaseDir()).forEach(result::add);
        return result;
    }

    public void addManagerListener(Listener listener2) {
        this.myManagerListeners.add(listener2);
    }

    public void addManagerListener(Listener listener2, @NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            MavenProjectsManager.$$$reportNull$$$0(59);
        }
        this.myManagerListeners.add(listener2);
        Disposer.register((Disposable)parentDisposable, () -> this.myManagerListeners.remove(listener2));
    }

    public void addProjectsTreeListener(MavenProjectsTree.Listener listener2) {
        this.myProjectsTreeDispatcher.addListener((EventListener)listener2, (Disposable)this);
    }

    public void addProjectsTreeListener(@NotNull MavenProjectsTree.Listener listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            MavenProjectsManager.$$$reportNull$$$0(60);
        }
        if (parentDisposable == null) {
            MavenProjectsManager.$$$reportNull$$$0(61);
        }
        this.myProjectsTreeDispatcher.addListener((EventListener)listener2, parentDisposable);
    }

    @TestOnly
    public void fireActivatedInTests() {
        this.fireActivated();
    }

    private void fireActivated() {
        for (Listener each : this.myManagerListeners) {
            each.activated();
        }
    }

    private void fireProjectScheduled() {
        for (Listener each : this.myManagerListeners) {
            each.projectsScheduled();
        }
    }

    private void fireImportAndResolveScheduled(MavenImportSpec spec) {
        ((MavenImportListener)this.myProject.getMessageBus().syncPublisher(MavenImportListener.TOPIC)).importStarted(spec);
        for (Listener each : this.myManagerListeners) {
            each.importAndResolveScheduled();
        }
    }

    private void fireProjectImportCompleted() {
        for (Listener each : this.myManagerListeners) {
            each.projectImportCompleted();
        }
    }

    public void setForceUpdateSnapshots(boolean forceUpdateSnapshots) {
        this.forceUpdateSnapshots = forceUpdateSnapshots;
    }

    public boolean getForceUpdateSnapshots() {
        return this.forceUpdateSnapshots;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 35: 
            case 36: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 50: 
            case 51: 
            case 54: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 35: 
            case 36: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 50: 
            case 51: 
            case 54: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectFileIndex";
                break;
            }
            case 5: 
            case 49: 
            case 55: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projects";
                break;
            }
            case 7: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 35: 
            case 36: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 50: 
            case 51: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/project/MavenProjectsManager";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "m";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 12: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "f";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profiles";
                break;
            }
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifact";
                break;
            }
            case 32: 
            case 33: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelsProvider";
                break;
            }
            case 40: 
            case 41: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mavenProject";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aggregator";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patterns";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 59: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/project/MavenProjectsManager";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectsTreesDir";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getExplicitProfiles";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableProfiles";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getProfilesWithStates";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjects";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootProjects";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getNonIgnoredProjects";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectsFiles";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "findInheritors";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getModules";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getIgnoredFilesPaths";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "getIgnoredFilesPatterns";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectsTree";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInstanceIfCreated";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getFilterConfigCrc";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "updateTabName";
                break;
            }
            case 7: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 35: 
            case 36: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 50: 
            case 51: 
            case 54: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isMavenizedModule";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addManagedFiles";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addManagedFilesOrUnignore";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "removeManagedFiles";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isManagedFile";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setExplicitProfiles";
                break;
            }
            case 28: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "findProject";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "findSingleProjectInReactor";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getMavenProject";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "findModule";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "findContainingProject";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "findPomFile";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "findAggregator";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "findRootProject";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getModules";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "setIgnoredFilesPaths";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getIgnoredState";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "setIgnoredState";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "setIgnoredFilesPatterns";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "isIgnored";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "forceUpdateProjects";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "doScheduleUpdateProjects";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "evaluateEffectivePom";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "addManagerListener";
                break;
            }
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "addProjectsTreeListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 35: 
            case 36: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 50: 
            case 51: 
            case 54: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ExternalWatcherContributor
    implements ExternalSystemProjectsWatcherImpl.Contributor {
        public void markDirtyAllExternalProjects(@NotNull Project project2) {
            if (project2 == null) {
                ExternalWatcherContributor.$$$reportNull$$$0(0);
            }
            ExternalWatcherContributor.runWhenFullyOpen(project2, manager -> manager.doScheduleUpdateProjects(List.of(), new MavenImportSpec(true, false, false)));
        }

        public void markDirty(@NotNull Module module) {
            if (module == null) {
                ExternalWatcherContributor.$$$reportNull$$$0(1);
            }
            ExternalWatcherContributor.runWhenFullyOpen(module.getProject(), manager -> {
                MavenProject mavenProject2 = manager.findProject(module);
                if (mavenProject2 != null) {
                    manager.doScheduleUpdateProjects(Collections.singletonList(mavenProject2), new MavenImportSpec(true, false, false));
                }
            });
        }

        private static void runWhenFullyOpen(@NotNull Project project2, @NotNull Consumer<MavenProjectsManager> consumer) {
            if (project2 == null) {
                ExternalWatcherContributor.$$$reportNull$$$0(2);
            }
            if (consumer == null) {
                ExternalWatcherContributor.$$$reportNull$$$0(3);
            }
            MavenProjectsManager manager = MavenProjectsManager.getInstance(project2);
            manager.runWhenFullyOpen(() -> consumer.accept(manager));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "consumer";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/idea/maven/project/MavenProjectsManager$ExternalWatcherContributor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "markDirtyAllExternalProjects";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "markDirty";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "runWhenFullyOpen";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface Listener {
        default public void activated() {
        }

        default public void projectsScheduled() {
        }

        default public void importAndResolveScheduled() {
        }

        default public void projectImportCompleted() {
        }
    }
}

