/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project.actions;

import com.intellij.lang.Language;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.util.NullableConsumer;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectBundle;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.server.MavenServerManager;
import org.jetbrains.idea.maven.utils.MavenUtil;
import org.jetbrains.idea.maven.utils.actions.MavenActionUtil;

public class MavenShowEffectivePom
extends AnAction
implements DumbAware {
    private static final Logger LOG = Logger.getInstance(MavenShowEffectivePom.class);

    public static void actionPerformed(@NotNull Project project2, @NotNull VirtualFile file) {
        if (project2 == null) {
            MavenShowEffectivePom.$$$reportNull$$$0(0);
        }
        if (file == null) {
            MavenShowEffectivePom.$$$reportNull$$$0(1);
        }
        MavenProjectsManager manager = MavenProjectsManager.getInstance(project2);
        MavenProject mavenProject2 = manager.findProject(file);
        assert (mavenProject2 != null);
        manager.evaluateEffectivePom(mavenProject2, (NullableConsumer<? super String>)((NullableConsumer)s -> ApplicationManager.getApplication().invokeLater(() -> {
            if (project2.isDisposed()) {
                return;
            }
            if (s == null) {
                new Notification("Maven", MavenProjectBundle.message("maven.effective.pom.failed.title", new Object[0]), MavenProjectBundle.message("maven.effective.pom.failed", new Object[0]), NotificationType.ERROR).notify(project2);
                return;
            }
            String fileName = mavenProject2.getMavenId().getArtifactId() + "-effective-pom.xml";
            PsiFile file1 = PsiFileFactory.getInstance((Project)project2).createFileFromText(fileName, (Language)XMLLanguage.INSTANCE, (CharSequence)s);
            try {
                file1.getVirtualFile().setWritable(false);
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
            file1.navigate(true);
        })));
    }

    @Nullable
    private static VirtualFile findPomXml(@NotNull DataContext dataContext) {
        VirtualFile file;
        if (dataContext == null) {
            MavenShowEffectivePom.$$$reportNull$$$0(2);
        }
        if ((file = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(dataContext)) == null) {
            return null;
        }
        if (file.isDirectory() && (file = (VirtualFile)MavenUtil.streamPomFiles(MavenActionUtil.getProject(dataContext), file).findFirst().orElse(null)) == null) {
            return null;
        }
        MavenProjectsManager manager = MavenActionUtil.getProjectsManager(dataContext);
        if (manager == null) {
            return null;
        }
        MavenProject mavenProject2 = manager.findProject(file);
        if (mavenProject2 == null) {
            return null;
        }
        return file;
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        Project project2;
        if (event == null) {
            MavenShowEffectivePom.$$$reportNull$$$0(3);
        }
        if ((project2 = MavenActionUtil.getProject(event.getDataContext())) == null) {
            return;
        }
        VirtualFile file = MavenShowEffectivePom.findPomXml(event.getDataContext());
        if (file == null) {
            return;
        }
        if (!MavenServerManager.getInstance().isUseMaven2()) {
            MavenShowEffectivePom.actionPerformed(project2, file);
        }
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            MavenShowEffectivePom.$$$reportNull$$$0(4);
        }
        Presentation p = e.getPresentation();
        boolean visible = MavenShowEffectivePom.findPomXml(e.getDataContext()) != null;
        visible = visible && !MavenServerManager.getInstance().isUseMaven2();
        p.setVisible(visible);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            MavenShowEffectivePom.$$$reportNull$$$0(5);
        }
        return actionUpdateThread;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/project/actions/MavenShowEffectivePom";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/project/actions/MavenShowEffectivePom";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findPomXml";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

