/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental;

import com.intellij.util.containers.Interner;
import com.intellij.util.containers.MultiMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.incremental.LookupSymbol;
import org.jetbrains.kotlin.incremental.components.LookupTracker;
import org.jetbrains.kotlin.incremental.components.Position;
import org.jetbrains.kotlin.incremental.components.ScopeKind;
import org.jetbrains.kotlin.utils.PlatformUtilsKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J0\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u00062\u0006\u0010/\u001a\u00020\u001a2\u0006\u00100\u001a\u00020\u00062\u0006\u00101\u001a\u00020#2\u0006\u00102\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u0007\u001a#\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t\u0012\f\u0012\n \n*\u0004\u0018\u00010\u00060\u00060\b\u00a2\u0006\u0002\b\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0013\"\u0004\b\u0018\u0010\u0015R\u001c\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u0013\"\u0004\b!\u0010\u0015R\u001c\u0010\"\u001a\u0004\u0018\u00010#X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u0014\u0010(\u001a\u00020)8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010+\u00a8\u00063"}, d2={"Lorg/jetbrains/kotlin/incremental/LookupTrackerImpl;", "Lorg/jetbrains/kotlin/incremental/components/LookupTracker;", "delegate", "(Lorg/jetbrains/kotlin/incremental/components/LookupTracker;)V", "interner", "Lcom/intellij/util/containers/Interner;", "", "lookups", "Lcom/intellij/util/containers/MultiMap;", "Lorg/jetbrains/kotlin/incremental/LookupSymbol;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getLookups", "()Lcom/intellij/util/containers/MultiMap;", "pathInterner", "getPathInterner", "()Lcom/intellij/util/containers/Interner;", "prevFilePath", "getPrevFilePath", "()Ljava/lang/String;", "setPrevFilePath", "(Ljava/lang/String;)V", "prevName", "getPrevName", "setPrevName", "prevPosition", "Lorg/jetbrains/kotlin/incremental/components/Position;", "getPrevPosition", "()Lorg/jetbrains/kotlin/incremental/components/Position;", "setPrevPosition", "(Lorg/jetbrains/kotlin/incremental/components/Position;)V", "prevScopeFqName", "getPrevScopeFqName", "setPrevScopeFqName", "prevScopeKind", "Lorg/jetbrains/kotlin/incremental/components/ScopeKind;", "getPrevScopeKind", "()Lorg/jetbrains/kotlin/incremental/components/ScopeKind;", "setPrevScopeKind", "(Lorg/jetbrains/kotlin/incremental/components/ScopeKind;)V", "requiresPosition", "", "getRequiresPosition", "()Z", "record", "", "filePath", "position", "scopeFqName", "scopeKind", "name", "kotlin-build-common"})
public final class LookupTrackerImpl
implements LookupTracker {
    @NotNull
    private final LookupTracker delegate;
    @NotNull
    private final MultiMap<LookupSymbol, String> lookups;
    @NotNull
    private final Interner<String> pathInterner;
    @NotNull
    private final Interner<String> interner;
    @NotNull
    private String prevFilePath;
    @Nullable
    private Position prevPosition;
    @NotNull
    private String prevScopeFqName;
    @Nullable
    private ScopeKind prevScopeKind;
    @NotNull
    private String prevName;

    public LookupTrackerImpl(@NotNull LookupTracker delegate) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        this.delegate = delegate;
        MultiMap multiMap = MultiMap.createSet();
        Intrinsics.checkNotNullExpressionValue((Object)multiMap, (String)"createSet<LookupSymbol, String>()");
        this.lookups = multiMap;
        this.pathInterner = PlatformUtilsKt.createStringInterner();
        this.interner = PlatformUtilsKt.createStringInterner();
        this.prevFilePath = "";
        this.prevScopeFqName = "";
        this.prevName = "";
    }

    @NotNull
    public final MultiMap<LookupSymbol, String> getLookups() {
        return this.lookups;
    }

    @NotNull
    public final Interner<String> getPathInterner() {
        return this.pathInterner;
    }

    @Override
    public boolean getRequiresPosition() {
        return this.delegate.getRequiresPosition();
    }

    @NotNull
    public final String getPrevFilePath() {
        return this.prevFilePath;
    }

    public final void setPrevFilePath(@NotNull String string2) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"<set-?>");
        this.prevFilePath = string2;
    }

    @Nullable
    public final Position getPrevPosition() {
        return this.prevPosition;
    }

    public final void setPrevPosition(@Nullable Position position) {
        this.prevPosition = position;
    }

    @NotNull
    public final String getPrevScopeFqName() {
        return this.prevScopeFqName;
    }

    public final void setPrevScopeFqName(@NotNull String string2) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"<set-?>");
        this.prevScopeFqName = string2;
    }

    @Nullable
    public final ScopeKind getPrevScopeKind() {
        return this.prevScopeKind;
    }

    public final void setPrevScopeKind(@Nullable ScopeKind scopeKind) {
        this.prevScopeKind = scopeKind;
    }

    @NotNull
    public final String getPrevName() {
        return this.prevName;
    }

    public final void setPrevName(@NotNull String string2) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"<set-?>");
        this.prevName = string2;
    }

    @Override
    public void record(@NotNull String filePath, @NotNull Position position, @NotNull String scopeFqName, @NotNull ScopeKind scopeKind, @NotNull String name) {
        boolean lookupChanged;
        boolean bl;
        boolean fqNameChanged;
        boolean bl2;
        boolean nameChanged;
        boolean bl3;
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)scopeFqName, (String)"scopeFqName");
        Intrinsics.checkNotNullParameter((Object)((Object)scopeKind), (String)"scopeKind");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (!Intrinsics.areEqual((Object)name, (Object)this.prevName)) {
            Object object = this.interner.intern((Object)name);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"interner.intern(name)");
            this.prevName = (String)object;
            bl3 = true;
        } else {
            bl3 = nameChanged = false;
        }
        if (!Intrinsics.areEqual((Object)scopeFqName, (Object)this.prevScopeFqName)) {
            Object object = this.interner.intern((Object)scopeFqName);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"interner.intern(scopeFqName)");
            this.prevScopeFqName = (String)object;
            bl2 = true;
        } else {
            bl2 = fqNameChanged = false;
        }
        if (!Intrinsics.areEqual((Object)filePath, (Object)this.prevFilePath)) {
            Object object = this.pathInterner.intern((Object)filePath);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"pathInterner.intern(filePath)");
            this.prevFilePath = (String)object;
            bl = true;
        } else {
            bl = false;
        }
        boolean filePathChanged = bl;
        boolean bl4 = lookupChanged = nameChanged || fqNameChanged || filePathChanged;
        if (lookupChanged) {
            this.lookups.putValue((Object)new LookupSymbol(this.prevName, this.prevScopeFqName), (Object)this.prevFilePath);
        }
        if (lookupChanged || !Intrinsics.areEqual((Object)this.prevPosition, (Object)position) || this.prevScopeKind != scopeKind) {
            this.prevPosition = position;
            this.prevScopeKind = scopeKind;
            this.delegate.record(this.prevFilePath, position, this.prevScopeFqName, scopeKind, this.prevName);
        }
    }
}

