/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.codegen;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Processor;
import com.intellij.util.concurrency.annotations.RequiresWriteLock;
import com.intellij.workspaceModel.codegen.CodeWriterKt;
import com.intellij.workspaceModel.codegen.TypeKt;
import com.intellij.workspaceModel.codegen.deft.model.DefType;
import com.intellij.workspaceModel.codegen.deft.model.KtFile;
import com.intellij.workspaceModel.codegen.deft.model.KtObjModule;
import com.intellij.workspaceModel.codegen.patcher.RewriteKt;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.deft.Type;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004H\u0002J0\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e2\u000e\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0010H\u0007J&\u0010\b\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000e\u00a8\u0006\u0016"}, d2={"Lcom/intellij/workspaceModel/codegen/CodeWriter;", "", "()V", "createPackageFolderIfMissing", "Lcom/intellij/openapi/vfs/VirtualFile;", "sourceRoot", "sourceFile", "genFolder", "generate", "", "project", "Lcom/intellij/openapi/project/Project;", "sourceFolder", "keepUnknownFields", "", "targetFolderGenerator", "Lkotlin/Function0;", "dir", "Ljava/io/File;", "fromDirectory", "", "generatedDestDir", "intellij.platform.workspaceModel.codegen"})
public final class CodeWriter {
    @NotNull
    public static final CodeWriter INSTANCE;

    /*
     * WARNING - void declaration
     */
    @RequiresWriteLock
    public final void generate(@NotNull Project project, @NotNull VirtualFile sourceFolder, boolean keepUnknownFields, @NotNull Function0<? extends VirtualFile> targetFolderGenerator) {
        void $this$filterNotTo$iv$iv;
        Object $dstr$vfu$document;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)sourceFolder, (String)"sourceFolder");
        Intrinsics.checkNotNullParameter(targetFolderGenerator, (String)"targetFolderGenerator");
        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)fileDocumentManager, (String)"FileDocumentManager.getInstance()");
        FileDocumentManager documentManager = fileDocumentManager;
        List ktSrcs = new ArrayList();
        Map fileMapping = new LinkedHashMap();
        VfsUtilCore.processFilesRecursively((VirtualFile)sourceFolder, (Processor)new Processor(documentManager, ktSrcs, fileMapping){
            final /* synthetic */ FileDocumentManager $documentManager;
            final /* synthetic */ List $ktSrcs;
            final /* synthetic */ Map $fileMapping;

            public final boolean process(VirtualFile it) {
                VirtualFile virtualFile = it;
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"it");
                if (Intrinsics.areEqual((Object)virtualFile.getExtension(), (Object)"kt")) {
                    Document document = this.$documentManager.getDocument(it);
                    if (document == null) {
                        return true;
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)document, (String)"documentManager.getDocum\u2026cessFilesRecursively true");
                    Document document2 = document;
                    this.$ktSrcs.add(TuplesKt.to((Object)it, (Object)document2));
                    String string = it.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name");
                    this.$fileMapping.put(string, it);
                }
                return true;
            }
            {
                this.$documentManager = fileDocumentManager;
                this.$ktSrcs = list2;
                this.$fileMapping = map;
            }
        });
        KtObjModule module = new KtObjModule(project, keepUnknownFields);
        Iterable $this$forEach$iv = ktSrcs;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void vfu;
            $dstr$vfu$document = (Pair)element$iv;
            boolean bl = false;
            VirtualFile virtualFile = (VirtualFile)$dstr$vfu$document.component1();
            Document document = (Document)$dstr$vfu$document.component2();
            String string = vfu.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"vfu.name");
            module.addPsiFile(string, (VirtualFile)vfu, (Function0<String>)((Function0)new Function0<String>(document){
                final /* synthetic */ Document $document;

                @NotNull
                public final String invoke() {
                    String string = this.$document.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"document.text");
                    return string;
                }
                {
                    this.$document = document;
                    super(0);
                }
            }));
        }
        KtObjModule.Built result = KtObjModule.build$default(module, null, 1, null);
        Iterable $this$filterNot$iv = result.getTypeDefs();
        boolean $i$f$filterNot = false;
        $dstr$vfu$document = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            DefType it = (DefType)((Object)element$iv$iv);
            boolean bl = false;
            if (it.getUtilityType() || it.getAbstract()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List entitiesForGeneration = (List)destination$iv$iv;
        if (!entitiesForGeneration.isEmpty()) {
            String virtualFile;
            Object it;
            VirtualFile genFolder = (VirtualFile)targetFolderGenerator.invoke();
            if (genFolder == null) {
                CodeWriterKt.access$getLOG$p().info("Generated source folder doesn't exist. Skip processing source folder with path: " + sourceFolder);
                return;
            }
            Iterable $this$forEach$iv2 = module.getFiles();
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                String fileContent;
                it = (KtFile)element$iv;
                boolean bl = false;
                if ((VirtualFile)fileMapping.get(((KtFile)it).getName()) == null) {
                    continue;
                }
                if (RewriteKt.rewrite((KtFile)it) == null) {
                    continue;
                }
                Document document = documentManager.getDocument((VirtualFile)virtualFile);
                if (document == null) continue;
                document.setText((CharSequence)fileContent);
            }
            $this$forEach$iv2 = entitiesForGeneration;
            $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                VirtualFile virtualFile2;
                it = (DefType)((Object)element$iv);
                boolean bl = false;
                KtFile ktFile = ((DefType)((Object)it)).getDef().getFile();
                if (ktFile == null || (ktFile = ktFile.getVirtualFile()) == null) {
                    virtualFile = "Source file for " + ((DefType)((Object)it)).getDef().getName() + " doesn't exist";
                    throw new IllegalStateException(virtualFile.toString());
                }
                KtFile sourceFile = ktFile;
                VirtualFile packageFolder = INSTANCE.createPackageFolderIfMissing(sourceFolder, (VirtualFile)sourceFile, genFolder);
                Intrinsics.checkNotNullExpressionValue((Object)packageFolder.createChildData((Object)INSTANCE, TypeKt.getJavaImplName((Type)it) + ".kt"), (String)"packageFolder.createChil\u2026 it.javaImplName + \".kt\")");
                Document document = documentManager.getDocument(virtualFile2);
                if (document == null) continue;
                document.setText((CharSequence)CodeWriterKt.implIjWsFileContents((DefType)((Object)it), result.getSimpleTypes()));
            }
        } else {
            CodeWriterKt.access$getLOG$p().info("Not found types for generation");
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void generate(@NotNull File dir, @NotNull String fromDirectory, @NotNull File generatedDestDir, boolean keepUnknownFields) {
        void $this$filterNotTo$iv$iv;
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Intrinsics.checkNotNullParameter((Object)fromDirectory, (String)"fromDirectory");
        Intrinsics.checkNotNullParameter((Object)generatedDestDir, (String)"generatedDestDir");
        generatedDestDir.mkdirs();
        Object[] objectArray = FilesKt.resolve((File)dir, (String)fromDirectory).listFiles();
        Intrinsics.checkNotNull((Object)objectArray);
        Iterable iterable = ArraysKt.toList((Object[])objectArray);
        boolean $i$f$filter = false;
        void var8_8 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            File it = (File)element$iv$iv;
            boolean bl = false;
            File file = it;
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"it");
            String string = file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name");
            if (!StringsKt.endsWith$default((String)string, (String)".kt", (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List ktSrcs = (List)destination$iv$iv;
        KtObjModule module = new KtObjModule(null, keepUnknownFields);
        Iterable $this$forEach$iv = ktSrcs;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File it = (File)element$iv;
            boolean bl = false;
            File file = it;
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"it");
            String string = FilesKt.relativeTo((File)file, (File)dir).getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.relativeTo(dir).path");
            module.addFile(string, null, (Function0<String>)((Function0)new Function0<String>(it){
                final /* synthetic */ File $it;

                @NotNull
                public final String invoke() {
                    File file = this.$it;
                    Intrinsics.checkNotNullExpressionValue((Object)file, (String)"it");
                    return FilesKt.readText$default((File)file, null, (int)1, null);
                }
                {
                    this.$it = file;
                    super(0);
                }
            }));
        }
        KtObjModule.Built result = KtObjModule.build$default(module, null, 1, null);
        Iterable $this$forEach$iv2 = module.getFiles();
        boolean $i$f$forEach2 = false;
        for (Object element$iv2 : $this$forEach$iv2) {
            String fileContent;
            KtFile it = (KtFile)element$iv2;
            boolean bl = false;
            if (RewriteKt.rewrite(it) == null) {
                continue;
            }
            FilesKt.writeText$default((File)FilesKt.resolve((File)dir, (String)it.getName()), (String)fileContent, null, (int)2, null);
        }
        Iterable $this$filterNot$iv = result.getTypeDefs();
        boolean $i$f$filterNot = false;
        Iterable element$iv = $this$filterNot$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            DefType it = (DefType)((Object)element$iv$iv);
            boolean bl = false;
            if (Intrinsics.areEqual((Object)it.getName(), (Object)"WorkspaceEntity") || Intrinsics.areEqual((Object)it.getName(), (Object)"WorkspaceEntityWithPersistentId") || it.getAbstract()) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filterNot$iv = (List)destination$iv$iv2;
        $i$f$forEach2 = false;
        for (Object element$iv2 : $this$forEach$iv2) {
            DefType it = (DefType)((Object)element$iv2);
            boolean bl = false;
            FilesKt.writeText$default((File)FilesKt.resolve((File)generatedDestDir, (String)(TypeKt.getJavaImplName(it) + ".kt")), (String)CodeWriterKt.implIjWsFileContents(it, result.getSimpleTypes()), null, (int)2, null);
        }
    }

    private final VirtualFile createPackageFolderIfMissing(VirtualFile sourceRoot, VirtualFile sourceFile, VirtualFile genFolder) {
        String relativePath = VfsUtil.getRelativePath((VirtualFile)sourceFile.getParent(), (VirtualFile)sourceRoot, (char)'/');
        VirtualFile virtualFile = VfsUtil.createDirectoryIfMissing((VirtualFile)genFolder, (String)String.valueOf(relativePath));
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"VfsUtil.createDirectoryI\u2026nFolder, \"$relativePath\")");
        return virtualFile;
    }

    private CodeWriter() {
    }

    static {
        CodeWriter codeWriter;
        INSTANCE = codeWriter = new CodeWriter();
    }
}

