/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.util;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.SmartList;
import java.util.Collections;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.dom.Extension;
import org.jetbrains.idea.devkit.dom.ExtensionPoint;
import org.jetbrains.idea.devkit.util.ExtensionCandidate;
import org.jetbrains.idea.devkit.util.ExtensionLocator;
import org.jetbrains.idea.devkit.util.ExtensionLocatorKt;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0016\b\u0002\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\t\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016J\u001c\u0010\u0012\u001a\u00020\u00132\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\tH\u0002R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\f\u001a\f0\u0007\u00a2\u0006\u0002\b\r\u00a2\u0006\u0002\b\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/idea/devkit/util/ExtensionByExtensionPointLocator;", "Lorg/jetbrains/idea/devkit/util/ExtensionLocator;", "project", "Lcom/intellij/openapi/project/Project;", "extensionPoint", "Lorg/jetbrains/idea/devkit/dom/ExtensionPoint;", "extensionId", "", "extensionIdFunction", "Lkotlin/Function1;", "Lorg/jetbrains/idea/devkit/dom/Extension;", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/idea/devkit/dom/ExtensionPoint;Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "pointQualifiedName", "Lorg/jetbrains/annotations/NotNull;", "Lcom/intellij/openapi/util/NlsSafe;", "findCandidates", "", "Lorg/jetbrains/idea/devkit/util/ExtensionCandidate;", "processCandidates", "", "processor", "Lcom/intellij/psi/xml/XmlTag;", "", "intellij.devkit.core"})
public final class ExtensionByExtensionPointLocator
extends ExtensionLocator {
    private final String pointQualifiedName;
    private final Project project;
    private final String extensionId;
    private final Function1<Extension, String> extensionIdFunction;

    private final void processCandidates(Function1<? super XmlTag, Boolean> processor) {
        boolean strictMatch = false;
        String searchText = null;
        if (this.extensionId != null) {
            searchText = this.extensionId;
            strictMatch = true;
        } else {
            String string = StringUtil.substringAfterLast((String)this.pointQualifiedName, (String)".");
            if (string == null) {
                return;
            }
            searchText = string;
            strictMatch = false;
        }
        ExtensionLocatorKt.processExtensionDeclarations(searchText, this.project, strictMatch, (Function2<? super Extension, ? super XmlTag, Boolean>)((Function2)new Function2<Extension, XmlTag, Boolean>(this, processor){
            final /* synthetic */ ExtensionByExtensionPointLocator this$0;
            final /* synthetic */ Function1 $processor;

            public final boolean invoke(@NotNull Extension extension, @NotNull XmlTag tag) {
                Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
                Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
                ExtensionPoint extensionPoint = extension.getExtensionPoint();
                if (extensionPoint == null) {
                    return true;
                }
                Intrinsics.checkNotNullExpressionValue((Object)extensionPoint, (String)"extension.extensionPoint\u2026xtensionDeclarations true");
                ExtensionPoint ep = extensionPoint;
                return Intrinsics.areEqual((Object)ep.getEffectiveQualifiedName(), (Object)ExtensionByExtensionPointLocator.access$getPointQualifiedName$p(this.this$0)) && (ExtensionByExtensionPointLocator.access$getExtensionId$p(this.this$0) == null || Intrinsics.areEqual((Object)ExtensionByExtensionPointLocator.access$getExtensionId$p(this.this$0), (Object)((String)ExtensionByExtensionPointLocator.access$getExtensionIdFunction$p(this.this$0).invoke((Object)extension)))) ? ((Boolean)this.$processor.invoke((Object)tag)).booleanValue() && ExtensionByExtensionPointLocator.access$getExtensionId$p(this.this$0) == null : true;
            }
            {
                this.this$0 = extensionByExtensionPointLocator;
                this.$processor = function1;
                super(2);
            }
        }));
    }

    @Override
    @NotNull
    public List<ExtensionCandidate> findCandidates() {
        List<ExtensionCandidate> result = Collections.synchronizedList((List)new SmartList());
        KProperty kProperty = null;
        Lazy smartPointerManager2 = LazyKt.lazy((Function0)((Function0)new Function0<SmartPointerManager>(this){
            final /* synthetic */ ExtensionByExtensionPointLocator this$0;

            public final SmartPointerManager invoke() {
                return SmartPointerManager.getInstance((Project)ExtensionByExtensionPointLocator.access$getProject$p(this.this$0));
            }
            {
                this.this$0 = extensionByExtensionPointLocator;
                super(0);
            }
        }));
        this.processCandidates((Function1<? super XmlTag, Boolean>)((Function1)new Function1<XmlTag, Boolean>(result, smartPointerManager2, kProperty){
            final /* synthetic */ List $result;
            final /* synthetic */ Lazy $smartPointerManager;
            final /* synthetic */ KProperty $smartPointerManager$metadata;

            public final boolean invoke(@NotNull XmlTag it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Lazy lazy = this.$smartPointerManager;
                Object var3_3 = null;
                KProperty kProperty = this.$smartPointerManager$metadata;
                return this.$result.add(new ExtensionCandidate((SmartPsiElementPointer<XmlTag>)((SmartPointerManager)lazy.getValue()).createSmartPsiElementPointer((PsiElement)it)));
            }
            {
                this.$result = list2;
                this.$smartPointerManager = lazy;
                this.$smartPointerManager$metadata = kProperty;
                super(1);
            }
        }));
        List<ExtensionCandidate> list2 = result;
        Intrinsics.checkNotNullExpressionValue(list2, (String)"result");
        return list2;
    }

    public ExtensionByExtensionPointLocator(@NotNull Project project, @NotNull ExtensionPoint extensionPoint, @Nullable String extensionId, @NotNull Function1<? super Extension, String> extensionIdFunction) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)extensionPoint, (String)"extensionPoint");
        Intrinsics.checkNotNullParameter(extensionIdFunction, (String)"extensionIdFunction");
        super(null);
        this.project = project;
        this.extensionId = extensionId;
        this.extensionIdFunction = extensionIdFunction;
        String string = extensionPoint.getEffectiveQualifiedName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"extensionPoint.effectiveQualifiedName");
        this.pointQualifiedName = string;
    }

    public /* synthetic */ ExtensionByExtensionPointLocator(Project project, ExtensionPoint extensionPoint, String string, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            function1 = 1.INSTANCE;
        }
        this(project, extensionPoint, string, (Function1<? super Extension, String>)function1);
    }

    public static final /* synthetic */ String access$getPointQualifiedName$p(ExtensionByExtensionPointLocator $this) {
        return $this.pointQualifiedName;
    }

    public static final /* synthetic */ String access$getExtensionId$p(ExtensionByExtensionPointLocator $this) {
        return $this.extensionId;
    }

    public static final /* synthetic */ Function1 access$getExtensionIdFunction$p(ExtensionByExtensionPointLocator $this) {
        return $this.extensionIdFunction;
    }

    public static final /* synthetic */ Project access$getProject$p(ExtensionByExtensionPointLocator $this) {
        return $this.project;
    }
}

