/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.resolver;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.ivy.core.IvyPatternHelper;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.DefaultArtifact;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.resolve.ResolveData;
import org.apache.ivy.core.settings.IvyPattern;
import org.apache.ivy.plugins.matcher.Matcher;
import org.apache.ivy.plugins.resolver.BasicResolver;
import org.apache.ivy.plugins.resolver.util.ResolvedResource;
import org.apache.ivy.plugins.resolver.util.ResourceMDParser;
import org.apache.ivy.util.Message;

public abstract class AbstractPatternsBasedResolver
extends BasicResolver {
    private List<String> ivyPatterns = new ArrayList<String>();
    private List<String> artifactPatterns = new ArrayList<String>();
    private boolean m2compatible = false;

    @Override
    public ResolvedResource findIvyFileRef(DependencyDescriptor dd, ResolveData data2) {
        ModuleRevisionId mrid = dd.getDependencyRevisionId();
        if (this.isM2compatible()) {
            mrid = this.convertM2IdForResourceSearch(mrid);
        }
        return this.findResourceUsingPatterns(mrid, this.ivyPatterns, DefaultArtifact.newIvyArtifact(mrid, data2.getDate()), this.getRMDParser(dd, data2), data2.getDate());
    }

    @Override
    public ResolvedResource findArtifactRef(Artifact artifact, Date date2) {
        ModuleRevisionId mrid = artifact.getModuleRevisionId();
        if (this.isM2compatible()) {
            mrid = this.convertM2IdForResourceSearch(mrid);
        }
        return this.findResourceUsingPatterns(mrid, this.artifactPatterns, artifact, this.getDefaultRMDParser(artifact.getModuleRevisionId().getModuleId()), date2);
    }

    @Override
    public ResolvedResource findResource(ResolvedResource[] rress, ResourceMDParser rmdparser, ModuleRevisionId mrid, Date date2) {
        if (this.isM2compatible()) {
            mrid = this.convertM2ResourceSearchIdToNormal(mrid);
        }
        return super.findResource(rress, rmdparser, mrid, date2);
    }

    protected ResolvedResource findResourceUsingPatterns(ModuleRevisionId moduleRevision, List<String> patternList, Artifact artifact, ResourceMDParser rmdparser, Date date2) {
        ArrayList<ResolvedResource> resolvedResources = new ArrayList<ResolvedResource>();
        HashSet<String> foundRevisions = new HashSet<String>();
        boolean dynamic = this.getSettings().getVersionMatcher().isDynamic(moduleRevision);
        for (String pattern2 : patternList) {
            ResolvedResource rres = this.findResourceUsingPattern(moduleRevision, pattern2, artifact, rmdparser, date2);
            if (rres == null || foundRevisions.contains(rres.getRevision())) continue;
            foundRevisions.add(rres.getRevision());
            resolvedResources.add(rres);
            if (dynamic) continue;
            break;
        }
        if (resolvedResources.size() > 1) {
            ResolvedResource[] rress = resolvedResources.toArray(new ResolvedResource[resolvedResources.size()]);
            return this.findResource(rress, rmdparser, moduleRevision, date2);
        }
        if (resolvedResources.size() == 1) {
            return (ResolvedResource)resolvedResources.get(0);
        }
        return null;
    }

    protected abstract ResolvedResource findResourceUsingPattern(ModuleRevisionId var1, String var2, Artifact var3, ResourceMDParser var4, Date var5);

    @Override
    protected Collection<String> findNames(Map<String, String> tokenValues, String token2) {
        HashSet<String> names2 = new HashSet<String>(this.findIvyNames(tokenValues, token2));
        if (this.isAllownomd()) {
            names2.addAll(this.findArtifactNames(tokenValues, token2));
        }
        return names2;
    }

    protected Collection<String> findIvyNames(Map<String, String> tokenValues, String token2) {
        HashSet<String> names2 = new HashSet<String>();
        tokenValues = new HashMap<String, String>(tokenValues);
        tokenValues.put("artifact", "ivy");
        tokenValues.put("type", "ivy");
        tokenValues.put("ext", "xml");
        if (this.isM2compatible()) {
            this.convertM2TokenValuesForResourceSearch(tokenValues);
        }
        this.findTokenValues(names2, this.getIvyPatterns(), tokenValues, token2);
        this.filterNames(names2);
        return names2;
    }

    protected Collection<String> findArtifactNames(Map<String, String> tokenValues, String token2) {
        HashSet<String> names2 = new HashSet<String>();
        tokenValues = new HashMap<String, String>(tokenValues);
        tokenValues.put("artifact", tokenValues.get("module"));
        tokenValues.put("type", "jar");
        tokenValues.put("ext", "jar");
        if (this.isM2compatible()) {
            this.convertM2TokenValuesForResourceSearch(tokenValues);
        }
        this.findTokenValues(names2, this.getArtifactPatterns(), tokenValues, token2);
        this.filterNames(names2);
        return names2;
    }

    @Override
    public Map<String, String>[] listTokenValues(String[] tokens2, Map<String, Object> criteria) {
        LinkedHashSet<Map<String, String>> result2 = new LinkedHashSet<Map<String, String>>();
        HashMap<String, Object> subcriteria = new HashMap<String, Object>(criteria);
        subcriteria.put("type", "ivy");
        subcriteria.put("ext", this.getModuleDescriptorExtension());
        if (this.isM2compatible()) {
            this.convertM2CriteriaForResourceSearch(subcriteria);
        }
        for (String ivyPattern : this.getIvyPatterns()) {
            result2.addAll(this.resolveTokenValues(tokens2, ivyPattern, subcriteria, false));
        }
        if (this.isAllownomd()) {
            subcriteria = new HashMap<String, Object>(criteria);
            subcriteria.put("type", "jar");
            subcriteria.put("ext", "jar");
            if (this.isM2compatible()) {
                this.convertM2CriteriaForResourceSearch(subcriteria);
            }
            for (String artifactPattern : this.getArtifactPatterns()) {
                result2.addAll(this.resolveTokenValues(tokens2, artifactPattern, subcriteria, true));
            }
        }
        return result2.toArray(new Map[result2.size()]);
    }

    protected String getModuleDescriptorExtension() {
        return "xml";
    }

    private Set<Map<String, String>> resolveTokenValues(String[] tokens2, String pattern2, Map<String, Object> criteria, boolean noMd) {
        String[] values2;
        LinkedHashSet<Map<String, String>> result2 = new LinkedHashSet<Map<String, String>>();
        HashSet<String> tokenSet = new HashSet<String>(Arrays.asList(tokens2));
        HashMap<String, String> tokenValues = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : criteria.entrySet()) {
            Object value2 = entry.getValue();
            if (!(value2 instanceof String)) continue;
            tokenValues.put(entry.getKey(), (String)value2);
        }
        if (tokenSet.isEmpty()) {
            result2.add(tokenValues);
            return result2;
        }
        String partiallyResolvedPattern = IvyPatternHelper.substituteTokens(pattern2, tokenValues);
        String token2 = IvyPatternHelper.getFirstToken(partiallyResolvedPattern);
        if (token2 == null && this.exist(partiallyResolvedPattern)) {
            result2.add(tokenValues);
            return result2;
        }
        tokenSet.remove(token2);
        Matcher matcher2 = null;
        Object criteriaForToken = criteria.get(token2);
        if (criteriaForToken instanceof Matcher) {
            matcher2 = (Matcher)criteriaForToken;
        }
        if ((values2 = this.listTokenValues(partiallyResolvedPattern, token2)) == null) {
            return result2;
        }
        ArrayList<String> valueList = new ArrayList<String>(Arrays.asList(values2));
        this.filterNames(valueList);
        for (String value3 : valueList) {
            if (matcher2 != null && !matcher2.matches(value3)) continue;
            tokenValues.put(token2, value3);
            String moreResolvedPattern = IvyPatternHelper.substituteTokens(partiallyResolvedPattern, tokenValues);
            HashMap<String, Object> newCriteria = new HashMap<String, Object>(criteria);
            newCriteria.put(token2, value3);
            if (noMd && "artifact".equals(token2)) {
                newCriteria.put("module", value3);
            } else if (noMd && "module".equals(token2)) {
                newCriteria.put("artifact", value3);
            }
            result2.addAll(this.resolveTokenValues(tokenSet.toArray(new String[tokenSet.size()]), moreResolvedPattern, newCriteria, noMd));
        }
        return result2;
    }

    protected abstract String[] listTokenValues(String var1, String var2);

    protected abstract boolean exist(String var1);

    protected void findTokenValues(Collection<String> names2, List<String> patterns, Map<String, String> tokenValues, String token2) {
    }

    public void addIvyPattern(String pattern2) {
        this.ivyPatterns.add(pattern2);
    }

    public void addArtifactPattern(String pattern2) {
        this.artifactPatterns.add(pattern2);
    }

    public List<String> getIvyPatterns() {
        return Collections.unmodifiableList(this.ivyPatterns);
    }

    public List<String> getArtifactPatterns() {
        return Collections.unmodifiableList(this.artifactPatterns);
    }

    protected void setIvyPatterns(List<String> patterns) {
        this.ivyPatterns = patterns;
    }

    protected void setArtifactPatterns(List<String> patterns) {
        this.artifactPatterns = patterns;
    }

    public void addConfiguredIvy(IvyPattern p2) {
        this.ivyPatterns.add(p2.getPattern());
    }

    public void addConfiguredArtifact(IvyPattern p2) {
        this.artifactPatterns.add(p2.getPattern());
    }

    @Override
    public void dumpSettings() {
        super.dumpSettings();
        Message.debug("\t\tm2compatible: " + this.isM2compatible());
        Message.debug("\t\tivy patterns:");
        for (String p2 : this.getIvyPatterns()) {
            Message.debug("\t\t\t" + p2);
        }
        Message.debug("\t\tartifact patterns:");
        for (String p2 : this.getArtifactPatterns()) {
            Message.debug("\t\t\t" + p2);
        }
    }

    public boolean isM2compatible() {
        return this.m2compatible;
    }

    public void setM2compatible(boolean compatible) {
        this.m2compatible = compatible;
    }

    protected ModuleRevisionId convertM2ResourceSearchIdToNormal(ModuleRevisionId mrid) {
        if (mrid.getOrganisation() == null || mrid.getOrganisation().indexOf(47) == -1) {
            return mrid;
        }
        return ModuleRevisionId.newInstance(mrid.getOrganisation().replace('/', '.'), mrid.getName(), mrid.getBranch(), mrid.getRevision(), mrid.getQualifiedExtraAttributes());
    }

    protected ModuleRevisionId convertM2IdForResourceSearch(ModuleRevisionId mrid) {
        if (mrid.getOrganisation() == null || mrid.getOrganisation().indexOf(46) == -1) {
            return mrid;
        }
        return ModuleRevisionId.newInstance(mrid.getOrganisation().replace('.', '/'), mrid.getName(), mrid.getBranch(), mrid.getRevision(), mrid.getQualifiedExtraAttributes());
    }

    protected String convertM2OrganizationForResourceSearch(String org) {
        return org.replace('.', '/');
    }

    protected void convertM2TokenValuesForResourceSearch(Map<String, String> tokenValues) {
        tokenValues.put("organisation", this.convertM2OrganizationForResourceSearch(tokenValues.get("organisation")));
    }

    protected void convertM2CriteriaForResourceSearch(Map<String, Object> criteria) {
        Object org = criteria.get("organisation");
        if (org instanceof String) {
            criteria.put("organisation", this.convertM2OrganizationForResourceSearch((String)org));
        }
    }
}

