/*
 * Decompiled with CFR 0.152.
 */
package runtime.system;

import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import runtime.system.JStack;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\u0014\b\u0002\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a8\u0006\t"}, d2={"Lruntime/system/JStack;", "", "()V", "dumpThreads", "", "threadSelector", "Lkotlin/Function1;", "Ljava/lang/Thread;", "", "platform-runtime"})
public final class JStack {
    @NotNull
    public static final JStack INSTANCE = new JStack();

    private JStack() {
    }

    @NotNull
    public final String dumpThreads(@NotNull Function1<? super Thread, Boolean> threadSelector) {
        LockInfo[] lockInfoArray;
        Object it;
        Intrinsics.checkNotNullParameter(threadSelector, (String)"threadSelector");
        StringBuilder $this$dumpThreads_u24lambda_u2d2 = new StringBuilder();
        boolean bl = false;
        try {
            ThreadMXBean bean = ManagementFactory.getThreadMXBean();
            ThreadInfo[] threadInfoArray = bean.dumpAllThreads(true, true);
            Intrinsics.checkNotNullExpressionValue((Object)threadInfoArray, (String)"bean.dumpAllThreads(true, true)");
            Object[] $this$associateBy$iv = threadInfoArray;
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)$this$associateBy$iv.length), (int)16);
            Object[] object2 = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : object2) {
                ThreadInfo threadInfo = (ThreadInfo)element$iv$iv;
                Map map2 = destination$iv$iv;
                boolean bl2 = false;
                map2.put(it.getThreadId(), element$iv$iv);
            }
            lockInfoArray = destination$iv$iv;
        }
        catch (Throwable t) {
            lockInfoArray = MapsKt.emptyMap();
        }
        Map threadsInfos = lockInfoArray;
        LockInfo[] $this$dumpThreads_u24lambda_u2d2_u24lambda_u2d1 = lockInfoArray = new StringBuilder();
        boolean bl3 = false;
        StringBuilder stringBuilder = $this$dumpThreads_u24lambda_u2d2_u24lambda_u2d1.append("Full thread dump ").append(System.getProperty("java.vm.name")).append(" ").append(System.getProperty("java.vm.version")).append(" ").append(System.getProperty("java.vm.info"));
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(\"Full thread dump\u2026Property(\"java.vm.info\"))");
        StringsKt.appendln((StringBuilder)stringBuilder);
        Map<Thread, StackTraceElement[]> map3 = Thread.getAllStackTraces();
        Intrinsics.checkNotNullExpressionValue(map3, (String)"getAllStackTraces()");
        for (Map.Entry entry : map3.entrySet()) {
            LockInfo[] locks;
            CharSequence charSequence;
            LockInfo[] lockInfoArray2;
            ThreadInfo thInfo;
            ThreadGroup group;
            Thread thread = (Thread)entry.getKey();
            StackTraceElement[] stackTrace = (StackTraceElement[])entry.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)thread, (String)"thread");
            if (!((Boolean)threadSelector.invoke((Object)thread)).booleanValue()) continue;
            $this$dumpThreads_u24lambda_u2d2_u24lambda_u2d1.append('\"' + thread.getName() + "\" ");
            if (thread.isDaemon()) {
                $this$dumpThreads_u24lambda_u2d2_u24lambda_u2d1.append("daemon ");
            }
            if ((group = thread.getThreadGroup()) != null) {
                $this$dumpThreads_u24lambda_u2d2_u24lambda_u2d1.append("group=\"" + group.getName() + "\" ");
            }
            $this$dumpThreads_u24lambda_u2d2_u24lambda_u2d1.append("prio=" + thread.getPriority() + ' ');
            $this$dumpThreads_u24lambda_u2d2_u24lambda_u2d1.append("tid=" + thread.getId() + ' ');
            $this$dumpThreads_u24lambda_u2d2_u24lambda_u2d1.append("nid=" + thread.getId() + ' ');
            Thread.State state2 = thread.getState();
            if (state2 == Thread.State.RUNNABLE) {
                $this$dumpThreads_u24lambda_u2d2_u24lambda_u2d1.append("runnable ");
            }
            if (state2 == Thread.State.WAITING || state2 == Thread.State.TIMED_WAITING) {
                $this$dumpThreads_u24lambda_u2d2_u24lambda_u2d1.append("waiting ");
            }
            if (state2 == Thread.State.BLOCKED) {
                $this$dumpThreads_u24lambda_u2d2_u24lambda_u2d1.append("blocked ");
            }
            if ((thInfo = (ThreadInfo)threadsInfos.get(thread.getId())) != null) {
                if (thInfo.getLockName() != null) {
                    $this$dumpThreads_u24lambda_u2d2_u24lambda_u2d1.append(Intrinsics.stringPlus((String)"on ", (Object)thInfo.getLockName()));
                }
                if (thInfo.getLockOwnerName() != null) {
                    $this$dumpThreads_u24lambda_u2d2_u24lambda_u2d1.append(" owned by \"").append(thInfo.getLockOwnerName()).append("\" Id=").append(thInfo.getLockOwnerId());
                }
                if (thInfo.isSuspended()) {
                    $this$dumpThreads_u24lambda_u2d2_u24lambda_u2d1.append(" (suspended)");
                }
                if (thInfo.isInNative()) {
                    $this$dumpThreads_u24lambda_u2d2_u24lambda_u2d1.append(" (in native)");
                }
                StringsKt.appendln((StringBuilder)$this$dumpThreads_u24lambda_u2d2_u24lambda_u2d1);
                LockInfo[] element$iv$iv = $this$dumpThreads_u24lambda_u2d2_u24lambda_u2d1;
                it = Intrinsics.stringPlus((String)"   java.lang.Thread.State: ", (Object)state2.name());
                StringBuilder stringBuilder2 = element$iv$iv.append((String)it);
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
                StringsKt.appendln((StringBuilder)stringBuilder2);
            } else {
                StringsKt.appendln((StringBuilder)$this$dumpThreads_u24lambda_u2d2_u24lambda_u2d1);
            }
            int i = -1;
            Intrinsics.checkNotNullExpressionValue((Object)stackTrace, (String)"stackTrace");
            it = stackTrace;
            int n = 0;
            int n2 = ((StackTraceElement[])it).length;
            while (n < n2) {
                StringBuilder stringBuilder3;
                StackTraceElement ste = it[n];
                ++n;
                int n3 = i;
                i = n3 + 1;
                MonitorInfo[] monitorInfoArray = $this$dumpThreads_u24lambda_u2d2_u24lambda_u2d1.append("\tat ");
                Intrinsics.checkNotNullExpressionValue((Object)monitorInfoArray, (String)"append(\"\\tat \")");
                lockInfoArray2 = ste.toString();
                charSequence = monitorInfoArray.append((String)lockInfoArray2);
                Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"append(value)");
                StringsKt.appendln((StringBuilder)charSequence);
                if (thInfo == null) continue;
                if (i == 0 && thInfo.getLockInfo() != null) {
                    Thread.State state3 = thInfo.getThreadState();
                    switch (state3 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[state3.ordinal()]) {
                        case 1: {
                            charSequence = $this$dumpThreads_u24lambda_u2d2_u24lambda_u2d1.append("\t\t-  blocked on ");
                            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"append(\"\\t\\t-  blocked on \")");
                            LockInfo lockInfo = thInfo.getLockInfo();
                            stringBuilder3 = ((StringBuilder)charSequence).append(lockInfo);
                            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(value)");
                            StringsKt.appendln((StringBuilder)stringBuilder3);
                            break;
                        }
                        case 2: {
                            charSequence = $this$dumpThreads_u24lambda_u2d2_u24lambda_u2d1.append("\t\t-  waiting on ");
                            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"append(\"\\t\\t-  waiting on \")");
                            LockInfo lockInfo = thInfo.getLockInfo();
                            stringBuilder3 = ((StringBuilder)charSequence).append(lockInfo);
                            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(value)");
                            StringsKt.appendln((StringBuilder)stringBuilder3);
                            break;
                        }
                        case 3: {
                            charSequence = $this$dumpThreads_u24lambda_u2d2_u24lambda_u2d1.append("\t\t-  waiting on ");
                            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"append(\"\\t\\t-  waiting on \")");
                            LockInfo lockInfo = thInfo.getLockInfo();
                            stringBuilder3 = ((StringBuilder)charSequence).append(lockInfo);
                            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(value)");
                            StringsKt.appendln((StringBuilder)stringBuilder3);
                        }
                    }
                }
                lockInfoArray2 = thInfo.getLockedMonitors();
                Intrinsics.checkNotNullExpressionValue((Object)lockInfoArray2, (String)"thInfo.lockedMonitors");
                for (MonitorInfo monitorInfo : lockInfoArray2) {
                    if (monitorInfo.getLockedStackDepth() != i) continue;
                    stringBuilder3 = $this$dumpThreads_u24lambda_u2d2_u24lambda_u2d1.append("\t-  locked ");
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(\"\\t-  locked \")");
                    StringBuilder stringBuilder4 = stringBuilder3.append(monitorInfo);
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(value)");
                    StringsKt.appendln((StringBuilder)stringBuilder4);
                }
            }
            StringsKt.appendln((StringBuilder)$this$dumpThreads_u24lambda_u2d2_u24lambda_u2d1);
            if (thInfo == null || (locks = thInfo.getLockedSynchronizers()) == null || !(!(locks.length == 0))) continue;
            StringsKt.appendln((StringBuilder)$this$dumpThreads_u24lambda_u2d2_u24lambda_u2d1);
            LockInfo[] lockInfoArray3 = $this$dumpThreads_u24lambda_u2d2_u24lambda_u2d1;
            String string2 = "  Locked ownable synchronizers:\n";
            StringBuilder stringBuilder5 = lockInfoArray3.append(string2);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder5);
            for (LockInfo lock : locks) {
                lockInfoArray2 = $this$dumpThreads_u24lambda_u2d2_u24lambda_u2d1;
                charSequence = Intrinsics.stringPlus((String)"\t- ", (Object)lock);
                StringBuilder stringBuilder6 = lockInfoArray2.append((String)charSequence);
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6, (String)"append(value)");
                StringsKt.appendln((StringBuilder)stringBuilder6);
            }
            StringsKt.appendln((StringBuilder)$this$dumpThreads_u24lambda_u2d2_u24lambda_u2d1);
        }
        StringsKt.appendln((StringBuilder)$this$dumpThreads_u24lambda_u2d2_u24lambda_u2d1);
        String string3 = lockInfoArray.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"StringBuilder().apply(builderAction).toString()");
        return string3;
    }

    public static /* synthetic */ String dumpThreads$default(JStack jStack, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            function1 = dumpThreads.1.INSTANCE;
        }
        return jStack.dumpThreads((Function1<? super Thread, Boolean>)function1);
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Thread.State.values().length];
            nArray[Thread.State.BLOCKED.ordinal()] = 1;
            nArray[Thread.State.WAITING.ordinal()] = 2;
            nArray[Thread.State.TIMED_WAITING.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

