/*
 * Decompiled with CFR 0.152.
 */
package runtime.utils;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import runtime.utils.PrintableTreeNode;
import runtime.utils.TreeNodeConverter;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JM\u0010\u0003\u001a\u00020\u0004\"\u0004\b\u0000\u0010\u00052\u0006\u0010\u0006\u001a\u0002H\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00050\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\n\u0010\u000e\u001a\u00060\u000fj\u0002`\u0010H\u0002\u00a2\u0006\u0002\u0010\u0011J'\u0010\u0012\u001a\u00020\n\"\u0004\b\u0000\u0010\u00052\u0006\u0010\u0013\u001a\u0002H\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00050\b\u00a2\u0006\u0002\u0010\u0014J\u000e\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0015\u00a8\u0006\u0016"}, d2={"Lruntime/utils/TreePrinter;", "", "()V", "process", "", "T", "current", "treeNodeConverter", "Lruntime/utils/TreeNodeConverter;", "prefix", "", "isRoot", "", "lastInPeers", "stringBuilder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "(Ljava/lang/Object;Lruntime/utils/TreeNodeConverter;Ljava/lang/String;ZZLjava/lang/StringBuilder;)V", "toString", "root", "(Ljava/lang/Object;Lruntime/utils/TreeNodeConverter;)Ljava/lang/String;", "Lruntime/utils/PrintableTreeNode;", "platform-runtime"})
public final class TreePrinter {
    @NotNull
    public static final TreePrinter INSTANCE = new TreePrinter();

    private TreePrinter() {
    }

    private final <T> void process(T current2, TreeNodeConverter<T> treeNodeConverter, String prefix, boolean isRoot, boolean lastInPeers, StringBuilder stringBuilder) {
        stringBuilder.append(prefix);
        if (!isRoot) {
            stringBuilder.append(lastInPeers ? "\u2514\u2500\u2500 " : "\u251c\u2500\u2500 ");
        } else {
            stringBuilder.append(" \u2500\u2500 ");
        }
        stringBuilder.append(treeNodeConverter.name(current2));
        stringBuilder.append('\n');
        List<T> children = treeNodeConverter.children(current2);
        String indentation = isRoot ? "    " : "    ";
        int n = 0;
        int n2 = children.size() - 1;
        while (n < n2) {
            int i = n++;
            this.process(children.get(i), treeNodeConverter, Intrinsics.stringPlus((String)prefix, (Object)(lastInPeers ? indentation : "\u2502   ")), false, false, stringBuilder);
        }
        if (!((Collection)children).isEmpty()) {
            this.process(children.get(children.size() - 1), treeNodeConverter, Intrinsics.stringPlus((String)prefix, (Object)(lastInPeers ? indentation : "\u2502   ")), false, true, stringBuilder);
        }
    }

    @NotNull
    public final String toString(@NotNull PrintableTreeNode root2) {
        Intrinsics.checkNotNullParameter((Object)root2, (String)"root");
        StringBuilder stringBuilder = new StringBuilder();
        TreeNodeConverter converter2 = new TreeNodeConverter<PrintableTreeNode>(){

            @NotNull
            public String name(@NotNull PrintableTreeNode node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                return node.name();
            }

            @NotNull
            public List<PrintableTreeNode> children(@NotNull PrintableTreeNode node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                return node.children();
            }
        };
        this.process(root2, converter2, "", true, true, stringBuilder);
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"stringBuilder.toString()");
        return string2;
    }

    @NotNull
    public final <T> String toString(T root2, @NotNull TreeNodeConverter<T> treeNodeConverter) {
        Intrinsics.checkNotNullParameter(treeNodeConverter, (String)"treeNodeConverter");
        StringBuilder stringBuilder = new StringBuilder();
        this.process(root2, treeNodeConverter, "", true, true, stringBuilder);
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"stringBuilder.toString()");
        return string2;
    }
}

