/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve;

import org.gradle.api.Transformer;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.attributes.AttributesSchema;
import org.gradle.api.internal.artifacts.ComponentMetadataProcessorFactory;
import org.gradle.api.internal.artifacts.ComponentSelectionRulesInternal;
import org.gradle.api.internal.artifacts.configurations.dynamicversion.CachePolicy;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ComponentResolvers;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.DefaultVersionedComponentChooser;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleComponentRepository;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.RepositoryChainArtifactResolver;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.RepositoryChainComponentMetaDataResolver;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.RepositoryChainDependencyToComponentIdResolver;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.RepositoryChainModuleResolution;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.RepositoryChainModuleSource;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionComparator;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionParser;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.internal.component.external.model.ModuleComponentResolveMetadata;
import org.gradle.internal.component.model.ImmutableModuleSources;
import org.gradle.internal.component.model.ModuleSource;
import org.gradle.internal.component.model.ModuleSources;
import org.gradle.internal.model.CalculatedValueContainerFactory;
import org.gradle.internal.resolve.caching.ComponentMetadataSupplierRuleExecutor;
import org.gradle.internal.resolve.resolver.ArtifactResolver;
import org.gradle.internal.resolve.resolver.ComponentMetaDataResolver;
import org.gradle.internal.resolve.resolver.DependencyToComponentIdResolver;
import org.gradle.internal.resolve.resolver.OriginArtifactSelector;

public class UserResolverChain
implements ComponentResolvers {
    private final RepositoryChainDependencyToComponentIdResolver componentIdResolver;
    private final RepositoryChainComponentMetaDataResolver componentResolver;
    private final RepositoryChainArtifactResolver artifactResolver;
    private final ComponentSelectionRulesInternal componentSelectionRules;

    public UserResolverChain(VersionComparator versionComparator, ComponentSelectionRulesInternal componentSelectionRules, VersionParser versionParser, AttributeContainer consumerAttributes, AttributesSchema attributesSchema, ImmutableAttributesFactory attributesFactory, ComponentMetadataProcessorFactory componentMetadataProcessor, ComponentMetadataSupplierRuleExecutor componentMetadataSupplierRuleExecutor, CachePolicy cachePolicy, CalculatedValueContainerFactory calculatedValueContainerFactory) {
        this.componentSelectionRules = componentSelectionRules;
        DefaultVersionedComponentChooser componentChooser = new DefaultVersionedComponentChooser(versionComparator, versionParser, componentSelectionRules, attributesSchema);
        ModuleTransformer metaDataFactory = new ModuleTransformer();
        this.componentIdResolver = new RepositoryChainDependencyToComponentIdResolver(componentChooser, metaDataFactory, versionParser, consumerAttributes, attributesFactory, componentMetadataProcessor, componentMetadataSupplierRuleExecutor, cachePolicy);
        this.componentResolver = new RepositoryChainComponentMetaDataResolver(componentChooser, metaDataFactory);
        this.artifactResolver = new RepositoryChainArtifactResolver(calculatedValueContainerFactory);
    }

    @Override
    public DependencyToComponentIdResolver getComponentIdResolver() {
        return this.componentIdResolver;
    }

    @Override
    public ComponentMetaDataResolver getComponentResolver() {
        return this.componentResolver;
    }

    @Override
    public ArtifactResolver getArtifactResolver() {
        return this.artifactResolver;
    }

    @Override
    public OriginArtifactSelector getArtifactSelector() {
        return this.artifactResolver;
    }

    public ComponentSelectionRulesInternal getComponentSelectionRules() {
        return this.componentSelectionRules;
    }

    public void add(ModuleComponentRepository repository) {
        this.componentIdResolver.add(repository);
        this.componentResolver.add(repository);
        this.artifactResolver.add(repository);
    }

    private static class ModuleTransformer
    implements Transformer<ModuleComponentResolveMetadata, RepositoryChainModuleResolution> {
        private ModuleTransformer() {
        }

        @Override
        public ModuleComponentResolveMetadata transform(RepositoryChainModuleResolution original) {
            RepositoryChainModuleSource moduleSource = new RepositoryChainModuleSource(original.repository);
            ModuleSources originSources = original.module.getSources();
            ImmutableModuleSources mutated = ImmutableModuleSources.of(originSources, (ModuleSource)moduleSource);
            return original.module.withSources(mutated);
        }
    }
}

