/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve.verification;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.net.URI;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.artifacts.result.ResolvedVariantResult;
import org.gradle.api.artifacts.verification.DependencyVerificationMode;
import org.gradle.api.component.Artifact;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.internal.artifacts.configurations.ResolutionStrategyInternal;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.DependencyVerifyingModuleComponentRepository;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleComponentRepository;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.verification.ArtifactVerificationOperation;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.verification.DefaultKeyServers;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.verification.DependencyVerificationOverride;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.verification.RepositoryAwareVerificationFailure;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.verification.report.DependencyVerificationReportWriter;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.verification.report.VerificationReport;
import org.gradle.api.internal.artifacts.verification.DependencyVerificationException;
import org.gradle.api.internal.artifacts.verification.serializer.DependencyVerificationsXmlReader;
import org.gradle.api.internal.artifacts.verification.signatures.BuildTreeDefinedKeys;
import org.gradle.api.internal.artifacts.verification.signatures.SignatureVerificationService;
import org.gradle.api.internal.artifacts.verification.signatures.SignatureVerificationServiceFactory;
import org.gradle.api.internal.artifacts.verification.verifier.DependencyVerifier;
import org.gradle.api.internal.properties.GradleProperties;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.Factory;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.component.external.model.ModuleComponentArtifactIdentifier;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.hash.ChecksumService;
import org.gradle.internal.impldep.com.google.common.collect.LinkedHashMultimap;
import org.gradle.internal.impldep.com.google.common.collect.Multimap;
import org.gradle.internal.impldep.com.google.common.collect.Queues;
import org.gradle.internal.impldep.com.google.common.collect.Sets;
import org.gradle.internal.logging.ConsoleRenderer;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.RunnableBuildOperation;

public class ChecksumAndSignatureVerificationOverride
implements DependencyVerificationOverride,
ArtifactVerificationOperation,
Stoppable {
    private static final Logger LOGGER = Logging.getLogger(ChecksumAndSignatureVerificationOverride.class);
    private final DependencyVerifier verifier;
    private final Multimap<ModuleComponentArtifactIdentifier, RepositoryAwareVerificationFailure> failures = LinkedHashMultimap.create();
    private final BuildOperationExecutor buildOperationExecutor;
    private final ChecksumService checksumService;
    private final SignatureVerificationService signatureVerificationService;
    private final DependencyVerificationMode verificationMode;
    private final Set<VerificationQuery> verificationQueries = Sets.newConcurrentHashSet();
    private final Deque<VerificationEvent> verificationEvents = Queues.newArrayDeque();
    private final AtomicBoolean closed = new AtomicBoolean();
    private final AtomicBoolean hasFatalFailure = new AtomicBoolean();
    private final DependencyVerificationReportWriter reportWriter;

    public ChecksumAndSignatureVerificationOverride(BuildOperationExecutor buildOperationExecutor, File gradleUserHome, File verificationsFile, BuildTreeDefinedKeys keyrings, ChecksumService checksumService, SignatureVerificationServiceFactory signatureVerificationServiceFactory, DependencyVerificationMode verificationMode, DocumentationRegistry documentationRegistry, File reportsDirectory, Factory<GradleProperties> gradlePropertiesFactory) {
        this.buildOperationExecutor = buildOperationExecutor;
        this.checksumService = checksumService;
        this.verificationMode = verificationMode;
        try {
            this.verifier = DependencyVerificationsXmlReader.readFromXml(new FileInputStream(verificationsFile));
            this.reportWriter = new DependencyVerificationReportWriter(gradleUserHome.toPath(), documentationRegistry, verificationsFile, this.verifier.getSuggestedWriteFlags(), reportsDirectory, gradlePropertiesFactory);
        }
        catch (FileNotFoundException e) {
            throw UncheckedException.throwAsUncheckedException(e);
        }
        catch (DependencyVerificationException e) {
            throw new DependencyVerificationException("Unable to read dependency verification metadata from " + verificationsFile, e.getCause());
        }
        this.signatureVerificationService = signatureVerificationServiceFactory.create(keyrings, this.keyServers(), this.verifier.getConfiguration().isUseKeyServers());
    }

    private List<URI> keyServers() {
        return DefaultKeyServers.getOrDefaults(this.verifier.getConfiguration().getKeyServers());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onArtifact(ArtifactVerificationOperation.ArtifactKind kind, ModuleComponentArtifactIdentifier artifact, File mainFile, Factory<File> signatureFile, String repositoryName, String repositoryId) {
        if (this.verificationQueries.add(new VerificationQuery(artifact, repositoryId))) {
            VerificationEvent event = new VerificationEvent(kind, artifact, mainFile, signatureFile, repositoryName);
            Deque<VerificationEvent> deque = this.verificationEvents;
            synchronized (deque) {
                this.verificationEvents.add(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyConcurrently() {
        this.hasFatalFailure.set(false);
        Deque<VerificationEvent> deque = this.verificationEvents;
        synchronized (deque) {
            if (this.verificationEvents.isEmpty()) {
                return;
            }
        }
        if (this.closed.get()) {
            LOGGER.debug("Cannot perform verification of all dependencies because the verification service has been shutdown. Under normal circumstances this shouldn't happen unless a user buildFinished was added in an unexpected way.");
            return;
        }
        this.buildOperationExecutor.runAll(queue -> {
            Deque<VerificationEvent> deque = this.verificationEvents;
            synchronized (deque) {
                VerificationEvent event;
                while ((event = this.verificationEvents.poll()) != null) {
                    final VerificationEvent ve = event;
                    queue.add(new RunnableBuildOperation(){

                        @Override
                        public void run(BuildOperationContext context) {
                            ChecksumAndSignatureVerificationOverride.this.verifier.verify(ChecksumAndSignatureVerificationOverride.this.checksumService, ChecksumAndSignatureVerificationOverride.this.signatureVerificationService, ve.kind, ve.artifact, ve.mainFile, (File)ve.signatureFile.create(), f -> {
                                Multimap multimap = ChecksumAndSignatureVerificationOverride.this.failures;
                                synchronized (multimap) {
                                    ChecksumAndSignatureVerificationOverride.this.failures.put((Object)ve.artifact, (Object)new RepositoryAwareVerificationFailure(f, ve.repositoryName));
                                }
                                if (f.isFatal()) {
                                    ChecksumAndSignatureVerificationOverride.this.hasFatalFailure.set(true);
                                }
                            });
                        }

                        @Override
                        public BuildOperationDescriptor.Builder description() {
                            return BuildOperationDescriptor.displayName("Dependency verification").progressDisplayName("Verifying " + ve.artifact);
                        }
                    });
                }
            }
        });
    }

    @Override
    public ModuleComponentRepository overrideDependencyVerification(ModuleComponentRepository original, String resolveContextName, ResolutionStrategyInternal resolutionStrategy) {
        return new DependencyVerifyingModuleComponentRepository(original, this, this.verifier.getConfiguration().isVerifySignatures());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void artifactsAccessed(String displayName) {
        this.verifyConcurrently();
        Multimap<ModuleComponentArtifactIdentifier, RepositoryAwareVerificationFailure> multimap = this.failures;
        synchronized (multimap) {
            if (this.hasFatalFailure.get() && !this.failures.isEmpty()) {
                this.failures.asMap().entrySet().removeIf(entry -> {
                    Collection value = (Collection)entry.getValue();
                    return value.stream().noneMatch(wrapper -> wrapper.getFailure().isFatal());
                });
                VerificationReport report2 = this.reportWriter.generateReport(displayName, this.failures, this.verifier.getConfiguration().isUseKeyServers());
                String errorMessage = this.buildConsoleErrorMessage(report2);
                if (this.verificationMode == DependencyVerificationMode.LENIENT) {
                    LOGGER.error(errorMessage);
                    this.failures.clear();
                    this.hasFatalFailure.set(false);
                } else {
                    throw new DependencyVerificationException(errorMessage);
                }
            }
        }
    }

    public String buildConsoleErrorMessage(VerificationReport report2) {
        String errorMessage = report2.getSummary();
        String htmlReport = new ConsoleRenderer().asClickableFileUrl(report2.getHtmlReport());
        errorMessage = errorMessage + "\n\nOpen this report for more details: " + htmlReport;
        return errorMessage;
    }

    @Override
    public ResolvedArtifactResult verifiedArtifact(final ResolvedArtifactResult artifact) {
        return new ResolvedArtifactResult(){

            @Override
            public File getFile() {
                ChecksumAndSignatureVerificationOverride.this.artifactsAccessed(artifact.getVariant().getDisplayName());
                return artifact.getFile();
            }

            @Override
            public ResolvedVariantResult getVariant() {
                return artifact.getVariant();
            }

            @Override
            public ComponentArtifactIdentifier getId() {
                return artifact.getId();
            }

            @Override
            public Class<? extends Artifact> getType() {
                return artifact.getType();
            }
        };
    }

    @Override
    public void stop() {
        this.closed.set(true);
        this.signatureVerificationService.stop();
    }

    private static class VerificationEvent {
        private final ArtifactVerificationOperation.ArtifactKind kind;
        private final ModuleComponentArtifactIdentifier artifact;
        private final File mainFile;
        private final Factory<File> signatureFile;
        private final String repositoryName;

        private VerificationEvent(ArtifactVerificationOperation.ArtifactKind kind, ModuleComponentArtifactIdentifier artifact, File mainFile, Factory<File> signatureFile, String repositoryName) {
            this.kind = kind;
            this.artifact = artifact;
            this.mainFile = mainFile;
            this.signatureFile = signatureFile;
            this.repositoryName = repositoryName;
        }
    }

    private static class VerificationQuery {
        private final ModuleComponentArtifactIdentifier artifact;
        private final String repositoryId;
        private final int hashCode;

        public VerificationQuery(ModuleComponentArtifactIdentifier artifact, String repositoryId) {
            this.artifact = artifact;
            this.repositoryId = repositoryId;
            this.hashCode = this.precomputeHashCode(artifact, repositoryId);
        }

        private int precomputeHashCode(ModuleComponentArtifactIdentifier artifact, String repositoryId) {
            int hashCode = artifact.getComponentIdentifier().hashCode();
            hashCode = 31 * hashCode + artifact.getFileName().hashCode();
            hashCode = 31 * hashCode + repositoryId.hashCode();
            return hashCode;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            VerificationQuery that = (VerificationQuery)o;
            if (this.hashCode != that.hashCode) {
                return false;
            }
            if (!this.artifact.getComponentIdentifier().equals(that.artifact.getComponentIdentifier())) {
                return false;
            }
            if (!this.artifact.getFileName().equals(that.artifact.getFileName())) {
                return false;
            }
            return this.repositoryId.equals(that.repositoryId);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

