/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.catalog;

import java.io.IOException;
import java.io.Writer;
import java.util.Comparator;
import java.util.stream.Collectors;
import org.gradle.api.initialization.ProjectDescriptor;
import org.gradle.api.internal.catalog.AbstractSourceGenerator;
import org.gradle.internal.impldep.com.google.common.base.Splitter;

public class AbstractProjectAccessorsSourceGenerator
extends AbstractSourceGenerator {
    public AbstractProjectAccessorsSourceGenerator(Writer writer2) {
        super(writer2);
    }

    protected static String toClassName(String path, String rootProjectName) {
        String name = AbstractProjectAccessorsSourceGenerator.toProjectName(path);
        if (name.isEmpty()) {
            name = AbstractProjectAccessorsSourceGenerator.toJavaName(rootProjectName);
        }
        return name + "ProjectDependency";
    }

    protected static String toProjectName(String path) {
        return Splitter.on((String)":").omitEmptyStrings().splitToList((CharSequence)path).stream().map(AbstractSourceGenerator::toJavaName).collect(Collectors.joining("_"));
    }

    protected void writeHeader(String packageName) throws IOException {
        this.writeLn("package " + packageName + ";");
        this.writeLn();
        this.addImport("org.gradle.api.NonNullApi");
        this.addImport("org.gradle.api.artifacts.ProjectDependency");
        this.addImport("org.gradle.api.internal.artifacts.dependencies.ProjectDependencyInternal");
        this.addImport("org.gradle.api.internal.artifacts.DefaultProjectDependencyFactory");
        this.addImport("org.gradle.api.internal.artifacts.dsl.dependencies.ProjectFinder");
        this.addImport("org.gradle.api.internal.catalog.DelegatingProjectDependency");
        this.addImport("org.gradle.api.internal.catalog.TypeSafeProjectDependencyFactory");
        this.addImport("javax.inject.Inject");
        this.writeLn();
    }

    protected static String rootProjectName(ProjectDescriptor descriptor) {
        ProjectDescriptor current = descriptor;
        while (current.getParent() != null) {
            current = current.getParent();
        }
        return current.getName();
    }

    protected void writeProjectAccessor(String name, ProjectDescriptor descriptor) throws IOException {
        this.writeLn("    /**");
        String path = descriptor.getPath();
        this.writeLn("     * Creates a project dependency on the project at path \"" + path + "\"");
        this.writeLn("     */");
        String returnType = AbstractProjectAccessorsSourceGenerator.toClassName(path, AbstractProjectAccessorsSourceGenerator.rootProjectName(descriptor));
        this.writeLn("    public " + returnType + " get" + name + "() { return new " + returnType + "(getFactory(), create(\"" + path + "\")); }");
        this.writeLn();
    }

    protected void processChildren(ProjectDescriptor current) {
        current.getChildren().stream().sorted(Comparator.comparing(ProjectDescriptor::getPath)).forEachOrdered(child -> {
            try {
                this.writeProjectAccessor(AbstractProjectAccessorsSourceGenerator.toJavaName(child.getName()), (ProjectDescriptor)child);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }
}

