/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.collections;

import java.io.File;
import org.gradle.api.internal.file.collections.DirectoryFileTree;
import org.gradle.api.internal.file.collections.DirectoryFileTreeFactory;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.internal.Factory;
import org.gradle.internal.nativeintegration.filesystem.FileSystem;
import org.gradle.internal.nativeintegration.services.FileSystems;

public class DefaultDirectoryFileTreeFactory
implements DirectoryFileTreeFactory {
    private final Factory<PatternSet> patternSetFactory;
    private final FileSystem fileSystem;

    public DefaultDirectoryFileTreeFactory() {
        this.patternSetFactory = new Factory<PatternSet>(){

            @Override
            public PatternSet create() {
                return new PatternSet();
            }
        };
        this.fileSystem = FileSystems.getDefault();
    }

    public DefaultDirectoryFileTreeFactory(Factory<PatternSet> patternSetFactory, FileSystem fileSystem) {
        this.patternSetFactory = patternSetFactory;
        this.fileSystem = fileSystem;
    }

    @Override
    public DirectoryFileTree create(File directory) {
        return new DirectoryFileTree(directory, this.patternSetFactory.create(), this.fileSystem);
    }

    @Override
    public DirectoryFileTree create(File directory, PatternSet patternSet) {
        return new DirectoryFileTree(directory, patternSet, this.fileSystem);
    }
}

