/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution;

import java.util.ArrayList;
import java.util.List;
import org.gradle.TaskExecutionRequest;
import org.gradle.api.internal.StartParameterInternal;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.configuration.project.BuiltInCommand;
import org.gradle.execution.BuildConfigurationAction;
import org.gradle.execution.BuildExecutionContext;
import org.gradle.execution.ProjectConfigurer;
import org.gradle.util.internal.GUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTasksBuildExecutionAction
implements BuildConfigurationAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultTasksBuildExecutionAction.class);
    private final ProjectConfigurer projectConfigurer;
    private final List<BuiltInCommand> builtInCommands;

    public DefaultTasksBuildExecutionAction(ProjectConfigurer projectConfigurer, List<BuiltInCommand> builtInCommands) {
        this.projectConfigurer = projectConfigurer;
        this.builtInCommands = builtInCommands;
    }

    @Override
    public void configure(BuildExecutionContext context) {
        StartParameterInternal startParameter = context.getGradle().getStartParameter();
        for (TaskExecutionRequest request : startParameter.getTaskRequests()) {
            if (request.getArgs().isEmpty()) continue;
            context.proceed();
            return;
        }
        ProjectInternal project = context.getGradle().getDefaultProject();
        this.projectConfigurer.configure(project);
        List<String> defaultTasks = project.getDefaultTasks();
        if (defaultTasks.size() == 0) {
            defaultTasks = new ArrayList<String>();
            for (BuiltInCommand command : this.builtInCommands) {
                defaultTasks.addAll(command.asDefaultTask());
            }
            LOGGER.info("No tasks specified. Using default task {}", (Object)GUtil.toString(defaultTasks));
        } else {
            LOGGER.info("No tasks specified. Using project default tasks {}", (Object)GUtil.toString(defaultTasks));
        }
        startParameter.setTaskNames(defaultTasks);
        context.proceed();
    }
}

