/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution;

import java.util.HashSet;
import java.util.LinkedList;
import org.gradle.api.Task;
import org.gradle.api.execution.TaskExecutionGraph;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.execution.BuildWorkExecutor;
import org.gradle.execution.plan.ExecutionPlan;
import org.gradle.execution.taskgraph.TaskExecutionGraphInternal;
import org.gradle.internal.build.ExecutionResult;
import org.gradle.internal.impldep.com.google.common.collect.Sets;

public class SelectedTaskExecutionAction
implements BuildWorkExecutor {
    @Override
    public ExecutionResult<Void> execute(GradleInternal gradle, ExecutionPlan plan) {
        TaskExecutionGraphInternal taskGraph = gradle.getTaskGraph();
        if (gradle.getStartParameter().isContinueOnFailure()) {
            taskGraph.setContinueOnFailure(true);
        }
        this.bindAllReferencesOfProject(taskGraph);
        LinkedList taskFailures = new LinkedList();
        taskGraph.execute(plan, taskFailures);
        return ExecutionResult.maybeFailed(taskFailures);
    }

    private void bindAllReferencesOfProject(TaskExecutionGraph graph) {
        HashSet seen = Sets.newHashSet();
        for (Task task : graph.getAllTasks()) {
            if (!seen.add(task.getProject())) continue;
            ProjectInternal projectInternal = (ProjectInternal)task.getProject();
            projectInternal.bindAllModelRules();
        }
    }
}

