/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.history.changes;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.gradle.internal.execution.history.changes.AbstractFingerprintCompareStrategy;
import org.gradle.internal.execution.history.changes.ChangeVisitor;
import org.gradle.internal.execution.history.changes.DefaultFileChange;
import org.gradle.internal.execution.history.changes.FilePathWithType;
import org.gradle.internal.execution.history.changes.FingerprintCompareStrategy;
import org.gradle.internal.fingerprint.FileSystemLocationFingerprint;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.ListMultimap;
import org.gradle.internal.impldep.com.google.common.collect.MultimapBuilder;

public class IgnoredPathCompareStrategy
extends AbstractFingerprintCompareStrategy {
    public static final FingerprintCompareStrategy INSTANCE = new IgnoredPathCompareStrategy();
    private static final Comparator<Map.Entry<HashCode, FilePathWithType>> ENTRY_COMPARATOR = Map.Entry.comparingByKey();

    private IgnoredPathCompareStrategy() {
        super(IgnoredPathCompareStrategy::visitChangesSince);
    }

    private static boolean visitChangesSince(Map<String, FileSystemLocationFingerprint> previous, Map<String, FileSystemLocationFingerprint> current, String propertyTitle, ChangeVisitor visitor) {
        ListMultimap unaccountedForPreviousFiles = MultimapBuilder.hashKeys((int)previous.size()).linkedListValues().build();
        for (Map.Entry<String, FileSystemLocationFingerprint> entry : previous.entrySet()) {
            String absolutePath = entry.getKey();
            FileSystemLocationFingerprint previousFingerprint = entry.getValue();
            unaccountedForPreviousFiles.put((Object)previousFingerprint.getNormalizedContentHash(), (Object)new FilePathWithType(absolutePath, previousFingerprint.getType()));
        }
        for (Map.Entry<String, FileSystemLocationFingerprint> entry : current.entrySet()) {
            String currentAbsolutePath = entry.getKey();
            FileSystemLocationFingerprint currentFingerprint = entry.getValue();
            HashCode normalizedContentHash = currentFingerprint.getNormalizedContentHash();
            List previousFilesForContent = unaccountedForPreviousFiles.get((Object)normalizedContentHash);
            if (previousFilesForContent.isEmpty()) {
                DefaultFileChange added = DefaultFileChange.added(currentAbsolutePath, propertyTitle, currentFingerprint.getType(), "");
                if (visitor.visitChange(added)) continue;
                return false;
            }
            previousFilesForContent.remove(0);
        }
        ImmutableList unaccountedForPreviousEntries = ImmutableList.sortedCopyOf(ENTRY_COMPARATOR, (Iterable)unaccountedForPreviousFiles.entries());
        for (Map.Entry unaccountedForPreviousEntry : unaccountedForPreviousEntries) {
            FilePathWithType removedFile = (FilePathWithType)unaccountedForPreviousEntry.getValue();
            DefaultFileChange removed = DefaultFileChange.removed(removedFile.getAbsolutePath(), propertyTitle, removedFile.getFileType(), "");
            if (visitor.visitChange(removed)) continue;
            return false;
        }
        return true;
    }
}

