/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.typeconversion;

import org.gradle.internal.exceptions.DiagnosticsVisitor;
import org.gradle.internal.typeconversion.NotationConvertResult;
import org.gradle.internal.typeconversion.NotationConverter;
import org.gradle.internal.typeconversion.TypeConversionException;

class CharSequenceNotationConverter<N, T>
implements NotationConverter<N, T> {
    private final NotationConverter<? super String, ? extends T> delegate;

    public CharSequenceNotationConverter(NotationConverter<? super String, ? extends T> delegate) {
        this.delegate = delegate;
    }

    @Override
    public void convert(N notation, NotationConvertResult<? super T> result2) throws TypeConversionException {
        if (notation instanceof CharSequence) {
            CharSequence charSequence = (CharSequence)notation;
            this.delegate.convert(charSequence.toString(), result2);
        }
    }

    @Override
    public void describe(DiagnosticsVisitor visitor) {
        this.delegate.describe(visitor);
    }
}

