/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.model;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtilRt;
import java.io.File;
import java.io.Serializable;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.model.MavenCoordinate;
import org.jetbrains.idea.maven.model.MavenId;

public class MavenArtifact
implements Serializable,
MavenCoordinate {
    static final long serialVersionUID = 6389627095309274357L;
    public static final String MAVEN_LIB_PREFIX = "Maven: ";
    private final String myGroupId;
    private final String myArtifactId;
    private final String myVersion;
    private final String myBaseVersion;
    private final String myType;
    private final String myClassifier;
    private String myScope;
    private final boolean myOptional;
    private final String myExtension;
    private final File myFile;
    private final boolean myResolved;
    private final boolean myStubbed;
    private volatile transient boolean myFileUnresolved;
    private volatile transient String myLibraryNameCache;
    private volatile transient long myLastFileCheckTimeStamp;
    private static final Condition<File> ourDefaultFileExists = File::exists;

    public MavenArtifact(String groupId, String artifactId, String version, String baseVersion, String type, String classifier, String scope, boolean optional, String extension, @Nullable File file, File localRepository, boolean resolved, boolean stubbed) {
        this.myGroupId = groupId;
        this.myArtifactId = artifactId;
        this.myVersion = version;
        this.myBaseVersion = baseVersion;
        this.myType = type;
        this.myClassifier = classifier;
        this.myScope = scope;
        this.myOptional = optional;
        this.myExtension = extension;
        this.myFile = file != null ? file : new File(localRepository, this.getRelativePath());
        this.myResolved = resolved;
        this.myStubbed = stubbed;
    }

    public String getGroupId() {
        return this.myGroupId;
    }

    public String getArtifactId() {
        return this.myArtifactId;
    }

    public String getVersion() {
        return this.myVersion;
    }

    public String getBaseVersion() {
        return this.myBaseVersion;
    }

    public MavenId getMavenId() {
        return new MavenId(this.myGroupId, this.myArtifactId, this.myVersion);
    }

    public String getType() {
        return this.myType;
    }

    public String getClassifier() {
        return this.myClassifier;
    }

    public String getScope() {
        return this.myScope;
    }

    public void setScope(String scope) {
        this.myScope = scope;
    }

    public boolean isOptional() {
        return this.myOptional;
    }

    public boolean isExportable() {
        if (this.myOptional) {
            return false;
        }
        return "compile".equals(this.myScope) || "runtime".equals(this.myScope);
    }

    public String getExtension() {
        return this.myExtension;
    }

    @Deprecated
    public boolean isResolved() {
        return this.isResolved(ourDefaultFileExists);
    }

    @Deprecated
    public boolean isResolved(Condition<? super File> fileExists) {
        if (this.myResolved && !this.myStubbed) {
            long currentTime = System.currentTimeMillis();
            if (this.myLastFileCheckTimeStamp + 2000L < currentTime) {
                if (!fileExists.value((Object)this.myFile)) {
                    return false;
                }
                this.myLastFileCheckTimeStamp = currentTime;
            }
            return true;
        }
        return false;
    }

    public boolean isResolvedArtifact() {
        return this.myResolved;
    }

    @NotNull
    public File getFile() {
        File file = this.myFile;
        if (file == null) {
            MavenArtifact.$$$reportNull$$$0(0);
        }
        return file;
    }

    public String getPath() {
        return FileUtilRt.toSystemIndependentName((String)this.myFile.getPath());
    }

    public String getRelativePath() {
        return this.getRelativePathForExtraArtifact(null, null);
    }

    public String getFileNameWithBaseVersion(@Nullable String extraArtifactClassifier, @Nullable String customExtension) {
        StringBuilder res = new StringBuilder();
        this.appendFileName(res, extraArtifactClassifier, customExtension, true);
        return res.toString();
    }

    private void appendFileName(StringBuilder result, @Nullable String extraArtifactClassifier, @Nullable String customExtension, boolean useBaseVersion) {
        result.append(this.myArtifactId);
        result.append('-');
        result.append(useBaseVersion ? this.myBaseVersion : this.myVersion);
        String fullClassifier = this.getFullClassifier(extraArtifactClassifier);
        if (fullClassifier != null) {
            result.append("-").append(fullClassifier);
        }
        result.append(".");
        result.append(customExtension == null ? this.myExtension : customExtension);
    }

    public String getRelativePathForExtraArtifact(@Nullable String extraArtifactClassifier, @Nullable String customExtension) {
        StringBuilder result = new StringBuilder();
        result.append(this.myGroupId.replace('.', '/'));
        result.append('/');
        result.append(this.myArtifactId);
        result.append('/');
        result.append(this.myBaseVersion);
        result.append('/');
        this.appendFileName(result, extraArtifactClassifier, customExtension, false);
        return result.toString();
    }

    @Nullable
    public String getFullClassifier(@Nullable String extraClassifier) {
        if (StringUtilRt.isEmptyOrSpaces((CharSequence)extraClassifier)) {
            return this.myClassifier;
        }
        String result = "";
        if ("test-jar".equals(this.myType) || "tests".equals(this.myClassifier)) {
            result = result + "test";
        }
        if (!StringUtilRt.isEmptyOrSpaces((CharSequence)extraClassifier)) {
            result = result + (!result.isEmpty() ? "-" + extraClassifier : extraClassifier);
        }
        return StringUtilRt.isEmptyOrSpaces((CharSequence)result) ? null : result;
    }

    public String getPathForExtraArtifact(@Nullable String extraArtifactClassifier, @Nullable String customExtension) {
        String path = this.getPath();
        if (extraArtifactClassifier == null && customExtension == null && Objects.equals(this.myVersion, this.myBaseVersion)) {
            return path;
        }
        int slashPos = path.lastIndexOf(47);
        if (slashPos != -1) {
            StringBuilder res = new StringBuilder();
            res.append(path, 0, slashPos + 1);
            res.append(this.myArtifactId);
            res.append('-');
            res.append(this.myVersion);
            String fullClassifier = this.getFullClassifier(extraArtifactClassifier);
            if (fullClassifier != null) {
                res.append('-').append(fullClassifier);
            }
            res.append('.');
            res.append(customExtension == null ? this.myExtension : customExtension);
            return res.toString();
        }
        int dotPos = path.lastIndexOf(46);
        if (dotPos != -1) {
            return path.substring(0, dotPos) + '-' + extraArtifactClassifier + (customExtension == null ? this.myExtension : customExtension);
        }
        return path;
    }

    public String getDisplayStringSimple() {
        StringBuilder builder = new StringBuilder();
        MavenId.append((StringBuilder)builder, (String)this.myGroupId);
        MavenId.append((StringBuilder)builder, (String)this.myArtifactId);
        MavenId.append((StringBuilder)builder, (String)this.myVersion);
        return builder.toString();
    }

    public String getDisplayStringWithType() {
        StringBuilder builder = new StringBuilder();
        MavenId.append((StringBuilder)builder, (String)this.myGroupId);
        MavenId.append((StringBuilder)builder, (String)this.myArtifactId);
        MavenId.append((StringBuilder)builder, (String)this.myType);
        MavenId.append((StringBuilder)builder, (String)this.myVersion);
        return builder.toString();
    }

    public String getDisplayStringWithTypeAndClassifier() {
        StringBuilder builder = new StringBuilder();
        MavenId.append((StringBuilder)builder, (String)this.myGroupId);
        MavenId.append((StringBuilder)builder, (String)this.myArtifactId);
        MavenId.append((StringBuilder)builder, (String)this.myType);
        if (!StringUtilRt.isEmptyOrSpaces((CharSequence)this.myClassifier)) {
            MavenId.append((StringBuilder)builder, (String)this.myClassifier);
        }
        MavenId.append((StringBuilder)builder, (String)this.myVersion);
        return builder.toString();
    }

    public String getDisplayStringFull() {
        StringBuilder builder = new StringBuilder();
        MavenId.append((StringBuilder)builder, (String)this.myGroupId);
        MavenId.append((StringBuilder)builder, (String)this.myArtifactId);
        MavenId.append((StringBuilder)builder, (String)this.myType);
        if (!StringUtilRt.isEmptyOrSpaces((CharSequence)this.myClassifier)) {
            MavenId.append((StringBuilder)builder, (String)this.myClassifier);
        }
        MavenId.append((StringBuilder)builder, (String)this.myVersion);
        if (!StringUtilRt.isEmptyOrSpaces((CharSequence)this.myScope)) {
            MavenId.append((StringBuilder)builder, (String)this.myScope);
        }
        return builder.toString();
    }

    public String getLibraryName() {
        String res = this.myLibraryNameCache;
        if (res == null) {
            String version;
            StringBuilder builder = new StringBuilder();
            MavenId.append((StringBuilder)builder, (String)this.myGroupId);
            MavenId.append((StringBuilder)builder, (String)this.myArtifactId);
            if (!StringUtilRt.isEmptyOrSpaces((CharSequence)this.myType) && !"jar".equals(this.myType)) {
                MavenId.append((StringBuilder)builder, (String)this.myType);
            }
            if (!StringUtilRt.isEmptyOrSpaces((CharSequence)this.myClassifier)) {
                MavenId.append((StringBuilder)builder, (String)this.myClassifier);
            }
            String string = version = !StringUtilRt.isEmptyOrSpaces((CharSequence)this.myBaseVersion) ? this.myBaseVersion : this.myVersion;
            if (!StringUtilRt.isEmptyOrSpaces((CharSequence)version)) {
                MavenId.append((StringBuilder)builder, (String)version);
            }
            builder.insert(0, MAVEN_LIB_PREFIX);
            this.myLibraryNameCache = res = builder.toString();
        }
        return res;
    }

    public String getDisplayStringForLibraryName() {
        return this.getLibraryName().substring(MAVEN_LIB_PREFIX.length());
    }

    public boolean isFileUnresolved() {
        return this.myFileUnresolved;
    }

    public void setFileUnresolved(boolean fileUnresolved) {
        this.myFileUnresolved = fileUnresolved;
    }

    public static boolean isMavenLibrary(@Nullable String libraryName) {
        return libraryName != null && libraryName.startsWith(MAVEN_LIB_PREFIX);
    }

    public String toString() {
        return this.getDisplayStringFull();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MavenArtifact that = (MavenArtifact)o;
        return Objects.equals(this.myGroupId, that.myGroupId) && Objects.equals(this.myArtifactId, that.myArtifactId) && Objects.equals(this.myVersion, that.myVersion) && Objects.equals(this.myBaseVersion, that.myBaseVersion) && Objects.equals(this.myType, that.myType) && Objects.equals(this.myClassifier, that.myClassifier) && Objects.equals(this.myScope, that.myScope) && Objects.equals(this.myExtension, that.myExtension) && Objects.equals(this.myFile, that.myFile);
    }

    public int hashCode() {
        int result = this.myGroupId != null ? this.myGroupId.hashCode() : 0;
        result = 31 * result + (this.myArtifactId != null ? this.myArtifactId.hashCode() : 0);
        result = 31 * result + (this.myVersion != null ? this.myVersion.hashCode() : 0);
        result = 31 * result + (this.myBaseVersion != null ? this.myBaseVersion.hashCode() : 0);
        result = 31 * result + (this.myType != null ? this.myType.hashCode() : 0);
        result = 31 * result + (this.myClassifier != null ? this.myClassifier.hashCode() : 0);
        result = 31 * result + (this.myScope != null ? this.myScope.hashCode() : 0);
        result = 31 * result + (this.myExtension != null ? this.myExtension.hashCode() : 0);
        result = 31 * result + (this.myFile != null ? this.myFile.hashCode() : 0);
        return result;
    }

    public MavenArtifact replaceFile(File newFile, File newLocalRepository) {
        return new MavenArtifact(this.myGroupId, this.myArtifactId, this.myVersion, this.myBaseVersion, this.myType, this.myClassifier, this.myScope, this.myOptional, this.myExtension, newFile, newLocalRepository, this.myResolved, this.myStubbed);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/model/MavenArtifact", "getFile"));
    }
}

