/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.packagesearch.intellij.plugin.api.query.language;

import com.intellij.util.io.URLUtil;
import com.jetbrains.packagesearch.intellij.plugin.api.query.SearchQueryParser;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\n\u001a\u00020\u0003J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0006H\u0014R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/packagesearch/intellij/plugin/api/query/language/SampleQuery;", "Lcom/jetbrains/packagesearch/intellij/plugin/api/query/SearchQueryParser;", "query", "", "(Ljava/lang/String;)V", "onlyMpp", "", "onlyStable", "tags", "", "buildQueryString", "handleAttribute", "", "name", "value", "invert", "intellij.packageSearch"})
public final class SampleQuery
extends SearchQueryParser {
    private final Set<String> tags;
    private boolean onlyStable;
    private boolean onlyMpp;

    @Override
    protected void handleAttribute(@NotNull String name, @NotNull String value, boolean invert) {
        block1: {
            block2: {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                    Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                    if (!StringsKt.equals((String)name, (String)"/tag", (boolean)true)) break block0;
                    this.tags.add(value);
                    break block1;
                }
                if (!StringsKt.equals((String)name, (String)"/onlyStable", (boolean)true)) break block2;
                String string = value;
                this.onlyStable = Boolean.parseBoolean(string);
                break block1;
            }
            if (!StringsKt.equals((String)name, (String)"/onlyMpp", (boolean)true)) break block1;
            String string = value;
            this.onlyMpp = Boolean.parseBoolean(string);
        }
    }

    @NotNull
    public final String buildQueryString() {
        StringBuilder url = new StringBuilder();
        url.append("q=");
        CharSequence charSequence = this.getSearchQuery();
        if (!(charSequence == null || charSequence.length() == 0)) {
            String string = this.getSearchQuery();
            Intrinsics.checkNotNull((Object)string);
            url.append(URLUtil.encodeURIComponent((String)string));
        }
        url.append("&onlyStable=" + this.onlyStable);
        url.append("&onlyMpp=" + this.onlyMpp);
        for (String tag : this.tags) {
            url.append("&tags=").append(URLUtil.encodeURIComponent((String)tag));
        }
        String string = url.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"url.toString()");
        return string;
    }

    public SampleQuery(@NotNull String query) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        this.tags = new LinkedHashSet();
        this.onlyStable = true;
        this.parse(query);
    }
}

