/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.packagesearch.intellij.plugin.dependency.analyzer;

import com.intellij.buildsystem.model.unified.UnifiedCoordinates;
import com.intellij.ide.IdeTooltipManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.util.PopupUtilsKt;
import com.intellij.util.ui.JBUI;
import com.jetbrains.packagesearch.intellij.plugin.PackageSearchBundle;
import com.jetbrains.packagesearch.intellij.plugin.ui.services.DependencyNavigationService;
import com.jetbrains.packagesearch.intellij.plugin.ui.services.NavigationResult;
import java.awt.Color;
import javax.swing.JComponent;
import javax.swing.JLabel;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\t\u001a\u00020\nH&J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\t\u001a\u00020\nH&J\u001d\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00132\u000b\u0010\u0014\u001a\u00070\u0015\u00a2\u0006\u0002\b\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/packagesearch/intellij/plugin/dependency/analyzer/DependencyAnalyzerGoToPackageSearchAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "systemId", "Lcom/intellij/openapi/externalSystem/model/ProjectSystemId;", "getSystemId", "()Lcom/intellij/openapi/externalSystem/model/ProjectSystemId;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "getModule", "Lcom/intellij/openapi/module/Module;", "getUnifiedCoordinates", "Lcom/intellij/buildsystem/model/unified/UnifiedCoordinates;", "showBalloon", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "message", "", "Lcom/intellij/openapi/util/NlsContexts$Label;", "update", "intellij.packageSearch"})
public abstract class DependencyAnalyzerGoToPackageSearchAction
extends DumbAwareAction {
    @NotNull
    public abstract ProjectSystemId getSystemId();

    @Nullable
    public abstract Module getModule(@NotNull AnActionEvent var1);

    @Nullable
    public abstract UnifiedCoordinates getUnifiedCoordinates(@NotNull AnActionEvent var1);

    public void actionPerformed(@NotNull AnActionEvent e) {
        String string;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Module module = this.getModule(e);
        if (module == null) {
            return;
        }
        Module module2 = module;
        UnifiedCoordinates unifiedCoordinates = this.getUnifiedCoordinates(e);
        if (unifiedCoordinates == null) {
            return;
        }
        UnifiedCoordinates coordinates = unifiedCoordinates;
        Project project = module2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"module.project");
        DependencyNavigationService navigationService = DependencyNavigationService.Companion.getInstance(project);
        NavigationResult navigationResult = navigationService.navigateToDependency(module2, coordinates);
        if (navigationResult instanceof NavigationResult.CoordinatesNotFound) {
            string = PackageSearchBundle.INSTANCE.message("packagesearch.actions.showToolWindow.not.found.dependency", new Object[0]);
        } else if (navigationResult instanceof NavigationResult.DependencyNotFound) {
            string = PackageSearchBundle.INSTANCE.message("packagesearch.actions.showToolWindow.not.found.dependency", new Object[0]);
        } else if (navigationResult instanceof NavigationResult.ModuleNotSupported) {
            string = PackageSearchBundle.INSTANCE.message("packagesearch.actions.showToolWindow.not.found.module", new Object[0]);
        } else if (Intrinsics.areEqual((Object)navigationResult, (Object)NavigationResult.Success.INSTANCE)) {
            string = null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        String navigationResultMessage = string;
        if (navigationResultMessage != null) {
            DataContext dataContext = e.getDataContext();
            Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"e.dataContext");
            this.showBalloon(dataContext, navigationResultMessage);
        }
    }

    private final void showBalloon(DataContext dataContext, String message) {
        IdeTooltipManager tooltipManager = IdeTooltipManager.getInstance();
        Color foreground = tooltipManager.getTextForeground(false);
        Color background = tooltipManager.getTextBackground(false);
        Color color = JBUI.CurrentTheme.Tooltip.borderColor();
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"JBUI.CurrentTheme.Tooltip.borderColor()");
        Color borderColor = color;
        JLabel label = new JLabel(message);
        label.setForeground(foreground);
        label.setBackground(background);
        JBPopupFactory.getInstance().createBalloonBuilder((JComponent)label).setFillColor(background).setBorderColor(borderColor).createBalloon().show(PopupUtilsKt.getBestBalloonPosition((DataContext)dataContext), Balloon.Position.above);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Presentation presentation = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
        presentation.setEnabledAndVisible(Intrinsics.areEqual((Object)this.getSystemId(), (Object)((ProjectSystemId)e.getData(ExternalSystemDataKeys.EXTERNAL_SYSTEM_ID))) && this.getModule(e) != null && this.getUnifiedCoordinates(e) != null);
    }

    public DependencyAnalyzerGoToPackageSearchAction() {
        Presentation presentation = this.getTemplatePresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"templatePresentation");
        presentation.setText(PackageSearchBundle.INSTANCE.message("packagesearch.actions.showToolWindow.text", new Object[0]));
    }
}

