/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.panels.management.packagedetails;

import com.jetbrains.packagesearch.api.v2.ApiStandardPackage;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.panels.management.packagedetails.InfoLink;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0015B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fJ\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011J\b\u0010\t\u001a\u0004\u0018\u00010\u0012J\f\u0010\u0013\u001a\u00020\r*\u00020\u0014H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/panels/management/packagedetails/LinkExtractor;", "", "standardV2Package", "Lcom/jetbrains/packagesearch/api/v2/ApiStandardPackage;", "(Lcom/jetbrains/packagesearch/api/v2/ApiStandardPackage;)V", "documentation", "Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/panels/management/packagedetails/InfoLink$Documentation;", "extractScmUrl", "Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/panels/management/packagedetails/LinkExtractor$ScmUrl;", "scm", "Lcom/jetbrains/packagesearch/api/v2/ApiStandardPackage$ApiScm;", "licenses", "", "Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/panels/management/packagedetails/InfoLink$License;", "projectWebsite", "Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/panels/management/packagedetails/InfoLink$ProjectWebsite;", "readme", "Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/panels/management/packagedetails/InfoLink$Readme;", "Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/panels/management/packagedetails/InfoLink$ScmRepository;", "asLicenseInfoLink", "Lcom/jetbrains/packagesearch/api/v2/ApiStandardPackage$ApiLinkedFile;", "ScmUrl", "intellij.packageSearch"})
public final class LinkExtractor {
    private final ApiStandardPackage standardV2Package;

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final InfoLink.ScmRepository scm() {
        InfoLink.ScmRepository scmRepository;
        void scmUrl;
        ApiStandardPackage.ApiScm apiScm = this.standardV2Package.getScm();
        if (apiScm == null) {
            return null;
        }
        ApiStandardPackage.ApiScm scm = apiScm;
        ScmUrl scmUrl2 = this.extractScmUrl(scm);
        String string = scmUrl2.component1();
        boolean isGitHub = scmUrl2.component2();
        if (isGitHub) {
            ApiStandardPackage.ApiGitHub apiGitHub = this.standardV2Package.getGitHub();
            scmRepository = new InfoLink.ScmRepository.GitHub((String)scmUrl, apiGitHub != null ? apiGitHub.getStars() : null);
        } else {
            scmRepository = new InfoLink.ScmRepository.Generic((String)scmUrl);
        }
        return scmRepository;
    }

    private final ScmUrl extractScmUrl(ApiStandardPackage.ApiScm scm) {
        String string;
        CharSequence charSequence;
        String scmUrl = scm.getUrl();
        boolean isGitHub = StringsKt.contains((CharSequence)scmUrl, (CharSequence)"github.com", (boolean)true);
        if (isGitHub) {
            charSequence = scmUrl;
            String string2 = "((?:ssh|https)://)?git@github.com";
            Object object = RegexOption.IGNORE_CASE;
            string2 = new Regex(string2, object);
            object = "https://github.com";
            charSequence = StringsKt.replace$default((String)string2.replace(charSequence, (String)object), (String)"github.com:", (String)"github.com/", (boolean)false, (int)4, null);
            string = ((Object)StringsKt.trim((CharSequence)charSequence)).toString();
        } else {
            charSequence = scmUrl;
            string = ((Object)StringsKt.trim((CharSequence)charSequence)).toString();
        }
        String normalizedUrl = string;
        return new ScmUrl(normalizedUrl, isGitHub);
    }

    @Nullable
    public final InfoLink.ProjectWebsite projectWebsite() {
        InfoLink.ProjectWebsite projectWebsite;
        String string = this.standardV2Package.getUrl();
        if (string != null) {
            String string2;
            String it = string2 = string;
            boolean bl = false;
            projectWebsite = new InfoLink.ProjectWebsite(it);
        } else {
            projectWebsite = null;
        }
        return projectWebsite;
    }

    @Nullable
    public final InfoLink.Documentation documentation() {
        InfoLink.Documentation documentation;
        Object object = this.standardV2Package.getGitHub();
        if (object != null && (object = ((ApiStandardPackage.ApiGitHub)object).getCommunityProfile()) != null && (object = ((ApiStandardPackage.ApiGitHub.ApiCommunityProfile)object).getDocumentation()) != null) {
            Object object2;
            Object it = object2 = object;
            boolean bl = false;
            documentation = new InfoLink.Documentation((String)it);
        } else {
            documentation = null;
        }
        return documentation;
    }

    @Nullable
    public final InfoLink.Readme readme() {
        InfoLink.Readme readme;
        Object object = this.standardV2Package.getGitHub();
        if (object != null && (object = ((ApiStandardPackage.ApiGitHub)object).getCommunityProfile()) != null && (object = ((ApiStandardPackage.ApiGitHub.ApiCommunityProfile)object).getFiles()) != null && (object = ((ApiStandardPackage.ApiGitHub.ApiCommunityProfile.ApiCommunityProfileFiles)object).getReadme()) != null) {
            Object object2;
            Object it = object2 = object;
            boolean bl = false;
            String string = ((ApiStandardPackage.ApiLinkedFile)it).getHtmlUrl();
            if (string == null) {
                string = ((ApiStandardPackage.ApiLinkedFile)it).getUrl();
            }
            readme = new InfoLink.Readme(string);
        } else {
            readme = null;
        }
        return readme;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<InfoLink.License> licenses() {
        List licenses;
        block2: {
            void $this$mapTo$iv$iv;
            Object object;
            Object object2;
            licenses = new ArrayList();
            Object object3 = this.standardV2Package.getLicenses();
            if (object3 != null && (object3 = ((ApiStandardPackage.ApiLicenses)object3).getMainLicense()) != null) {
                Object it = object2 = object3;
                boolean bl = false;
                licenses.add(this.asLicenseInfoLink((ApiStandardPackage.ApiLinkedFile)it));
            }
            if ((object = this.standardV2Package.getLicenses()) == null || (object = ((ApiStandardPackage.ApiLicenses)object).getOtherLicenses()) == null) break block2;
            Iterable $this$map$iv = (Iterable)object;
            boolean $i$f$map = false;
            Iterable bl = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ApiStandardPackage.ApiLinkedFile apiLinkedFile = (ApiStandardPackage.ApiLinkedFile)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                InfoLink.License license = this.asLicenseInfoLink((ApiStandardPackage.ApiLinkedFile)it);
                collection.add(license);
            }
            Object it = object2 = (List)destination$iv$iv;
            boolean bl3 = false;
            licenses.addAll((Collection)it);
        }
        return licenses;
    }

    private final InfoLink.License asLicenseInfoLink(ApiStandardPackage.ApiLinkedFile $this$asLicenseInfoLink) {
        String string = $this$asLicenseInfoLink.getHtmlUrl();
        if (string == null) {
            string = $this$asLicenseInfoLink.getUrl();
        }
        return new InfoLink.License(string, $this$asLicenseInfoLink.getName());
    }

    public LinkExtractor(@NotNull ApiStandardPackage standardV2Package) {
        Intrinsics.checkNotNullParameter((Object)standardV2Package, (String)"standardV2Package");
        this.standardV2Package = standardV2Package;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u00052\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/panels/management/packagedetails/LinkExtractor$ScmUrl;", "", "url", "", "isGitHub", "", "(Ljava/lang/String;Z)V", "()Z", "getUrl", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "intellij.packageSearch"})
    private static final class ScmUrl {
        @NotNull
        private final String url;
        private final boolean isGitHub;

        @NotNull
        public final String getUrl() {
            return this.url;
        }

        public final boolean isGitHub() {
            return this.isGitHub;
        }

        public ScmUrl(@NotNull String url, boolean isGitHub) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            this.url = url;
            this.isGitHub = isGitHub;
        }

        @NotNull
        public final String component1() {
            return this.url;
        }

        public final boolean component2() {
            return this.isGitHub;
        }

        @NotNull
        public final ScmUrl copy(@NotNull String url, boolean isGitHub) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            return new ScmUrl(url, isGitHub);
        }

        public static /* synthetic */ ScmUrl copy$default(ScmUrl scmUrl, String string, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                string = scmUrl.url;
            }
            if ((n & 2) != 0) {
                bl = scmUrl.isGitHub;
            }
            return scmUrl.copy(string, bl);
        }

        @NotNull
        public String toString() {
            return "ScmUrl(url=" + this.url + ", isGitHub=" + this.isGitHub + ")";
        }

        public int hashCode() {
            String string = this.url;
            int n = (string != null ? string.hashCode() : 0) * 31;
            int n2 = this.isGitHub ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            return n + n2;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ScmUrl)) break block3;
                    ScmUrl scmUrl = (ScmUrl)object;
                    if (!Intrinsics.areEqual((Object)this.url, (Object)scmUrl.url) || this.isGitHub != scmUrl.isGitHub) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

